<?php $this->extend('Layouts/layout-blank.html.php'); ?>

<body class="app flex-row align-items-center pace-done">

    <div class="pace  pace-inactive">
        <div class="pace-progress" data-progress-text="100%" data-progress="99" style="transform: translate3d(100%, 0px, 0px);">
            <div class="pace-progress-inner"></div>
            </div>
        <div class="pace-activity">

        </div>
    </div>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card-group shadow">
                    <div class="card p-4 mb-0 noborder-r">
                        <div class="card-body">

                            <div class="">
                                <img src="/assets/images/logo/logo_header.png" class="img-header" />

                                <?php if($this->Status == 'alreadyactive'){ ?>

                                <h2 class="alert-heading pt-3 mb3 mt-4">Aktivasi akun gagal</h2>
                                <hr>
                                <p>
                                    Akun Anda telah teraktivasi sebelumnya, silakan langsung melakukan login
                                </p>
                                                    
                                <a href="/login">
                                    <button type="button" class="btn btn-danger px-5 mt-4">Login</button>
                                </a>                        

                                <?php } else if($this->Status == 'expired') { ?>

                                <h2 class="alert-heading pt-3 mb3 mt-4">Aktivasi akun gagal</h2>
                                <hr>
                                <p>
                                    Link aktivasi Anda sudah tidak berlaku, silakan untuk meminta ulang link aktifasi
                                </p>
                                                    
                                <a href="javascript:void(0);">
                                    <button type="button" class="btn btn-danger px-5 mt-4" onclick="sendEmailActivation()">Kirim ulang email aktivasi</button>
                                </a>                        

                                <?php } else { ?>

                                <h2 class="alert-heading pt-3 mb3 mt-4">Proses aktivasi Anda gagal</h2>
                                <hr>
                                <p>
                                    Anda perlu bantuan?
                                </p>
                                                        
                                <a href="http://pakarya.com/contact-us">
                                    <button type="button" class="btn btn-danger px-5 mt-4">Hubungi kami</button>
                                </a>                        

                                <?php } ?>
 
                            </div>  

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>

<script type="text/javascript">
    
    function sendEmailActivation(){
        swal.close();
        showLoading();

        $.ajaxSetup({
            headers: { 'apikey': '<?= $this->Apikey ?>' }
        })
        $.ajax({
            type: 'POST',
            url: '/api/authentication/send-activation-email',
            data: { Email : '<?= $_GET['e'] ?>'},
            success: function(response){
                hideLoading();
                
                if(response.Status == 1) {
                    swal({
                        title: 'Berhasil',
                        html: 'Kirim email link aktivasi berhasil, silahkan cek email Anda',
                        type: 'info',
                        showCloseButton: true
                    });                         
                } else {
                    swal({
                        title: 'Mohon Maaf',
                        html: response.Message,
                        type: 'info',
                        showCloseButton: true
                    });                         
                }
            }, error: function(response) {
                hideLoading();
                swal({
                    title: 'Mohon Maaf',
                    html: 'Terjadi kesalahan jaringan',
                    type: 'info',
                    showCloseButton: true
                });                                                 
            }
        });                 
    }

</script>


