<?php $this->extend('Layouts/layout-main.html.php'); ?>

<div class="container">

    <h2 class="my-4">
        Ubah Password
    </h2>

	<div class="row">
		<div class="col-md-6">

			<div class="alert alert-success alert-dismissible fade show d-none" role="alert">			
				<p class="mb-0">
					Ubah password berhasil
				</p>
				<button type="button" class="close" data-dismiss="alert" aria-label="Close">
					<span aria-hidden="true">×</span>
				</button>
			</div>

			<form>
				<div class="form-group">
					<label class="col-form-label">Password saat ini</label>
					<input type="password" class="form-control clear" name="OldPassword" placeholder="">
				</div>
				<div class="form-group">
					<label class="col-form-label">Password baru</label>
					<input type="password" class="form-control clear" name="NewPassword" placeholder="">
				</div>
				<div class="form-group">
					<label class="col-form-label">Konfirmasi password baru</label>
					<input type="password" class="form-control clear" name="ConfirmNewPassword" placeholder="">
				</div>
				<input type="hidden" class="form-control" name="Id" value="<?= $this->UserId ?>">
			</form>
			<div class="form-group text-right">
				<button type="submit" class="btn btn-danger px-5 mt-4 btn-submit">Simpan</button>
			</div>
		</div>
	</div>

</div>

<script type="text/javascript">

    $(document).ready(function(){

    	$('.btn-submit').click(function(){
    		$('form').submit();
    	});

		$.validator.setDefaults({
			submitHandler:function submitHandler(){

				$(".alert").addClass('d-none');							

				showLoading();

				$.ajaxSetup({
				    headers: { 'apikey': '<?= $this->Apikey ?>' }
				});
				$.ajax({
					type: 'POST',
					url: '/api/authentication/change-password',
					data: getData(),
				 	success: function(response){
						if(response.Status == 1) {
							hideLoading();
							$(".alert").removeClass('d-none');						
							$('input.form-control.clear').val('');	
						} else {
							hideLoading();
							swal({
								title: 'Mohon Maaf',
					            html: response.Message,
					            type: 'info',
					            showCloseButton: true
					        });							
						}
					}, error: function(response) {
						hideLoading();
						swal({
							title: 'Mohon Maaf',
				            html: 'Terjadi kesalahan pada jaringan',
				            type: 'info',
				            showCloseButton: true
				        });							
					}
				});

			}
		});
		
		$('form').validate({
			rules:{
				OldPassword: { required:true },
				NewPassword: { required:true, minlength: 6 },
				ConfirmNewPassword:{ required:true, minlength: 6, equalTo:'[name=NewPassword]' }				
			},
			messages:{
				OldPassword:{
					required: 'Password saat ini harus diisi',
				},
				NewPassword:{
					required: 'Password baru harus diisi',
					minlength:'Password minimal 6 karakter'
				},
				ConfirmNewPassword:{
					required: 'Konfirmasi password baru harus diisi',
					minlength:'Password minimal 6 karakter',
					equalTo: 'Konfirmasi password baru tidak sama dengan password baru'
				},				
			},
			errorElement:'em',
			errorPlacement:function errorPlacement(error,element){
				error.addClass('invalid-feedback');
				if(element.prop('type')==='checkbox'){
					error.insertAfter(element.parent('label'));
				}else{
					error.insertAfter(element);
				}
			},
			highlight:function highlight(element){
				$(element).addClass('is-invalid').removeClass('is-valid');
			},
			unhighlight:function unhighlight(element){
				$(element).addClass('is-valid').removeClass('is-invalid');
			}
		});

	});	

	function getData(){
		var data = {};

		$.each($('form .form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

        return data;
	}	

</script>
