<?php $this->extend('Layouts/layout-blank.html.php'); ?>

<body class="app flex-row align-items-center  pace-done">

	<div class="pace  pace-inactive">
		<div class="pace-progress" data-progress-text="100%" data-progress="99" style="transform: translate3d(100%, 0px, 0px);">
			<div class="pace-progress-inner"></div>
		</div>
		<div class="pace-activity"></div>
	</div>
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-md-6">
				<div class="card-group shadow">
					<div class="card p-4 mb-0">
						<div class="card-body">
				  			<img src="/assets/images/logo/logo_header.png" class="img-header mb-4" />
							<h1>Login</h1>
							<p class="text-muted">Sign In to your account</p>

							<form id="form-login">
								<div class="input-group mb-3">
									<input type="text" class="form-control input-enter" name="Email" placeholder="Email">
								</div>
								<div class="input-group mb-4">
									<input type="password" class="form-control input-enter" name="Password" placeholder="Password">
								</div>

								<div class="row pt-2">
									<div class="col-6">
										<button type="button" class="btn btn-danger px-5 btn-submit-login">Login</button>
									</div>
									<div class="col-6 text-right">
										<a href="/forgot-password">									
											<button type="button" class="btn btn-link px-0">Lupa password?</button>
										</a>
									</div>
								</div>
							</form>
						</div>

						<div class="py-3 mt-2 bg-gray-100">
							<p class="text-center p-0 m-0">
								Belum punya akun?
								<a href="/registration" class="p-0 m-0">									
									Daftar sekarang
								</a>
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="custom-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
		<div class="modal-dialog modal-danger" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Error Message</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">×</span>
					</button>
				</div>
				<div class="modal-body"></div>
			</div>
		</div>
	</div>	

</body>

<link href="/assets/css/bootstrap-pincode-input.css" rel="stylesheet">
<script src="/assets/js/bootstrap-pincode-input.js"></script> 
<script type="text/javascript">
	
    $(document).ready(function(){

    	$('.btn-submit-login').click(function(){
    		$('#form-login').submit();
    	});

    	$('.input-enter').on('keyup', function (e) {
    		if (e.which == 13) {
    			$('#form-login').submit();
    		}
    	});
		
		$('#form-login').validate({
			rules:{
				Email: { required:true, email:true },
				Password: { required:true }
			},
			messages:{
				Email: {
					required: 'Email harus diisi',
					email: 'Format email tidak valid'
				},
				Password: {
					required:'Password harus diisi',
				}
			},
			errorElement:'em',
			errorPlacement:function errorPlacement(error,element){
				error.addClass('invalid-feedback');
				if(element.prop('type')==='checkbox'){
					error.insertAfter(element.parent('label'));
				}else{
					error.insertAfter(element);
				}
			},
			highlight:function highlight(element){
				$(element).addClass('is-invalid').removeClass('is-valid');
			},
			unhighlight:function unhighlight(element){
				$(element).addClass('is-valid').removeClass('is-invalid');
			}, 
			submitHandler: function(form) {
				showLoading();

				$.ajax({
					type: 'POST',
					url: '/login',
					data: getData(),
				 	success: function(response){
						if(response.Status == 1) {
							window.location.assign('<?= $this->RedirectUrl ?>' ? '<?= $this->RedirectUrl ?>' : response.RedirectUrl);
						} else {
							hideLoading();
							swal({
								title: 'Mohon Maaf',
					            html: response.Message,
					            type: 'info',
					            showCloseButton: true,
					            showConfirmButton: false,
					            onOpen: () => document.activeElement.blur()
					        });						

							$('.input-verification-code').pincodeInput({
								hidedigits:false,
								inputs:6,
								complete:function(value, e, errorElement){     
									$.ajaxSetup({
										headers: { 'apikey': '<?= $this->Apikey ?>' }
									})
									$.ajax({
										type: 'POST',
										url: '/api/authentication/submit-verification-code',
										data: { Code: value, Email: $('[name=Email]').val(), Activity: 'activation', Auto: 1 },
									 	success: function(response){
											if(response.Status == 1) {
												window.location.assign('<?= $this->RedirectUrl ?>' ? '<?= $this->RedirectUrl ?>' : response.RedirectUrl);
											} else {
							            		$(errorElement).html("Kode aktifasi salah");
											}
										}, error: function(response) {
						            		$(errorElement).html("Terjadi kesalahan jaringan");
										}
									});				
				            	}
				        	});					        	
						}
					}, error: function(response) {
						hideLoading();
						swal({
							title: 'Mohon Maaf',
				            html: 'Terjadi kesalahan pada jaringan',
				            type: 'info',
				            showCloseButton: true,
				            showConfirmButton: false,
				            onOpen: () => document.activeElement.blur()			            
				        });							
					}
				});				
		  	}
		});
	});	

	function showLoginForm(){
		window.location.assign('/login');	
	}

	function showRegistrationForm(){
		window.location.assign('/registration');	
	}

	function showForgotPasswordForm(){
		window.location.assign('/forfot-password');	
	}

	function getData(){
		var data = {};

		$.each($('form .form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

        return data;
	}	

	function sendEmailVerification(){
		$.ajaxSetup({
			headers: { 'apikey': '<?= $this->Apikey ?>' }
		})
		$.ajax({
			type: 'POST',
			url: '/api/authentication/send-verification-email',
			data: { Email : $('[name=Email]').val() },
		 	success: function(response){
				if(response.Status == 1) {
					$('.message-verification-code').html('Kirim kode aktivasi berhasil, silahkan cek email Anda').addClass('text-success').removeClass('text-danger');
				} else {
					$('.message-verification-code').html(response.Message).addClass('text-danger').removeClass('text-success');
				}
			}, error: function(response) {
				$('.message-verification-code').html('Terjadi kesalahan jaringan, silahkan cek koneksi jaringan Anda').addClass('text-danger').removeClass('text-success');
			}
		});    				
	}	

</script>
     