<?php $this->extend('Layouts/layout-blank.html.php'); ?>

<body class="app flex-row align-items-center  pace-done">

	<div class="pace  pace-inactive">
		<div class="pace-progress" data-progress-text="100%" data-progress="99" style="transform: translate3d(100%, 0px, 0px);">
			<div class="pace-progress-inner"></div>
			</div>
		<div class="pace-activity">

		</div>
	</div>

	<div class="container">
		<div class="row justify-content-center">
			<div class="col-md-6">
				<div class="card-group shadow">
					<div class="card p-4 mb-0 noborder-r">
						<div class="card-body">
				  			<img src="/assets/images/logo/logo_header.png" class="img-header mb-4" />
					  		<div class="mb-4">
						  		<h1>Registration</h1>
								<p class="text-muted">Create your account</p>
							</div>	

							<form id="form-register">
								<div class="input-group mb-3">
									<input type="text" class="form-control input-enter" name="Name" placeholder="Nama">
								</div>
								<div class="input-group mb-3">
									<input type="text" class="form-control input-enter" name="Email" placeholder="Email">
								</div>
								<div class="input-group mb-3">
									<input type="password" class="form-control input-enter" name="Password" placeholder="Password">
								</div>
								<div class="input-group mb-3">
									<input type="password" class="form-control input-enter" name="ConfirmPassword" placeholder="Konfirmasi Password">
								</div>
	                            <div class="d-flex flex-wrap py-3">
	                                <div class="px-1 align-items-center d-flex">
										<span class="captcha-q"></span>
									</div>
	                                <div class="px-1 align-items-center d-flex">
										<input type="text" class="form-control input-enter" name="Captcha" placeholder="?" style="width:50px">
									</div>
								</div>
								<div class="row pt-2">
									<div class="col-6">
										<button type="button" class="btn btn-danger btn-submit-register">Buat akun</button>
									</div>
									<div class="col-6 text-right">
										<a href="/login">									
											<button type="button" class="btn btn-link px-0">Sudah punya akun?</button>
										</a>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="custom-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
		<div class="modal-dialog modal-danger" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Pesan Kesalahan</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">×</span>
					</button>
				</div>
				<div class="modal-body"></div>
			</div>
		</div>
	</div>		

</body>

<link href="/assets/css/bootstrap-pincode-input.css" rel="stylesheet">
<script src="/assets/js/bootstrap-pincode-input.js"></script> 
<script type="text/javascript">
	
    $(document).ready(function(){

		capt_cha.generate();
		$('.captcha-q').text(capt_cha.show() + ' = ');

    	$('.btn-submit-register').click(function(){
    		$('#form-register').submit();
    	});
    	
    	$('.input-enter').on('keyup', function (e) {
    		if (e.which == 13) {
    			$('#form-register').submit();
    		}
    	});

		$.validator.addMethod("emailcustom", function(value, element) {
			return this.optional(element) || /\S+@\S+\.\S+/i.test(value);
		}, "Format email tidak valid");    	

		$.validator.addMethod("captcha", function(value, element) {
			return value == capt_cha.solve();
		}, "&nbsp;Jawaban salah");    	

		$('#form-register').validate({
			rules:{
				Name: { required:true },
				Email: { required:true, emailcustom:true },
				Password: { required:true, minlength: 6 },
				Captcha: { captcha :true },
				ConfirmPassword: { required:true, equalTo:'[name=Password]' }
			},
			messages:{
				Name: {
					required:'Nama harus diisi',
				},
				Email: {
					required: 'Email harus diisi'
				},
				Password: {
					required:'Password harus diisi',
					minlength:'Masukan password minimal 6 karakter'
				},
				ConfirmPassword: {
					required:'Konfirmasi password harus diisi',
					equalTo:'Konfirmasi password tidak sama'
				}
			},
			errorElement:'em',
			errorPlacement:function errorPlacement(error,element){
				error.addClass('invalid-feedback');
				if(element.prop('type')==='checkbox'){
					error.insertAfter(element.parent('label'));
				}else{
					error.insertAfter(element);
				}
			},
			highlight:function highlight(element){
				$(element).addClass('is-invalid').removeClass('is-valid');
			},
			unhighlight:function unhighlight(element){
				$(element).addClass('is-valid').removeClass('is-invalid');
			}, 
			submitHandler:function submitHandler(){
				showLoading();

				$.ajaxSetup({
					headers: { 'apikey': '<?= $this->Apikey ?>' }
				})
				$.ajax({
					type: 'POST',
					url: '/api/authentication/registration',
					data: getData(),
				 	success: function(response){
				 		hideLoading();
						if(response.Status == 1) {
							swal({
					            html: response.Message,
					            type: 'success',
					            showCloseButton: true,
				            	showConfirmButton: false,
				            	onOpen: () => document.activeElement.blur()
					        });							
						} else {
							swal({
					            html: response.Message,
					            type: 'warning',
					            showCloseButton: true,
				            	showConfirmButton: false,
				            	onOpen: () => document.activeElement.blur()
					        });							
						}

						$('.input-verification-code').pincodeInput({
							hidedigits:false,
							inputs:6,
							complete:function(value, e, errorElement){     
								$.ajaxSetup({
									headers: { 'apikey': '<?= $this->Apikey ?>' }
								})
								$.ajax({
									type: 'POST',
									url: '/api/authentication/submit-verification-code',
									data: { Code: value, Email: $('[name=Email]').val(), Activity: 'activation', Auto: 1 },
								 	success: function(response){
										if(response.Status == 1) {
											window.location.assign('<?= $this->RedirectUrl ?>' ? '<?= $this->RedirectUrl ?>' : response.RedirectUrl);
										} else {
						            		$(errorElement).html("Kode aktifasi salah");
										}
									}, error: function(response) {
					            		$(errorElement).html("Terjadi kesalahan jaringan");
									}
								});							            						
			            	}
			        	});					        										 		
					}, error: function(response) {
						hideLoading();
						swal({
							title: 'Mohon Maaf',
				            html: 'Terjadi kesalahan jaringan',
				            type: 'info',
				            showCloseButton: true,
			            	showConfirmButton: false,
			            	onOpen: () => document.activeElement.blur()
				        });													
					}
				});				
			}
		});

	});	

	function showLoginForm(){
		window.location.assign('/login');	
	}

	function showRegistrationForm(){
		window.location.assign('/registration');	
	}

	function showForgotPasswordForm(){
		window.location.assign('/forfot-password');	
	}	

	function sendEmailVerification(){
		$.ajaxSetup({
			headers: { 'apikey': '<?= $this->Apikey ?>' }
		})
		$.ajax({
			type: 'POST',
			url: '/api/authentication/send-verification-email',
			data: { Email : $('[name=Email]').val() },
		 	success: function(response){
				if(response.Status == 1) {
					$('.message-verification-code').html('Kirim kode aktivasi berhasil, silahkan cek email Anda').addClass('text-success').removeClass('text-danger');
				} else {
					$('.message-verification-code').html(response.Message).addClass('text-danger').removeClass('text-success');
				}
			}, error: function(response) {
				$('.message-verification-code').html('Terjadi kesalahan jaringan, silahkan cek koneksi jaringan Anda').addClass('text-danger').removeClass('text-success');
			}
		});    				
	}	

	function getData(){
		var data = {};

		$.each($('form .form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

        return data;
	}	

</script>
