<?php $this->extend('Layouts/layout-blank.html.php'); ?>

<body class="app flex-row align-items-center  pace-done">

	<div class="pace  pace-inactive">
		<div class="pace-progress" data-progress-text="100%" data-progress="99" style="transform: translate3d(100%, 0px, 0px);">
			<div class="pace-progress-inner"></div>
		</div>
		<div class="pace-activity"></div>
	</div>
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-sm-10 col-md-8 col-lg-5">
				<div class="card-group">
					<div class="card p-4">
						<div class="card-body">
														
				  			<img src="/assets/images/logo/logo_header.png" class="img-header mb-4" />
							
							<h1>Reset Password</h1>
							<p class="text-muted">
								Silakan atur ulang password Anda 
							</p>

							<form>
								<div class="form-group">
									<label class="col-form-label">Password baru</label>
									<input type="password" class="form-control" name="Password" placeholder="">
								</div>
								<div class="form-group">
									<label class="col-form-label">Konfirmasi password baru</label>
									<input type="password" class="form-control" name="ConfirmNewPassword" placeholder="">
								</div>
							</form>
							<div class="form-group text-right">
								<button type="submit" class="btn btn-danger btn-submit">Simpan</button>
							</div>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="custom-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
		<div class="modal-dialog modal-danger" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">Pesan Kesalahan</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">×</span>
					</button>
				</div>
				<div class="modal-body"></div>
			</div>
		</div>
	</div>	

</body>

<script type="text/javascript">
	
    $(document).ready(function(){

    	$('.btn-submit').click(function(){
    		$('form').submit();
    	});

		$.validator.setDefaults({
			submitHandler:function submitHandler(){

				showLoading();

				$.ajax({
					type: 'POST',
					url: window.location.href,
					data: getData(),
				 	success: function(response){
						if(response.Status == 1) {
							window.location.assign('/reset-password/success');
						} else {
							hideLoading();
							swal({
								title: 'Mohon Maaf',
					            html: response.Message,
					            type: 'info',
					            showCloseButton: true
					        });
						}
					}, error: function(response) {
						hideLoading();
						swal({
							title: 'Mohon Maaf',
				            html: 'Terjadi kesalahan jaringan',
				            type: 'info',
				            showCloseButton: true
				        });					}
				});

			}
		});
		
		$('form').validate({
			rules:{
				Password: { required:true, minlength: 6 },
				ConfirmNewPassword:{ required:true, minlength: 6, equalTo:'[name=Password]' }				
			},
			messages:{
				Password:{
					required: 'Password baru harus diisi',
					minlength:'Password minimal 6 karakter'
				},
				ConfirmNewPassword:{
					required: 'Password konfirmasi harus diisi',
					minlength:'Password minimal 6 karakter',
					equalTo: 'Password knfirmasi tidak sama dengan password baru'
				},				
			},
			errorElement:'em',
			errorPlacement:function errorPlacement(error,element){
				error.addClass('invalid-feedback');
				if(element.prop('type')==='checkbox'){
					error.insertAfter(element.parent('label'));
				}else{
					error.insertAfter(element);
				}
			},
			highlight:function highlight(element){
				$(element).addClass('is-invalid').removeClass('is-valid');
			},
			unhighlight:function unhighlight(element){
				$(element).addClass('is-valid').removeClass('is-invalid');
			}
		});

	});	

	function getData(){
		var data = {};

		$.each($('form .form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

        return data;
	}

</script>
