
<!-- modal for login -->
<div id="modal-login-form" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-danger" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-user-lock"></i>
                    Login
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
				<p class="text-muted">Sign In to your account</p>

				<form id="form-login">
					<div class="input-group mb-3">
						<input type="text" class="form-control input-enter" name="Email" placeholder="Email">
					</div>
					<div class="input-group mb-4">
						<input type="password" class="form-control input-enter" name="Password" placeholder="Password">
					</div>
				</form>
				<a href="javascript:void(0)">									
					<button type="button" class="btn-link px-0 small btn-forgot-password">Lupa password?</button>
				</a>					
				|
				<a href="javascript:void(0)">									
					<button type="button" class="btn-link px-0 small btn-registration">Belum punya akun?</button>
				</a>				
            </div>
            <div class="modal-footer">
				<button type="button" class="btn btn-danger px-5 btn-submit-login">Login</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for login -->

<!-- modal for register -->
<div id="modal-registration-form" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-danger" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-user-edit"></i>
                    Registration
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
				<p class="text-muted">Create your account</p>
				<form id="form-registration">
					<div class="input-group mb-3">
						<input type="text" class="form-control input-enter" name="Name" placeholder="Nama">
					</div>
					<div class="input-group mb-3">
						<input type="text" class="form-control input-enter" name="Email" placeholder="Email">
					</div>
					<div class="input-group mb-3">
						<input type="password" id="password-registration-value" class="form-control input-enter" name="Password" placeholder="Password">
					</div>
					<div class="input-group mb-3">
						<input type="password" class="form-control input-enter" name="ConfirmPassword" placeholder="Konfirmasi Password">
					</div>
                    <div class="d-flex flex-wrap py-3">
                        <div class="px-1 align-items-center d-flex">
							<span class="captcha-q"></span>
						</div>
                        <div class="px-1 align-items-center d-flex">
							<input type="text" class="form-control input-enter" name="Captcha" placeholder="?" style="width:50px">
						</div>
					</div>

					<a href="javascript:void(0)">									
						<button type="button" class="btn-link px-0 small btn-login">Sudah punya akun?</button>
					</a>					
				</form>
            </div>
            <div class="modal-footer">
				<button type="button" class="btn btn-danger btn-submit-registration">Buat akun</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for register -->

<!-- modal for forgot password -->
<div id="modal-forgot-password-form" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-danger" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-user-lock"></i>
                    Lupa Password
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
				<p class="text-muted">Masukan email Anda untuk melakukan reset password </p>
				<form id="form-forgot-password">
					<div class="input-group mb-3">
						<input type="text" class="form-control" name="Email" placeholder="Email">
					</div>
					<div class="input-group mb-3">
						<input type="password" id="password-forgot-password-value" class="form-control input-enter" name="Password" placeholder="Password Baru">
					</div>
					<div class="input-group mb-3">
						<input type="password" class="form-control input-enter" name="ConfirmPassword" placeholder="Konfirmasi Password Baru">
					</div>
				</form>

				<a href="javascript:void(0)">									
					<button type="button" class="btn-link px-0 small btn-login">Login</button>
				</a>				
            </div>
            <div class="modal-footer">
				<button type="button" class="btn btn-danger px-5 btn-submit-forgot-password">Kirim</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for forgot password -->

<link href="/assets/css/bootstrap-pincode-input.css" rel="stylesheet">
<script src="/assets/js/bootstrap-pincode-input.js"></script> 
<script type="text/javascript">
	
	$(document).ready(function(){

		capt_cha.generate();
		$('.captcha-q').text(capt_cha.show() + ' = ');

		$.validator.addMethod("captcha", function(value, element) {
			return value == capt_cha.solve();
		}, "&nbsp;Jawaban salah");    	
		
		$.validator.addMethod("emailcustom", function(value, element) {
			return this.optional(element) || /\S+@\S+\.\S+/i.test(value);
		}, "Format email tidak valid");    	

	    $(".btn-next").click(function(){
	        $.ajax({
	            type: 'POST',
	            url: '/check-login-status',
	            success: function(response){
	                if(response.Status){
	                    window.location.assign(redirectUrl);
	                } else{
						swal({
			                title: '',
			                text: 'Apakah Anda sudah mendaftar sebelumnya?',
			                type: 'question',
			                showCancelButton: true,
			                cancelButtonText: 'Belum',
			                confirmButtonText: 'Sudah',
			                onOpen: () => document.activeElement.blur()
			            }).then((result) => {
			                if (result.value) {
			                	$('#modal-login-form').modal('show');
			                } else if(result.dismiss == 'cancel'){
			                	$('#modal-registration-form').modal('show');
					        }
			            });						
	                }
	            }, error: function(response) {  
                    swal("", "Terjadi kesalahan jaringan pada jaringan Anda, apabila terjadi dalam jangka waktu lama dapat menghubungi kami di http://pakarya.com/contact-us", "error");
	            }
	        });
	    });

    	$('[name=Email]').change(function(){
			$('[name=Email]').val($(this).val());	    
		});

    	$('.btn-forgot-password').click(function(){
    		showForgotPasswordForm();
    	});

    	$('.btn-login').click(function(){
    		showLoginForm();
    	});

    	$('.btn-registration').click(function(){
    		showRegistrationForm();
    	});

    	$('.input-enter').on('keyup', function (e) {
    		if (e.which == 13) {
    			$(this).closest('form').submit();
    		}
    	});	    

    	$('.btn-submit-login').click(function(){
    		$('#form-login').submit();
    	});

    	$('.btn-submit-registration').click(function(){
    		$('#form-registration').submit();
    	});

    	$('.btn-submit-forgot-password').click(function(){
    		$('#form-forgot-password').submit();
    	});

		$('#form-login').validate({
			rules:{
				Email: { required:true, email:true },
				Password: { required:true }
			},
			messages:{
				Email: {
					required: 'Email harus diisi',
					email: 'Format email tidak valid'
				},
				Password: {
					required:'Password harus diisi',
				}
			},
			errorElement:'em',
			errorPlacement:function errorPlacement(error,element){
				error.addClass('invalid-feedback');
				if(element.prop('type')==='checkbox'){
					error.insertAfter(element.parent('label'));
				}else{
					error.insertAfter(element);
				}
			},
			highlight:function highlight(element){
				$(element).addClass('is-invalid').removeClass('is-valid');
			},
			unhighlight:function unhighlight(element){
				$(element).addClass('is-valid').removeClass('is-invalid');
			}, 
			submitHandler: function(form) {
				showLoading();

				$.ajax({
					type: 'POST',
					url: '/login',
					data: getDataLogin(),
				 	success: function(response){
						if(response.Status == 1) {
							window.location.assign(redirectUrl);
						} else {
							hideLoading();
							swal({
								title: 'Mohon Maaf',
					            html: response.Message,
					            type: 'warning',
					            showCloseButton: true,
					            showConfirmButton: false,
					            onOpen: () => document.activeElement.blur()
					        });							

							$('.input-verification-code').pincodeInput({
								hidedigits:false,
								inputs:6,
								complete:function(value, e, errorElement){     
									$.ajaxSetup({
										headers: { 'apikey': '<?= $this->Apikey ?>' }
									})
									$.ajax({
										type: 'POST',
										url: '/api/authentication/submit-verification-code',
										data: { Code: value, Email: $('[name=Email]').val(), Activity: 'activation', Auto: 1 },
									 	success: function(response){
											if(response.Status == 1) {
												window.location.assign(redirectUrl);
											} else {
							            		$(errorElement).html("Kode aktifasi salah");
											}
										}, error: function(response) {
						            		$(errorElement).html("Terjadi kesalahan jaringan");
										}
									});				
				            	}
				        	});					        
						}
					}, error: function(response) {
						hideLoading();
						swal({
							title: 'Mohon Maaf',
				            html: 'Terjadi kesalahan pada jaringan',
				            type: 'warning',
				            showCloseButton: true,
				            showConfirmButton: false,
				            onOpen: () => document.activeElement.blur()
				        });							
					}
				});				
		  	}
		});	    

		$('#form-registration').validate({
			rules:{
				Name: { required:true },
				Email: { required:true, emailcustom:true },
				Password: { required:true, minlength: 6 },
				Captcha: { captcha :true },
				ConfirmPassword: { required:true, equalTo:'#password-registration-value' }
			},
			messages:{
				Name: {
					required:'Nama harus diisi',
				},
				Email: {
					required: 'Email harus diisi'
				},
				Password: {
					required:'Password harus diisi',
					minlength:'Masukan password minimal 6 karakter'
				},
				ConfirmPassword: {
					required:'Konfirmasi password harus diisi',
					equalTo:'Konfirmasi password tidak sama'
				}
			},
			errorElement:'em',
			errorPlacement:function errorPlacement(error,element){
				error.addClass('invalid-feedback');
				if(element.prop('type')==='checkbox'){
					error.insertAfter(element.parent('label'));
				}else{
					error.insertAfter(element);
				}
			},
			highlight:function highlight(element){
				$(element).addClass('is-invalid').removeClass('is-valid');
			},
			unhighlight:function unhighlight(element){
				$(element).addClass('is-valid').removeClass('is-invalid');
			}, 
			submitHandler: function(form) {
				showLoading();

				$.ajaxSetup({
					headers: { 'apikey': '<?= $this->Apikey ?>' }
				})
				$.ajax({
					type: 'POST',
					url: '/api/authentication/registration',
					data: getDataRegistration(),
				 	success: function(response){
						hideLoading();

						if(response.Status == 1) {
							swal({
					            html: response.Message,
					            type: 'success',
					            showCloseButton: true,
				            	showConfirmButton: false,
				            	onOpen: () => document.activeElement.blur()
					        });							
						} else {
							swal({
					            html: response.Message,
					            type: 'warning',
					            showCloseButton: true,
				            	showConfirmButton: false,
				            	onOpen: () => document.activeElement.blur()
					        });							
						}

						$('.input-verification-code').pincodeInput({
							hidedigits:false,
							inputs:6,
							complete:function(value, e, errorElement){     
								$.ajaxSetup({
									headers: { 'apikey': '<?= $this->Apikey ?>' }
								})
								$.ajax({
									type: 'POST',
									url: '/api/authentication/submit-verification-code',
									data: { Code: value, Email: $('[name=Email]').val(), Activity: 'activation', Auto: 1 },
								 	success: function(response){
										if(response.Status == 1) {
											window.location.assign(redirectUrl);
										} else {
						            		$(errorElement).html("Kode aktifasi salah");
										}
									}, error: function(response) {
					            		$(errorElement).html("Terjadi kesalahan jaringan");
									}
								});							            						
			            	}
			        	});					        						
					}, error: function(response) {
						hideLoading();
						swal({
				            html: 'Terjadi kesalahan jaringan',
				            type: 'warning',
				            showCloseButton: true,
				            showConfirmButton: false,
				            onOpen: () => document.activeElement.blur()
				        });													
					}
				});			
			}
		});		

		$('#form-forgot-password').validate({
			rules:{
				Email: { required:true, email:true },
				Password: { required:true, minlength: 6 },
				ConfirmPassword: { required:true, equalTo:'#password-forgot-password-value' }
			},
			messages:{
				Email: {
					required: 'Email harus diisi',
					email: 'Format email tidak valid'
				},
				Password: {
					required:'Password harus diisi',
					minlength:'Masukan password minimal 6 karakter'
				},
				ConfirmPassword: {
					required:'Konfirmasi password harus diisi',
					equalTo:'Konfirmasi password tidak sama'
				}			
			},
			errorElement:'em',
			errorPlacement:function errorPlacement(error,element){
				error.addClass('invalid-feedback');
				if(element.prop('type')==='checkbox'){
					error.insertAfter(element.parent('label'));
				}else{
					error.insertAfter(element);
				}
			},
			highlight:function highlight(element){
				$(element).addClass('is-invalid').removeClass('is-valid');
			},
			unhighlight:function unhighlight(element){
				$(element).addClass('is-valid').removeClass('is-invalid');
			}, 
			submitHandler: function(form) {
				showLoading();

				$.ajaxSetup({
					headers: { 'apikey': '<?= $this->Apikey ?>' }
				})
				$.ajax({
					type: 'POST',
					url: '/api/authentication/forgot-password',
					data: getDataForgotPassword(),
				 	success: function(response){
				 		hideLoading();

						if(response.Status == 1) {
							swal({
					            html: response.Message,
					            type: 'success',
					            showCloseButton: true,
				            	showConfirmButton: false,
				            	onOpen: () => document.activeElement.blur()
					        });							
						} else {
							swal({
					            html: response.Message,
					            type: 'warning',
					            showCloseButton: true,
				            	showConfirmButton: false,
				            	onOpen: () => document.activeElement.blur()
					        });							
						}

						$('.input-verification-code').pincodeInput({
							hidedigits:false,
							inputs:6,
							complete:function(value, e, errorElement){     
								$.ajaxSetup({
									headers: { 'apikey': '<?= $this->Apikey ?>' }
								})
								$.ajax({
									type: 'POST',
									url: '/api/authentication/submit-verification-code',
									data: { Code: value, Email: $('[name=Email]').val(), Activity: 'activation,change-password', NewPassword: getDataForgotPassword()['Password'], Auto: 1 },
								 	success: function(response){
										if(response.Status == 1) {
											window.location.assign(redirectUrl);
										} else {
						            		$(errorElement).html("Kode aktifasi salah");
										}
									}, error: function(response) {
					            		$(errorElement).html("Terjadi kesalahan jaringan");
									}
								});							            						
			            	}
			        	});					        						
					}, error: function(response) {
						hideLoading();
						swal({
							title: 'Mohon Maaf',
				            html: 'Terjadi kesalahan jaringan',
				            type: 'warning',
				            showCloseButton: true,
				            showConfirmButton: false,
				            onOpen: () => document.activeElement.blur()
				        });
					}
				});
			}				
		});
    });

	function showLoginForm(){
		if(Swal.isVisible()) Swal.close();

		$('.modal').modal('hide');
    	$('#modal-login-form').modal('show');    		
	}

	function showRegistrationForm(){
		if(Swal.isVisible()) Swal.close();

		$('.modal').modal('hide');
    	$('#modal-registration-form').modal('show');    		
	}

	function showForgotPasswordForm(){
		if(Swal.isVisible()) Swal.close();

		$('.modal').modal('hide');
    	$('#modal-forgot-password-form').modal('show');    		
	}

	function getDataLogin(){
		var data = {};

		$.each($('#form-login .form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

		data['Role'] = 'Participant';
		data['Popup'] = 1;
        return data;
	}    

	function getDataRegistration(){
		var data = {};

		$.each($('#form-registration .form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

		data['Popup'] = 1;
        return data;
	}	

	function getDataForgotPassword(){
		var data = {};

		$.each($('#form-forgot-password .form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

		data['Popup'] = 1;
        return data;
	}	

	function sendEmailVerification(){
		$.ajaxSetup({
			headers: { 'apikey': '<?= $this->Apikey ?>' }
		})
		$.ajax({
			type: 'POST',
			url: '/api/authentication/send-verification-email',
			data: { Email : $('[name=Email]').val() },
		 	success: function(response){
				if(response.Status == 1) {
					$('.message-verification-code').html('Kirim kode aktivasi berhasil, silahkan cek email Anda').addClass('text-success').removeClass('text-danger');
				} else {
					$('.message-verification-code').html(response.Message).addClass('text-danger').removeClass('text-success');
				}
			}, error: function(response) {
				$('.message-verification-code').html('Terjadi kesalahan jaringan, silahkan cek koneksi jaringan Anda').addClass('text-danger').removeClass('text-success');
			}
		});    				
	}	

</script>
