<?php if($this->UserId){ ?>
<?php
    $provinces = \AppModel\Master::getProvinces();
    $cities = \AppModel\Master::getCities();

    $array_city = [];
    foreach($cities as $city) {
        $province_name = $city->Province->Name;
        $temp['Id'] = $city->o_id;
        $temp['City'] = $city->Name;
        $temp['Province'] = $province_name;
        if($city->Province){
            if(array_key_exists($province_name, $array_city)){
                array_push($array_city[$province_name], $temp);
            } else {
                $array_city[$province_name] = [$temp];
            }
        }
    }
    $cities = json_encode($array_city, JSON_PARTIAL_OUTPUT_ON_ERROR);
    $cities = addslashes(preg_replace('/[\t\r\n\v\f]/', '', $cities));

    $params = new \stdClass;
    $params->Id = $this->UserId;
    $profile = \AuthenticationModel\User::getById($params)->Data;   

    $this->Provinces = $provinces;
    $this->Cities = $cities;
    $this->Profile = $profile;
?>

<style type="text/css">
    .modal-backdrop.show {
        opacity: .8;
    }
</style>   

<!-- modal for update profile -->
<div id="modal-update-profile-form" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-danger modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-user-edit"></i>
                    Lengkapi Biodata Anda
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="form-update-profile">        
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="col-form-label">Nama <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control" name="Name" data-mask="Z" data-rule-required="true" data-msg-required="Nama harus diisi" value="<?= $this->Profile->Name ?>" >
                            </div>
                            <div class="form-group d-none">
                                <label class="col-form-label">Email <i class="nav-icon fas fa-info-circle"data-toggle="tooltip" data-placement="right" title="" data-original-title="Email tidak dapat diubah" ></i>  </label>
                                <p class="font-weight-bold mb-0"> <?= $this->Profile->Email ?> </p>
                                <hr class="mt-1">
                            </div>
                            <div class="form-group">
                                <label class="col-form-label">No Telepon </label>
                                <input type="text" class="form-control" name="Phone" data-mask="0000000009999" data-rule-minlength="10" data-msg-minlength="Format not valid" value="<?= $this->Profile->Phone ?>">
                            </div>
                            <div class="form-group">
                                <label class="col-form-label">Jenis Kelamin <span class="text-danger">*</span> </label>
                                <select name="Gender" class="form-control" data-rule-required="true" data-msg-required="Jenis kelamin harus diisi" >
                                    <option value="">Pilih jenis kelamin</option>
                                    <option value="Laki-laki">Laki-laki</option>
                                    <option value="Perempuan">Perempuan</option>
                                </select>
                            </div>                
                            <div class="form-group">
                                <label class="col-form-label">Tanggal lahir <span class="text-danger">*</span> </label>
                                <div class="controls">
                                    <div class='input-group dob'>                   
                                        <span class="input-group-addon">
                                            <i class="far fa-calendar-alt fa-lg bg-danger p-3"></i>
                                        </span>
                                        <input type="text" class="form-control bg-white" name="Dob" readonly data-rule-required="true" data-msg-required="Date of birth required">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-12 col-md-6 mb-3">
                                    <label class="col-form-label">Province <span class="text-danger">*</span> </label>
                                    <select name="Province" class="form-control" data-rule-required="true" data-msg-required="Province required" onchange="changeProvince(this)">
                                        <option value="">Pilih provinsi</option>

                                        <?php if($this->Provinces){ ?>
                                        <?php foreach($this->Provinces as $key => $province) { ?>
                                        
                                        <option value="<?= $province->Name?>" data-filter="<?= $province->Name ?>"><?= $province->Name?></option>
                                        
                                        <?php } ?> 
                                        <?php } ?>                                                          

                                    </select>                        
                                </div>
                                <div class="col-sm-12 col-md-6 mb-3">
                                    <label class="col-form-label">City <span class="text-danger">*</span> </label>
                                    <select name="City" class="form-control" data-rule-required="true" data-msg-required="City required" >
                                        <option value="">Pilih kota</option>
                                    </select>
                                </div>
                            </div>                                  
                            <div class="form-group">
                                <label class="col-form-label">Pendidikan Terakhir</label>
                                <select name="Education" class="form-control" >
                                    <option value="">Pilih pendidikan</option>
                                    <option value="SD">SD</option>
                                    <option value="SMP">SMP</option>
                                    <option value="SMA">SMA</option>
                                    <option value="S1">S1</option>
                                    <option value="S2">S2</option>
                                    <option value="S3">S3</option>
                                </select>
                            </div>                
                        </div>

                        <div class="col-lg-6 text-center">
                            <div class="form-group">
                                <label class="col-form-label"> Foto Profile </label>
                                <input type="file" class="form-control image-file-input d-none" name="FileProfilePicture" accept="image/png, image/jpg, image/jpeg" >
                                <input type="hidden" class="form-control" name="ProfilePicture" >
                                <div class="clearfix"></div>
                                <img class="col-8 px-0 p-1 my-2 border img-preview" src="<?= $this->Profile->ProfilePicture ? $this->Profile->ProfilePicture : '/assets/images/placeholder_human_600_600.png' ?>" onclick="$('.image-file-input').click()" /> 
                            </div>

                            <div class="form-group ">
                                <input type="hidden" class="form-control" name="Id" value="<?= $this->UserId ?>">
                                <button type="submit" class="btn btn-danger mt-4 px-5 btn-submit">
                                    <i class="fa fa-check-circle"></i> 
                                    Simpan
                                </button>
                            </div>          
                        </div>                              
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>  
<!-- modal for update profile -->

<script type="text/javascript">

    var redirectUrl = $(".trigger-profile").attr('data-redirect');
    var noConfirm = $(".trigger-profile").attr('data-noconfirm');
    var autoClick = $(".trigger-profile").attr('data-autoclick');
    var notClose = $(".trigger-profile").attr('data-notclose');
    
    $(document).ready(function(){

        if('<?= $this->Profile->Province ?>'){
            $('[name=Province]').val('<?= $this->Profile->Province ?>').change();
            
            if('<?= $this->Profile->City ?>'){
                $('[name=City]').val('<?= $this->Profile->City ?>');                            
            }
        }       

        $('[name=Gender]').val('<?= $this->Profile->Gender ?>');                            
        $('[name=Education]').val('<?= $this->Profile->Education ?>');                            


        $('[data-toggle="tooltip"]').tooltip();

        $('.input-group.dob').datetimepicker({
            viewMode: 'years',
            ignoreReadonly: true,
            allowInputToggle: true,
            useCurrent: false,
            defaultDate: <?= $this->Profile->Dob ? 'moment(' . $this->Profile->Dob->timestamp * 1000 . ')' : 'false' ?>,
            maxDate: moment().subtract(13, 'years'),
            format: 'DD-MM-YYYY'
        });

        $('#form-update-profile .form-control').on('keyup', function (e) {
            if (e.which == 13) {
                $(this).closest('#form-update-profile').find('.btn-submit').first().click();
            }
        }).find('[type=text]').on('change', function (e) {
            $(this).val($(this).val().trim());
        });
        
        $(".image-file-input").change(function(){ 
            showImg(this);
        });     
        
        validationForm();

        $(".trigger-profile").click(function(){
            showLoading();
            $.ajax({
                type: 'POST',
                url: '/check-profile-status',
                data: { Id : '<?= $this->UserId ?>' },
                success: function(response){
                    hideLoading();
                    if(response.Status){
                        if(redirectUrl){
                            window.location.assign(redirectUrl);
                        }
                    } else{
                        if(notClose){
                            $('#modal-update-profile-form .close').hide();
                            $('#modal-update-profile-form').modal({backdrop: 'static', keyboard: false});
                        }

                        if(noConfirm){
                            $('#modal-update-profile-form').modal('show');
                        } else {
                            swal({
                                title: '',
                                html: 'Anda harus melengkapi data terlebih dahulu<br><br>Anda setuju?<br><br>',
                                type: 'question',
                                showCancelButton: true,
                                cancelButtonText: 'Tidak',
                                confirmButtonText: 'Ya',
                                onOpen: () => document.activeElement.blur()
                            }).then((result) => {
                                if (result.value) {
                                    $('#modal-update-profile-form').modal('show');
                                }
                            });                     
                        }
                    }
                }, error: function(response) {  
                    hideLoading();
                    swal("", "Terjadi kesalahan jaringan pada jaringan Anda, apabila terjadi dalam jangka waktu lama dapat menghubungi kami di http://pakarya.com/contact-us", "error");
                }
            });
        });

        if(autoClick){
            $(".trigger-profile").click();
        }
    });

    function getDataUser(){
        var data = {};

        $.each($('#form-update-profile').find('.form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

        return data;
    }       

    function submitProfile(){    
        showLoading();

        $.ajaxSetup({
            headers: { 'apikey': '<?= $this->Apikey ?>' }
        });
        $.ajax({            
            type : 'post',
            url  : '/api/authentication/update-profile',
            data : getDataUser(),
            timeout: 45000,
            success:function(response){
                hideLoading();
                if(response.Status){            
                    swal({
                        title: '',
                        html: 'Profil Anda berhasil diperbarui',
                        type: 'success',
                        showCloseButton: false,
                        showConfirmButton: false,
                        timer: 2000
                    });

                    setTimeout(function(){  
                        if(redirectUrl){                        
                            showLoading();
                            window.location.assign(redirectUrl);
                        } else {
                            $('#modal-update-profile-form').modal('hide');                            
                        }
                    }, 2000);                    

                }else{
                    swal({
                        title: 'Mohon Maaf',
                        html: response.Message,
                        type: 'info',
                        showCloseButton: true
                    });                         
                }
            },
            error: function(response){
                hideLoading();
                swal({
                    title: 'Mohon Maaf',
                    html: 'Terjadi kesalahan pada jaringan',
                    type: 'info',
                    showCloseButton: true
                });                         
            }
        }); 

    }

    function validationForm(){
        $('#form-update-profile').validate({
            errorElement:'em',
            errorPlacement:function errorPlacement(error,element){
                error.addClass('invalid-feedback');
                if(element.prop('type')==='checkbox'){
                    error.insertAfter(element.parent('label'));
                }else{
                    error.insertAfter(element);
                }
            },
            highlight:function highlight(element){
                $(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight:function unhighlight(element){
                $(element).addClass('is-valid').removeClass('is-invalid');
            },
            submitHandler: function(form) {
                submitProfile();
            }
        });
    }

    function changeProvince(thisProvince){
        var cities = JSON.parse("<?= $this->Cities ?>");
        var provinceSelected = $(thisProvince).val();
        var thisCity = $(thisProvince).closest('#form-update-profile').find('[name=City]');

        if(!$(thisProvince).val()){
            thisCity.val('').attr('disabled', 'disabled');
            return false;
        } else{
            thisCity.removeAttr('disabled');            
        }

        thisCity.html('<option value="" selected> Pilih kota </option>');        
        $.each(cities[provinceSelected], function(k,v){
            thisCity.append('<option value="' + v.City + '">' + v.City + '</option>');
        });
    }

    function showImg(input) {
        var url = input.value;
        var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
        if (input.files && input.files[0]&& (ext == "png" || ext == "jpeg" || ext == "jpg")) {
            var reader = new FileReader();

            reader.onload = function (e) {
                $(input).siblings('img').attr('src', e.target.result);
                $(input).siblings('[type=hidden]').val(e.target.result);
            }
            
            reader.readAsDataURL(input.files[0]);
        } else { 
            $('#custom-modal .modal-body').html('File yang dipilih harus bertipe .jpg, .jpeg dan .png');
            $('#custom-modal').modal('show');

            $(input).val('');
        }
    }    

</script>
<?php } ?>
