<?php $this->extend('Layouts/layout-main.html.php'); ?>

<?php 
    $msai = $this->Msai;
    $answers = $this->Answers;
?>

<div class="container">

    <h2 class="text-center mb-4 mt-2">
        MANAGEMENT (LEADERSHIP) SKILLS ASSESSMENT INSTRUMENT (MSAI)
    </h2>

    <div class="alert alert-primary alert-dismissible fade show" role="alert">
        <strong> Informasi!</strong> Silahkan baca petunjuk pengerjaan dengan menekan tombol merah di kanan bawah layar Anda
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>

    <ul class="nav nav-pills mb-2 mt-3" id="pills-tab" role="tablist">

        <?php $i = 0; ?>
        <?php foreach ($msai as $key => $value) { ?>

        <li class="nav-item li-<?= $value['id'] ?>">
            <a class="nav-link <?= $i++ == 0 ? 'active' : '' ?>" href="javascript:void(0)"> 
                <?= $value['nama'] ?>            
            </a>
        </li>

        <?php } ?>        

    </ul>

    <div class="tab-content mb-5">

        <?php $i = 0; ?>
        <?php foreach ($msai as $key => $value) { ?>

        <div class="tab-pane fade parameter <?= $i++ == 0 ? 'active show' : '' ?>" id="<?= $value['id'] ?>" data-next="<?= $msai[$key+1]['id'] ?>" data-prev="<?= $msai[$key-1]['id'] ?>" >

            <div class="d-none d-sm-flex">

                <div class="col-sm-1 col-xs-1 font-weight-bold" style="width: 1%; white-space: nowrap;">
                    No 
                </div>
                <div class="col-sm-6 col-xs-11 font-weight-bold">
                    Pernyataan
                </div>

                <?php if($value['type'] == 'radio') { ?>                        
                <?php foreach ($value['option'] as $k => $v) { ?>

                    <div class="col-sm-1 col-xs-2 text-center font-weight-bold" <?= $v[2] ? 'data-toggle="tooltip" data-placement="bottom" title="' .$v[2]. '"' : '' ?> >
                        <?= $v[1] ?>
                    </div>

                <?php } ?>        
                <?php } ?>        

            </div>

            <?php foreach ($value['pernyataan'] as $key => $val) { ?>

                <hr class="my-4">

                <div class="container">

                    <div class="pernyataan row">
                        <div class="col-sm-1 col-xs-1" style="width: 1%; white-space: nowrap;">
                            <span class="font-weight-bold"> 
                                <text class="d-sm-none">Pernyataan </text> 
                                <?= $val[0] ?>
                            </span> 
                        </div>
                        <div class="<?= ($value['type'] == 'choice') ? 'col-sm-11' : 'col-sm-6' ?> col-xs-11 mb-3">
                            <span><?= $val[1] ?></span> 
                        </div>

                        <?php if($value['type'] == 'radio') { ?>                        

                            <?php foreach ($value['option'] as $k => $v) { ?>

                            <div class="col col-sm-1 col-xs-2 text-center">
                                <input type="radio" class="form-control" name="pernyataan-<?= $val[0] ?>" data-pernyataan="<?= $val[1] ?>" value="<?= $v[0] ?>" value-string="<?= $v[1] ?>" <?= $answers[($val[0]-1)][4] == $v[0] ? 'checked' : '' ?> > 
                                <span class="" <?= $v[2] ? 'data-toggle="tooltip" data-placement="bottom" title="' .$v[2]. '"' : '' ?> >
                                    <?= $v[1] ?>
                                </span>
                            </div>
                    
                            <?php } ?>        

                        <?php } ?>        

                        <?php if($value['type'] == 'choice') { ?>                        

            
                            <?php foreach ($val[2] as $k => $v) { ?>

                            <div class="container">
                                <div class="d-flex">
                                    <div class="col col-1">
                                        <input type="radio" class="form-control" name="pernyataan-<?= $val[0] ?>" value="<?= $v[0] ?>" data-pernyataan="<?= $val[1] ?>" value-string="<?= $v[1] ?>" <?= $answers[($val[0]-1)][4] == $v[0] ? 'checked' : '' ?> > 
                                    </div>
                                    <div class="col col-10">
                                        <?= $v[1] ?>                                
                                    </div>          
                                </div>                      
                            </div>                      

                            <?php } ?>        

                        <?php } ?>       

                    </div>                         
                </div>

            <?php } ?>        

            <div class="d-flex mt-4">
                <div class="col-6 col-xs-6">
                    <button class="btn btn-primary btn-prev mx-3">
                        <i class="fa fa-arrow-circle-left"></i> 
                        Sebelumnya
                    </button>
                </div>
                <div class="col-6 col-xs-6 text-right">
                    <button class="btn btn-primary btn-next mx-3">
                        <i class="fa fa-arrow-circle-right"></i> 
                        Selanjutnya
                    </button>
                </div>
            </div>

        </div>

        <?php } ?>        

    </div>    

</div>

<!-- button fixed for help -->
<div class="help-fixed">
    <button class="btn button-help" data-toggle="modal" data-target="#help-modal">
        <span class="d-none"> Petunjuk Pengerjaan </span> 
        <i class="fa fa-question "></i>
    </button>
</div>
<!-- button fixed for help -->

<!-- modal for petunjuk pengerjaan -->
<div id="help-modal" class="modal fade" id="confirm-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-info modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-question-circle"></i>
                    Petunjuk Pengerjaan MSAI
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>
                    Gambarkan perilaku anda sebagai seorang pemimpin di UNIT ORGANISASI maupun ORGANISASI/LEMBAGA. 
                </p>
                <p>
                    Jawablah pernyataan-pernyataan di bawah ini dengan perilaku yang paling sesuai dengan yang anda tampilkan sehari-hari, bukan dengan perilaku yang anda inginkan. Bila anda tidak yakin, buat perkiraan yang terbaik, jangan mengosongkan suatu jawaban.
                </p>

                <strong class="text-center"> Bagian 1</strong>
                <table>
                    <tr>
                        <td width="30px"> SS </td>
                        <td width="30px"> = </td>
                        <td> Sangat Setuju </td>
                    <tr>
                    <tr>
                        <td> S </td>
                        <td> = </td>
                        <td> Setuju </td>
                    <tr>
                    <tr>
                        <td> R </td>
                        <td> = </td>
                        <td> Rata-rata </td>
                    <tr>
                    <tr>
                        <td> TS </td>
                        <td> = </td>
                        <td> TIdak Setuju </td>
                    <tr>
                    <tr>
                        <td> STS </td>
                        <td> = </td>
                        <td> Sangat Tidak Setuju </td>
                    <tr>
                </table>

                <br>

                <strong class="text-center"> Bagian 2</strong>
                <span>
                    Untuk pertanyaan 61 – 73 nilailah efektivitas Anda dalam menilai keterampilan-keterampilan manajerial ini. Isilah pada lembar jawaban Anda dengan menggunakan skala penilaian berikut ini:                    
                </span>
                <table>
                    <tr>
                        <td width="30px"> SB </td>
                        <td width="30px"> = </td>
                        <td> Sangat Baik </td>
                    <tr>
                    <tr>
                        <td> B </td>
                        <td> = </td>
                        <td> Baik </td>
                    <tr>
                    <tr>
                        <td> C </td>
                        <td> = </td>
                        <td> Cukup </td>
                    <tr>
                    <tr>
                        <td> K </td>
                        <td> = </td>
                        <td> Kurang </td>
                    <tr>
                    <tr>
                        <td> SK </td>
                        <td> = </td>
                        <td> Sangat Kurang </td>
                    <tr>
                </table>

                <br>

                <strong class="text-center"> Bagian 3</strong>
                <span>
                    Untuk pertanyaan 74 – 75 isilah pada lembar jawaban Anda salah satu dari pilihan yang ada (PILIH HANYA SATU ALTERNATIF JAWABAN)
                </span>

                <br><br>

                <strong class="text-center"> Bagian 4</strong>
                <span>
                    CATATAN : Skala penilaian berubah untuk pertanyaan 76 – 87. Bacalah dengan hati-hati.
                </span>
                <span>
                    Untuk berhasil pada posisi jabatan anda saat ini, seberapa pentingkah keterampilan-keterampilan berikut ini? Isilah pada lembar jawaban Anda dengan menggunakan skala penilaian berikut:                    
                </span>
                <table>
                    <tr>
                        <td width="30px"> K </td>
                        <td width="30px"> = </td>
                        <td> Kritikal (Critically Important) </td>
                    <tr>
                    <tr>
                        <td> SP </td>
                        <td> = </td>
                        <td> Sangat penting (Very Important) </td>
                    <tr>
                    <tr>
                        <td> P </td>
                        <td> = </td>
                        <td> Penting (Moderately Important) </td>
                    <tr>
                    <tr>
                        <td> CP </td>
                        <td> = </td>
                        <td> Cukup penting (of Some Importance) </td>
                    <tr>
                    <tr>
                        <td> KP </td>
                        <td> = </td>
                        <td> Kurang penting (Little Importance) </td>
                    <tr>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary px-2" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for petunjuk pengerjaan -->

<!-- embed js function for update profile -->
<a class="trigger-profile" href="javascript:void(0)" data-autoclick="true" data-noconfirm="true" data-notclose="true"></a>
<?= $this->template("Includes/main/embed-update-profile-popup.html.php") ?>
<!-- embed js function for update profile -->

<script type="text/javascript">
    
    $(document).ready(function(){
        $('#help-modal').modal('show');
        $('[data-toggle="tooltip"]').tooltip();

        $(".btn-next").click(function(){
            goNext(this);
        });

        $(".btn-prev").click(function(){
            var prev = $(this).closest('.parameter').attr('data-prev');
            if(prev){
                goTab(prev);
            } else {
                window.location.href = '/sipbos/section/ocai';                              
            }
        });     

        $('.pernyataan input').click(function(){
            saveState();
        });
    });

    function goNext(ele){
        if(!validate(ele)) return false;

        finished = 1;
        var next = $(ele).closest('.parameter').attr('data-next');
        if(next){
            goTab(next);
            finished = 0;
        }
        saveState(finished);
    }

    function goTab(tabId){
        $('.nav li a').removeClass('active');
        $('.tab-pane.parameter').removeClass('active').removeClass('show');

        $('.li-' + tabId + ' a').addClass('active');
        $('#' + tabId).addClass('active').addClass('show');

        $('html, body').animate( {scrollTop:0}, '300');
    }

    function validate(ele){
        var error = 0, total = 0;
        var allValue = $(ele).closest('.parameter').find('.pernyataan');

        allValue.each(function (k, v) {

            if(!$(v).find('input:checked').length){
                $(v).find('span').css('color', '#d00');   
                error++;
            } else {
                $(v).find('span').css('color', '');                   
            }

        });

        if(error){
            swal("Anda belum mengisi semua pernyataan", ".Tolong pilih jawaban semua pernyataan yang berwana merah", "error");            
            return false;
        }

        return true;
    }

    function getData(){
        var data = new Object;

        var temp = [];
        $('.pernyataan').each(function (kPernyataan, vPernyataan) {
            var tempSub = [];
            var inputChecked = $(vPernyataan).find('input:checked');
            if(inputChecked.length){
                tempSub.push(kPernyataan+1);
                tempSub.push($(inputChecked).attr('data-pernyataan').trim());
                tempSub.push($(inputChecked).attr('name').trim());
                tempSub.push($(inputChecked).attr('value-string').trim());                 
                tempSub.push($(inputChecked).val().trim());
            } else {
                tempSub = ["", "", "", "", ""];                
            }
            temp.push(tempSub);
        });

        data['MsaiRaw'] = temp;        
        
        return data;
    }

   function saveState(finished){
        var data = getData();

        if(finished) data.MsaiFinished = 1;

        $.ajax({
            type: 'POST',
            url: '/sipbos/section/msai',
            data: { data : JSON.stringify(data) },
            success: function(response){
                if(response.Status){
                    console.log('save state');
                    if(finished){
                        showLoading();
                        window.location.assign('/sipbos/thankyou');
                    }
                } else{
                    console.log('failed save state');
                }
            }, error: function(response) {  
                console.log('failed save state');
            }
        });         
    }   

</script>
