<?php $this->extend('Layouts/layout-main.html.php'); ?>

<!-- css ion slider plugin -->
<link href="/assets/plugins/ion.rangeslider/css/normalize.css" rel="stylesheet">
<link href="/assets/plugins/ion.rangeslider/css/ion.rangeSlider.css" rel="stylesheet">
<link href="/assets/plugins/ion.rangeslider/css/ion.rangeSlider.skinFlat.css" rel="stylesheet">

<style type="text/css">
	@media screen and (min-width: 0) and (max-width: 768px) {
		.wrap-table.overflow-x{
			overflow-x: scroll;			
		}		   
	}
</style>

<div class="container">

    <h2 class="text-center mb-4 mt-2">
	    ORGANIZATIONAL CULTURE ASSESSMENT INSTRUMENT (OCAI)
    </h2>

    <div class="alert alert-primary alert-dismissible fade show" role="alert">
        <strong> Informasi!</strong> Silahkan baca petunjuk pengerjaan dengan menekan tombol merah di kanan bawah layar Anda
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>

    <ul class="nav nav-pills mb-2 mt-3" id="pills-tab" role="tablist">

    	<?php $i = 0; ?>
        <?php foreach ($this->Parameters as $key => $parameter) { ?>

        <li class="nav-item li-<?= $parameter['id'] ?>">
            <a class="nav-link <?= $i++ == 0 ? 'active' : '' ?>" href="javascript:void(0)"> 
                 <span class="d-lg-none"> P <?= ($key+1) ?> </span>  
                 <span class="d-none d-lg-block small"> <?= $parameter['nama'] ?> </span>            
            </a>
        </li>

        <?php } ?>        

    </ul>

    <div class="tab-content mb-5">

    	<?php $i = 0; ?>
        <?php foreach ($this->Parameters as $key => $parameter) { ?>
    	<?php $index_answer = 0; ?>

        <div class="tab-pane fade parameter <?= $i++ == 0 ? 'active show' : '' ?>"  id="<?= $parameter['id'] ?>" data-next="<?= $this->Parameters[$key+1]['id'] ?>" data-prev="<?= $this->Parameters[$key-1]['id'] ?>">

	        <div class="wrap-table overflow-x">

			    <table class="table table-hover">

			        <thead class="font-dark bold uppercase">
			            <tr>
			                <th rowspan="2" class="text-center" width="1%"> #<?= $key + 1 ?> </th>
			                <th rowspan="2" class="text-center hidden-xs" width="50%"> Pernyataan <?= $parameter['nama'] ?> </th>
			                <th colspan="2" class="text-center"> Unit Organisasi </th>
			                <th colspan="2" class="text-center"> Organisasi / Lembaga </th>
			            </tr>
			            <tr>
			                <th class="text-center" style="font-size: 11px"> Saat ini </th>
			                <th class="text-center" style="font-size: 11px"> Yang diinginkan </th>
			                <th class="text-center" style="font-size: 11px"> Saat ini </th>
			                <th class="text-center" style="font-size: 11px"> Yang diinginkan </th>
			            </tr>
			        </thead>

			        <tbody>

				        <?php foreach ($parameter['pernyataan'] as $pernyataanKey => $pernyataan) { ?>

			            <tr class="pernyataan" data-id="<?= $pernyataanKey ?>">
			                <td class="bold"> <?= $pernyataanKey ?> </td>
			                <td class="text font-dark bold hidden-xs"> 
			                	<?= $pernyataan ?> 
			                </td>
			                <td class="font-dark bold" style="min-width: 70px"> 
			                	<input type="text" class="form-control bg-white uk-si value-ocai" data-label="uk-si" value="<?= $parameter['answer'][$index_answer++] ?>" data-mask="099" readonly attr-level1="Unit Organisasi" attr-level2="Saat Ini"  />  
			                </td>
			                <td class="font-dark bold" style="min-width: 70px"> 
			                	<input type="text" class="form-control uk-di bg-white value-ocai" data-label="uk-di" value="<?= $parameter['answer'][$index_answer++] ?>" data-mask="099" readonly attr-level1="Unit Organisasi" attr-level2="Yang Diinginkan" />  
			                </td>
			                <td class="font-dark bold" style="min-width: 70px"> 
			                	<input type="text" class="form-control klh-si bg-white value-ocai" data-label="klh-si" value="<?= $parameter['answer'][$index_answer++] ?>" data-mask="099" readonly attr-level1="Organisasi/Lembaga" attr-level2="Saat Ini" />  
			                </td>
			                <td class="font-dark bold" style="min-width: 70px"> 
			                	<input type="text" class="form-control klh-di bg-white value-ocai" data-label="klh-di" value="<?= $parameter['answer'][$index_answer++] ?>" data-mask="099" readonly attr-level1="Organisasi/Lembaga" attr-level2="Yang Diinginkan" />  
			                </td>
			            </tr>

				        <?php } ?>        

			            <tr>
			                <td class="hidden-xs"> </td>
			                <td class="text-right bold"> 
			                	Total
			                </td>
			                <td class="text-center bold"> 
			                	<div class="total-score total-uk-si"> 0 </div>
			                </td>
			                <td class="text-center bold"> 
			                	<div class="total-score total-uk-di"> 0 </div>
			                </td>
			                <td class="text-center bold"> 
			                	<div class="total-score total-klh-si"> 0 </div>
			                </td>
			                <td class="text-center bold"> 
			                	<div class="total-score total-klh-di"> 0 </div>
			                </td>
			            </tr>

			        </tbody>
			    </table>        	

		   	</div>

            <div class="d-flex mt-5">
                <div class="col-6 col-xs-6">
                    <button class="btn btn-primary btn-prev mx-3">
                        <i class="fa fa-arrow-circle-left"></i> 
                        Sebelumnya
                    </button>
                </div>
                <div class="col-6 col-xs-6 text-right">
                    <button class="btn btn-primary btn-next mx-3">
                        <i class="fa fa-arrow-circle-right"></i> 
                        Selanjutnya
                    </button>
                </div>
            </div>

        </div>

        <?php } ?>    

    </div>
</div>

<!-- button fixed for help -->
<div class="help-fixed">
    <button class="btn button-help" data-toggle="modal" data-target="#help-modal">
        <span class="d-none"> Petunjuk Pengerjaan </span> 
        <i class="fa fa-question "></i>
    </button>
</div>
<!-- button fixed for help -->

<!-- modal for petunjuk pengerjaan -->
<div id="help-modal" class="modal fade" id="confirm-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-info modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-question-circle"></i>
                    Petunjuk Pengerjaan OCAI
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">

				<strong> Kuesioner kedua adalah OCAI, yang terdiri dari 6 pernyataan, yang harus dijawab dengan cara: </strong>

				<br><br>

				<p>
					Mengalokasikan sejumlah nilai kepada 4 (empat) pernyataan yang dianggap mewakili kondisi UNIT ORGANISASI dan ORGANISASI/LEMBAGA saat ini, dengan total nilai masing-masing 100, serta kondisi UNIT ORGANISASI dan ORGANISASI/LEMBAGA yang diinginkan, juga dengan total nilai masing-masing 100 (ipsative scale).
				</p>

				<p>
					Isi nilai/poin (0/10/20/30/40/50/60/70/80/90) pada lembar jawaban untuk setiap pernyataan sehingga total poin untuk pernyataan A+B+C+D adalah sama dengan 100. Besarnya nilai/poin didasarkan pada situasi/kondisi yang menurut Anda paling sesuai di UNIT ORGANISASI.
				</p>

				<p>
					Cara pengisian yang seperti ini juga berlaku untuk pernyataan A, B, C dan D, berdasarkan situasi/kondisi yang paling Anda inginkan ada di ORGANISASI/LEMBAGA            
				</p>

				<p>
					Hal ini menyatakan bahwa menurut Anda, saat ini UNIT ORGANISASI lebih merupakan Organisasi yang bersifat sangat personal, seperti dalam keluarga besar, dan sama sekali bukan tempat yang terkendali dan terpola (structured).
				</p>

				<p>
					Setelah anda menyelesaikan kolom “SAAT INI” yang menggambarkan situasi/kondisi UNIT ORGANISASI “SAAT INI”, silahkan mengisi kolom “YANG DIINGINKAN” untuk menggambarkan situasi/kondisi UNIT ORGANISASI “YANG DIINGINKAN”. Jangan mengosongkan kolom jawaban, isilah dengan angka di setiap kolom pada lembar jawaban, meskipun angkanya 0.
				</p>

				<p>
					Hal yang sama berlaku pula, saat anda menilai untuk kondisi ORGANISASI/LEMBAGA. Isilah kolom “SAAT INI” yang menggambarkan situasi/kondisi ORGANISASI/LEMBAGA “SAAT INI”, kemudian isilah kolom “YANG DIINGINKAN” untuk menggambarkan situasi/kondisi ORGANISASI/LEMBAGA “YANG DIINGINKAN”. Jangan mengosongkan kolom jawaban, isilah dengan angka di setiap kolom pada lembar jawaban, meskipun angkanya 0.				
				</p>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary px-2" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for petunjuk pengerjaan -->

<!-- modal for pilih nilai pernyataan -->
<div id="choose-value-modal" class="modal fade" id="confirm-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-info" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-question-circle"></i>
                    Pilih Nilai Pernyataan
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body text-center"> 

				<strong class="code"></strong>
				<br>
				<strong class="level1"></strong>
				<br>
				<strong class="level2"></strong>
				<br>
				<p class="pernyataan"></p>

				<div class="range-slider mx-3">
				    <input type="text" class="js-range-slider" value="" />
				    
				    <div class="d-flex mt-3">
				    	<div class="col-6 text-left p-0">
						    <button class="btn btn-danger minus js-btn-minus"> 
						    	<i class="fa fa-minus"></i> 
					    	</button>
					    </div>
				    	<div class="col-6 text-right p-0">						
						    <button class="btn btn-danger plus js-btn-plus">
						    	<i class="fa fa-plus"></i> 
					    	</button>
					    </div>
					</div>
				</div>

				<br>				
				<Strong class="">
					Catatan: 
				</Strong>
				<br>
				<strong>A + B + C + D = Harus 100</strong>

            </div>
            
            <div class="modal-footer"> 
                <button type="button" data-dismiss="modal" class="btn btn-outline dark">Batal</button>
                <button type="button" class="btn red btn-choose-value">Pilih</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal for pilih nilai pernyataan -->

<!-- embed js function for update profile -->
<a class="trigger-profile" href="javascript:void(0)" data-autoclick="true" data-noconfirm="true" data-notclose="true"></a>
<?= $this->template("Includes/main/embed-update-profile-popup.html.php") ?>
<!-- embed js function for update profile -->

<!-- js ion slider plugin -->
<script type="text/javascript" src="/assets/plugins/ion.rangeslider/js/ion.rangeSlider.min.js"></script>

<script type="text/javascript">

	var sliderInstance;
	
	$(document).ready(function(){
        $('#help-modal').modal('show');

	    $(".btn-next").click(function(){
	    	goNext(this);	    	
	    });

	    $(".btn-prev").click(function(){
			var prev = $(this).closest('.parameter').attr('data-prev');
			if(prev){
		    	goTab(prev);
			} else {
                window.location.href = '/sipbos/section/rvs';				
			}
	    });	    

	    $(".value-ocai").click(function(){
	    	var $thisInput = $(this);

	    	$('#choose-value-modal .level1').html($thisInput.attr('attr-level1'));
	    	$('#choose-value-modal .level2').html($thisInput.attr('attr-level2'));
	    	$('#choose-value-modal .code').html($thisInput.closest('tr').find('td').eq(0).html().trim());
	    	$('#choose-value-modal .pernyataan').html($thisInput.closest('tr').find('td').eq(1).html().trim());

	    	$('#choose-value-modal .btn-choose-value').unbind("click").click(function(){
	    		$thisInput.val(sliderInstance.old_from);
	    		updateScore($thisInput);
	    		$('#choose-value-modal').modal('hide');
	    	});

			var parameter = $thisInput.closest('.parameter');
			var inputs = parameter.find('.' + $thisInput.attr('data-label'));

			var total = 0;
			inputs.each(function (k, v) {
				var value = v.value ? v.value : 0;
				total += parseInt(value);
			});

			var subsVal = total - $thisInput.val();

	    	sliderInstance.update({
			    min: 0,
			    max: (100 - subsVal),
			    step: 1,
			    from: $thisInput.val()
	    	});

	    	$('#choose-value-modal').modal('show');	    	

	    });	    

		$(".js-range-slider").ionRangeSlider({
		    min: 0,
		    max: 100,
		    step: 1,
		    from: 0
		});

		sliderInstance = $(".js-range-slider").data("ionRangeSlider");
	
		$(".js-btn-minus").on("click", function () {
		    updateRange(-5);
		});

		$(".js-btn-plus").on("click", function () {
		    updateRange(5);
		});

		var updateRange = function (direction) {
		    sliderInstance.update({
		        from: sliderInstance.old_from + direction
		    });
		};	    

		// auto calculate total
		$(".value-ocai").each(function (k, v) {
			updateScore(this);
		});

	});

	function goNext(ele){
		if(!validate(ele)) return false;

        var finished = 1;
		var next = $(ele).closest('.parameter').attr('data-next');
		if(next){
            goTab(next);
            finished = 0;
		}
        saveState(finished);
	}

	function goTab(tabId){
		removeAllError();

        $('.nav li a').removeClass('active');
        $('.tab-pane.parameter').removeClass('active').removeClass('show');

        $('.li-' + tabId + ' a').addClass('active');
        $('#' + tabId).addClass('active').addClass('show');

        $('html, body').animate( {scrollTop:0}, '300');
	}

	function updateScore(ele){
		if(!$(ele).val()){
			$(ele).val('0');
		}

		var parameter = $(ele).closest('.parameter');
		var inputs = parameter.find('.' + $(ele).attr('data-label'));

		var total = 0;
		inputs.each(function (k, v) {
			var value = v.value ? v.value : 0;
			total += parseInt(value);
		});

		var eleTotal = parameter.find('.total-' + $(ele).attr('data-label'));
		eleTotal.html(total);
		
		if(total == 100){
			eleTotal.css('color', '');
			eleTotal.tooltip('dispose');			
		} 
	}

	function validate(ele){
		var parameter = $(ele).closest('.parameter');

		var ukSi = parameter.find('.total-uk-si');
		var ukDi = parameter.find('.total-uk-di');
		var klhSi = parameter.find('.total-klh-si');
		var klhDi = parameter.find('.total-klh-di');

		var valid = true;
		
		validUkSi = checkValid(ukSi, 'Total nilai harus 100', 'bottom');
		validUkDi = checkValid(ukDi, 'Total nilai harus 100', 'bottom');
		validKlhSi = checkValid(klhSi, 'Total nilai harus 100', 'bottom');
		validKlhDi = checkValid(klhDi, 'Total nilai harus 100', 'bottom');

		return (validUkDi && validUkSi && validKlhDi && validKlhSi);
	}

	function removeAllError(){
		$('.total-score').each(function(){
			$(this).css('color', '').tooltip('dispose');
		});
	}	

	function checkValid(ele, title, placement){
		var valid;
		if(ele.html() != 100){
			ele.css('color', 'red');
			ele.tooltip({
			        title: title,
			        trigger: 'manual',
			        placement : placement,
			        template: '<div class="tooltip" role="tooltip" style="font-weight: 800"><div class="tooltip-arrow" style="border-bottom-color: #f33"></div><div class="tooltip-inner" style="max-width: 100px; background-color: #f33"></div></div>'
			    }).tooltip('show');

			valid = false;
		} else {
			ele.css('color', '');
			ele.tooltip('dispose');

			valid = true;
		}

		return valid;
	}

	function getData(){
		var data = new Object;

		var temp = [];
		$('.parameter').each(function (key, parameter) {
			var tempSub = [];
			$(parameter).find('.pernyataan').each(function(k, pernyataan){
				// data.push($(this).find(".text").html().trim());
				tempSub.push($(this).find(".uk-si").val());
				tempSub.push($(this).find(".uk-di").val());
				tempSub.push($(this).find(".klh-si").val());
				tempSub.push($(this).find(".klh-di").val());
			});
			temp.push(tempSub);
		});

		data['OcaiRaw'] = temp;

		return data;
	}

    function saveState(finished){
        var data = getData();

        if(finished) data.OcaiFinished = 1;

        $.ajax({
            type: 'POST',
            url: '/sipbos/section/ocai',
            data: { data : JSON.stringify(data) },
            success: function(response){
                if(response.Status){
                    console.log('save state');
                    if(finished){
                        showLoading();
                        window.location.assign('/sipbos/section/msai');
                    }
                } else{
                    console.log('failed save state');
                }
            }, error: function(response) {  
                console.log('failed save state');
            }
        });         
    }   

</script>
