<?php $this->extend('Layouts/layout-main.html.php') ?>

<?php

    $peserta = $this->Peserta;
      
    $pendidikan = array("SMA","D3","S1","S2","S3");

?>

<style>
    form .form-group .error-message{
        color: red;
    }
</style>

<div class="container">

    <h2 class="text-center my-4">
        Lengkapi Profil Anda
    </h2>

    <div class="alert alert-primary alert-dismissible fade show" role="alert">
        <strong> Informasi!</strong> Silahkan baca petunjuk pengerjaan dengan menekan tombol merah di kanan bawah layar Anda
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>

    <form class="border mb-5">        
        <div class="row m-3">
            <div class="col-lg-6">
                <div class="form-group">
                    <label class="col-form-label">Nama <span class="text-danger">*</span> </label>
                    <input type="text" class="form-control" name="Name" data-mask="Z" data-rule-required="true" data-msg-required="Nama harus diisi" >
                </div>
                <div class="form-group">
                    <label class="col-form-label">Email <span class="text-danger">*</span> </label>
                    <input type="text" class="form-control" name="Email" data-rule-required="true" data-msg-required="Email harus diisi" data-rule-email="true" data-msg-email="Format email tidak valid">
                </div>
                <div class="form-group">
                    <label class="col-form-label">No Telepon </label>
                    <input type="text" class="form-control" name="Phone" data-mask="0000000009999" data-rule-minlength="10" data-msg-minlength="Format not valid" >
                </div>
                <div class="form-group">
                    <label class="col-form-label">Jenis Kelamin <span class="text-danger">*</span> </label>
                    <select name="Gender" class="form-control" data-rule-required="true" data-msg-required="Jenis kelamin harus diisi" >
                        <option value="">Pilih jenis kelamin</option>
                        <option value="Laki-laki">Laki-laki</option>
                        <option value="Perempuan">Perempuan</option>
                    </select>
                </div>                
                <div class="form-group">
                    <label class="col-form-label">Tanggal lahir <span class="text-danger">*</span> </label>
                    <div class="controls">
                        <div class='input-group dob'>                   
                            <input type="text" class="form-control bg-white" name="Dob" readonly data-rule-required="true" data-msg-required="Date of birth required">
                            <span class="input-group-addon">
                                <i class="far fa-calendar-alt fa-lg bg-primary p-3"></i>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="form-group row">
                    <div class="col-sm-12 col-md-6 mb-3">
                        <label class="col-form-label">Province <span class="text-danger">*</span> </label>
                        <select name="Province" class="form-control" data-rule-required="true" data-msg-required="Province required" onchange="changeProvince(this)">
                            <option value="">Pilih provinsi</option>

                            <?php if($this->Provinces){ ?>
                            <?php foreach($this->Provinces as $key => $province) { ?>
                            
                            <option value="<?= $province->Name?>" data-filter="<?= $province->Name ?>"><?= $province->Name?></option>
                            
                            <?php } ?> 
                            <?php } ?>                                                          

                        </select>                        
                    </div>
                    <div class="col-sm-12 col-md-6 mb-3">
                        <label class="col-form-label">City <span class="text-danger">*</span> </label>
                        <select name="City" class="form-control" data-rule-required="true" data-msg-required="City required" >
                            <option value="">Pilih kota</option>
                        </select>
                    </div>
                </div>                                  
                <div class="form-group">
                    <label class="col-form-label">Pendidikan Terakhir</label>
                    <select name="Education" class="form-control" >
                        <option value="">Pilih pendidikan</option>
                        <option value="SD">SD</option>
                        <option value="SMP">SMP</option>
                        <option value="SMA">SMA</option>
                        <option value="S1">S1</option>
                        <option value="S2">S2</option>
                        <option value="S3">S3</option>
                    </select>
                </div>                
                <div class="form-group">
                    <label class="col-form-label">Jabatan </label>
                    <input type="text" class="form-control" name="Departement" data-mask="Z" >
                </div>
                <div class="form-group">
                    <label class="col-form-label">Nomor Induk Pegawai </label>
                    <input type="text" class="form-control" name="Nip" data-mask="Z" >
                </div>
            </div>

            <div class="col-md-6 text-center">
                <div class="form-group">
                    <label class="col-form-label"> Foto Profile </label>
                    <input type="file" class="form-control image-file-input d-none" name="FileProfilePicture" accept="image/png, image/jpg, image/jpeg" >
                    <input type="hidden" class="form-control" name="ProfilePicture" >
                    <div class="clearfix"></div>
                    <img class="col-8 px-0 p-1 my-2 border img-preview" src="<?= $this->Profile->ProfilePicture ? $this->Profile->ProfilePicture : '/assets/images/placeholder_human_600_600.png' ?>" onclick="$('.image-file-input').click()" /> 
                </div>

                <div class="form-group ">
                    <button type="submit" class="btn btn-primary btn-next  mt-4 px-5 btn-submit">
                        <i class="fa fa-arrow-circle-right"></i> 
                        Lanjutkan melengkapi kuesioner
                    </button>
                </div>          
            </div>                              
        </div>
    </form>
</div>

<script type="text/javascript">

    function submitForm(){
    
        showLoading();
        var data = getData();

        $.ajax({            
            type : 'post',
            url  : '/api/peserta/update',
            data : { 
                Data : getData()
            },
            timeout: 45000,
            success:function(response){
                response = JSON.parse(response);
                if(response.Status){
            
                    <?php if($this->flagKuesioner){ ?>

                    hideLoading();
                    swal("Berhasil menyimpan data", "", "success")

                    <?php } else { ?>

                    window.location.href = '/sabos/kuesioner/rvs';

                    <?php } ?>

                }else{
                    hideLoading();
                    swal(response.Message, "", "error")
                }
            },
            error: function(response){
                hideLoading();
                swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
            }
        }); 

    }

    $(document).ready(function(){
        
        $('[data-toggle="tooltip"]').tooltip();

        $('.input-group.dob').datetimepicker({
            viewMode: 'years',
            ignoreReadonly: true,
            allowInputToggle: true,
            useCurrent: false,
            defaultDate: <?= $this->Profile->Dob ? 'moment(' . $this->Profile->Dob->timestamp * 1000 . ')' : 'false' ?>,
            maxDate: moment().subtract(13, 'years'),
            format: 'DD-MM-YYYY'
        });

        $('.form-control').on('keyup', function (e) {
            if (e.which == 13) {
                $(this).closest('form').find('.btn-submit').first().click();
            }
        }).find('[type=text]').on('change', function (e) {
            $(this).val($(this).val().trim());
        });
        
        $(".image-file-input").change(function(){ 
            showImg(this);
        });     
        
        validationForm();
        
    });     
    
    function getData(){
        var data = {};

        $.each($('form').find('.form-control'), function() {
            var key = $(this).attr('name');
            var value = $(this).val();

            data[key] = value;
        });

        return data;
    }       

    function validationForm(){
        $('form').validate({
            errorElement:'em',
            errorPlacement:function errorPlacement(error,element){
                error.addClass('invalid-feedback');
                if(element.prop('type')==='checkbox'){
                    error.insertAfter(element.parent('label'));
                }else{
                    error.insertAfter(element);
                }
            },
            highlight:function highlight(element){
                $(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight:function unhighlight(element){
                $(element).addClass('is-valid').removeClass('is-invalid');
            },
            submitHandler: function(form) {

                var data = getData();

                showLoading();

                $.ajax({
                    type: 'POST',
                    url: '/api/influencer/update-profile',
                    data: data,
                    success: function(response){
                        if(response.Status == 1) {
                            $('.alert-success').addClass('d-none');
                            $('.alert-success-' + thisForm.attr('id')).removeClass('d-none');
                            $('html, body').animate({ scrollTop: 0 }, 0);                               
                            validateAllForm();
                            updateProfileHeader();
                        } else {
                            $('#custom-modal .modal-body').html(response.Message);
                            $('#custom-modal').modal('show');               
                        }                           
                        hideLoading();
                    }, error: function(response) {
                        hideLoading();
                    }
                });             
            }
        });
    }

    function changeProvince(thisProvince){
        var cities = JSON.parse("<?= $this->Cities ?>");
        var provinceSelected = $(thisProvince).val();
        var thisCity = $(thisProvince).closest('form').find('[name=City]');

        if(!$(thisProvince).val()){
            thisCity.val('').attr('disabled', 'disabled');
            return false;
        } else{
            thisCity.removeAttr('disabled');            
        }

        thisCity.html('<option value="" selected> Pilih kota </option>');        
        $.each(cities[provinceSelected], function(k,v){
            thisCity.append('<option value="' + v.City + '">' + v.City + '</option>');
        });
    }

    function showImg(input) {
        var url = input.value;
        var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
        if (input.files && input.files[0]&& (ext == "png" || ext == "jpeg" || ext == "jpg")) {
            var reader = new FileReader();

            reader.onload = function (e) {
                $(input).siblings('img').attr('src', e.target.result);
                $(input).siblings('[type=hidden]').val(e.target.result);
            }
            
            reader.readAsDataURL(input.files[0]);
        } else { 
            $('#custom-modal .modal-body').html('File yang dipilih harus bertipe .jpg, .jpeg dan .png');
            $('#custom-modal').modal('show');

            $(input).val('');
        }
    }

</script>
