<?php $this->extend('Layouts/layout-main.html.php'); ?>

<?php 
    $allRvs = $this->rvs;
    $peserta = $this->User;

?>
    <script src="/assets/plugins/jqueryui/jquery-ui.min.js"></script> 
    <link href="/assets/plugins/jqueryui/jquery-ui.min.css" rel="stylesheet"> 

<div class="container">

    <h2 class="text-center mb-4 mt-2">
        ROKEACH VALUE SURVEY (RVS)
    </h2>

    <div class="alert alert-primary alert-dismissible fade show" role="alert">
        <strong> Informasi!</strong> Silahkan baca petunjuk pengerjaan dengan menekan tombol merah di kanan bawah layar Anda
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>

    <ul class="nav nav-pills mb-2 mt-3" id="pills-tab" role="tablist">

        <?php $i = 0; ?>
        <?php foreach ($allRvs as $key => $rvs) { ?>

        <li class="nav-item li-<?= $rvs['id'] ?>">
            <a class="nav-link <?= $i++ == 0 ? 'active' : '' ?>" href="javascript:void(0)"> 
                <?= $rvs['nama'] ?>            
            </a>
        </li>

        <?php } ?>        

    </ul>

    <div class="tab-content rvs mb-5">

        <?php $i = 0; ?>
        <?php foreach ($allRvs as $key => $rvs) { ?>

        <div class="tab-pane fade parameter <?= $i++ == 0 ? 'active show' : '' ?>" id="<?= $rvs['id'] ?>" data-next="<?= $allRvs[$key+1]['id'] ?>" data-prev="<?= $allRvs[$key-1]['id'] ?>">

            <table class="table table-responsive-sm table-hover table-rsv">
                <thead>
                    <tr>
                        <th style="text-align: center;">Urutkan</th>                        
                        <th class="" style="width: 30px; text-align: center;">No</th>
                        <th>Pernyataan</th>
                        <th class="d-none d-lg-block">Kode</th>
                    </tr>
                </thead>
                <tbody>

                    <?php foreach ($rvs['data'] as $pernyataanKey => $pernyataan) { ?>

                    <tr>
                        <td style="width: 80px; text-align: center;">
                            <i class="fa fas fa-arrow-alt-circle-down fa-lg mr-2 btn_sort" attr-step="1"></i> 
                            <i class="fa fas fa-arrow-alt-circle-up fa-lg btn_sort" attr-step="-1"></i>
                        </td>
                        <td class="data_sort" style="width: 30px; text-align: center;"><?= $pernyataanKey+1 ?></td>
                        <td class="data_statement"><?= $pernyataan[1] ?></td>
                        <td class="data_code d-none d-lg-block"><?= $pernyataan[0] ?></td>
                     </tr>            

                    <?php } ?>        

                </tbody>
            </table>

            <div class="row mt-4">
                <div class="col-6 col-xs-6">
                    <button class="btn btn-primary btn-prev mx-3">
                        <i class="fa fa-arrow-circle-left"></i> 
                        Sebelumnya
                    </button>
                </div>
                <div class="col-6 col-xs-6 text-right">
                    <button class="btn btn-primary btn-next mx-3">
                        <i class="fa fa-arrow-circle-right"></i> 
                        Selanjutnya
                    </button>
                </div>
            </div>

        </div>

        <?php } ?>    

    </div>

</div>

<!-- button fixed for help -->
<div class="help-fixed">
    <button class="btn button-help" data-toggle="modal" data-target="#help-modal">
        <span class="d-none"> Petunjuk Pengerjaan </span> 
        <i class="fa fa-question "></i>
    </button>
</div>
<!-- button fixed for help -->

<!-- modal for petunjuk pengerjaan -->
<div id="help-modal" class="modal fade" id="confirm-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-info modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-question-circle"></i>
                    Petunjuk Pengerjaan RVS
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>
                    Apakah tujuan hidup yang ingin Anda capai dengan bekerja di ORGANISASI/LEMBAGA ini?
                </p>

                <strong class="text-center"> Bagian 1 (Nilai Terminal) </strong>
                <span>
                    Mengurutkan 18 nilai-nilai terminal (akhir) dari yang paling penting (PALING BERNILAI) sampai dengan yang kurang penting (PALING KURANG BERNILAI). Nilai terminal adalah keadaan akhir eksistensi yang sangat diinginkan/tujuan yang ingin dicapai seseorang selama hayatnya.
                </span>

                <br><br>

                <strong class="text-center"> Bagian 2 (Nilai Instrumental) </strong>
                <span>
                    Mengurutkan 18 nilai-nilai instrumental (alat) untuk meraih nilai-nilai (tujuan) akhir tersebut. Nilai-nilai instrumental merujuk ke modus perilaku yang lebih disukai, atau cara untuk mencapai nilai-nilai terminal
                </span>                                          

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary px-2" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for petunjuk pengerjaan -->

<!-- embed js function for update profile -->
<a class="trigger-profile" href="javascript:void(0)" data-autoclick="true" data-noconfirm="true" data-notclose="true"></a>
<?= $this->template("Includes/main/embed-update-profile-popup.html.php") ?>
<!-- embed js function for update profile -->

<script type="text/javascript">

    $(document).ready(function(){
        $('#help-modal').modal('show');

        $(".btn_sort").click(function(){
            var now = $(this).closest('tr');
            var step = $(this).attr('attr-step');
            if(step == 1){
                now.before(now.next());
            } else if(step == -1) {
                now.after(now.prev());
            }
            reorderKey(now.closest('tbody'));
        });  

        $(".btn-next").click(function(){
            goNext(this);
        });

        $(".btn-prev").click(function(){
            var prev = $(this).closest('.parameter').attr('data-prev');
            if(prev){
                goTab(prev);
            } else {
                window.location.assign('/sipbos/instruction');
            }
        });  

        $('tbody').sortable({
            opacity: 0.8,
            cursor: "move",
            update: function(event, ui) {
                reorderKey($(this));
            }
        });
    });

    function reorderKey(ele){
        ele.find('.data_sort').each(function (key, val) {
            $(this).html(key+1);
        });        
    }

    function goNext(ele){
        var finished = 1;
        var next = $(ele).closest('.parameter').attr('data-next');
        if(next){
            goTab(next);
            finished = 0;
        } 
        saveState(finished);
    }

    function goTab(tabId){
        $('.nav li a').removeClass('active');
        $('.tab-pane.parameter').removeClass('active').removeClass('show');

        $('.li-' + tabId + ' a').addClass('active');
        $('#' + tabId).addClass('active').addClass('show');

        $('html, body').animate( {scrollTop:0}, '300');
    }

    function getData(){
        var data = new Object;

        $('.tab-pane.parameter').each(function (kPane, vPane) {
            data[vPane.id] = new Array();
            $(vPane).find('.table-rsv tbody tr').each(function (kInput, vInput) {
                var temp = [];
                temp.push($(vInput).find('.data_code').html());
                temp.push($(vInput).find('.data_statement').html());
                temp.push($(vInput).find('.data_sort').html());
 
                data[vPane.id].push(temp);
            });
        });
        
        return data;
    }

    function saveState(finished){
        var data = getData();

        if(finished) data.RvsFinished = 1;

        $.ajax({
            type: 'POST',
            url: '/sipbos/section/rvs',
            data: { data : JSON.stringify(data) },
            success: function(response){
                if(response.Status){
                    console.log('save state');
                    if(finished){
                        showLoading();
                        window.location.assign('/sipbos/section/ocai');
                    }
                } else{
                    console.log('failed save state');
                }
            }, error: function(response) {  
                console.log('failed save state');
            }
        });         
    }   

</script>
