<?php $this->extend('Layouts/layout-main.html.php'); ?>

<style type="text/css">
    .now-color{
        background-color: rgba(0, 0, 255, .3);
    }
    .want-color{
        background-color: rgba(255, 0, 0, .3);
    }
    .clan-color{
        background-color: rgba(0, 255, 0, .5);
    }
    .adhocracy-color{
        background-color: rgba(255, 255, 153, .8);
    }
    .market-color{
        background-color: rgba(255, 204, 153, .8);
    }
    .hierarchy-color{
        background-color: rgba(204, 255, 255, .8);
    }

</style>

<div class="container ">

    <h2 class="text-center mt-2 mb-0">
        Penilaian Budaya Organisasi
    </h2>
    <h4 class="text-center mb-4">
        Hasil Ringkasan Penilaian
    </h4>

    <div role="tablist">

        <?php if($this->Role == "SuperAdmin"){ ?>

        <div class="card">
            <div class="card-header" role="tab" id="headingFive" data-toggle="collapse" href="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                <div class="row">
                    <h5 class="mb-0 col-11">
                        <a>
                            <?= count($this->Users) > 1 ? "Daftar Data Peserta" : "Biodata Peserta" ?>
                        </a>
                    </h5>
                    <span class="col-1 text-right">
                        <i class="fa fa-caret-down fa-lg"></i>                    
                    </span>
                </div>
            </div>
            <div id="collapseFive" class="collapse show" role="tabpanel" aria-labelledby="headingFive" data-parent="#accordion" style="">
                <div class="card-body">

                    <?php if(count($this->Users) > 1){ ?>

                        <table class="table-users table table-bordered table-striped table-hover hide_pdf">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th class="align-middle text-center">Nama</th>
                                    <th class="align-middle text-center">Email</th>
                                    <th class="align-middle text-center">Telepon</th>
                                    <th class="align-middle text-center">Jenis Kelamin</th>
                                    <th class="align-middle text-center">Tanggal Lahir</th>
                                    <th class="align-middle text-center">Usia</th>
                                    <th class="align-middle text-center">Provinsi</th>
                                    <th class="align-middle text-center">Kota</th>
                                    <th class="align-middle text-center">Pendidikan</th>
                                    <th class="align-middle text-center">Mulai Pengisian</th>
                                    <th class="align-middle text-center">Selesai Pengisian</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php foreach ($this->Users as $key => $value) { ?>
                                
                                <tr>
                                    <td class="align-middle text-center"><a href='/sa/sipbos/resume?q=<?= $value['o_id'] ?>' target='_blank' title='View Detail'><button class='btn btn-info text-light'><i class='fas fa-search'></i></button></a></td>
                                    <td><?= $value['Name'] ?></td>
                                    <td><?= $value['Email'] ?></td>
                                    <td><?= $value['Phone'] ? $value['Phone'] : '---' ?></td>
                                    <td><?= $value['Gender'] ? $value['Gender'] : '---' ?></td>
                                    <td><?= $value['Dob'] ? \AppHelper\General::indonesiaDate($value['Dob'], 'd F Y') : '---' ?></td>
                                    <td class="align-middle text-center"><?= $value['Age'] ? $value['Age'] : '---' ?></td>
                                    <td><?= $value['Province'] ? $value['Province'] : '---' ?></td>
                                    <td><?= $value['City'] ? $value['City'] : '---' ?></td>
                                    <td><?= $value['Education'] ? $value['Education'] : '---' ?></td>
                                    <td><?= \AppHelper\General::indonesiaDate($value['o_creationDate'], 'd F Y H:i')  ?></td>
                                    <td><?= $value['FinishedDate'] ? \AppHelper\General::indonesiaDate($value['FinishedDate'], 'd F Y H:i')  : '---' ?></td>                                    
                                </tr>

                                <?php } ?>

                            </tbody>
                        </table>

                        <table id="table_users" class="table table-bordered table-striped table-hover d-none show_pdf">
                            <thead>
                                <tr>
                                    <th class="align-middle text-center">No</th>
                                    <th class="align-middle text-center">Nama</th>
                                    <th class="align-middle text-center">Jenis Kelamin</th>
                                    <th class="align-middle text-center">Usia</th>
                                    <th class="align-middle text-center">Mulai Pengisian</th>
                                    <th class="align-middle text-center">Selesai Pengisian</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php foreach ($this->Users as $key => $value) { ?>
                                
                                <tr>
                                    <td class="align-middle text-center"><?= $key+1 ?></td>
                                    <td><?= $value['Name'] ?></td>
                                    <td><?= $value['Gender'] ? $value['Gender'] : '---' ?></td>
                                    <td class="align-middle text-center"><?= $value['Age'] ? $value['Age'] : '---' ?></td>
                                    <td><?= \AppHelper\General::indonesiaDate($value['o_creationDate'], 'd F Y H:i')  ?></td>
                                    <td><?= $value['FinishedDate'] ? \AppHelper\General::indonesiaDate($value['FinishedDate'], 'd F Y H:i')  : '---' ?></td>                                    
                                </tr>

                                <?php } ?>

                            </tbody>
                        </table>

                    <?php } else { ?>

                        <?php $user = $this->Users[0]; ?>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Nama</label>
                                    <p class=" mb-0"> <?= $user['Name'] ? $user['Name'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Email</label>
                                    <p class=" mb-0"> <?= $user['Email'] ? $user['Email'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Telepon</label>
                                    <p class=" mb-0"> <?= $user['Phone'] ? $user['Phone'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Jenis Kelamin</label>
                                    <p class=" mb-0"> <?= $user['Gender'] ? $user['Gender'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>                
                                <div class="form-group row">
                                    <div class="col-sm-12 col-md-9">
                                        <label class="col-form-label font-weight-bold">Tanggal Lahir</label>
                                        <p class=" mb-0"> <?= $user['Dob'] ? \AppHelper\General::indonesiaDate($user['Dob'], 'd F Y') : '---' ?> </p>
                                        <hr class="mt-1 mb-0">
                                    </div>
                                    <div class="col-sm-12 col-md-3">                                        
                                        <label class="col-form-label font-weight-bold">Usia</label>
                                        <p class=" mb-0"> <?= $user['Age'] ? $user['Age'] : '---' ?> </p>
                                        <hr class="mt-1 mb-0">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Provinsi</label>
                                    <p class=" mb-0"> <?= $user['Province'] ? $user['Province'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Kota</label>
                                    <p class=" mb-0"> <?= $user['City'] ? $user['City'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Pendidikan Terakhir</label>
                                    <p class=" mb-0"> <?= $user['Education'] ? $user['Education'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>                
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Jabatan</label>
                                    <p class=" mb-0"> <?= $user['Departement'] ? $user['Departement'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group d-none">
                                    <label class="col-form-label font-weight-bold">NIP</label>
                                    <p class=" mb-0"> <?= $user['Nip'] ? $user['Nip'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group row">
                                    <div class="col-sm-12 col-md-6">
                                        <label class="col-form-label font-weight-bold">Tanggal Mulai Pengisian</label>
                                        <p class=" mb-0"> <?= $user['Dob'] ? \AppHelper\General::indonesiaDate($user['o_creationDate'], 'd F Y H:i') : '---' ?> </p>
                                        <hr class="mt-1 mb-0">
                                    </div>
                                    <div class="col-sm-12 col-md-6">                                        
                                        <label class="col-form-label font-weight-bold">Tanggal Selesai Pengisian</label>
                                        <p class=" mb-0"> <?= $user['Dob'] ? \AppHelper\General::indonesiaDate($user['o_modificationDate'], 'd F Y H:i') : '---' ?> </p>
                                        <hr class="mt-1 mb-0">
                                    </div>
                                </div>                                
                            </div>

                            <div class="col-lg-6 text-center">
                                <div class="form-group">
                                    <label class="col-form-label"> Foto Profile </label>
                                    <div class="clearfix"></div>
                                    <img class="col-8 px-0 p-1 my-2 border img-preview" src="<?= $user['ProfilePicture'] ? $user['ProfilePicture'] : '/assets/images/placeholder_human_600_600.png' ?>" /> 
                                </div>
                            </div>                              
                        </div>

                    <?php }  ?>

                </div>
            </div>
        </div>            

        <div class="html2pdf__page-break"></div>        

        <?php } ?>

        <div class="card">
            <div class="card-header" role="tab" id="headingOne" data-toggle="collapse" href="#collapseOne" aria-expanded="false" aria-controls="collapseOne">    
                <div class="row">
                    <h5 class="mb-0 col-11">
                        <a>
                            Hasil Rokeach Value Survey (RVS)
                        </a>
                    </h5>                    
                    <span class="col-1 text-right">
                        <i class="fa fa-caret-down fa-lg"></i>                    
                    </span>
                </div>
            </div>
            <div id="collapseOne" class="collapse show" role="tabpanel" aria-labelledby="headingOne" data-parent="#accordion" style="">
                <div class="card-body">                    
                    <div class="row px-5 py-2">
                        <p class="font-weight-bold"> Nilai Terminal (Dirurtkan dari paling penting) </p>
                        <table id="table-rvs-terminal" class="table table-striped table-bordered table-hover mb-5">
                            <thead>
                                <tr>
                                    <th class="align-middle text-center" width="70"> No </th>
                                    <th class="align-middle text-center" width="150"> Kode </th>
                                    <th class="align-middle text-center"> Deskripsi </th>
                                    <th class="align-middle text-center" width="100"> Nilai </th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php if($this->Summary['Rvs']['Terminal']){ ?>
                                <?php foreach ($this->Summary['Rvs']['Terminal'] as $key => $value) { ?>

                                <tr class="odd gradeX">
                                    <td class="align-middle text-center">  <?= ($key + 1) ?>  </td>
                                    <td class="align-middle text-center"> <?= $value[0] ?> </td>
                                    <td> <?= $value[1] ?> </td>
                                    <td class="align-middle text-center"> <?= $value[2] ?> </td>
                                </tr>

                                <?php }} ?>

                            </tbody>
                        </table>                 

                        <p class="font-weight-bold"> Nilai Instrumen (Dirurtkan dari paling penting) </p>
                        <table id="table-rvs-terminal" class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="align-middle text-center" width="70"> No </th>
                                    <th class="align-middle text-center" width="150"> Kode </th>
                                    <th class="align-middle text-center"> Deskripsi </th>
                                    <th class="align-middle text-center" width="100"> Nilai </th>
                                </tr>
                             </thead>

                            <tbody>

                                <?php if($this->Summary['Rvs']['Instrument']){ ?>
                                <?php foreach ($this->Summary['Rvs']['Instrument'] as $key => $value) { ?>

                                <tr class="odd gradeX">
                                    <td class="align-middle text-center">  <?= ($key + 1) ?>  </td>
                                    <td class="align-middle text-center"> <?= $value[0] ?> </td>
                                    <td class=""> <?= $value[1] ?> </td>
                                    <td class="align-middle text-center"> <?= $value[2] ?> </td>
                                </tr>

                                <?php }} ?>

                            </tbody>
                        </table>                        

                    </div>    
                </div>
            </div>
        </div>

        <div class="html2pdf__page-break"></div>

        <div class="card">
            <div class="card-header" role="tab" id="headingTwo" data-toggle="collapse" href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">    
                <div class="row">
                    <h5 class="mb-0 col-11">
                        <a>
                            Hasil Organizational Culture Assessment Instrument (OCAI)
                        </a>
                    </h5>                    
                    <span class="col-1 text-right">
                        <i class="fa fa-caret-down fa-lg"></i>                    
                    </span>
                </div>
            </div>
            <div id="collapseTwo" class="collapse show" role="tabpanel" aria-labelledby="headingTwo" data-parent="#accordion" style="">
                <div class="card-body">                    
                    <div class="row px-5 py-2">
                        <div class="col-12 mt-3 mb-5">

                            <?php if($this->DataRaw['Ocai']){ ?>            

                            <style type="text/css">
                                .table_ocai_raw td, .table_ocai_raw th {
                                    padding: .4rem;
                                }
                            </style>

                            <div class="table_ocai_raw">
                                <p class="font-weight-bold"> Pengisian Kuesioner </p>
                                <table class="table table-bordered mb-5">
                                    <thead>
                                        <tr>
                                            <th class="align-middle text-center">No</th>
                                            <th class="align-middle text-center"></th>
                                            <th class="align-middle text-center"></th>
                                            <th class="align-middle text-center">A</th>
                                            <th class="align-middle text-center">B</th>
                                            <th class="align-middle text-center">C</th>
                                            <th class="align-middle text-center">D</th>
                                            <th class="align-middle text-center">Jumlah Skor</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php foreach ($this->DataRaw['Ocai'] as $key => $value) { ?>
                                        
                                        <tr>
                                            <?php if(($key) % 4 == 0){ ?>
                                            <td class="align-middle text-center" rowspan="4"><?= $value[0]+1 ?></td>
                                            <?php } ?>
                                            
                                            <?php if(($key) % 2 == 0){ ?>
                                            <td class="align-middle text-center" rowspan="2"><?= $value[1] ?></td>
                                            <?php } ?>
                                            
                                            <td class="align-middle text-center"><?= $value[2] ?></td>
                                            <td class="align-middle text-center"><?= $value[3] ?></td>
                                            <td class="align-middle text-center"><?= $value[4] ?></td>
                                            <td class="align-middle text-center"><?= $value[5] ?></td>
                                            <td class="align-middle text-center"><?= $value[6] ?></td>
                                            <td class="align-middle text-center"><?= $value[3] + $value[4] + $value[5] + $value[6] ?></td>
                                        </tr>

                                        <?php } ?>

                                    </tbody>
                                </table>

                                <hr class="my-5 hide_pdf">
                                <div class="html2pdf__page-break"></div>                                
                            </div>

                            <?php } ?>

                            <h3 class="text-center mb-3">Penilaian Unit Kerja</h3>
                            <div class="text-center my-5">
                                <svg id="graphOcaiUnitKerja" class="hide_pdf" style="max-width: 500px"></svg>
                                <img class="graphOcaiUnitKerjaImg d-none show_pdf" />
                            </div>

                            <table class="table table-bordered table-hover mb-2">
                                <thead>
                                    <tr>
                                        <th class="align-middle text-center bg-gray-100" rowspan="2"> Tipologi </th>
                                        <th class="align-middle text-center now-color" colspan="<?= count($this->Users) > 1 ? '3' : '2'?>"> Saat Ini (Des Sein) </th>
                                        <th class="align-middle text-center want-color" colspan="<?= count($this->Users) > 1 ? '3' : '2'?>"> Diinginkan (Des Solen) </th>
                                        <th class="align-middle text-center bg-gray-100" rowspan="2"> Selisih </th>
                                    </tr>
                                    <tr>
                                        <th class="align-middle text-center now-color"> Nilai </th>
                                        <th class="align-middle text-center now-color"> Posisi </th>

                                        <?php if(count($this->Users) > 1){ ?>
                                        <th class="align-middle text-center now-color"> Jumlah </th>
                                        <?php } ?>
                                        
                                        <th class="align-middle text-center want-color"> Nilai </th>
                                        <th class="align-middle text-center want-color"> Posisi </th>
                                        
                                        <?php if(count($this->Users) > 1){ ?>
                                        <th class="align-middle text-center want-color"> Jumlah </th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php 
                                        if($this->Summary['Ocai']){ 
                                            $now = $this->Summary['Ocai']['UnitKerja']['Now'];
                                            $want = $this->Summary['Ocai']['UnitKerja']['Want'];
                                            arsort($now);
                                            arsort($want);

                                            foreach ($this->Tipologi as $kTipologi => $vTipologi) { 
                                    ?>

                                            <tr class="odd gradeX">
                                                <td class="align-middle text-center <?= strtolower($vTipologi) ?>-color"> <strong> <?= $vTipologi ?> </strong> </td>
                                                <td class="align-middle text-center now-color"> <?= $now[$vTipologi] ?> </td>
                                                <td class="align-middle text-center now-color"> (<?= array_search($vTipologi, array_keys($now)) + 1 ?>) </td>

                                                <?php if(count($this->Users) > 1){ ?>
                                                <td class="align-middle text-center now-color"> <?= $this->TypologyOcaiNowUnit[$vTipologi] ?> </td>
                                                <?php } ?>

                                                <td class="align-middle text-center want-color"> <?= $want[$vTipologi] ?> </td>
                                                <td class="align-middle text-center want-color"> (<?= array_search($vTipologi, array_keys($want)) + 1 ?>) </td>

                                                <?php if(count($this->Users) > 1){ ?>
                                                <td class="align-middle text-center want-color"> <?= $this->TypologyOcaiWantUnit[$vTipologi] ?> </td>
                                                <?php } ?>

                                                <td class="align-middle text-center <?= strtolower($vTipologi) ?>-color"> <?= $want[$vTipologi] - $now[$vTipologi] ?> </td>
                                            </tr>

                                    <?php }} ?>

                                </tbody>
                            </table>

                            <div class="html2pdf__page-break"></div>

                            <h3 class="text-center mb-3">Penilaian Organisasi</h3>
                            <div class="text-center my-5">
                                <svg id="graphOcaiOrganisasi" class="hide_pdf" style="max-width: 500px"></svg>
                                <img class="graphOcaiOrganisasiImg d-none show_pdf" />
                            </div>                        

                            <table class="table table-bordered table-hover mb-2">
                                <thead>
                                    <tr>
                                        <th class="align-middle text-center bg-gray-100" rowspan="2"> Tipologi </th>
                                        <th class="align-middle text-center now-color" colspan="<?= count($this->Users) > 1 ? '3' : '2'?>"> Saat Ini (Des Sein) </th>
                                        <th class="align-middle text-center want-color" colspan="<?= count($this->Users) > 1 ? '3' : '2'?>"> Diinginkan (Des Solen) </th>
                                        <th class="align-middle text-center bg-gray-100" rowspan="2"> Selisih </th>
                                    </tr>
                                    <tr>
                                        <th class="align-middle text-center now-color"> Nilai </th>
                                        <th class="align-middle text-center now-color"> Posisi </th>

                                        <?php if(count($this->Users) > 1){ ?>
                                        <th class="align-middle text-center now-color"> Jumlah </th>
                                        <?php } ?>
                                        
                                        <th class="align-middle text-center want-color"> Nilai </th>
                                        <th class="align-middle text-center want-color"> Posisi </th>
                                        
                                        <?php if(count($this->Users) > 1){ ?>
                                        <th class="align-middle text-center want-color"> Jumlah </th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php 
                                        if($this->Summary['Ocai']){ 
                                            $now = $this->Summary['Ocai']['Organisasi']['Now'];
                                            $want = $this->Summary['Ocai']['Organisasi']['Want'];
                                            arsort($now);
                                            arsort($want);

                                            foreach ($this->Tipologi as $kTipologi => $vTipologi) { 
                                    ?>

                                            <tr class="odd gradeX">
                                                <td class="align-middle text-center <?= strtolower($vTipologi) ?>-color"> <strong> <?= $vTipologi ?> </strong> </td>
                                                <td class="align-middle text-center now-color"> <?= $now[$vTipologi] ?> </td>
                                                <td class="align-middle text-center now-color"> (<?= array_search($vTipologi, array_keys($now)) + 1 ?>) </td>

                                                <?php if(count($this->Users) > 1){ ?>
                                                <td class="align-middle text-center now-color"> <?= $this->TypologyOcaiNowOrganisasi[$vTipologi] ?> </td>
                                                <?php } ?>

                                                <td class="align-middle text-center want-color"> <?= $want[$vTipologi] ?> </td>
                                                <td class="align-middle text-center want-color"> (<?= array_search($vTipologi, array_keys($want)) + 1 ?>) </td>
                                                <?php if(count($this->Users) > 1){ ?>
                                                <td class="align-middle text-center want-color"> <?= $this->TypologyOcaiWantOrganisasi[$vTipologi] ?> </td>
                                                <?php } ?>

                                                <td class="align-middle text-center <?= strtolower($vTipologi) ?>-color"> <?= $want[$vTipologi] - $now[$vTipologi] ?> </td>
                                            </tr>

                                    <?php }} ?>

                                </tbody>
                            </table>
                        </div>
                    </div>    
                </div>
            </div>
        </div>

        <div class="html2pdf__page-break"></div>

        <div class="card">
            <div class="card-header" role="tab" id="headingThree" data-toggle="collapse" href="#collapseThree" aria-expanded="false" aria-controls="collapseThree">    
                <div class="row">
                    <h5 class="mb-0 col-11">
                        <a>
                            Hasil Management (Leadership) Skills Assessment Instrument (MSAI)
                        </a>
                    </h5>                    
                    <span class="col-1 text-right">
                        <i class="fa fa-caret-down fa-lg"></i>                    
                    </span>
                </div>
            </div>
            <div id="collapseThree" class="collapse show" role="tabpanel" aria-labelledby="headingThree" data-parent="#accordion" style="">
                <div class="card-body">                    
                    <div class="row px-5 py-2">
                        <div class="col-12">

                            <div class="row mt-3 mb-5">
                                <div class="col-md-6">
                                    <div class="text-center">
                                        <canvas id="msaiChart" class="hide_pdf" width="400" height="400"></canvas>
                                        <img class="msaiChartImg d-none show_pdf" />
                                    </div>
                                </div>                                

                                <div class="col-md-6">
                                    <div class="text-center">
                                        <svg id="graphMsai" class="hide_pdf"></svg>
                                        <img class="graphMsaiImg d-none show_pdf" />
                                    </div>                        
                                </div>
                            </div>

                            <table id="table_msai" class="table table-bordered table-hover mb-2">
                                <thead>
                                    <tr class="bg-gray-100">
                                        <th class="align-middle text-center"> Tipologi </th>
                                        <th class="align-middle text-center"> Deskripsi </th>
                                        <th class="align-middle text-center"> Nilai </th>
                                        <th class="align-middle text-center"> Total </th>
                                        <th class="align-middle text-center"> Geomean </th>

                                        <?php if(count($this->Users) > 1){ ?>
                                        <th class="align-middle text-center"> Jumlah Peserta </th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $msai_process_key = []; $msai_process_value = []; $msai_end_value = []; ?>
                                    <?php if($this->Summary['Msai']){ ?>
                                    <?php foreach ($this->Summary['Msai'] as $key => $value) { ?>
                                    <?php array_push($msai_process_key, $value[1]) ?>
                                    <?php array_push($msai_process_value, $value[2]) ?>

                                    <tr>

                                        <?php if(($key) % 3 == 0){ ?>
    
                                        <td class="align-middle text-center <?= strtolower($value[0]) ?>-color" rowspan="3"><?= $value[0] ?></td>
    
                                        <?php } ?>
                                        
                                        <td class="align-middle text-center <?= strtolower($value[0]) ?>-color"> <?= $value[1] ?> </td>
                                        <td class="align-middle text-center <?= strtolower($value[0]) ?>-color"><?= $value[2] ?></td>
                                        
                                        <?php if(($key) % 3 == 0){ ?>
    
                                        <td class="align-middle text-center <?= strtolower($value[0]) ?>-color" rowspan="3"><?= $this->Summary['Msai'][$key][2] + $this->Summary['Msai'][$key+1][2] + $this->Summary['Msai'][$key+2][2] ?></td>            

                                        <td class="align-middle text-center <?= strtolower($value[0]) ?>-color" rowspan="3"><?= $value[3] ?></td>            

                                        <?php if(count($this->Users) > 1){ ?>                            
                                        <td class="align-middle text-center <?= strtolower($value[0]) ?>-color" rowspan="3"><?= $this->TypologyMsai[$value[0]] ?></td>
                                        <?php } ?>
    
                                        <?php array_push($msai_end_value, $value[3]) ?>
                                        <?php } ?>

                                    </tr>

                                    <?php }} ?>

                                </tbody>
                            </table>    

                            <?php if($this->DataRaw['Msai']){ ?>            

                            <hr class="mt-5 mb-3 hide_pdf" />                            
                            <div class="html2pdf__page-break msai_raw"></div>

                            <p class="font-weight-bold"> Pengisian Kuesioner </p>
                            <table class="table-assesment table table-bordered table-striped table-hover mb-5">
                                <thead>
                                    <tr>
                                        <th class="align-middle text-center">No</th>
                                        <th class="align-middle text-center">Pernyataan</th>
                                        <th class="align-middle text-center">Jawaban</th>
                                        <th class="align-middle text-center">Nilai</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php foreach ($this->DataRaw['Msai'] as $key => $value) { ?>
                                    
                                    <tr>
                                        <td class="align-middle text-center"><?= $value[0] ?></td>
                                        <td><?= $value[1] ?></td>
                                        <td class="align-middle text-center"><?= $value[3] ?></td>
                                        <td class="align-middle text-center"><?= $value[4] ?></td>
                                    </tr>

                                    <?php } ?>

                                </tbody>
                            </table>

                            <table id="table_msai_raw" class="table table-bordered table-striped table-hover mb-5 d-none show_pdf" style="font-size: 11px;">
                                <thead>
                                    <tr>
                                        <th class="align-middle text-center">No</th>
                                        <th class="align-middle text-center">Pernyataan</th>
                                        <th class="align-middle text-center">Jawaban</th>
                                        <th class="align-middle text-center">Nilai</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php foreach ($this->DataRaw['Msai'] as $key => $value) {  ?>
                                    
                                    <tr>
                                        <td class="align-middle text-center"><?= $value[0] ?></td>
                                        <td><?= $value[1] ?></td>
                                        <td class="align-middle text-center"><?= $value[3] ?></td>
                                        <td class="align-middle text-center"><?= $value[4] ?></td>
                                    </tr>

                                    <?php } ?>

                                </tbody>
                            </table>                            
                            
                            <?php } ?>

                        </div>
                    </div>    
                </div>
            </div>
        </div>                
    </div>    

    <div class="text-center">
        <a href="javascript:void(0)" onclick="downloadResume()">
            <button type="submit" class="btn btn-outline-danger btn_download_pdf px-5 mt-3 mb-5 d-none">
                <i class="fa fa-download"></i> 
                Unduh Ringkasan Penilaian
            </button>
        </a>
    </div>

</div>

<div id="temp-pdf-section"></div>

<!--[if lt IE 9]>
<script src="//html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->

<script src="/assets/js/html2pdf.bundle.min.js"></script> 
<script src="/assets/js/snap.svg.min.js" type="text/javascript"></script>
<script type="text/javascript">

    $(document).ready(function () {    

        $('.table-assesment').DataTable({
            scrollX: true,
            searching: true,
            autoWidth: true,
            ordering: false,
            bLengthChange: false,
            responsive: true,
            info: true,
            order: [],
            language: {
                search: '<span>Filter:</span> _INPUT_',
                searchPlaceholder: 'Cari keyword.',
                lengthMenu: '<span>Show:</span> _MENU_',
                infoEmpty: "Data tidak ditemukan",
                infoFiltered: "(filtered from _MAX_ total records)",
                paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
            }
        });   

        $('.table-users').DataTable({
            scrollX: true,
            searching: true,
            autoWidth: true,
            // ordering: false,
            bLengthChange: false,
            responsive: true,
            info: true,
            order: [],
            columnDefs: [ { orderable: false, targets: [0] } ],
            language: {
                search: '<span>Filter:</span> _INPUT_',
                searchPlaceholder: 'Cari keyword.',
                lengthMenu: '<span>Show:</span> _MENU_',
                infoEmpty: "Data tidak ditemukan",
                infoFiltered: "(filtered from _MAX_ total records)",
                paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
            }
        });

        $(".card-header").click(function(){
            var eleIcon = $(this).find('.fa');
            var statusShow = $(this).closest('.card').find('.collapse').hasClass('show');
            if(statusShow){
                eleIcon.removeClass('fa-caret-down').addClass('fa-caret-up');
            } else {
                eleIcon.removeClass('fa-caret-up').addClass('fa-caret-down');
            }
        });                

        // for ocai
        var params = new Object;
        params.items = new Array();
        params.items.push({
            extraText : "Saat Ini",
            line : { color : 'blue', opacity : 0.9, size: 2 },
            point : { color : 'blue', opacity : 0.9, size: 4 },
            value : <?= json_encode(array_values($this->Summary['Ocai']['UnitKerja']['Now'])) ?>
        });
        params.items.push({
            extraText : "Diinginkan",
            line : { color : 'red', opacity : 0.9, size: 2, type: 'dash' },
            point : { color : 'red', opacity : 0.9, size: 4 },
            value : <?= json_encode(array_values($this->Summary['Ocai']['UnitKerja']['Want'])) ?>
        });
        quadrantTipologiChart('#graphOcaiUnitKerja', 300, params);

        var params = new Object;
        params.items = new Array();
        params.items.push({
            extraText : "Saat Ini",
            line : { color : 'blue', opacity : 0.9, size: 2 },
            point : { color : 'blue', opacity : 0.9, size: 4 },
            value : <?= json_encode(array_values($this->Summary['Ocai']['Organisasi']['Now'])) ?>
        });
        params.items.push({
            extraText : "Diinginkan",
            line : { color : 'red', opacity : 0.9, size: 2, type: 'dash' },
            point : { color : 'red', opacity : 0.9, size: 4 },
            value : <?= json_encode(array_values($this->Summary['Ocai']['Organisasi']['Want'])) ?>
        });
        quadrantTipologiChart('#graphOcaiOrganisasi', 300, params);


        var params = new Object;
        params.items = new Array();
        params.items.push({
            point : { color : 'red', opacity : 0.9, size: 4 },
            value : <?= json_encode($msai_process_value) ?>, 
            label : <?= json_encode($msai_process_key) ?> 
        });
        quadrantTipologiChartMsai('#graphMsai', 300, params);

        var ctx = document.getElementById("msaiChart").getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'horizontalBar',
            data: {
                labels: <?= json_encode($msai_process_key) ?>,
                datasets: [{
                    label: '',
                    data: <?= json_encode($msai_process_value) ?>,
                    backgroundColor: [
                        'rgba(0, 255, 0, .5)',
                        'rgba(0, 255, 0, .5)',
                        'rgba(0, 255, 0, .5)',
                        'rgba(255, 255, 153, .8)',
                        'rgba(255, 255, 153, .8)',
                        'rgba(255, 255, 153, .8)',
                        'rgba(255, 204, 153, .8)',
                        'rgba(255, 204, 153, .8)',
                        'rgba(255, 204, 153, .8)',
                        'rgba(204, 255, 255, .8)',
                        'rgba(204, 255, 255, .8)',
                        'rgba(204, 255, 255, .8)'
                    ],
                    borderColor: [
                        'rgba(0, 255, 0, .8)',
                        'rgba(0, 255, 0, .8)',
                        'rgba(0, 255, 0, .8)',
                        'rgba(255, 255, 153, .8)',
                        'rgba(255, 255, 153, .8)',
                        'rgba(255, 255, 153, .8)',
                        'rgba(255, 204, 153, .8)',
                        'rgba(255, 204, 153, .8)',
                        'rgba(255, 204, 153, .8)',
                        'rgba(204, 255, 255, .8)',
                        'rgba(204, 255, 255, .8)',
                        'rgba(204, 255, 255, .8)'
                    ],
                    borderWidth: 3
                }]
            },
            options: {
                plugins: {
                  datalabels: {
                    anchor: 'center',
                    align: 'center',
                    font: {
                      weight: 'bold'
                    }
                  }
                },                
                scales: {
                    xAxes: [{
                        ticks: {
                            beginAtZero: true,
                            max: 5
                        }
                    }]
                },
                legend: { display: false }
            }
        });

        setTimeout(function(){ 
            var canvas = document.createElement( "canvas" );
            drawInlineSVG($('#graphOcaiUnitKerja')[0], canvas, $('.graphOcaiUnitKerjaImg'), { width: 400, height: 500 });

            canvas = document.createElement( "canvas" );                
            drawInlineSVG($('#graphOcaiOrganisasi')[0], canvas, $('.graphOcaiOrganisasiImg'), { width: 400, height: 500 });       

            canvas = document.createElement( "canvas" );
            drawInlineSVG($('#graphMsai')[0], canvas, $('.graphMsaiImg'), { width: 320, height: 320 });

            canvas = $('#msaiChart')[0];
            $('.msaiChartImg').attr('src', canvas.toDataURL("image/png")).attr('width', '320');

            $('.btn_download_pdf').removeClass('d-none');            
        }, 3000);

    });

    function downloadResume() {
        (async function getFormValues () {
            var filename = "SIPBOS-" + moment().format("YYYY-MM-DD HH:mm");            
            const {value: formValues} = await Swal.fire({
                title: 'Nama file yang akan diunduh',
                html:
                    '<input id="swal-filename" class="swal2-input" value="' + filename + '">' +
                    '<input id="swal-check-quesioner" type="checkbox" class="mr-1 <?= (count($this->Users) > 1) ? 'd-none' : '' ?>" style="cursor: pointer;"> \
                        <span onclick="$(this).prev().click()" class="<?= (count($this->Users) > 1) ? 'd-none' : '' ?>"style="cursor: pointer;">Tampilkan pengisian data kuesioner</span>',
                showCancelButton: true,
                focusConfirm: false,
                preConfirm: () => {
                    return [
                        document.getElementById('swal-filename').value,
                        document.getElementById('swal-check-quesioner').checked
                    ]
                }
            })

            if (formValues) {
                var filename = formValues[0];
                var checkQuesioner = formValues[1];

                if(!filename){
                    swal("", "Nama file harus diisi", "error");
                    return false;
                }

                var clone = $('[role=tablist]').clone().attr('id', 'temp-pdf').css('width', '755px');
                clone.find('.fa-caret-down,[type=submit],.hide_pdf').remove();
                clone.find('.dataTables_wrapper').remove();
                clone.find('.show_pdf').removeClass('d-none');
                clone.find('.px-5').removeClass('px-5').addClass('px-3');
                clone.find('.form-group').removeClass('form-group');
                clone.find('table').css('font-size', '14px');
                clone.find('#table_users,#table_msai_raw').css('font-size', '11px');
                clone.find('#table_msai').css('font-size', '12px');
                clone.find('#table_msai td').css('padding', '10px');
                clone.find('.col-lg-6').removeClass('col-lg-6').addClass('col-6');
                clone.find('.col-sm-6').removeClass('col-sm-6').addClass('col-6');
                clone.find('.col-sm-12.col-md-6').removeClass('col-md-6').removeClass('col-sm-12').addClass('col-12');                
                if(!checkQuesioner){
                    clone.find('#table_msai_raw,.table_ocai_raw').prev().remove();
                    clone.find('#table_msai_raw,.table_ocai_raw').remove();
                    clone.find('.html2pdf__page-break.msai_raw').remove();
                }

                $('#temp-pdf-section').append(clone);

                showLoading();

                var element = document.getElementById('temp-pdf');          
                var opt = {
                    margin:       [8, 5],
                    filename:     filename + '.pdf',
                    image:        { type: 'jpeg', quality: 0.5 },
                    html2canvas:  { dpi: 192, letterRendering: true },
                    jsPDF:        { unit: 'mm', format: 'a4', orientation: 'portrait' }
                };
                workerPdf = html2pdf().set(opt).from(element).outputPdf().then(function(pdf){
                    hideLoading();
                }).save();
                
                $('#temp-pdf-section').html('');
            }
        })()             
    }

    function quadrantTipologiChart(ele, size, opt){        
        var s = Snap(ele); 
        var rotate = 'r-45';
        var topologiName = ['CLAN', 'ADHOCRACY', 'MARKET', 'HIERARCHY'];
        var midsize = size / 2;
        var viewBox = { x: size, y: size};

        var legendPoint = { x: midsize - (midsize/1.5), y: (size+40) };
        if(opt.legend === undefined || opt.legend) {
            opt.legend = true;

            var countItem = opt.items.length;
            var widthLegend = 240;
            var heightLegend = 20 * countItem;
            viewBox.y += 45 * countItem;            

            s.polygon(legendPoint.x-25, legendPoint.y-25, legendPoint.x+widthLegend, legendPoint.y-25, legendPoint.x+widthLegend, legendPoint.y+heightLegend, legendPoint.x-25, legendPoint.y+heightLegend)
                .attr({ fill: "black", 'fill-opacity': 0.1, stroke: "black", opacity: 0.5, 'strokeWidth': 3 });
            
            s.text(legendPoint.x, legendPoint.y, "Keterangan:").attr({
                fill : 'black', fontSize:"10px"
            });

            legendPoint.x += 70;
        }
         
        s.attr({ viewBox: "0 0 " + viewBox.x + " " + viewBox.y});
        
        var lineX = s.line(0, midsize, size, midsize).attr({
            stroke: "#000",
            strokeWidth: 2
        });
        var lineY = s.line(midsize, 0, midsize, size).attr({
            stroke: "#000",
            strokeWidth: 2
        });

        s.text(midsize - (midsize/1.5), 20, topologiName[0]).attr({
            fill : 'black', fontSize:"10px"
        });
        s.text(size - (midsize/1.5), 20, topologiName[1]).attr({
            fill : 'black', fontSize:"10px"
        });        
        s.text(midsize - (midsize/1.5), (size - 20), topologiName[3]).attr({
            fill : 'black', fontSize:"10px"
        });
        s.text(size - (midsize/2), (size - 20), topologiName[2]).attr({
            fill : 'black', fontSize:"10px"
        });

        // var p = s.circle( midsize, midsize, midsize )
        //     .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1});
        // var p = s.circle( midsize, midsize, midsize * 0.8 )
        //     .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1});
        // var p = s.circle( midsize, midsize, midsize * 0.6 )
        //     .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1});
        // var p = s.circle( midsize, midsize, midsize * 0.4 )
        //     .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1});
        // var p = s.circle( midsize, midsize, midsize * 0.2 )
        //     .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1});        

        var arrayValue = [];
        $.each(opt.items, function(key, item){
            arrayValue = arrayValue.concat(item.value);
        });

        var maxValue = Math.max.apply(Math,arrayValue);
        var rasio = midsize / maxValue;

        $.each(opt.items, function(key, item){     
            var extraText = item.extraText ? ' ' + item.extraText : '';
            var line = item.line;
            var point = item.point;
            var value = item.value; 
            var clickFunction = item.clickFunction;
            var tempPoint = [
                (midsize + (value[0] * rasio)), 
                (midsize + (value[1] * rasio)), 
                (midsize - (value[2] * rasio)), 
                (midsize - (value[3] * rasio))
            ];

            var poly = s.polygon(tempPoint[0], midsize, midsize, tempPoint[1], tempPoint[2], midsize, midsize, tempPoint[3])
                .attr({ fill: "none", stroke: line.color, opacity: line.opacity, 'strokeWidth': line.size });

            if(line.type == 'dash'){
                poly.attr({strokeDasharray: "5"});
            }

            var a = s.circle( tempPoint[0], midsize, point.size )
                .attr({ fill: point.color, opacity: point.opacity })
                .append(Snap.parse('<title>' + topologiName[0] + extraText + ': ' + value[0] + '</title>'))
                .click(function () { if(clickFunction) eval(clickFunction[0]) });
            var b = s.circle( midsize, tempPoint[1], point.size )
                .attr({ fill: point.color, opacity: point.opacity })
                .append(Snap.parse('<title>' + topologiName[1] + extraText + ': ' + value[1] + '</title>'))
                .click(function () { if(clickFunction) eval(clickFunction[1]) });
            var c = s.circle( tempPoint[2], midsize, point.size ).attr({ fill: point.color, opacity: point.opacity })
                .append(Snap.parse('<title>' + topologiName[2] + extraText + ': ' + value[2] + '</title>'))
                .click(function () { if(clickFunction) eval(clickFunction[2]) });
            var d = s.circle( midsize, tempPoint[3], point.size )
                .attr({ fill: point.color, opacity: point.opacity })
                .append(Snap.parse('<title>' + topologiName[3] + extraText + ': ' + value[3] + '</title>'))
                .click(function () { if(clickFunction) eval(clickFunction[3]) });

            var g0 = s.group( poly, a, b, c, d );        
            g0.transform( 'r225, ' + midsize + ', ' + midsize + '' );     

            if(opt.legend){
                tempLine = s.line(legendPoint.x, legendPoint.y-3, legendPoint.x+80, legendPoint.y-3)
                    .attr({ stroke: point.color, strokeWidth: 2 });

                if(line.type == 'dash') tempLine.attr({strokeDasharray: "5"});

                s.text(legendPoint.x+85, legendPoint.y, extraText).attr({
                    fill : 'black', fontSize:"10px"
                });

                legendPoint.y += 20;
            }   
        });
    }  
    var ss; 

    function drawInlineSVG(svgElement, canvas, elementOutput, size){
        if(size === undefined) size = { width: 100, height: 100 };
        canvas.width = size.width;
        canvas.height = size.height;

        var ctx = canvas.getContext( "2d" );
        var data = (new XMLSerializer()).serializeToString(svgElement);
        var DOMURL = window.URL || window.webkitURL || window;

        var img = new Image();
        var svgBlob = new Blob([data], {type: 'image/svg+xml;charset=utf-8'});
        var url = DOMURL.createObjectURL(svgBlob);

        img.onload = function () {
            ctx.drawImage(img, 0, 0);
            DOMURL.revokeObjectURL(url);

            var imgURI = canvas.toDataURL();

            $(elementOutput).attr('src', imgURI);
        };
        img.src = url;        
    }

    function quadrantTipologiChartMsai(ele, size, opt){        
        var s = Snap(ele); 
        var midsize = size / 2;
        var viewBox = { x: size, y: size};
         
        s.attr({ viewBox: "0 0 " + viewBox.x + " " + viewBox.y});
        
        var lineX = s.line(0, midsize, size, midsize).attr({
            stroke: "#000",
            strokeWidth: 2
        });
        var lineY = s.line(midsize, 0, midsize, size).attr({
            stroke: "#000",
            strokeWidth: 2
        });

        s.polygon(0, 0, 0, midsize, midsize, midsize, midsize, 0)
            .attr({ fill: "rgba(0, 255, 0, .5)", 'fill-opacity': 1, stroke: "black", opacity: 0.5, 'strokeWidth': 1 });

        s.polygon(midsize, 0, size, 0, size, midsize, midsize, midsize)
            .attr({ fill: "rgba(255, 255, 153, .8)", 'fill-opacity': 1, stroke: "black", opacity: 0.5, 'strokeWidth': 1 });

        s.polygon(size,midsize, midsize, midsize, midsize, size, size, size)
            .attr({ fill: "rgba(255, 204, 153, .8)", 'fill-opacity': 1, stroke: "black", opacity: 0.5, 'strokeWidth': 1 });

        s.polygon(0, midsize, midsize, midsize, midsize, size, 0, size)
            .attr({ fill: "rgba(204, 255, 255, .8)", 'fill-opacity': 1, stroke: "black", opacity: 0.5, 'strokeWidth': 1 });

        s.text(10, 15, "CLAN").attr({
            fill : 'black', fontSize:"9px"
        });
        s.text(size-60, 15, "ADHOCRACY").attr({
            fill : 'black', fontSize:"9px"
        });        
        s.text(10, (size - 10), "HIERARCHY").attr({
            fill : 'black', fontSize:"9px"
        });
        s.text(size-45, (size - 10), "MARKET").attr({
            fill : 'black', fontSize:"9px"
        });

        var p = s.circle( midsize, midsize, midsize )
            .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1, class: "radius_max_area"});
        var p = s.circle( midsize, midsize, midsize * 0.8 )
            .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1, class: "radius_max_area"});
        var p = s.circle( midsize, midsize, midsize * 0.6 )
            .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1, class: "radius_max_area"});
        var p = s.circle( midsize, midsize, midsize * 0.4 )
            .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1, class: "radius_max_area"});
        var p = s.circle( midsize, midsize, midsize * 0.2 )
            .attr({ fill: 'black', 'fill-opacity': 0, opacity: 0.1, stroke: "black", 'strokeWidth': 1, class: "radius_max_area"});

        s.text(size-5, midsize+10, "5").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text(size-5-(midsize*0.2), midsize+10, "4").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text(size-5-(midsize*0.4), midsize+10, "3").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text(size-5-(midsize*0.6), midsize+10, "2").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text(size-5-(midsize*0.8), midsize+10, "1").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text(midsize, midsize+10, "0").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text((midsize*0.8), midsize+10, "1").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text((midsize*0.6), midsize+10, "2").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text((midsize*0.4), midsize+10, "3").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text((midsize*0.2), midsize+10, "4").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });
        s.text((midsize*0), midsize+10, "5").attr({
            fill : 'black', fontSize:"8px", opacity: 0.7
        });

        var arrayValue = [];
        $.each(opt.items, function(key, item){
            arrayValue = arrayValue.concat(item.value);
        });

        var maxValue = 5;
        // var maxValue = Math.max.apply(Math,arrayValue);
        var rasio = midsize / maxValue;

        $.each(opt.items, function(key, item){     
            var extraText = item.extraText ? ' ' + item.extraText : '';
            var line = item.line;
            var point = item.point;
            var value = item.value; 
            var label = item.label; 
            var clickFunction = item.clickFunction;

            var pointPolygon = [];

            var rAdd = 22.5;
            var r = 22.5;
            var bbox = s.getBBox(); //bounding box, get coords and centre
            $.each(value, function(k, v){  

                var p = s.circle( (midsize - (value[k] * rasio)), midsize, point.size )
                    .attr({ fill: point.color, opacity: point.opacity, class: "points_value" })
                    .append(Snap.parse('<title>' + label[k] + extraText + ': ' + value[k] + '</title>'))
                    .click(function () { if(clickFunction) eval(clickFunction[key]) });

                var rotateText = "rotate(" + (r * k + rAdd) + "," + bbox.cy + ',' + bbox.cy + ")";
                $(p.node).attr("transform", rotateText);

                if((k+1) % 3 == 0) rAdd += r;

                var tempPoint = $(ele)[0].createSVGPoint();
                tempPoint.x = p.attr().cx;
                tempPoint.y = p.attr().cy;

                var ctm = $(p.node)[0].getCTM();
                tempPoint = tempPoint.matrixTransform(ctm);

                var tx = s.text(tempPoint.x-15, tempPoint.y-10 , value[k]).attr({
                    fill : 'black', fontSize:"14px", opacity: 1
                });                
                $(tx.node).attr("transform", "scale(0.635)");

                pointPolygon[k] = [];
                pointPolygon[k][0] = tempPoint.x;
                pointPolygon[k][1] = tempPoint.y;
            });

            var polygon = s.polygon(pointPolygon[0][0], pointPolygon[0][1], pointPolygon[1][0], pointPolygon[1][1], pointPolygon[2][0], pointPolygon[2][1], pointPolygon[3][0], pointPolygon[3][1], pointPolygon[4][0], pointPolygon[4][1], pointPolygon[5][0], pointPolygon[5][1], pointPolygon[6][0], pointPolygon[6][1], pointPolygon[7][0], pointPolygon[7][1], pointPolygon[8][0], pointPolygon[8][1], pointPolygon[9][0], pointPolygon[9][1], pointPolygon[10][0], pointPolygon[10][1], pointPolygon[11][0], pointPolygon[11][1])
                .attr({ fill: "red", 'fill-opacity': 0.1, stroke: "red", opacity: 0.2, 'strokeWidth': 3, class: "polygon_area" });            
            $(polygon.node).attr("transform", "scale(0.635)");
            $('.polygon_area').insertAfter($('.radius_max_area'));
        });
    }   

</script>
