<?php $this->extend('Layouts/layout-main.html.php'); ?>

<style type="text/css">
	.assessment_question_item {
		display: none;
	}

	.assessment_question_item.active{
		display: block !important;
	}
</style>

<h2 class="text-center mb-4 mt-3">
    Penilaian Manajemen Aparatur Sipil Negara (ASN)
</h2>
<div class="row mx-3">

	<div class="col-lg-8 col-md-12"> 

	    <div class="assessment_section mb-5">			

			<?php if($this->Question) {  ?>
			<?php foreach ($this->Question as $key => $question) { ?>

	        <div class="assessment_question_item question_item_<?= $key ?> mt-4 <?= $key == 0 ? 'active' : ''?> " data-next="<?= ($key+1) < count($this->Question) ? ($key+1) : ''?>" data-prev="<?= $key > 0 ? ($key-1) : ''?>">

				<hr>

				<h4 class="my-3 assessment_item_pillar text-center">
					Pilar <?= $question->CountPillar ?>. <?= $question->Pillar ?>
				</h4>

				<hr>

				<div class="row my-2 assessment_indicator">
					<div class="col-6">
						<p class="my-0 font-weight-bold">
							Soal No.  
							<span><?= $question->CountQuestion ?></span>
							dari 
							<span><?= $this->QuestionCount[$question->Pillar] ?></span>
						</p>
					</div>
					<div class="col-6 text-right">
					    <button class="btn btn-sm btn-outline-primary d-lg-none" onclick="showIndicatorModal()">
					        <i class="fa fa-map"></i>
					        <span class=""> Navigasi soal </span> 
					    </button>			
				    </div>			
				</div>

				<div class="my-3">						
					<strong>
						Elemen
					</strong>
					<p class="mb-0 assessment_item_element">
						<?= $question->Element ?>										
					</p>
				</div>

				<div class="my-3">						
					<strong>
						Aktivitas Kunci
					</strong>
					<p class="mb-0 assessment_item_activity_key">
						<?= $question->KeyActivity ?>										
					</p>
				</div>

				<div class="my-3">						
					<strong>
						Keluaran
					</strong>
					<p class="mb-0 assessment_item_output">
						<?= $question->Output ?>										
					</p>
				</div>

				<div class="my-3">						
					<strong>
						Indikator
					</strong>
					<p class="mb-0 assessment_item_indicator">
						<?= $question->Indicator ?>
					</p>
				</div>

				<hr>
				
				<p class="mb-3">
					<em>Pilihlah jawaban yang paling sesuai antara kondisi manajemen ASN dalam organisasi dengan salah satu Artefak/ efidence atau perilaku kunci.</em>
				</p>

				<div class="assessment_question_options">

					<?php if($question->Options) { ?>
					<?php foreach ($question->Options as $key_option => $option) { ?>

					<div class="form-check my-2">
						<input class="form-check-input answer_item" type="radio" name="<?= $key ?>" value="<?= $option[0] ?>" data-label="<?= $option[1] ?>">
						<label class="form-check-label" onclick="$(this).siblings('.answer_item').click()">
							<?= $option[1] ?>
						</label>
					</div><!--/ .form-check -->
																
			     	<?php } ?>
			     	<?php } ?>

				</div><!--/ .survey-box__form -->

				<input type="hidden" class="answer-question answer-question-4" name="Answers[]" value="" >
	     	</div>

	     	<?php } ?>
	     	<?php } ?>

	    </div>

		<div class="row my-3 px-0 mx-0">
	        <div class="col-6 col-xs-6 px-0">
	            <button class="btn btn-sm btn-primary btn-prev mb-2">	                
	                <span class="d-md-none">
	                	<i class="fa fa-arrow-circle-left"></i>  
	                	Kembali 
	                </span> 
	                <span class="d-none d-md-block"> 
	                	<i class="fa fa-arrow-circle-left"></i> 
	                	Soal sebelumnya 
	                </span> 
	            </button>
	            <button class="btn btn-sm btn-primary btn-next mb-2">	                
	                <span class="d-md-none"> 
	                	<i class="fa fa-arrow-circle-right"></i> 
	                	Lewati 
	                </span>
	                <span class="d-none d-md-block"> 
	                	<i class="fa fa-arrow-circle-right"></i> 
	                	Lewati soal ini 
	                </span> 
	            </button>
	        </div>
	        <div class="col-6 col-xs-6 text-right px-0">
	            <button class="btn btn-sm btn-primary btn-save  mb-2">
	                <i class="fa fa-check"></i> 
	                Simpan dan lanjutkan
	            </button>
	        </div>
	    </div>
	</div>

	<div class="col-lg-4 col-md-12 d-lg-block">
		<div class="my-3 border p-4 indicator_section">

			<h4 class="font-weight-bold my-2"> Navigasi soal </h4>							

			<?php if($this->QuestionCount) {  $count_pillar = 1; $count_question = 0; ?>
			<?php foreach ($this->QuestionCount as $key => $value) { ?>

				<p class="font-weight-bold my-1"> Pilar. <?= $count_pillar++ ?> <?= $key ?> </p>				

				<div class="row mb-3 mx-0">
				<?php for ($no = 1; $no <= $value ; $no++) { ?>	

                    <div class="col-1 border bg-danger p-1 text-center indicator_item indicator_item_<?= $count_question ?>" data-key="<?= $count_question++ ?>" style="cursor: pointer;" onclick="goTo($(this).attr('data-key'))">
						<span> <?= $no ?> </span>
                    </div>

		     	<?php } ?>
		     	</div>

	     	<?php } ?>
	     	<?php } ?>

		</div>
	</div>


</div>

<!-- button fixed for help -->
<div class="help-fixed d-none">
    <button class="btn button-help" data-toggle="modal" data-target="#help-modal">
        <span class="d-none"> Petunjuk Pengerjaan </span> 
        <i class="fa fa-question "></i>
    </button>
</div>
<!-- button fixed for help -->

<!-- modal for petunjuk pengerjaan -->
<div id="help-modal" class="modal fade" id="confirm-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-info modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-question-circle"></i>
                    Petunjuk Pengerjaan
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">

            	<p>
					Pilihlah jawaban yang paling sesuai antara kondisi manajemen ASN dalam organisasi dengan salah satu Artefak/ efidence atau perilaku kunci. 														
				</p>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-dark px-5" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for petunjuk pengerjaan -->

<!-- modal for petunjuk pengerjaan -->
<div id="indicator-modal" class="modal fade" id="confirm-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-info modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    Navigasi Soal
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-dark px-5" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for petunjuk pengerjaan -->

<!-- embed js function for update profile -->
<a class="trigger-profile" href="javascript:void(0)" data-autoclick="true" data-noconfirm="true" data-notclose="true"></a>
<?= $this->template("Includes/main/embed-update-profile-popup.html.php") ?>
<!-- embed js function for update profile -->

<script type="text/javascript">
	
	$(document).ready(function(){

	    $(".btn-save").click(function(){
	    	goNext(true);
	    });

	    $(".btn-next").click(function(){
	    	goNext();
	    });

	    $(".btn-prev").click(function(){
	    	goPrev();
	    });	   

	    <?php if($this->Answer) { echo "mappingAnswer({$this->Answer})"; } ?>

	    refreshIndicator();

	});

	function goPrev(){
		var item = $('.assessment_question_item.active');
		var prev = item.attr('data-prev');
		if(prev){
	    	goTo(prev);
	    }
	}

	function goNext(isValidate){
		var item = $('.assessment_question_item.active');
		var next = item.attr('data-next');

		if(!isValidate){
	    	goTo(next);
		} else {
			if(!validate(item)) return false;

			if(!next) {				
				if(validateAll()){				
					swal({
		                title: '',
		                text: 'Apakah Anda yakin sudah menjawab semua pertanyaan dengan benar?',
		                type: 'question',
		                showCancelButton: true,
		                cancelButtonText: 'Tidak',
		                confirmButtonText: 'Ya'
		            }).then((result) => {
		                if (result.value) {
		                	if(!validateAll()) return false;
	    					submit();
		                }
		            });			
				} else {
					goTo(0);
				}
	        } else {
        		goTo(next);
	        }

	        saveState();
		}
	}

	function goTo(id){
        $('.assessment_question_item').removeClass('active');
        $('.assessment_question_item.question_item_' + id).addClass('active');

        if(id==0){
        	$(".btn-prev").addClass('d-none');
        } else {
        	$(".btn-prev").removeClass('d-none');       	
        }

        refreshIndicator();

        $('html, body').animate( {scrollTop:0}, '300');
	}

	function validate(ele){
		if(ele.find('.answer_item:checked').length > 0){
			return true;
		} else {
			swal({
	            // title: 'Informasi Kesalahan',
	            text: "Pastikan Anda sudah menjawab pertanyaan di step ini",
	            type: 'warning',
	            showCloseButton: true,
	        });        

	        return false;
		}
	}

	function validateAll(){
		var validation = true;
		$('.assessment_question_item').each(function (key, value) {
			if($(this).find('.answer_item:checked').length < 1){
				// swal({
		  //           title: 'Informasi Kesalahan',
		  //           text: "Pastikan Anda sudah menjawab semua soal, periksa kembali di kolom navigasi soal",
		  //           type: 'warning',
		  //           showCloseButton: true,
		  //       });        

				validation = false;
			}
		});

		return validation;		
	}

	function refreshIndicator(){
		$('.assessment_question_item').each(function (key, value) {
			$('.indicator_item_' + key).removeClass('bg-danger bg-success bg-info');

			if($(this).hasClass('active')){
				$('.indicator_item_' + key).addClass('bg-primary');
			} else {
				if($(this).find('.answer_item:checked').length > 0){
					$('.indicator_item_' + key).addClass('bg-success');
				} else {
					$('.indicator_item_' + key).addClass('bg-danger');
				}
			}
		});		
	}

	function showIndicatorModal(){
		$('#indicator-modal .modal-body').html($('.indicator_section').html());
		$('#indicator-modal').modal('show');
	}	

	function getData(){
		var rawData = [];
		var assosiativeData = [];
		var elementData = new Object;
		var pillarData = new Object;
		
		$('.assessment_question_item').each(function (key, value) {

			var pillar = $(this).find('.assessment_item_pillar').text().trim();
			var element = $(this).find('.assessment_item_element').text().trim();
			var activityKey = $(this).find('.assessment_item_activity_key').text().trim();
			var output = $(this).find('.assessment_item_output').text().trim();
			var indicator = $(this).find('.assessment_item_indicator').text().trim();
			var name = $(this).find('.answer_item:checked').attr('data-label');
			var value = $(this).find('.answer_item:checked').val();

			var temp = [];
			temp[0] = pillar;
			temp[1] = element;
			temp[2] = activityKey;
			temp[3] = output;
			temp[4] = indicator;
			temp[5] = name ? name.trim() : name;
			temp[6] = value;
			rawData.push(temp);

			var temp = new Object;
			temp['Pillar'] = pillar;
			temp['Element'] = element;
			temp['ActivityKey'] = activityKey;
			temp['Output'] = output;
			temp['Indicator'] = indicator;
			temp['Name'] = name;
			temp['Value'] = value;
			assosiativeData.push(temp);

			if(element in elementData){
				elementData[element].push(temp);
			} else {
				elementData[element] = [ temp ];
			}

			if(pillar in pillarData){
				pillarData[pillar].push(temp);
			} else {
				pillarData[pillar] = [ temp ];
			}

		});

		var data = {
			'DataRaw' : rawData,
			'AssosiativeData' : assosiativeData,
			'ElementData' : elementData,
			'PillarData' : pillarData
		}

		return data;
	}

	function saveState(){
		$.ajax({
			type: 'POST',
			url: '/sipmas/assessment',
			data: { data : JSON.stringify(getData()) },
		 	success: function(response){
		 		if(response.Status){
		 			console.log('save state');
		 		} else{
		 			console.log('failed save state');
		 		}
			}, error: function(response) {	
	 			console.log('failed save state');
			}
		});			
	}	

	function submit(){

		showLoading();

		var data = getData();
		data.IsFinished = 1;
		var jsonData = JSON.stringify(data);

		var form = $('<form>', {
			"method" : 'POST',
		    "html" : '<input type="hidden" name="data" value="" />'
		}).appendTo(document.body);
		form.find('[name=data]').val(jsonData);
		form.submit();

	}

	function mappingAnswer(data){
		$('.assessment_question_item').each(function (key, value) {
			var selected = data[key];
			if(selected){
				$(this).find('.answer_item[value='+ selected +']').prop('checked', true);
			}
		});		
	}	

</script>
