<?php $this->extend('Layouts/layout-main.html.php'); ?>

<div class="container ">

    <h2 class="text-center mt-2 mb-0">
        Penilaian Manajemen Aparatur Sipil Negara (ASN)
    </h2>
    <h4 class="text-center mb-4">
        Hasil Ringkasan Penilaian
    </h4>

    <div role="tablist">

        <?php if($this->Role == "SuperAdmin"){ ?>

        <div class="card">
            <div class="card-header" role="tab" id="headingThree" data-toggle="collapse" href="#collapseThree" aria-expanded="false" aria-controls="collapseOne">
                <div class="row">
                    <h5 class="mb-0 col-11">
                        <a>
                            <?= count($this->Users) > 1 ? "Daftar Data Peserta" : "Biodata Peserta" ?>
                        </a>
                    </h5>
                    <span class="col-1 text-right">
                        <i class="fa fa-caret-down fa-lg"></i>                    
                    </span>
                </div>
            </div>
            <div id="collapseThree" class="collapse show" role="tabpanel" aria-labelledby="headingThree" data-parent="#accordion" style="">
                <div class="card-body">

                    <?php if(count($this->Users) > 1){ ?>

                        <table id="table-users" class="table table-bordered table-striped table-hover hide_pdf" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th class="align-middle text-center"></th>
                                    <th class="align-middle text-center">Nama</th>
                                    <th class="align-middle text-center">Email</th>
                                    <th class="align-middle text-center">Telepon</th>
                                    <th class="align-middle text-center">Jenis Kelamin</th>
                                    <th class="align-middle text-center">Tanggal Lahir</th>
                                    <th class="align-middle text-center">Usia</th>
                                    <th class="align-middle text-center">Provinsi</th>
                                    <th class="align-middle text-center">Kota</th>
                                    <th class="align-middle text-center">Pendidikan</th>
                                    <th class="align-middle text-center">Mulai Pengisian</th>
                                    <th class="align-middle text-center">Selesai Pengisian</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php foreach ($this->Users as $key => $value) { ?>
                                
                                <tr>
                                    <td class="align-middle text-center"><a href='/sa/sipmas/resume?q=<?= $value['o_id'] ?>' target='_blank' title='View Detail'><button class='btn btn-info text-light'><i class='fas fa-search'></i></button></a></td>
                                    <td><?= $value['Name'] ?></td>
                                    <td><?= $value['Email'] ?></td>
                                    <td><?= $value['Phone'] ? $value['Phone'] : '---' ?></td>
                                    <td><?= $value['Gender'] ? $value['Gender'] : '---' ?></td>
                                    <td><?= $value['Dob'] ? \AppHelper\General::indonesiaDate($value['Dob'], 'd F Y') : '---' ?></td>
                                    <td class="align-middle text-center"><?= $value['Age'] ? $value['Age'] : '---' ?></td>
                                    <td><?= $value['Province'] ? $value['Province'] : '---' ?></td>
                                    <td><?= $value['City'] ? $value['City'] : '---' ?></td>
                                    <td><?= $value['Education'] ? $value['Education'] : '---' ?></td>
                                    <td><?= \AppHelper\General::indonesiaDate($value['o_creationDate'], 'd F Y H:i')  ?></td>
                                    <td><?= $value['FinishedDate'] ? \AppHelper\General::indonesiaDate($value['FinishedDate'], 'd F Y H:i')  : '---' ?></td>                                    
                                </tr>

                                <?php } ?>

                            </tbody>
                        </table>

                        <table id="table_users" class="table table-bordered table-striped table-hover d-none show_pdf">
                            <thead>
                                <tr>
                                    <th class="align-middle text-center">No</th>
                                    <th class="align-middle text-center">Nama</th>
                                    <th class="align-middle text-center">Jenis Kelamin</th>
                                    <th class="align-middle text-center">Usia</th>
                                    <th class="align-middle text-center">Mulai Pengisian</th>
                                    <th class="align-middle text-center">Selesai Pengisian</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php foreach ($this->Users as $key => $value) { ?>
                                
                                <tr>
                                    <td class="align-middle text-center"><?= $key+1 ?></td>
                                    <td><?= $value['Name'] ?></td>
                                    <td><?= $value['Gender'] ? $value['Gender'] : '---' ?></td>
                                    <td class="align-middle text-center"><?= $value['Age'] ? $value['Age'] : '---' ?></td>
                                    <td><?= \AppHelper\General::indonesiaDate($value['o_creationDate'], 'd F Y H:i')  ?></td>
                                    <td><?= $value['FinishedDate'] ? \AppHelper\General::indonesiaDate($value['FinishedDate'], 'd F Y H:i')  : '---' ?></td>                                    
                                </tr>

                                <?php } ?>

                            </tbody>
                        </table>

                    <?php } else { ?>

                        <?php $user = $this->Users[0]; ?>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Nama</label>
                                    <p class=" mb-0"> <?= $user['Name'] ? $user['Name'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Email</label>
                                    <p class=" mb-0"> <?= $user['Email'] ? $user['Email'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Telepon</label>
                                    <p class=" mb-0"> <?= $user['Phone'] ? $user['Phone'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Jenis Kelamin</label>
                                    <p class=" mb-0"> <?= $user['Gender'] ? $user['Gender'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>                
                                <div class="form-group row">
                                    <div class="col-sm-12 col-md-9">
                                        <label class="col-form-label font-weight-bold">Tanggal Lahir</label>
                                        <p class=" mb-0"> <?= $user['Dob'] ? \AppHelper\General::indonesiaDate($user['Dob'], 'd F Y') : '---' ?> </p>
                                        <hr class="mt-1 mb-0">
                                    </div>
                                    <div class="col-sm-12 col-md-3">                                        
                                        <label class="col-form-label font-weight-bold">Usia</label>
                                        <p class=" mb-0"> <?= $user['Age'] ? $user['Age'] : '---' ?> </p>
                                        <hr class="mt-1 mb-0">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Provinsi</label>
                                    <p class=" mb-0"> <?= $user['Province'] ? $user['Province'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Kota</label>
                                    <p class=" mb-0"> <?= $user['City'] ? $user['City'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Pendidikan Terakhir</label>
                                    <p class=" mb-0"> <?= $user['Education'] ? $user['Education'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>                
                                <div class="form-group">
                                    <label class="col-form-label font-weight-bold">Jabatan</label>
                                    <p class=" mb-0"> <?= $user['Departement'] ? $user['Departement'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group d-none">
                                    <label class="col-form-label font-weight-bold">NIP</label>
                                    <p class=" mb-0"> <?= $user['Nip'] ? $user['Nip'] : '---' ?> </p>
                                    <hr class="mt-1">
                                </div>
                                <div class="form-group row">
                                    <div class="col-sm-12 col-md-6">
                                        <label class="col-form-label font-weight-bold">Tanggal Mulai Pengisian</label>
                                        <p class=" mb-0"> <?= $user['Dob'] ? \AppHelper\General::indonesiaDate($user['o_creationDate'], 'd F Y H:i') : '---' ?> </p>
                                        <hr class="mt-1 mb-0">
                                    </div>
                                    <div class="col-sm-12 col-md-6">                                        
                                        <label class="col-form-label font-weight-bold">Tanggal Selesai Pengisian</label>
                                        <p class=" mb-0"> <?= $user['Dob'] ? \AppHelper\General::indonesiaDate($user['o_modificationDate'], 'd F Y H:i') : '---' ?> </p>
                                        <hr class="mt-1 mb-0">
                                    </div>
                                </div>                                
                            </div>

                            <div class="col-lg-6 text-center">
                                <div class="form-group">
                                    <label class="col-form-label"> Foto Profile </label>
                                    <div class="clearfix"></div>
                                    <img class="col-8 px-0 p-1 my-2 border img-preview" src="<?= $user['ProfilePicture'] ? $user['ProfilePicture'] : '/assets/images/placeholder_human_600_600.png' ?>" /> 
                                </div>
                            </div>                              
                        </div>

                    <?php }  ?>

                </div>
            </div>
        </div>    

        <div class="html2pdf__page-break"></div>                        

        <?php } ?>

        <div class="card">
            <div class="card-header" role="tab" id="headingTwo" data-toggle="collapse" href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">    
                <div class="row">
                    <h5 class="mb-0 col-11">
                        <a>
                            Hasil Penilaian Berdasarkan Pilar
                        </a>
                    </h5>                    
                    <span class="col-1 text-right">
                        <i class="fa fa-caret-down fa-lg"></i>                    
                    </span>
                </div>
            </div>
            <div id="collapseTwo" class="collapse show" role="tabpanel" aria-labelledby="headingTwo" data-parent="#accordion" style="">
                <div class="card-body">                    
                    <div class="row">
                        <div class="col-lg-12 col-md-12">

                            <div class="chart_pillar_element section_all">
                                <h4 class="text-center my-3 hide_pdf"> 
                                    Penilaian Semua Pilar Manajemen ASN
                                </h3>

                                <div class="visual_data px-4 py-2">

                                    <div class="text-right mb-2">
                                        <button class="btn btn-secondary btn-sm btn_bar px-4">
                                            Bar
                                        </button>
                                        <button class="btn btn-secondary btn-sm btn_radar px-3">
                                            Radar
                                        </button>
                                    </div>

                                    <canvas class="chart_item chart_bar hide_pdf" id="chart_bar_pillar"></canvas>
                                    <canvas class="chart_item chart_radar d-none hide_pdf" id="chart_radar_pillar"></canvas>

                                    <div class="alert alert-primary mt-4 mb-0 mr-5 p-2 hide_pdf">
                                        <strong>*Note:</strong> klik bar atau point radar untuk melihat detail elemen pilar 
                                    </div>                                    

                                    <img class="img_chart_bar_pillar d-none show_pdf" />
                                    <img class="img_chart_radar_pillar d-none show_pdf" />
                                </div>
                            </div>

                            <?php if ($this->Data->PillarResult) { ?>
                            <?php foreach ($this->Data->PillarResult as $key => $value) { ?>

                            <div class="chart_pillar_element section_<?= $key ?> d-none">
                                <h4 class="text-center my-3"> 
                                    Penilaian <?= $value[0] ?>
                                </h3>

                                <div class="visual_data px-4 py-2">

                                    <div class="float-left mb-2 ml-2">
                                        <button class="btn btn-secondary btn-sm px-2" style="cursor: pointer;" onclick="showPillarElement('all', ($(this).closest('.visual_data').find('.chart_item.chart_bar').hasClass('d-none')) ? 'radar' : 'bar')"> 
                                            <i class="far fa-arrow-alt-circle-left"></i>
                                            Tampilkan Semua Pilar  
                                        </button>
                                    </div>

                                    <div class="float-right mb-2">
                                        <button class="btn btn-secondary btn-sm btn_bar px-4">
                                            Bar
                                        </button>
                                        <button class="btn btn-secondary btn-sm btn_radar px-3">
                                            Radar
                                        </button>
                                    </div>

                                    <canvas class="chart_item chart_bar hide_pdf" id="chart_bar_pillar_element_<?= $key ?>"></canvas>
                                    <canvas class="chart_item chart_radar d-none hide_pdf" id="chart_radar_pillar_element_<?= $key ?>"></canvas>

                                    <img class="img_chart_bar_pillar_element_<?= $key ?> d-none show_pdf" />
                                    <img class="img_chart_radar_pillar_element_<?= $key ?> d-none show_pdf" />
                                </div>
                            </div>                            

                            <?php } ?>
                            <?php } ?>

                        </div>


                        <div class="col-lg-4 col-md-12 d-none show_pdf">
                            <div class="m-3">
                                <h4> 
                                    Nilai Pilar
                                </h4>
                                <hr>
                            </div>

                            <div class="px-2 mx-3">

                                <?php if ($this->Data->PillarResult) { ?>
                                <?php foreach ($this->Data->PillarResult as $key => $value) { ?>

                                    <div class="py-1 row" style="background-color: <?= $this->ChartData['Pillar']['Color'][$key] ?>; border: 3px solid #fff;">

                                        <div class="col-9" onclick="showPillarElement('<?= $key ?>')">
                                            <span class="text_pillar_element section_<?= $key ?>" style="cursor: pointer;"> 
                                                <?= $value[0] . " (P" .($key+1) . ")" ?>  
                                            </span>
                                        </div>
                                        <div class="col-3"> <?= $value[1] ?> </div>

                                    </div>

                                <?php } ?>
                                <?php } ?>

                                <div class="my-4 row hide_pdf">
                                    <div class="col-9 font-weight-bold" onclick="showPillarElement('all')"> 
                                        <span class="text_pillar_element section_all text-primary" style="cursor: pointer;"> 
                                            Tampilkan semua  
                                        </span>
                                    </div>
                                    <div class="col-3"> </div>
                                </div>

                            </div>                    
                        </div>

                    </div>    
                </div>
            </div>
        </div>

        <div class="html2pdf__page-break"></div>                        

        <div class="card">
            <div class="card-header" role="tab" id="headingOne" data-toggle="collapse" href="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                <div class="row">
                    <h5 class="mb-0 col-11">
                        <a>
                            Hasil Penilaian Berdasarkan Elemen
                        </a>
                    </h5>                    
                    <span class="col-1 text-right">
                        <i class="fa fa-caret-down fa-lg"></i>                    
                    </span>
                </div>                
            </div>
            <div id="collapseOne" class="collapse show" role="tabpanel" aria-labelledby="headingOne" data-parent="#accordion" style="">
                <div class="card-body">

                    <h4 class="text-center my-3 hide_pdf"> 
                        Penilaian Semua Elemen Manajemen ASN 
                    </h3>

                    <div class="visual_data px-4">

                        <div class="text-right mb-2">
                            <button class="btn btn-secondary btn_bar btn-sm px-4">
                                Bar
                            </button>
                            <button class="btn btn-secondary btn_radar btn-sm px-3">
                                Radar
                            </button>
                        </div>

                        <canvas class="chart_item chart_bar hide_pdf" id="chart_bar_element"></canvas>
                        <canvas class="chart_item chart_radar d-none hide_pdf" id="chart_radar_element"></canvas>

                        <img class="img_chart_bar_element d-none show_pdf" />
                        <img class="img_chart_radar_element d-none show_pdf mt-3" />
                    </div>

                    <div class="html2pdf__page-break"></div>                        

                    <div class="m-3">
                        <h3> 
                            Nilai Elemen
                        </h3>
                        <hr>
                    </div>

                    <div class="row mx-2">

                        <?php if ($this->Data->ElementResult) { ?>
                        <?php foreach ($this->Data->ElementResult as $key => $value) { ?>

                        <div class="col-lg-4 col-md-6 col-xs-12 p-0" style="background-color: <?= $this->ChartData['Element']['Color'][$key] ?>; border: 3px solid #fff;">
                            <div class="d-flex py-2">
                                <div class="col-9"> <?= $value[0] . " (E" .($key+1) . ")" ?>  </div>
                                <div class="col-3"> <?= $value[1] ?> </div>
                            </div>
                        </div>

                        <?php } ?>
                        <?php } ?>

                    </div>

                </div>
            </div>
        </div>

        <?php if($this->Role == "SuperAdmin"){ ?>
        <?php if(count($this->Data->DataRaw) > 0 ){ ?>

        <div class="html2pdf__page-break raw_data"></div>                                    

        <div class="card">
            <div class="card-header" role="tab" id="headingFour" data-toggle="collapse" href="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                <div class="row">
                    <h5 class="mb-0 col-11">
                        <a>
                            Hasil Pengisian Kuesioner
                        </a>
                    </h5>
                    <span class="col-1 text-right">
                        <i class="fa fa-caret-down fa-lg"></i>                    
                    </span>
                </div>
            </div>
            <div id="collapseFour" class="collapse show" role="tabpanel" aria-labelledby="headingFour" data-parent="#accordion" style="">
                <div class="card-body">
                    <table id="table-assesment" class="table table-bordered table-striped table-hover hide_pdf" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th class="align-middle text-center">No</th>
                                <th class="align-middle text-center">Pilar</th>
                                <th class="align-middle text-center">Elemen</th>
                                <th class="align-middle text-center">Aktivitas Kunci</th>
                                <th class="align-middle text-center">Keluaran</th>
                                <th class="align-middle text-center">Indikator</th>
                                <th class="align-middle text-center">Penilaian</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php foreach ($this->Data->DataRaw as $key => $value) { ?>
                            
                            <tr>
                                <td class="text-center"><?= ($key + 1) ?></td>
                                <td><?= $value[0] ?></td>
                                <td><?= $value[1] ?></td>
                                <td><?= $value[2] ?></td>
                                <td><?= $value[3] ?></td>
                                <td><?= $value[4] ?></td>
                                <td class="text-center"><?= $value[6] ?></td>
                            </tr>

                            <?php } ?>

                        </tbody>
                    </table>

                    <table id="table_raw_data" class="table table-bordered table-striped table-hover mb-5 d-none show_pdf" style="font-size: 11px;">
                        <thead>
                            <tr>
                                <th class="align-middle text-center">No</th>
                                <th class="align-middle text-center">Pilar</th>
                                <th class="align-middle text-center">Elemen</th>
                                <th class="align-middle text-center">Aktivitas Kunci</th>
                                <th class="align-middle text-center">Keluaran</th>
                                <th class="align-middle text-center">Indikator</th>
                                <th class="align-middle text-center">Penilaian</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php foreach ($this->Data->DataRaw as $key => $value) {  ?>
                            
                            <tr>
                                <td class="text-center"><?= ($key + 1) ?></td>
                                <td><?= $value[0] ?></td>
                                <td><?= $value[1] ?></td>
                                <td><?= $value[2] ?></td>
                                <td><?= $value[3] ?></td>
                                <td><?= $value[4] ?></td>
                                <td class="text-center"><?= $value[6] ?></td>
                            </tr>

                            <?php } ?>

                        </tbody>
                    </table>                            

                </div>
            </div>
        </div>            

        <?php } ?>
        <?php } ?>

    </div>    

    <div class="text-center">
        <a class="btn_download_pdf d-none" href="javascript:void(0)" onclick="downloadResume()">
            <button type="submit" class="btn btn-outline-danger px-5 mt-3 mb-5">
                <i class="fa fa-download"></i> 
                Unduh Ringkasan Penilaian
            </button>
        </a>
    </div>

</div>

<div id="temp-pdf-section"></div>

<script src="/assets/js/html2pdf.bundle.min.js"></script> 
<script type="text/javascript" src="/assets/js/Chart.min.js"></script>
<script type="text/javascript">
    
    $(document).ready(function(){

        $('#table-assesment').DataTable({
            scrollX: true,
            searching: true,
            autoWidth: true,
            ordering: false,
            bLengthChange: false,
            responsive: true,
            info: false,
            order: [],
            language: {
                search: '<span>Filter:</span> _INPUT_',
                searchPlaceholder: 'Cari keyword.',
                lengthMenu: '<span>Show:</span> _MENU_',
                info: "Halaman _PAGE_ dari _PAGES_",
                infoEmpty: "Data tidak ditemukan",
                infoFiltered: "(filtered from _MAX_ total records)",
                paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
            }
        });   

        $('#table-users').DataTable({
            scrollX: true,
            searching: true,
            autoWidth: true,
            // ordering: false,
            bLengthChange: false,
            responsive: true,
            info: false,
            order: [],
            columnDefs: [ { orderable: false, targets: [0] } ],
            language: {
                search: '<span>Filter:</span> _INPUT_',
                searchPlaceholder: 'Cari keyword.',
                lengthMenu: '<span>Show:</span> _MENU_',
                info: "Halaman _PAGE_ dari _PAGES_",
                infoEmpty: "Data tidak ditemukan",
                infoFiltered: "(filtered from _MAX_ total records)",
                paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
            }
        });   

        $(".card-header").click(function(){
            var eleIcon = $(this).find('.fa');
            var statusShow = $(this).closest('.card').find('.collapse').hasClass('show');
            if(statusShow){
                eleIcon.removeClass('fa-caret-down').addClass('fa-caret-up');
            } else {
                eleIcon.removeClass('fa-caret-up').addClass('fa-caret-down');
            }
        });        

        $(".btn_bar").click(function(){
            var item = $(this).closest('.visual_data');
            item.find('.chart_item').addClass('d-none');
            item.find('.chart_item.chart_bar').removeClass('d-none');
        });

        $(".btn_radar").click(function(){
            var item = $(this).closest('.visual_data');
            item.find('.chart_item').addClass('d-none');
            item.find('.chart_item.chart_radar').removeClass('d-none');
        });        

        new Chart($('#chart_bar_element'),{
                type:'horizontalBar',
                data:{
                    labels: [ '<?= implode("', '", $this->ChartData['Element']['Label']) ?>' ],
                    datasets:[
                    {
                        backgroundColor:'rgba(23, 162, 184, 1)',
                        borderColor:'rgba(0, 0, 0ß, 0.8)',
                        highlightFill:'rgba(0, 0, 0, 0.75)',
                        highlightStroke:'rgba(0, 0, 0, 1)',
                        backgroundColor: [ '<?= implode("', '", $this->ChartData['Element']['Color']) ?>' ],
                        data: [ <?= implode(', ', $this->ChartData['Element']['Value']) ?> ]
                    }
                ]
            },
            options:{
                layout: {
                    padding: {
                        left: 0,
                        right: 50,
                        top: 0,
                        bottom: 0
                    }
                },
                plugins: {
                    datalabels: {
                        anchor: 'end',
                        align: 'end',
                        font: {
                            weight: 'bold'
                        },
                        rotation: 0,
                        color: 'rgba(0, 0, 0, 0.6)'
                    }
                },                
                tooltips: {
                    enabled: true,
                    mode: 'single',
                    callbacks: {
                        title: function(tooltipItems, data) { 
                            return data.labels[tooltipItems[0].index] + " (" + tooltipItems[0].xLabel + ")";;
                        }
                    }
                },                
                scales: {
                    yAxes: [{
                        ticks: {
                            fontColor: 'black',
                            mirror: true,
                            padding: -5                                                        
                        },                                        
                        gridLines: {
                            display: false
                        },
                    }],
                    xAxes: [{
                        ticks: {
                            beginAtZero: true,
                            max: 5,
                            min: 0,
                            stepSize: 1,
                            fontColor: 'black',                            
                        },                                                
                    }]                    
                },
                legend: { display: false },                
                responsive:true
            }
        });

        new Chart($('#chart_radar_element'),{
            type:'radar',
            data:{
                labels: [ '<?= implode("', '", $this->ChartData['Element']['Label']) ?>' ],
                datasets:[
                    {
                        backgroundColor: [ '<?= implode("', '", $this->ChartData['Element']['Color']) ?>' ],
                        borderColor: "rgba(0, 0, 0,0.9)",
                        fill: false,
                        radius: 4,
                        pointRadius: 10,
                        pointBorderWidth: 0,
                        pointBackgroundColor: [ '<?= implode("', '", $this->ChartData['Element']['Color']) ?>' ],
                        pointBorderColor: "rgba(0, 0, 0, 0)",
                        pointHoverRadius: 6,                        
                        data: [ '<?= implode("', '", $this->ChartData['Element']['Value']) ?>' ]
                    }
                ]
            },
            options:{
                plugins: {
                    datalabels: {
                        anchor: 'end',
                        align: 'end',                        
                        backgroundColor: '#555',
                        color: 'white',
                        padding: 4,
                        font: {
                            size: 10,
                            weight: 'bold'
                        }
                    }
                },                                
                title: {
                    display: true
                },                
                scale: {
                    ticks: {
                        beginAtZero: true,
                        min: 0,
                        max: 6
                    },
                    pointLabels: {
                      fontSize: 6,
                      // callback: function(pointLabel, index, labels) { 
                      //       return "E" + (index+1)
                      //  }
                    }
                },                
                legend: { display: false },                
                responsive:true
            }
        });

        new Chart($('#chart_bar_pillar'),{
            type: 'horizontalBar',
            data:{
                labels: [ '<?= implode("', '", $this->ChartData['Pillar']['Label']) ?>' ],
                datasets:[{
                    backgroundColor:'#f86c6b',
                    borderColor:'rgba(0, 0, 0, 0.8)',
                    highlightFill:'rgba(0, 0, 0, 0.75)',
                    highlightStroke:'rgba(0, 0, 0, 1)',
                    backgroundColor: [ '<?= implode("', '", $this->ChartData['Pillar']['Color']) ?>' ],
                    data: [ '<?= implode("', '", $this->ChartData['Pillar']['Value']) ?>' ]
                }]
            },
            options:{
                onClick: function(e){
                    var element = this.getElementAtEvent(e);
                    var index = element[0]._index;
                    showPillarElement(index);
                },                                
                layout: {
                    padding: {
                        left: 0,
                        right: 50,
                        top: 0,
                        bottom: 0
                    }
                },
                plugins: {
                    datalabels: {
                        anchor: 'end',
                        align: 'end',
                        font: {
                            weight: 'bold'
                        },
                        rotation: 0,
                        color: 'rgba(0, 0, 0, 0.6)'
                    }
                },                
                tooltips: {
                    enabled: true,
                    mode: 'single',
                    callbacks: {
                        title: function(tooltipItems, data) { 
                            return data.labels[tooltipItems[0].index] + " (" + tooltipItems[0].xLabel + ")";;
                        }
                    }
                },                
                scales: {
                    yAxes: [{
                        ticks: {
                            fontColor: 'black',
                            mirror: true,
                            padding: -5                                                        
                        },                                        
                        gridLines: {
                            display: false
                        },
                    }],
                    xAxes: [{
                        ticks: {
                            beginAtZero: true,
                            max: 5,
                            min: 0,
                            stepSize: 1,
                            fontColor: 'black',                            
                        },                                                
                    }]                    
                },
                legend: { display: false },                
                responsive:true
            }
        });

        new Chart($('#chart_radar_pillar'),{
            type:'radar',
            data:{
                labels: [ '<?= implode("', '", $this->ChartData['Pillar']['Label']) ?>' ],
                datasets:[
                    {
                        backgroundColor: "transparent",
                        borderColor: "rgba(0, 0, 0,0.5)",
                        fill: false,
                        radius: 10,
                        pointRadius: 10,
                        pointBorderWidth: 0,
                        pointBackgroundColor: [ '<?= implode("', '", $this->ChartData['Pillar']['Color']) ?>' ],
                        pointBorderColor: "rgba(0, 0, 0, 0)",
                        pointHoverRadius: 12,    
                        data: [ '<?= implode("', '", $this->ChartData['Pillar']['Value']) ?>' ]
                    }
                ]
            },
            options:{
                onClick: function(e){
                    var element = this.getElementAtEvent(e);
                    var index = element[0]._index;
                    showPillarElement(index, 'radar');
                },                                
                plugins: {
                    datalabels: {
                        anchor: 'end',
                        align: 'end',
                        backgroundColor: '#555',
                        color: 'white',
                        padding: 4,
                        font: {
                            size: 10,
                            weight: 'bold'
                        }
                    }
                },                                                
                title: {
                    display: true
                },                
                scale: {
                    ticks: {
                        beginAtZero: true,
                        min: 0,
                        max: 6
                    },
                    pointLabels: {
                      fontSize: 8,
                      // callback: function(pointLabel, index, labels) { 
                      //       return "P" + (index+1)
                      //  }
                    }
                },                
                legend: { display: false },                
                responsive:true
            }
        });

        <?php if ($this->Data->PillarResult) { ?>
        <?php foreach ($this->Data->PillarResult as $key => $value) { ?>

        new Chart($('#chart_bar_pillar_element_<?= $key ?>'),{
                type:'horizontalBar',
                data:{
                    labels: [ '<?= implode("', '", $this->ChartData['PillarElement'][$value[0]]['Label']) ?>' ],
                    datasets:[
                    {
                        backgroundColor:'#f86c6b',
                        borderColor:'rgba(0, 0, 0ß, 0.8)',
                        highlightFill:'rgba(0, 0, 0, 0.75)',
                        highlightStroke:'rgba(0, 0, 0, 1)',
                        backgroundColor: [ '<?= implode("', '", $this->ChartData['PillarElement'][$value[0]]['Color']) ?>' ],
                        data: [ '<?= implode("', '", $this->ChartData['PillarElement'][$value[0]]['Value']) ?>' ]
                    }
                ]
            },
            options:{
                layout: {
                    padding: {
                        left: 0,
                        right: 50,
                        top: 0,
                        bottom: 0
                    }
                },
                plugins: {
                    datalabels: {
                        anchor: 'end',
                        align: 'end',
                        font: {
                            weight: 'bold'
                        },
                        rotation: 0,
                        color: 'rgba(0, 0, 0, 0.6)'
                    }
                },                
                tooltips: {
                    enabled: true,
                    mode: 'single',
                    callbacks: {
                        title: function(tooltipItems, data) { 
                            return data.labels[tooltipItems[0].index] + " (" + tooltipItems[0].xLabel + ")";;
                        }
                    }
                },                
                scales: {
                    yAxes: [{
                        ticks: {
                            fontColor: 'black',
                            mirror: true,
                            padding: -5                                                        
                        },                                        
                        gridLines: {
                            display: false
                        },
                    }],
                    xAxes: [{
                        ticks: {
                            beginAtZero: true,
                            max: 5,
                            min: 0,
                            stepSize: 1,
                            fontColor: 'black',                            
                        },                                                
                    }]                    
                },
                legend: { display: false },                
                responsive:true
            }
        });

        new Chart($('#chart_radar_pillar_element_<?= $key ?>'),{
            type:'radar',
            data:{
                labels: [ '<?= implode("', '", $this->ChartData['PillarElement'][$value[0]]['Label']) ?>' ],
                datasets:[
                    {
                        backgroundColor: "transparent",
                        borderColor: "rgba(0, 0, 0,0.5)",
                        fill: false,
                        radius: 4,
                        pointRadius: 10,
                        pointBorderWidth: 0,
                        pointBackgroundColor: [ '<?= implode("', '", $this->ChartData['PillarElement'][$value[0]]['Color']) ?>' ],
                        pointBorderColor: "rgba(0, 0, 0, 0)",
                        pointHoverRadius: 6,    
                        data: [ '<?= implode("', '", $this->ChartData['PillarElement'][$value[0]]['Value']) ?>' ]
                    }
                ]
            },
            options:{
                plugins: {
                    datalabels: {
                        anchor: 'end',
                        align: 'end',
                        backgroundColor: '#555',
                        color: 'white',
                        padding: 4,
                        font: {
                            size: 10,
                            weight: 'bold'
                        }
                    }
                },                                                
                title: {
                    display: true
                },                
                scale: {
                    ticks: {
                        beginAtZero: true,
                        min: 0,
                        max: 6
                    },
                    pointLabels: {
                      fontSize: 8,
                      // callback: function(pointLabel, index, labels) { 
                      //       return "P" + (index+1)
                      //  }
                    }
                },                
                legend: { display: false },                
                responsive:true
            }
        });


        <?php } ?>
        <?php } ?>

        setTimeout(function(){ 
            var canvas = $('#chart_bar_pillar')[0];
            $('.img_chart_bar_pillar').attr('src', canvas.toDataURL("image/png")).attr('width', '500');
            
            canvas = $('#chart_radar_pillar')[0];
            $('.img_chart_radar_pillar').attr('src', canvas.toDataURL("image/png")).attr('width', '600');

            canvas = $('#chart_bar_element')[0];
            $('.img_chart_bar_element').attr('src', canvas.toDataURL("image/png")).attr('width', '720').css('margin-left', '-15px');
            canvas = $('#chart_radar_element')[0];
            $('.img_chart_radar_element').attr('src', canvas.toDataURL("image/png")).attr('width', '1000').css('margin-left', '-155px');

            $('.btn_download_pdf').removeClass('d-none');
        }, 3000);

    });

    function downloadResume() {
        (async function getFormValues () {
            var filename = "SIPMAS-" + moment().format("YYYY-MM-DD HH:mm");            
            const {value: formValues} = await Swal.fire({
                title: 'Nama file yang akan diunduh',
                html:
                    '<input id="swal-filename" class="swal2-input" value="' + filename + '">' +
                    '<input id="swal-check-quesioner" type="checkbox" class="mr-1 <?= (count($this->Users) > 1) ? 'd-none' : '' ?>" style="cursor: pointer;"> \
                        <span onclick="$(this).prev().click()" class="<?= (count($this->Users) > 1) ? 'd-none' : '' ?>"style="cursor: pointer;">Tampilkan pengisian data kuesioner</span>',
                showCancelButton: true,
                focusConfirm: false,
                preConfirm: () => {
                    return [
                        document.getElementById('swal-filename').value,
                        document.getElementById('swal-check-quesioner').checked
                    ]
                }
            })

            if (formValues) {
                var filename = formValues[0];
                var checkQuesioner = formValues[1];

                if(!filename){
                    swal("", "Nama file harus diisi", "error");
                    return false;
                }

                var clone = $('[role=tablist]').clone().attr('id', 'temp-pdf').css('width', '755px');
                clone.find('.fa-caret-down,[type=submit],.hide_pdf').remove();
                clone.find('.dataTables_wrapper').remove();
                clone.find('.show_pdf').removeClass('d-none');
                clone.find('.px-5').removeClass('px-5').addClass('px-3');
                clone.find('.form-group').removeClass('form-group');
                clone.css('font-size', '12px');
                clone.find('#table_users').css('font-size', '11px');
                clone.find('#table_raw_data').css('font-size', '9px');
                clone.find('.col-lg-6').removeClass('col-lg-6').addClass('col-6');
                clone.find('.col-sm-12.col-md-6').removeClass('col-md-6 col-sm-12').addClass('col-12');
                clone.find('.col-lg-8.col-md-12,.col-lg-4.col-md-12').removeClass('col-lg-4 col-lg-8 col-md-12').addClass('col-12');
                clone.find('.col-lg-4.col-md-6.col-xs-12').removeClass('col-lg-4 col-md-6 col-xs-12').addClass('col-6');
                clone.find('.visual_data').addClass('text-center');
                clone.find('.btn_bar,.btn_radar').addClass('d-none');                

                if(!checkQuesioner){
                    clone.find('#table_raw_data').closest('.card').remove();
                    clone.find('.html2pdf__page-break.raw_data').remove();
                }                

                $('#temp-pdf-section').append(clone);

                showLoading();

                var element = document.getElementById('temp-pdf');          
                var opt = {
                    margin:       [8, 5],
                    filename:     filename + '.pdf',
                    image:        { type: 'jpeg', quality: 0.5 },
                    html2canvas:  { dpi: 192, letterRendering: true },
                    jsPDF:        { unit: 'mm', format: 'a4', orientation: 'portrait' }
                };
                workerPdf = html2pdf().set(opt).from(element).outputPdf().then(function(pdf){
                    hideLoading();
                }).save();
                
                $('#temp-pdf-section').html('');                
            }
        })()             
    }

    function showPillarElement(key, type){
        if(type == 'radar'){
            $('.chart_pillar_element.section_' + key + ' .chart_bar').addClass('d-none');            
            $('.chart_pillar_element.section_' + key + ' .chart_radar').removeClass('d-none');            

            $('.chart_pillar_element').addClass('d-none');
            $('.chart_pillar_element.section_' + key).removeClass('d-none');
        } else {
            $('.chart_pillar_element.section_' + key + ' .chart_bar').removeClass('d-none');            
            $('.chart_pillar_element.section_' + key + ' .chart_radar').addClass('d-none');            

            $('.chart_pillar_element').addClass('d-none');
            $('.chart_pillar_element.section_' + key).removeClass('d-none');
        }

        $('.text_pillar_element').removeClass('text-primary');
        $('.text_pillar_element.section_' + key).addClass('text-primary');        
    }

</script>
