<?php $this->extend('Layouts/layout-main.html.php'); ?>

<div class="container">

    <div class="animated fadeIn">

        <div class="card d-none">
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-8">
                        <h4 class="card-title mb-0">Aktifitas Peserta</h4>
                    </div>
                    
                    <div class="col-sm-4 text-right">
                        <select class="form-control filter">
                            <option value="d">Hari</option>
                            <option value="w">Minggu</option>
                            <option value="m">Bulan</option>
                            <option value="y">Tahun</option>
                        </select>
                    </div>                    
                </div>

                <div class="chart-wrapper" style="height:300px;margin-top:40px;">
                    <canvas id="main-chart" class="chart chartjs-render-monitor" height="300" width="930" style="display: block; width: 930px; height: 300px;"></canvas>
                </div>

            </div>

            <div class="card-footer">
                <div class="row text-center">
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">Click</div>
                        <strong>21.098</strong>
                        <div class="progress progress-xs mt-2">
                            <div class="progress-bar bg-warning" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">Conversion</div>
                        <strong>745</strong>
                        <div class="progress progress-xs mt-2">
                            <div class="progress-bar bg-success" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">                
                <div class="card">
                    <div class="card-header">
                        Statistik Peserta Berdasarkan Produk
                    </div>
                    <div class="card-body py-0">
                        <div class="row">
                            <div class="col-sm-4 d-flex">
                                <div class="callout callout-warning col-9 justify-content-center align-self-center">
                                    <small class="text-muted">Jumlah peserta</small>
                                    <br>
                                    <strong class="h4"><?= $this->StatisticParticipant->All ?></strong>
                                </div>
                                <div class="col-3 justify-content-center align-self-center text-center">
                                    <i class="nav-icon fas fa-2x fa-users"></i> 
                                </div>
                            </div>
                            <div class="col-sm-4 d-flex">
                                <div class="callout callout-success col-9 justify-content-center align-self-center">
                                    <small class="text-muted">Peserta aktif</small>
                                    <br>
                                    <strong class="h4"><?= $this->StatisticParticipant->Active ?></strong>
                                </div>
                                <div class="col-3 justify-content-center align-self-center text-center">
                                    <i class="nav-icon fas fa-2x fa-user-check"></i> 
                                </div>
                            </div>
                            <div class="col-sm-4 d-flex">
                                <div class="callout callout-primary col-9 justify-content-center align-self-center">
                                    <small class="text-muted">Ratio aktifasi</small>
                                    <br>
                                    <strong class="h4"><?= $this->StatisticParticipant->Ratio ?>%</strong>
                                </div>
                                <div class="col-3 justify-content-center align-self-center text-center">
                                    <i class="nav-icon fas fa-2x fa-percent"></i> 
                                </div>
                            </div>
                        </div>

                        <table class="table table-responsive-sm table-hover my-3">
                            <thead class="thead bg-gray-100">
                                <tr class="text-center">
                                    <th>No</th>
                                    <th class="text-left">Nama Produk</th>
                                    <th>Peserta Mengikuti</th>
                                    <th>Peserta Menyelesaikan</th>
                                    <th>Rasio Tuntas</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php foreach ($this->StatisticAssessment as $key => $value) { ?>

                                <tr class="text-center">
                                    <td class="text-center">
                                        <?= ($key + 1) ?>
                                    </td>
                                    <td class="text-left">
                                        <?= $value->Name ?>
                                    </td>
                                    <td>
                                        <?= $value->All ?>
                                    </td>
                                    <td>
                                        <?= $value->Finished ?>
                                    </td>
                                    <td>
                                        <?= $value->Ratio ?>%
                                    </td>
                                </tr>

                                <?php } ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>

    

<script type="text/javascript" src="/assets/js/Chart.min.js"></script>
<script type="text/javascript">

    $(document).ready(function(){
        var mainChart = new Chart($('#main-chart'),{
            type:'line',
            data:{
                labels:['26/06/18', '27/06/18', '28/06/18', '29/06/18', '30/06/18', '31/06/18', '01/07/18'],
                datasets:[
                {
                    label:'Click',
                    backgroundColor:'transparent',
                    borderColor:getStyle('--warning'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:2,
                    data:[92,97,80,100,86,97,83]
                },{
                    label:'Conversion',
                    backgroundColor:'transparent',
                    borderColor:getStyle('--success'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:2,
                    data:[18,11,4,50,65,12,25]
                }]
            },
            options:{
                maintainAspectRatio:false,
                legend:{display:false},
                scales:{
                    xAxes:[{
                        gridLines:{drawOnChartArea:false}
                    }],
                    yAxes:[{
                        ticks:{
                            beginAtZero:true,
                            maxTicksLimit:5,
                            stepSize:Math.ceil(250/5),max:250
                        }
                    }]
                },
                elements:{
                    point:{
                        radius:0,
                        hitRadius:10,
                        hoverRadius:4,
                        hoverBorderWidth:3
                    }
                }
            }
        });

    });

</script>
