<?php $this->extend('Layouts/layout-main.html.php'); ?>

<div class="container">

    <h2 class="my-4">
        Import Data SIPBOS
    </h2>

    <div class="table-report table-responsive"></div>

</div>

<!-- modal for register -->
<div id="modal-import-form" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-danger modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-file-import mr-2"></i>
                    Import Data Baru
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
				<form id="form-new-import" method="POST" enctype="multipart/form-data">
					<div class="form-group">
						<label class="col-form-label">File Excel <span class="text-danger">*</span> </label>
						<input type="file" class="form-control clear" name="FilePath" placeholder="File data yang ingin diimport" accept=".xlsx" data-rule-required="true" data-msg-required="File harus dipilih" >
						<span class="small">Berikut template excel raw data SIPBOS
                            <a href="/assets/excel/sipbos/template_raw_data.xlsx" download="template_raw_data_SIPBOS">link</a>
                        </span>
					</div>
					<div class="form-group">
						<label class="col-form-label">Nama Import Data <span class="text-danger">*</span> </label>
						<input type="text" class="form-control clear" name="Name" placeholder="Nama import data" data-rule-required="true" data-msg-required="Nama harus diisi">
					</div>
                    <div class="form-group">
                        <label class="col-form-label">Tanggal Pengisian Data <span class="text-danger">*</span> </label>
                        <div class="controls">
                            <div class='input-group dateinputpicker'>                   
                                <span class="input-group-addon">
                                    <i class="far fa-calendar-alt fa-lg bg-danger p-3"></i>
                                </span>
                                <input type="text" class="form-control bg-white" name="DateInput" readonly data-rule-required="true" data-msg-required="Tanggal pengisian harus diisi" placeholder="Tanggal pengisian data">
                            </div>
                        </div>
                    </div>                    
					<div class="form-group">
						<label class="col-form-label">Keterangan (Note)</label>
						<input type="text" class="form-control clear" name="Note" placeholder="Keterangan (Note)">
						<span class="small">Untuk mengelompokan dan memudahkan pada saat melakukan pencarian data</span>
					</div>
				</form>
            </div>
            <div class="modal-footer">
				<button type="button" class="btn btn-danger" onclick="$('#form-new-import').submit()">Import Data</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for register -->

<script type="text/javascript">

    $(document).ready(function(){
        $('.input-group.dateinputpicker').datetimepicker({
            viewMode: 'years',
            ignoreReadonly: true,
            allowInputToggle: true,
            useCurrent: false,
            defaultDate: moment(),
            maxDate: moment(),
            format: 'DD-MM-YYYY'
        });

    	loadDataTables();
    	validationForm();
    });

    function validationForm(){
        $('form').validate({
            errorElement:'em',
            errorPlacement:function errorPlacement(error,element){
                error.addClass('invalid-feedback');
                if(element.prop('type')==='checkbox'){
                    error.insertAfter(element.parent('label'));
                }else{
                    error.insertAfter(element);
                }
            },
            highlight:function highlight(element){
                $(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight:function unhighlight(element){
                $(element).addClass('is-valid').removeClass('is-invalid');
            },
            submitHandler: function(form) {
                addData();
            }
        });
    }    

    function loadDataTables(){  
        selectedDataOnTable = [];
        $(".table-report").html('<table id="table-target" class="table table-bordered table-striped table-hover" cellspacing="0" width="100%"></table>');
        $('#table-target').DataTable({
            scrollX: true,
            searching: true,
            autoWidth: false,
            bLengthChange: false,
            "ordering": false,
            info: true,
            responsive: true,
            processing: true,
            serverSide: true,
            ajax: {
                type: 'POST',
                url: '/api/sipbos-import/get-server-side',
                data: {},
                dataSrc: function ( response ) {
                    return response.data;
                },
                beforeSend: function (request) {
                    request.setRequestHeader('apikey', '<?= $this->Apikey ?>');
                }
            },
            drawCallback: function( settings ) {},
            columns: [
            	{
					'id' : 0,
					'data' : 'data0',
					'title' : '' 
				},
            	{
					'id' : 1,
					'data' : 'data1',
					'title' : 'Nama' 
				},
            	{
					'id' : 2,
					'data' : 'data2',
					'title' : 'Note' 
				},
            	{
					'id' : 3,
					'data' : 'data3',
					'title' : 'Jumlah Data' 
				},				
                {
                    'id' : 4,
                    'data' : 'data4',
                    'title' : 'Tanggal Input' 
                },              
            	{
					'id' : 5,
					'data' : 'data5',
					'title' : 'Tanggal Import' 
				},				
            ],
            language: {
                search: '<span>Filter:</span> _INPUT_',
                searchPlaceholder: 'Cari nama atau note...',
                infoEmpty: "Tidak ada data import",
                emptyTable: "Tidak ada data import",
                zeroRecords: "Tidak ada data import",
                lengthMenu: '<span>Show:</span> _MENU_',
                paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
            },
            dom: 'Bfrtip',
            buttons: [
                {
                    text: 'Import Data Baru',
                    className: "btn btn-outline-danger mb-3 mr-2",
                    action: function ( e, dt, node, config ) {
				    	newImportForm();
                    }
                }
            ]
        });                     
    }    

    function newImportForm(){
        $("#form-new-import .form-control").val("");
        $("#form-new-import [name=Name]").val("IMPORT" + moment().format("|YYYY-MMM-DD|HH:mm"));
        $('#modal-import-form').modal('show');        
    }

    function addData(){
        showLoading();

        var form = $("#form-new-import");
        var formdata = new FormData(form[0]);
        $.ajax({
            type: 'POST',
            url: '/api/sipbos-import/import-data',
            cache: false,
            contentType: false,
            processData: false,
            data: formdata,
            success: function(response){
                hideLoading();
                if(response.Status){                    
                    $('#modal-import-form').modal('hide');        
                    loadDataTables();
                    swal({
                        html: 'Import data berhasil',
                        type: 'success',
                        timer: 2000,
                    });                                 
                } else{
                    swal({
                        title: 'Mohon Maaf',
                        html: response.Message,
                        type: 'error',
                        showCloseButton: true
                    });                                 
                }
            }, error: function(response) {  
                hideLoading();                
                swal({
                    title: 'Mohon Maaf',
                    html: "Terjadi kesalahan pada jaringan",
                    type: 'error',
                    showCloseButton: true
                });
            }
        });        
    }

    function deleteData(id, name){
		swal({
            title: '',
            text: 'Apakah Anda yakin akan menghapus data import "' + name + '"?',
            type: 'question',
            showCancelButton: true,
            cancelButtonText: 'Tidak',
            confirmButtonText: 'Ya'
        }).then((result) => {
            if (result.value) {
                showLoading();
				$.ajax({
					type: 'POST',
					url: '/api/sipbos-import/delete',
					data: { Id: id },
				 	success: function(response){
                        hideLoading();                
				 		if(response.Status){
                            loadDataTables();
				 			swal({
		                        html: 'Hapus data import berhasil',
		                        type: 'success',
								timer: 2000,
		                    });      				 			
				 		} else{
				 			swal({
		                        title: 'Mohon Maaf',
		                        html: response.Message,
		                        type: 'error',
		                        showCloseButton: true
		                    });      				 			
				 		}
					}, error: function(response) {	
                        hideLoading();
			 			swal({
	                        title: 'Mohon Maaf',
	                        html: "Terjadi kesalahan pada jaringan",
	                        type: 'error',
	                        showCloseButton: true
	                    });
					}
				});            	
            }
        });
    }

</script>
