<?php $this->extend('Layouts/layout-main.html.php'); ?>

<!-- css ion slider plugin and choosen -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.4.2/chosen.css" rel="stylesheet">
<link href="/assets/plugins/ion.rangeslider/css/normalize.css" rel="stylesheet">
<link href="/assets/plugins/ion.rangeslider/css/ion.rangeSlider.css" rel="stylesheet">
<link href="/assets/plugins/ion.rangeslider/css/ion.rangeSlider.skinFlat.css" rel="stylesheet">

<!-- js ion slider plugin and choosen -->
<script type="text/javascript" src="/assets/plugins/ion.rangeslider/js/ion.rangeSlider.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.4.2/chosen.jquery.min.js"></script>

<div class="container py-3">
    <div class="card filter_section">
        <div class="card-header bg-light d-flex" onclick="$(this).parent().find('.card-body').toggleClass('d-none')">
            <div class="col-8">
                <h5 class="mb-0">
                    <a>
                        Filter Data
                    </a>
                </h5>
            </div>
            <div class="col-4 text-right">
                <i class="nav-icon fas fa-filter"></i>                 
            </div>
        </div>
        <div class="card-body">                    
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Nama</label>
                <div class="col-md-6">
                    <input class="form-control input-enter" type="text" name="Name" placeholder="Cari nama..">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Email</label>
                <div class="col-md-6">
                    <input class="form-control input-enter" type="text" name="Email" placeholder="Cari email..">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Jenis Kelamin</label>
                <div class="col-md-8">
                    <div class="form-check form-check-inline mr-1 checkbox">
                        <input class="form-check-input" type="checkbox" name="Gender" value="Laki-laki">
                        <label class="form-check-label">Laki-laki</label>
                    </div>
                    <div class="form-check form-check-inline mr-1 checkbox">
                        <input class="form-check-input" type="checkbox" name="Gender" value="Perempuan">
                        <label class="form-check-label">Perempuan</label>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Usia</label>
                <div class="col-md-6">
                    <div class="range-slider m-4">
                        <input type="text" class="js-range-slider" value="" />
                        <input type="hidden" class="form-control" name="AgeFrom" />
                        <input type="hidden" class="form-control" name="AgeTo" />
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Provinsi</label>
                <div class="col-md-6">
                    <select name="Province" data-placeholder="Pilih provinsi.." class="form-control chosen-select" multiple tabindex="4">
                        <?php if($this->Provinces){ ?>
                        <?php foreach($this->Provinces as $key => $province) { ?>
                        
                        <option value="<?= $province->Name?>"><?= $province->Name ?></option>
                        
                        <?php } ?> 
                        <?php } ?>
                    </select>                        
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Kota</label>
                <div class="col-md-6">
                    <select name="City" data-placeholder="Pilih kota.." class="form-control chosen-select" multiple tabindex="4">
                        <?php if($this->Cities){ ?>
                        <?php foreach($this->Cities as $key => $city) { ?>
                        
                        <option value="<?= $city->Name?>"><?= $city->Name ?></option>
                        
                        <?php } ?> 
                        <?php } ?>                        
                    </select>                        
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Tingkat pendidikan</label>
                <div class="col-md-6">
                    <select name="Education" data-placeholder="Pilih tingkat pendidikan.." class="form-control chosen-select input-enter" multiple tabindex="4">
                        <option value="SD">SD</option>
                        <option value="SMP">SMP</option>
                        <option value="SMA">SMA</option>
                        <option value="D3">D3</option>
                        <option value="S1">S1</option>
                        <option value="S2">S2</option>
                        <option value="S3">S3</option>
                    </select>                        
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Jabatan</label>
                <div class="col-md-6">
                     <input class="form-control input-enter" type="text" name="Departement" placeholder="Cari jabatan..">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">NIP</label>
                <div class="col-md-6">
                     <input class="form-control input-enter" type="text" name="Nip" placeholder="Cari NIP.. ">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Instansi</label>
                <div class="col-md-6">
                    <input class="form-control input-enter" type="text" name="Institute" placeholder="Cari Institusi..">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Divisi Instansi</label>
                <div class="col-md-6">
                    <input class="form-control input-enter" type="text" name="InstituteSection" placeholder="Cari Divisi Institusi..">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Keterangan (Note)</label>
                <div class="col-md-6">
                    <input class="form-control input-enter" type="text" name="Note" placeholder="Cari note tertentu..">
                </div>
            </div>            
            <div class="form-group row my-4"></div>                    
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Waktu melakukan asesmen</label>
                <div class="col-md-6">
                    <div class="input-group">
                        <input type="hidden" class="form-control" name="StartDate" />
                        <input type="hidden" class="form-control" name="EndDate" />
                        <input class="form-control input-enter" type="text" name="DateRange" placeholder="Interval waktu.." name="daterange">
                        <span class="input-group-prepend btn-clear" onclick="$(this).siblings('.form-control').val('')">
                            <span class="input-group-text">
                                <i class="fa fa-times"></i>
                            </span>
                        </span>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Status asesmen</label>
                <div class="col-md-8">
                    <div class="form-form-check form-check-inline mr-1 checkbox">
                        <input class="form-check-input" type="checkbox" name="IsFinished" value="1">
                        <label class="form-check-label">Sudah selesai</label>
                    </div>
                    <div class="form-check form-check-inline mr-1 checkbox">
                        <input class="form-check-input" type="checkbox" name="IsFinished" value="0">
                        <label class="form-check-label">Belum selesai</label>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-md-2 col-form-label font-weight-bold">Kualitas Data</label>
                <div class="col-md-8">
                    <div class="form-check form-check-inline mr-1 checkbox">
                        <input class="form-check-input" type="checkbox" name="Corrupt" value="0">
                        <label class="form-check-label">Baik</label>
                    </div>
                    <div class="form-form-check form-check-inline mr-1 checkbox">
                        <input class="form-check-input" type="checkbox" name="Corrupt" value="1">
                        <label class="form-check-label">Kurang baik</label>
                    </div>
                </div>
            </div>            
            <div class="form-group row my-4"></div>                    
            <div class="form-group row">
                <div class="col-md-2 col-form-label"></div>
                <div class="col-md-6">
                    <div class="text-right">
                        <button class="btn btn-outline-danger" onclick="loadDataTables()">
                            <i class="fa fa-eye"></i>
                            <span class=""> Tampilkan Data </span> 
                        </button>           
                    </div>                                  
                </div>
            </div>
            <div class="form-group row my-2"></div>                    

        </div>
    </div>
    <div class="table-report table-responsive"></div>
    <input type="hidden" name="AllId">
</div>

<script type="text/javascript">
    var selectedDataOnTable = [];    
    $(document).ready(function() {
        $(".chosen-select").chosen();
        $(".filter_section .card-body").addClass('d-none');

        $('[name="DateRange"]').daterangepicker({
            opens:'center',
            drops:'up',
            autoUpdateInput: false,
            autoApply: false,
            maxDate: moment(),
            ranges:{ 
                Today:[moment(),moment()],
                Yesterday:[moment().subtract(1,'days'),moment().subtract(1,'days')],
                'Last 7 Days':[moment().subtract(6,'days'),moment()],
                'Last 30 Days':[moment().subtract(29,'days'),moment()],
                'This Month':[moment().startOf('month'),moment().endOf('month')],
                'Last Month':[moment().subtract(1,'month').startOf('month'),moment().subtract(1,'month').endOf('month')]
            },
            locale: {
                cancelLabel: 'Clear'
            }            
        });        
        $('[name="DateRange"]').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD MMM YYYY') + ' s/d ' + picker.endDate.format('DD MMM YYYY'));
            $('[name=StartDate]').val(picker.startDate.unix());
            $('[name=EndDate]').val(picker.endDate.unix());            
        });
     
        $(".js-range-slider").ionRangeSlider({
            type: "double",
            grid: true,
            min: 0,
            max: 100,
            from: 0,
            to: 100,
            prefix: "Umur: ",
            postfix: " Tahun",
            decorate_both: false, // false,
            step: 1,
            from: 0,
            onLoad: function (data) {
                $('[name=AgeFrom]').val(data.from);
                $('[name=AgeTo]').val(data.to);
            },
            onChange: function (data) {                
                $('[name=AgeFrom]').val(data.from);
                $('[name=AgeTo]').val(data.to);
            }
        });

        $('.input-enter').on('keyup', function (e) {
            if (e.which == 13) {
                loadDataTables();
            }
        });                

        loadDataTables();
    });

    function getFilterData() {
        data = {};

        $('.filter_section .form-control').each(function () {
            var key = $(this).attr('name');
            var value = $(this).val();

            if(value){
                data[key] = value;
            }
        });

        $('.form-check-input:checked').each(function () {
            var key = $(this).attr('name');
            var value = $(this).val();

            if(data[key]){
                data[key].push(value);
            } else {
                data[key] = [value];
            }
        });

        return data;
    }

    function checkboxDataCallback(ele){
        var value = $(ele).val();
        var checkExisting = selectedDataOnTable.includes(value);

        var action = $(ele).prop('checked');
        if(action){
            if(!checkExisting){
                selectedDataOnTable.push(value);
            }
        } else {
            if(checkExisting){
                selectedDataOnTable.splice($.inArray(value, selectedDataOnTable), 1);
            }            
        }

        var allId = $('[name=AllId]').val().split(",");
        if(allId.length == selectedDataOnTable.length){
            $('.checkbox_all_data').prop('checked', true);
        } else {
            $('.checkbox_all_data').prop('checked', false);            
        }

        if(selectedDataOnTable.length > 0) 
            $('.btn-resume-selected').removeClass('d-none');
        else 
            $('.btn-resume-selected').addClass('d-none');
    }

    function checkboxAllData(ele){
        var action = $(ele).prop('checked');
        if(action){
            $('.checkbox_data').prop('checked', true);
            selectedDataOnTable = $('[name=AllId]').val().split(",");
        } else {
            $('.checkbox_data').prop('checked', false);
            selectedDataOnTable = [];
        }

        if(selectedDataOnTable.length > 0) 
            $('.btn-resume-selected').removeClass('d-none');
        else 
            $('.btn-resume-selected').addClass('d-none');
    }    

    function renderCheckboxData(){
        $('.checkbox_data').each(function () {
            var value = $(this).val();
            var checkExisting = selectedDataOnTable.includes(value);
            
            if(checkExisting) $(this).prop('checked', true);
        });        

        setTimeout(function(){
            $('.checkbox_all_data').last().addClass('d-none');
        }, 100);
    }    
    
    function loadDataTables(){   
        selectedDataOnTable = [];
        $(".table-report").html('<table id="table-target" class="table table-bordered table-striped table-hover" cellspacing="0" width="100%"></table>');
        $('#table-target').DataTable({
            scrollX: true,
            searching: false,
            autoWidth: false,
            bLengthChange: false,
            "ordering": false,
            info: true,
            responsive: true,
            processing: true,
            serverSide: true,
            ajax: {
                type: 'POST',
                url: '/api/sipmas/get-report-data',
                data: { params_filter: JSON.stringify(getFilterData()) },
                dataSrc: function ( response ) {
                    $('[name=AllId]').val(response.allId);
                    return response.data;
                },
                beforeSend: function (request) {
                    showLoading();        
                    request.setRequestHeader('apikey', '<?= $this->Apikey ?>');
                }
            },
            drawCallback: function( settings ) {
                renderCheckboxData();
                hideLoading();
            },
            columns: JSON.parse('<?= $this->Column ?>'),
            language: {
                search: '<span>Filter:</span> _INPUT_',
                searchPlaceholder: 'Type to filter...',
                lengthMenu: '<span>Show:</span> _MENU_',
                paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
            },
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    text: 'Export to Excel',
                    title: 'Hasil Resume SIPMAS',
                    className: "btn btn-outline-danger mb-3 mr-2",
                    exportOptions: { 
                        format: { 
                            body: function ( data, row, column, node ) { 
                                return data; 
                            } 
                        },
                        columns: [ 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ] 
                    },
                    action: function (e, dt, button, config) {
                        var idx = this;
                        dt.one('preXhr', function (e, s, data){
                            data.length = -1;
                        }).one('draw', function (e, settings, json, xhr){
                            $.fn.dataTable.ext.buttons.excelHtml5.action.call(idx, e, dt, button, config);
                        }).draw();
                    }
                },
                {
                    text: 'Resume All Data',
                    className: "btn btn-outline-danger mb-3 mr-2",
                    action: function ( e, dt, node, config ) {
                        var allId = $('[name=AllId]').val();
                        if(!allId) {
                            swal({
                                text: "Data report kosong",
                                type: 'warning',
                                showCloseButton: true,
                            });   
                            return false;     
                        }

                        var url = "/sa/sipmas/resume?q=" + allId;
                        var win = window.open(url, '_blank');
                        win.focus();
                    }
                },
                {
                    text: 'Resume Selected Data',
                    className: "btn btn-outline-danger btn-resume-selected mb-3 d-none",
                    action: function ( e, dt, node, config ) {
                        var selectedId = selectedDataOnTable.join(',');
                        var url = "/sa/sipmas/resume?q=" + selectedId;
                        var win = window.open(url, '_blank');
                        win.focus();
                    }
                }
            ]
        });                     
    }    
</script>
