<?php $this->extend('Layouts/layout-main.html.php'); ?>

<div class="container">

    <div class="card">
        <div class="card-header">
            Statistik Akumulasi Data Penilaian Manajemen ASN
        </div>
        <div class="card-body py-0">
            <div class="row">
                <div class="col-sm-4 d-flex">
                    <div class="callout callout-danger col-9 justify-content-center align-self-center">
                        <small class="text-muted">Jumlah mengikuti</small>
                        <br>
                        <strong class="h4"><?= $this->Statistic->All ?></strong>
                    </div>
                    <div class="col-3 justify-content-center align-self-center text-center">
                        <i class="nav-icon fas fa-2x fa-clipboard-list"></i> 
                    </div>
                </div>
                <div class="col-sm-4 d-flex">
                    <div class="callout callout-success col-9 justify-content-center align-self-center">
                        <small class="text-muted">Jumlah tuntas</small>
                        <br>
                        <strong class="h4"><?= $this->Statistic->Finished ?></strong>
                    </div>
                    <div class="col-3 justify-content-center align-self-center text-center">
                        <i class="nav-icon fas fa-2x fa-clipboard-check"></i> 
                    </div>
                </div>
                <div class="col-sm-4 d-flex">
                    <div class="callout callout-primary col-9 justify-content-center align-self-center">
                        <small class="text-muted">Rasio</small>
                        <br>
                        <strong class="h4"><?= $this->Statistic->Ratio ?>%</strong>
                    </div>
                    <div class="col-3 justify-content-center align-self-center text-center">
                        <i class="nav-icon fas fa-2x fa-percent"></i> 
                    </div>
                </div>
            </div>
        </div>
    </div>    

    <div class="animated fadeIn">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-8">
                        <h4 class="card-title mb-0">Grafik Peserta Penilaian Manajemen ASN</h4>
                        <div class="small text-muted chart_description">7 hari terakhir</div>
                    </div>
                    
                    <div class="col-sm-4 text-right">
                        <select class="form-control filter-overview">
                            <option value="d">Hari</option>
                            <option value="w">Minggu</option>
                            <option value="m">Bulan</option>
                            <option value="y">Tahun</option>
                        </select>
                    </div>                    
                </div>

                <div class="chart-wrapper" style="height:300px;margin-top:40px;">
                    <canvas id="chart_overview_d" class="chart chartjs-render-monitor chart_item" height="300" width="930" style="display: block; width: 930px; height: 300px;"></canvas>
                </div>

                <div class="chart-wrapper d-none" style="height:300px;margin-top:40px;">
                    <canvas id="chart_overview_w" class="chart chartjs-render-monitor chart_item" height="300" width="930" style="display: block; width: 930px; height: 300px;"></canvas>
                </div>                

                <div class="chart-wrapper d-none" style="height:300px;margin-top:40px;">
                    <canvas id="chart_overview_m" class="chart chartjs-render-monitor chart_item" height="300" width="930" style="display: block; width: 930px; height: 300px;"></canvas>
                </div>                

                <div class="chart-wrapper d-none" style="height:300px;margin-top:40px;">
                    <canvas id="chart_overview_y" class="chart chartjs-render-monitor chart_item" height="300" width="930" style="display: block; width: 930px; height: 300px;"></canvas>
                </div>                

            </div>

            <div class="card-footer">
                <div class="row text-center">
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">Mengikuti Penilaian</div>
                        <strong class="chart_description_all"><?= $this->ChartData['Day']['Count'][0] ?></strong>
                        <div class="progress progress-xs mt-2">
                            <div class="progress-bar bg-danger role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">Menyelesaikan Penilaian</div>
                        <strong class="chart_description_success"><?= $this->ChartData['Day']['Count'][1] ?></strong>
                        <div class="progress progress-xs mt-2">
                            <div class="progress-bar bg-success" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

    

<script type="text/javascript" src="/assets/js/Chart.min.js"></script>
<script type="text/javascript">

    $(document).ready(function(){

        $(".filter-overview").change(function(){
            var id = $(this).val();

            if(id == 'd'){
                $('.chart_description').html('7 hari terakhir');
                $('.chart_description_all').html('<?= $this->ChartData['Day']['Count'][0] ?>');
                $('.chart_description_success').html('<?= $this->ChartData['Day']['Count'][1] ?>');
            } else if(id == 'w'){
                $('.chart_description').html('7 minggu terakhir');
                $('.chart_description_all').html('<?= $this->ChartData['Week']['Count'][0] ?>');
                $('.chart_description_success').html('<?= $this->ChartData['Week']['Count'][1] ?>');
            } else if(id == 'm'){
                $('.chart_description').html('7 bulan terakhir');
                $('.chart_description_all').html('<?= $this->ChartData['Month']['Count'][0] ?>');
                $('.chart_description_success').html('<?= $this->ChartData['Month']['Count'][1] ?>');
            } else if(id == 'y'){
                $('.chart_description').html('7 tahun terakhir');
                $('.chart_description_all').html('<?= $this->ChartData['Year']['Count'][0] ?>');
                $('.chart_description_success').html('<?= $this->ChartData['Year']['Count'][1] ?>');
            }

            var item = $(this).closest('.card-body');
            item.find('.chart-wrapper').addClass('d-none');
            item.find('#chart_overview_' + id).closest('.chart-wrapper').removeClass('d-none');
        });

        new Chart($('#chart_overview_d'),{
            type:'line',
            data:{
                labels: [ '<?= implode("', '", $this->ChartData['Day']['Label']) ?>' ],
                datasets:[
                {
                    label:'Mengikuti Penilaian',
                    lineTension: 0,
                    backgroundColor:'transparent',
                    borderColor:getStyle('--danger'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:5,
                    borderDash: [10,5],
                    data: [ <?= implode(', ', $this->ChartData['Day']['Value'][0]) ?> ]
                },{
                    label:'Menyelesaikan Penilaian',
                    lineTension: 0,
                    backgroundColor:'transparent',
                    borderColor:getStyle('--success'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:3,
                    data: [ <?= implode(', ', $this->ChartData['Day']['Value'][1]) ?> ]
                }]
            },
            options:{
                plugins: {
                  datalabels: {
                    display: false
                  }
                },                                
                tooltips: {
                    mode: 'index',
                    intersect: false,
                },
                maintainAspectRatio:false,
                legend:{display:false},
                scales:{
                    xAxes:[{
                        gridLines:{drawOnChartArea:false}
                    }],
                    yAxes:[{
                        ticks:{
                            beginAtZero:true,
                            maxTicksLimit:5,
                            max: <?= $this->ChartData['Day']['Max'] + 2 ?>
                        }
                    }]
                },
                elements:{
                    point:{
                        radius:4,
                        hitRadius:10,
                        hoverRadius:4,
                        hoverBorderWidth:3
                    }
                }
            }
        });        

        new Chart($('#chart_overview_w'),{
            type:'line',
            data:{
                labels: [ '<?= implode("', '", $this->ChartData['Week']['Label']) ?>' ],
                datasets:[
                {
                    label:'Mengikuti Penilaian',
                    lineTension: 0,
                    backgroundColor:'transparent',
                    borderColor:getStyle('--danger'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:5,
                    borderDash: [10,5],
                    data: [ <?= implode(', ', $this->ChartData['Week']['Value'][0]) ?> ]
                },{
                    label:'Menyelesaikan Penilaian',
                    lineTension: 0,
                    backgroundColor:'transparent',
                    borderColor:getStyle('--success'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:3,
                    data: [ <?= implode(', ', $this->ChartData['Week']['Value'][1]) ?> ]
                }]
            },
            options:{
                plugins: {
                  datalabels: {
                    display: false
                  }
                },                                
                tooltips: {
                    mode: 'index',
                    intersect: false,
                },
                maintainAspectRatio:false,
                legend:{display:false},
                scales:{
                    xAxes:[{
                        gridLines:{drawOnChartArea:false}
                    }],
                    yAxes:[{
                        ticks:{
                            beginAtZero:true,
                            maxTicksLimit:5,
                            max: <?= $this->ChartData['Week']['Max'] + 2 ?>
                        }
                    }]
                },
                elements:{
                    point:{
                        radius:4,
                        hitRadius:10,
                        hoverRadius:4,
                        hoverBorderWidth:3
                    }
                }
            }
        });        

        new Chart($('#chart_overview_m'),{
            type:'line',
            data:{
                labels: [ '<?= implode("', '", $this->ChartData['Month']['Label']) ?>' ],
                datasets:[
                {
                    label:'Mengikuti Penilaian',
                    lineTension: 0,
                    backgroundColor:'transparent',
                    borderColor:getStyle('--danger'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:5,
                    borderDash: [10,5],
                    data: [ <?= implode(', ', $this->ChartData['Month']['Value'][0]) ?> ]
                },{
                    label:'Menyelesaikan Penilaian',
                    lineTension: 0,
                    backgroundColor:'transparent',
                    borderColor:getStyle('--success'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:3,
                    data: [ <?= implode(', ', $this->ChartData['Month']['Value'][1]) ?> ]
                }]
            },
            options:{
                plugins: {
                  datalabels: {
                    display: false
                  }
                },                                
                tooltips: {
                    mode: 'index',
                    intersect: false,
                },
                maintainAspectRatio:false,
                legend:{display:false},
                scales:{
                    xAxes:[{
                        gridLines:{drawOnChartArea:false}
                    }],
                    yAxes:[{
                        ticks:{
                            beginAtZero:true,
                            maxTicksLimit:5,
                            max: <?= $this->ChartData['Month']['Max'] + 2 ?>
                        }
                    }]
                },
                elements:{
                    point:{
                        radius:4,
                        hitRadius:10,
                        hoverRadius:4,
                        hoverBorderWidth:3
                    }
                }
            }
        });        

        new Chart($('#chart_overview_y'),{
            type:'line',
            data:{
                labels: [ '<?= implode("', '", $this->ChartData['Year']['Label']) ?>' ],
                datasets:[
                {
                    label:'Mengikuti Penilaian',
                    lineTension: 0,
                    backgroundColor:'transparent',
                    borderColor:getStyle('--danger'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:5,
                    borderDash: [10,5],
                    data: [ <?= implode(', ', $this->ChartData['Year']['Value'][0]) ?> ]
                },{
                    label:'Menyelesaikan Penilaian',
                    lineTension: 0,
                    backgroundColor:'transparent',
                    borderColor:getStyle('--success'),
                    pointHoverBackgroundColor:'#fff',
                    borderWidth:3,
                    data: [ <?= implode(', ', $this->ChartData['Year']['Value'][1]) ?> ]
                }]
            },
            options:{
                plugins: {
                  datalabels: {
                    display: false
                  }
                },                                
                tooltips: {
                    mode: 'index',
                    intersect: false,
                },
                maintainAspectRatio:false,
                legend:{display:false},
                scales:{
                    xAxes:[{
                        gridLines:{drawOnChartArea:false}
                    }],
                    yAxes:[{
                        ticks:{
                            beginAtZero:true,
                            maxTicksLimit:5,
                            max: <?= $this->ChartData['Year']['Max'] + 2 ?>
                        }
                    }]
                },
                elements:{
                    point:{
                        radius:4,
                        hitRadius:10,
                        hoverRadius:4,
                        hoverBorderWidth:3
                    }
                }
            }
        });        

    });

</script>
