<?php $this->extend('Layouts/layout-main.html.php'); ?>

<div class="container">

    <h2 class="my-4">
        Project SIPMAS
    </h2>

    <div class="table-report table-responsive"></div>

</div>

<!-- modal for register -->
<div id="modal-project-form" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-danger modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-briefcase mr-2"></i>
                    Project Baru
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
				<form id="form-new-project" method="POST" enctype="multipart/form-data">
					<div class="form-group">
						<label class="col-form-label">Nama Project <span class="text-danger">*</span> </label>
						<input type="text" class="form-control clear" name="Name" placeholder="Nama project" data-rule-required="true" data-msg-required="Nama harus diisi">
					</div>
                    <div class="form-group">
                        <label class="col-form-label">Tanggal Mulai Pengisian <span class="text-danger">*</span> </label>
                        <div class="controls">
                            <div class='input-group dateinputpicker start'>                   
                                <span class="input-group-addon">
                                    <i class="far fa-calendar-alt fa-lg bg-danger p-3"></i>
                                </span>
                                <input type="text" class="form-control bg-white" name="DateStart" readonly data-rule-required="true" data-msg-required="Tanggal mulai pengisian harus diisi" placeholder="Tanggal mulai pengisian">
                            </div>
                        </div>
                    </div>                    
                    <div class="form-group">
                        <label class="col-form-label">Tanggal BerakhirPengisian <span class="text-danger">*</span> </label>
                        <div class="controls">
                            <div class='input-group dateinputpicker end'>                   
                                <span class="input-group-addon">
                                    <i class="far fa-calendar-alt fa-lg bg-danger p-3"></i>
                                </span>
                                <input type="text" class="form-control bg-white" name="DateEnd" readonly data-rule-required="true" data-msg-required="Tanggal berakhir pengisian harus diisi" placeholder="Tanggal berakhirpengisian data">
                            </div>
                        </div>
                    </div>                    
					<div class="form-group">
						<label class="col-form-label">Keterangan (Note)</label>
						<input type="text" class="form-control clear" name="Note" placeholder="Keterangan (Note)">
						<span class="small">Untuk mengelompokan dan memudahkan pada saat melakukan pencarian data</span>
					</div>
				</form>
            </div>
            <div class="modal-footer">
				<button type="button" class="btn btn-danger" onclick="$('#form-new-project').submit()">Buat</button>
            </div>
        </div>
    </div>
</div>  
<!-- modal for register -->

<script type="text/javascript">

    $(document).ready(function(){
        $('.input-group.dateinputpicker.start').datetimepicker({
            ignoreReadonly: true,
            allowInputToggle: true,
            useCurrent: false,
            minDate: moment(),
            format: 'DD-MM-YYYY'
        }).on('dp.change', function (selected) {
            if (selected.date){
                selected.date.add(1, 'day');
                $('.input-group.dateinputpicker.end').data("DateTimePicker").minDate(selected.date);
            }            
        });

        $('.input-group.dateinputpicker.end').datetimepicker({
            ignoreReadonly: true,
            allowInputToggle: true,
            useCurrent: false,
            minDate: moment(),
            format: 'DD-MM-YYYY'
        });

    	loadDataTables();
    	validationForm();
    });

    function validationForm(){
        $('form').validate({
            errorElement:'em',
            errorPlacement:function errorPlacement(error,element){
                error.addClass('invalid-feedback');
                if(element.prop('type')==='checkbox'){
                    error.insertAfter(element.parent('label'));
                }else{
                    error.insertAfter(element);
                }
            },
            highlight:function highlight(element){
                $(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight:function unhighlight(element){
                $(element).addClass('is-valid').removeClass('is-invalid');
            },
            submitHandler: function(form) {
                addData();
            }
        });
    }    

    function loadDataTables(){  
        selectedDataOnTable = [];
        $(".table-report").html('<table id="table-target" class="table table-bordered table-striped table-hover" cellspacing="0" width="100%"></table>');
        $('#table-target').DataTable({
            scrollX: true,
            searching: true,
            autoWidth: false,
            bLengthChange: false,
            "ordering": false,
            info: true,
            responsive: true,
            processing: true,
            serverSide: true,
            ajax: {
                type: 'POST',
                url: '/api/sipmas-project/get-server-side',
                data: {},
                dataSrc: function ( response ) {
                    return response.data;
                },
                beforeSend: function (request) {
                    request.setRequestHeader('apikey', '<?= $this->Apikey ?>');
                }
            },
            drawCallback: function( settings ) {},
            columns: [
            	{
					'id' : 0,
					'data' : 'data0',
					'title' : '' 
				},
                {
                    'id' : 1,
                    'data' : 'data1',
                    'title' : 'Kode' 
                },              
            	{
					'id' : 2,
					'data' : 'data2',
					'title' : 'Nama' 
				},
            	{
					'id' : 3,
					'data' : 'data3',
					'title' : 'Jumlah Data' 
				},
            	{
					'id' : 4,
					'data' : 'data4',
					'title' : 'Tanggal Mulai' 
				},				
                {
                    'id' : 5,
                    'data' : 'data5',
                    'title' : 'Tanggal Berakhir' 
                },              
                {
                    'id' : 6,
                    'data' : 'data6',
                    'title' : 'Note' 
                }                
            ],
            language: {
                search: '<span>Filter:</span> _INPUT_',
                searchPlaceholder: 'Cari code | nama | note...',
                infoEmpty: "Tidak ada data project",
                emptyTable: "Tidak ada data project",
                zeroRecords: "Tidak ada data project",
                lengthMenu: '<span>Show:</span> _MENU_',
                paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
            },
            dom: 'Bfrtip',
            buttons: [
                {
                    text: 'Buat Project',
                    className: "btn btn-outline-danger mb-3 mr-2",
                    action: function ( e, dt, node, config ) {
				    	newProjectForm();
                    }
                }
            ]
        });                     
    }    

    function newProjectForm(){
        $("#form-new-project .form-control").val("");
        $('#modal-project-form').modal('show');        
    }

    function addData(){
        showLoading();

        var form = $("#form-new-project");
        var formdata = new FormData(form[0]);
        $.ajax({
            type: 'POST',
            url: '/api/sipmas-project/create',
            cache: false,
            contentType: false,
            processData: false,
            data: formdata,
            success: function(response){
                hideLoading();
                if(response.Status){                    
                    $('#modal-project-form').modal('hide');        
                    loadDataTables();
                    swal({
                        html: 'Project berhasil ditambahkan<br><br><h4>Kode Project</h4><h2>' + response.Data.Code + '</h2>',
                        type: 'success'
                    });                                 
                } else{
                    swal({
                        title: 'Mohon Maaf',
                        html: response.Message,
                        type: 'error',
                        showCloseButton: true
                    });                                 
                }
            }, error: function(response) {  
                hideLoading();                
                swal({
                    title: 'Mohon Maaf',
                    html: "Terjadi kesalahan pada jaringan",
                    type: 'error',
                    showCloseButton: true
                });
            }
        });        
    }

    function deleteData(id, name){
		swal({
            title: '',
            text: 'Apakah Anda yakin akan menghapus data project "' + name + '"?',
            type: 'question',
            showCancelButton: true,
            cancelButtonText: 'Tidak',
            confirmButtonText: 'Ya'
        }).then((result) => {
            if (result.value) {
                showLoading();
				$.ajax({
					type: 'POST',
					url: '/api/sipmas-project/delete',
					data: { Id: id },
				 	success: function(response){
                        hideLoading();                
				 		if(response.Status){
                            loadDataTables();
				 			swal({
		                        html: 'Hapus data project berhasil',
		                        type: 'success',
								timer: 2000,
		                    });      				 			
				 		} else{
				 			swal({
		                        title: 'Mohon Maaf',
		                        html: response.Message,
		                        type: 'error',
		                        showCloseButton: true
		                    });      				 			
				 		}
					}, error: function(response) {	
                        hideLoading();
			 			swal({
	                        title: 'Mohon Maaf',
	                        html: "Terjadi kesalahan pada jaringan",
	                        type: 'error',
	                        showCloseButton: true
	                    });
					}
				});            	
            }
        });
    }

    function getLinkAssessment(code) {
        swal({
            html: "<textarea style='width: 90%; height: 70px'>" + window.location.origin + '/sipmas/?c=' + code + "</textarea>",
            type: 'info',
        });                                         
    }

</script>
