<?php $this->extend('Layouts/layout-template-dashboard.html.php'); ?>

<div class="animated fadeIn">
	<div class="row">
		<div class="col-md-12">
			<div class="card">
				<div class="card-header">
					<i class="icon-note"></i> Validation - jQuery Validation Plugin
					<a href="https://coreui.io/pro/" class="badge badge-danger">CoreUI Pro Component</a>
					<div class="card-header-actions">
						<a href="https://github.com/jzaefferer/jquery-validation" class="card-header-action" target="_blank">
							<small class="text-muted">docs</small>
						</a>
					</div>
				</div>
				<div class="card-body">
					This jQuery plugin makes simple clientside form validation easy, whilst still offering plenty of customization options. It makes a good choice if you’re building something new from scratch, but also when you’re trying to integrate something into an existing
					application with lots of existing markup. The plugin comes bundled with a useful set of validation methods, including URL and email validation, while providing an API to write your own methods. All bundled methods come with default error messages
					in english and translations into 37 other languages.
					<hr>
					<div class="row">
						<div class="col-md-6">
							<h6>Simple Form</h6>
							<form id="signupForm" novalidate="novalidate">
								<div class="form-group">
									<label class="col-form-label" for="firstname">First name</label>
									<input type="text" class="form-control is-invalid" id="firstname" name="firstname" placeholder="First name" aria-describedby="firstname-error" aria-invalid="true"><em id="firstname-error" class="error invalid-feedback">Please enter your firstname</em>
								</div>
								<div class="form-group">
									<label class="col-form-label" for="lastname">Last name</label>
									<input type="text" class="form-control is-invalid" id="lastname" name="lastname" placeholder="Last name" aria-describedby="lastname-error"><em id="lastname-error" class="error invalid-feedback">Please enter your lastname</em>
								</div>
								<div class="form-group">
									<label class="col-form-label" for="username">Username</label>
									<input type="text" class="form-control is-invalid" id="username" name="username" placeholder="Username" aria-describedby="username-error"><em id="username-error" class="error invalid-feedback">Please enter a username</em>
								</div>
								<div class="form-group">
									<label class="col-form-label" for="email">Email</label>
									<input type="text" class="form-control is-invalid" id="email" name="email" placeholder="Email" aria-describedby="email-error" aria-invalid="true"><em id="email-error" class="error invalid-feedback">Please enter a valid email address</em>
								</div>
								<div class="row">
									<div class="form-group col-md-6">
										<label class="col-form-label" for="password">Password</label>
										<input type="password" class="form-control is-invalid" id="password" name="password" placeholder="Password" aria-describedby="password-error"><em id="password-error" class="error invalid-feedback">Please provide a password</em>
									</div>
									<div class="form-group col-md-6">
										<label class="col-form-label" for="confirm_password">Confirm password</label>
										<input type="password" class="form-control is-invalid" id="confirm_password" name="confirm_password" placeholder="Confirm password" aria-describedby="confirm_password-error"><em id="confirm_password-error" class="error invalid-feedback">Please provide a password</em>
									</div>
								</div>
								<div class="form-group">
									<div class="checkbox">
										<label>
											<input type="checkbox" id="agree" name="agree" value="agree" class="is-invalid" aria-describedby="agree-error"> Please agree to our policy
										</label><em id="agree-error" class="error invalid-feedback" style="display: block;">Please accept our policy</em>
									</div>
								</div>
								<div class="form-group">
									<button type="submit" class="btn btn-primary" name="signup" value="Sign up">Sign up</button>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>

</div>

<script type="text/javascript">

    $(document).ready(function(){

		$.validator.setDefaults({
			submitHandler:function submitHandler(){
				alert('submitted!');
			}
		});
		
		$('#signupForm').validate({
			rules:{
				firstname:'required',
				lastname:'required',
				username:{required:true,minlength:2},
				password:{required:true,minlength:5},
				confirm_password:{required:true,minlength:5,equalTo:'#password'},
				email:{required:true,email:true},
				agree:'required'
			},
			messages:{
				firstname:'Please enter your firstname',
				lastname:'Please enter your lastname',
				username:{
					required:'Please enter a username',
					minlength:'Your username must consist of at least 2 characters'
				},
				password:{
					required:'Please provide a password',
					minlength:'Your password must be at least 5 characters long'
				},
				confirm_password:{
					required:'Please provide a password',
					minlength:'Your password must be at least 5 characters long',
					equalTo:'Please enter the same password as above'
				},
				email:'Please enter a valid email address',
				agree:'Please accept our policy'
			},
			errorElement:'em',
			errorPlacement:function errorPlacement(error,element){
				error.addClass('invalid-feedback');
				if(element.prop('type')==='checkbox'){
					error.insertAfter(element.parent('label'));
				}else{
					error.insertAfter(element);
				}
			},
			highlight:function highlight(element){
				$(element).addClass('is-invalid').removeClass('is-valid');
			},
			unhighlight:function unhighlight(element){$(element).addClass('is-valid').removeClass('is-invalid');
			}
		});

	});

</script>