<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Parser;
use Lcobucci\JWT\ValidationData;
use Pimcore\Log\Simple;
use AuthenticationBundle\Annotation\Login;

/** 
 * @Route("/dashboard") 
 */ 
class DashboardController extends \AppHelper\BaseFrontendController
{

    /**
     * @Route("/")
     * @Login(role = "Participant")
     * @param Request $request
     */
    public function defaultAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');
        $data_assessment = [];

        // SIPMAS
        $params = new \stdClass;
        $params->UserId = $user_id;
        $temp = \AppModel\Sipmas::getLastAssessmentByUser($params);

        $temp = (object) [ 
                "Url" => $temp->Data->IsFinished ? "/sipmas/thankyou" : "/sipmas",
                "Name" => "SIPMAS",
                "Description" => "Penilaian Manajemen ASN",
                "Status" => ($temp->Status ? ($temp->Data->IsFinished ? 2 : 1) : 0)
            ];
        array_push($data_assessment, $temp);

        // SIPBOS
        $params = new \stdClass;
        $params->UserId = $user_id;
        $temp = \AppModel\Sipbos::getLastAssessmentByUser($params);

        $temp = (object) [ 
                "Url" => $temp->Data->IsFinished ? "/sipbos/thankyou" : "/sipbos",
                "Name" => "SIPBOS",
                "Description" => "Penilaian Budaya Organisasi",
                "Status" => ($temp->Status ? ($temp->Data->IsFinished ? 2 : 1) : 0)
            ];
        array_push($data_assessment, $temp);

        $this->view->Assessment = $data_assessment;   
        $this->view->Sidebar = 1;	
    }    

}
