<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Parser;
use Lcobucci\JWT\ValidationData;
use Pimcore\Log\Simple;
use AuthenticationBundle\Annotation\Login;

class DefaultController extends \AppHelper\BaseFrontendController
{

    /**
     * @Route("/")
     * @param Request $request
     */
    public function defaultAction(Request $request)
    {
    	return $this->redirect('/dashboard');
    }

    /**
     * @Route("/error404")
     * @param Request $request
     */
    public function error404Action(Request $request)
    {

    }

    /**
     * @Route("/check-login-status")
     * @param Request $request
     */
    public function checkLoginStatusAction(Request $request)
    {
        $token = $request->getSession()->get('auth_token');
        return $this->json(['Status' => $token ? 1 : 0]);
    }

    /**
     * @Route("/check-profile-status")
     * @param Request $request
     */
    public function checkProfileStatusAction(Request $request)
    {
        $params = (object) $request->request->all();
        $status_complete_profile = \AuthenticationModel\User::checkCompleteProfile($params);

        return $this->json($status_complete_profile->Load(true));
    }

    /**
     * @Route("/login")
     * @param Request $request
     */
    public function loginAction(Request $request)
    {
        if ($request->isMethod("POST")) {

            $params = (object) $request->request->all();
            
            $headers = [
                'apikey' => $this->_api_key
            ];

            $response = $this->_client->request('POST', 'authentication/user', [
                'headers' => $headers,
                'form_params' => [
                    'Email' => $params->Email,
                    'Password' => $params->Password,
                    'Role' => $params->Role,
                    'Type' => 'global'
                ]
            ]);
            
            $contents = $response->getBody()->getContents();
            $contents = json_decode($contents);

            if($contents->Status == 1) {
                $session = $request->getSession();
                $session->set('auth_token', $contents->Token);

                return $this->json(array('Status' => 1, "RedirectUrl" => $contents->Redirect));
            } else {
                return $this->json([
                    'Status' => 0,
                    'Message' => $contents->Message
                ]);
            }
        } else {
            $redirect = $request->query->get('r');
            $this->view->RedirectUrl = $redirect;
            $this->view->Apikey = $this->_api_key;
        }
    }

    /**
     * @Route("/logout")
     * @param Request $request
     */
    public function logoutAction(Request $request)
    {
        $headers = [
            'apikey' => $this->_api_key
        ];

        $response = $this->_client->request('POST', 'authentication/destroy', [
            'headers' => $headers
        ]);

        $contents = $response->getBody()->getContents();
        $contents = json_decode($contents);
        if($contents->Status == 1) {
            $session = $request->getSession();
            $session->set('auth_token', $contents->Token);
        }
        return $this->redirect('/login');
    }    

    /**
     * @Route("/registration")
     * @param Request $request
     */
    public function registrationAction(Request $request)
    {
        $redirect = $request->query->get('r');
        $this->view->RedirectUrl = $redirect;
        $this->view->Apikey = $this->_api_key;
    }

    /**
     * @Route("/registration/success")
     * @param Request $request
     */
    public function registrationSuccessAction(Request $request)
    {

    }

    /**
     * @Route("/activation/{token}/secret")
     * @param Request $request
     */
    public function activationAction(Request $request, $token)
    {
        if (!$token) return $this->redirect('/error404');

        $token = (new Parser())->parse((string) $token);
        $validation_data = new ValidationData();
        $validation_data->setIssuer($request->getSchemeAndHttpHost());
        $validation_data->setAudience($request->getSchemeAndHttpHost());
        $is_validate = $token->validate($validation_data);

        $email = $token->getClaim('Email');

        if ($is_validate) {
            $params_temp = (object) ["Email" => $email];
            $object = \AuthenticationModel\User::getByEmail($params_temp)->Data;

            if (!$object) {
                return $this->redirect('/error404');
            }

            if ($object->StatusAccount) {
                return $this->redirect('/activation/failed/alreadyactive');
            }

            try {
                $object->TempCode = null;
                $object->StatusAccount = 1;
                if($object->save()){
                    return $this->redirect('/activation/success');
                } else {
                    return $this->redirect('/activation/failed/expired?e=' . $email);
                }
            } catch (Exception $e) {
                return $this->redirect('/activation/failed/expired?e=' . $email);
            }
        } else {
            return $this->redirect('/activation/failed/expired?e=' . $email);
        }
    }

    /**
     * @Route("/activation/success")
     * @param Request $request
     */
    public function activationSuccessAction(Request $request)
    {

    }

    /**
     * @Route("/activation/failed/{status}")
     * @param Request $request
     */
    public function activationFailedAction(Request $request, $status)
    {
        $this->view->Status = $status;
        $this->view->Apikey = $this->_api_key;
    }    

    /**
     * @Route("/forgot-password")
     * @param Request $request
     */
    public function forgotPasswordAction(Request $request)
    {
        $redirect = $request->query->get('r');
        $this->view->RedirectUrl = $redirect;
        $this->view->Apikey = $this->_api_key;
    }        

    /**
     * @Route("/forgot-password/success")
     * @param Request $request
     */
    public function forgotPasswordSuccessAction(Request $request)
    {

    }    

    /**
     * @Route("/reset-password/{token}/secret")
     * @param Request $request
     */
    public function resetPasswordAction(Request $request, $token)
    {

        if (!$token) return $this->redirect('/error404');

        $token = (new Parser())->parse((string) $token);
        $validation_data = new ValidationData();
        $validation_data->setIssuer($request->getSchemeAndHttpHost());
        $validation_data->setAudience($request->getSchemeAndHttpHost());
        $is_validate = $token->validate($validation_data);

        if ($is_validate) {
            $params = (object) ["TempCode" => $token->getClaim('TempCode')];
            $object = \AuthenticationModel\User::getByTempCode($params)->Data;

            if (!$object) {
                return $this->redirect('/reset-password/failed');
            }

            if ($request->isMethod("POST")) {

                if (!$request->request->get('Password')) {
                    return $this->json(['Status' => 0, 'Message' => 'Password kosong']);
                }

                try {
                    $object->TempCode = null;
                    $object->Password = $request->request->get('Password');
                    if($object->save()){
                        return $this->json(['Status' => 1]);
                    } else {
                        return $this->json(['Status' => 0, "Message" => "Gagal mengatur ulang passeord"]);                        
                    }
                } catch (Exception $e) {
                    return $this->json(['Status' => 0, 'Message' => 'Terjadi kesalahan, silahkan hubungi Administrator']);
                }

            }
        } else {
            return $this->redirect('/reset-password/failed');
        }

    }        

    /**
     * @Route("/reset-password/success")
     * @param Request $request
     */
    public function resetPasswordSuccessAction(Request $request)
    {

    }        

    /**
     * @Route("/reset-password/failed")
     * @param Request $request
     */
    public function resetPasswordFailedAction(Request $request)
    {

    }     

    /**
     * @Route("/user/profile")
     * @Login(role = "Participant,SuperAdmin")
     * @param Request $request
     */
    public function profileAction(Request $request)
    {
        $provinces = \AppModel\Master::getProvinces();
        $cities = \AppModel\Master::getCities();

        $array_city = [];
        foreach($cities as $city) {
            $province_name = $city->Province->Name;
            $temp['Id'] = $city->o_id;
            $temp['City'] = $city->Name;
            $temp['Province'] = $province_name;
            if($city->Province){
                if(array_key_exists($province_name, $array_city)){
                    array_push($array_city[$province_name], $temp);
                } else {
                    $array_city[$province_name] = [$temp];
                }
            }
        }
        $cities = json_encode($array_city, JSON_PARTIAL_OUTPUT_ON_ERROR);
        $cities = addslashes(preg_replace('/[\t\r\n\v\f]/', '', $cities));
        
        $this->view->Provinces = $provinces;
        $this->view->Cities = $cities;

        $params = new \stdClass;
        $params->Id = $request->request->get('auth_user_id');
        $profile = \AuthenticationModel\User::getById($params)->Data;   

        $this->view->Profile = $profile;

        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }

    /**
     * @Route("/user/change-password")
     * @Login(role = "Participant,SuperAdmin")
     * @param Request $request
     */
    public function changePasswordAction(Request $request)
    {
        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }

}
