<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Parser;
use Lcobucci\JWT\ValidationData;
use Pimcore\Log\Simple;
use AuthenticationBundle\Annotation\Login;

/** 
 * @Route("/sipbos") 
 */ 
class SipbosController extends \AppHelper\BaseFrontendController
{

    /**
     * @Route("/")
     * @param Request $request
     */
    public function defaultAction(Request $request)
    {
        // by default unset session project
        $session = $request->getSession()->remove('sipbos_project');

        $code = $request->query->get('c');
        if($code){
            $params = (object) ["Code" => $code];
            $valid_project = \AppModel\SipbosProject::checkValid($params);
            if($valid_project->Status){  
                // set session project
                $session = $request->getSession()->set('sipbos_project', $valid_project->Data->o_id);                
            }
        }

        $role = '';
        $auth_token = $request->getSession()->get('auth_token');
        if($auth_token){
            $role = \AppHelper\Session::getDataFromToken($auth_token, "Role");
        }

        if($role != 'Participant'){
            $params = (object) ["Request" => $request, "Client" => $this->_client, "ApiKey" => $this->_api_key];
            \AppModel\User::createDemoUser($params);
        }

        $this->view->Apikey = $this->_api_key;
    }

    /**
     * @Route("/instruction")
     * @Login(role = "Participant", redirect_url = "/sipbos", not_allowed_url = "/sipbos")
     * @param Request $request
     */
    public function instructionAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');

        $status_finish = self::checkFinished($user_id);
        if($status_finish) return $this->redirect('/sipbos/thankyou');
    }    

    /**
     * @Route("/section/rvs")
     * @Login(role = "Participant", redirect_url = "/sipbos", not_allowed_url = "/sipbos")
     * @param Request $request
     */
    public function rvsAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');

        $status_finish = self::checkFinished($user_id);
        if($status_finish) return $this->redirect('/sipbos/thankyou');        

        if ($request->isMethod("POST")) {
            $post = $request->request->all();

            $params = json_decode($post['data']);
            $params->User = $user_id;
            $params->ProjectData = $request->getSession()->get('sipbos_project'. '');
            $result = \AppModel\Sipbos::processRvs($params);

            if($result->Status){            
                return $this->json(["Status" => 1]);
            } else {            
                return $this->json(["Status" => 0]);
            }
        } else {

            $terminal = array(
                    "id" => "Terminal",
                    "nama" => "Nilai Terminal",
                    "data" => array(
                            ["TMV-1", "Hidup nyaman (hidup makmur)"],
                            ["TMV-2", "Hidup yang aktif dan dinamis"],
                            ["TMV-3", "Rasa berprestasi dan berkontribusi"],
                            ["TMV-4", "Hidup damai bebas dari konflik"],
                            ["TMV-5", "Menikmati keindahan alam dan kesenian"],
                            ["TMV-6", "Kesamaan dan persaudaraan antar sesama manusia/pekerja"],
                            ["TMV-7", "Keamanan keluarga"],
                            ["TMV-8", "Kemerdekaan dan kebebasan memilih"],
                            ["TMV-9", "Kebahagiaan (kepuasan)"],
                            ["TMV-10", "Ketentraman batin (bebas dari konflik batin)"],
                            ["TMV-11", "Cinta yang tulus"],
                            ["TMV-12", "Hidup santai dan bersenang-senang"],
                            ["TMV-13", "Keselamatan"],
                            ["TMV-14", "Menghormati/menghargai diri sendiri"],
                            ["TMV-15", "Pengakuan sosial/mendapat respek dari orang lain"],
                            ["TMV-16", "Persahabatan sejati (memperoleh kawan karib)"],
                            ["TMV-17", "Menjadi bijaksana (memahami kehidupan secara matang)"],
                            ["TMV-18", "Keamanan nasional"]                    
                        )
                    );

            $instrument = array(
                    "id" => "Instrument",
                    "nama" => "Nilai Instrumental",
                    "data" => array(
                            ["ITV-1", "Kerja keras, bercita-cita tinggi"],
                            ["ITV-2", "Berpikiran luas dan terbuka"],
                            ["ITV-3", "Kapabel (mampu, efektif)"],
                            ["ITV-4", "Riang (senang, gembira)"],
                            ["ITV-5", "Bersih (rapi, teratur)"],
                            ["ITV-6", "Berani (teguh mempertahankan keyakinan)"],
                            ["ITV-7", "Memaafkan (memaafkan orang lain)"],
                            ["ITV-8", "Membantu orang lain"],
                            ["ITV-9", "Jujur, tidak bohong"],
                            ["ITV-10", "Imaginatif, kreatif"],
                            ["ITV-11", "Berdikari, mencukupi diri"],
                            ["ITV-12", "Intelektual (cerdas, reflektif/penuh renungan)"],
                            ["ITV-13", "Logis dan rasional"],
                            ["ITV-14", "Mencintai (penuh kasih sayang, lembut)"],
                            ["ITV-15", "Patuh (menurut, penuh hormat)"],
                            ["ITV-16", "Sopan santun dan berbudi bahasa"],
                            ["ITV-17", "Bertanggung jawab dan dapat diandalkan"],
                            ["ITV-18", "Kendali diri (disiplin diri, tenang)"]
                        )
                    );            

            $params_answer = new \stdClass;
            $params_answer->UserId = $user_id;
            $answer = \AppModel\Sipbos::getLastAssessmentByUser($params_answer);

            if($answer->Status){
                $answer = $answer->Data;
                if($answer->RvsTerminal){
                    $terminal['data'] = $answer->RvsTerminal;
                } 
                if($answer->RvsInstrument){
                    $instrument['data'] = $answer->RvsInstrument;
                }                
            }

            $this->view->rvs = array($terminal, $instrument);
        }

        $this->view->UserId = $user_id;
        $this->view->Apikey = $this->_api_key;
    }    

    /**
     * @Route("/section/ocai")
     * @Login(role = "Participant", redirect_url = "/sipbos", not_allowed_url = "/sipbos")
     * @param Request $request
     */
    public function ocaiAction(Request $request)
    {    	
        $user_id = $request->request->get('auth_user_id');

        $status_finish = self::checkFinished($user_id);
        if($status_finish) return $this->redirect('/sipbos/thankyou');

        if ($request->isMethod("POST")) {
            $post = $request->request->all();

            $params = json_decode($post['data']);
            $params->User = $user_id;
            $params->ProjectData = $request->getSession()->get('sipbos_project'. '');
            $result = \AppModel\Sipbos::processOcai($params);

            if($result->Status){            
                return $this->json(["Status" => 1]);
            } else {            
                return $this->json(["Status" => 0]);
            }
        } else {

            $parameters = array(
                    array(
                        "id" => "kd", 
                        "nama" => "Karakteristik Domain", 
                        "pernyataan" => array(
                            "A" => "Organisasi merupakan tempat yang bersifat sangat personal, seperti dalam keluarga besar. Setiap orang banyak berbagi cerita tentang diri mereka.",
                            "B" => "Organisasi merupakan tempat yang dinamis dan bersifat entrepreneur. Setiap orang mau mempertaruhkan dirinya dan mengambil resiko.",
                            "C" => "Organisasi sangat berorientasi hasil. Perhatian utamanya ada pada penyelesaian tugas. Setiap orang sangat kompetitif dan berorientasi pada pencapaian prestasi.",
                            "D" => "Organisasi merupakan tempat yang terkendali dan terpola (structured). Pada umumnya, prosedur formal mengatur perilaku orang bekerja",
                        )
                    ),
                    array(
                        "id" => "ko", 
                        "nama" => "Kepemimpinan Organisasi", 
                        "pernyataan" => array(
                            "A" => "Kepemimpinan dalam Organisasi secara umum dapat dikatakan bersifat membimbing, memfasilitasi atau mengedukasi (nurturing).",
                            "B" => "Kepemimpinan dalam Organisasi secara umum dapat dikatakan untuk mendorong entrepreneurship, inovasi dan pengambilan resiko.",
                            "C" => "Kepemimpinan dalam Organisasi secara umum dapat dikatakan bersifat rasional (no-nonsense), kerja keras dan berfokus kepada hasil.",
                            "D" => "Kepemimpinan dalam Organisasi secara umum dapat dikatakan bersifat mendorong koordinasi, pengorganisasian dan penekanan pada efisiensi.",
                         )
                    ),
                    array(
                        "id" => "msdm", 
                        "nama" => "MANAJEMEN SDM", 
                        "pernyataan" => array(
                            "A" => "Gaya manajemen dalam Organisasi dicirikan dengan kerja tim, konsensus dan partisipasi.",
                            "B" => "Gaya manajemen dalam Organisasi dicirikan dengan pengambilan resiko individu, inovasi, kebebasan dan keunikan.",
                            "C" => "Gaya manajemen dalam Organisasi dicirikan dengan sangat kompetitif, tuntutan tinggi dan pencapaian prestasi.",
                            "D" => "Gaya manajemen dalam Organisasi dicirikan dengan keamanan kerja (security of employment), konformitas (kepatuhan karena tekanan/ tatanan sosial), dapat diduga (predictability) dan stabilitas dalam hubungan.",
                         )
                    ),
                    array(
                        "id" => "po", 
                        "nama" => "PEREKAT ORGANISASI", 
                        "pernyataan" => array(
                            "A" => "Perekat yang menyatukan Organisasi secara keseluruhan adalah kesetiaan dan saling percaya. Komitmen dalam Organisasi sangat tinggi.",
                            "B" => "Perekat yang menyatukan Organisasi secara keseluruhan adalah inovasi dan pengembangan. Ada penekanan pada mencapai titik puncak.",
                            "C" => "Perekat yang menyatukan Organisasi secara keseluruhan adalah penekanan pada pencapaian prestasi (achievement) dan pencapaian tujuan. Kerja keras dan keberhasilan menjadi tema yang utama.",
                            "D" => "Perekat yang menyatukan Organisasi secara keseluruhan adalah aturan dan kebijakan formal. Memelihara jalannya operasi Organisasi dengan lancar adalah penting.",
                         )
                    ),
                    array(
                        "id" => "ps", 
                        "nama" => "PENEKANAN STRATEGIS", 
                        "pernyataan" => array(
                            "A" => "Organisasi menekankan pada pengembangan SDM. Terdapat kepercayaan yang tinggi, keterbukaan dan partisipasi.",
                            "B" => "Organisasi menekankan pada perolehan sumber daya baru dan penciptaan tantangan baru. Mencoba hal baru dan menjajagi peluang sangat dihargai.",
                            "C" => "Organisasi menekankan pada tindakan kompetitif dan pencapaian prestasi. Pencapaian sasaran yang tinggi dan penguasaan pasar adalah suatu yang dominan.",
                            "D" => "Organisasi menekankan pada status-quo (permanence) dan stabilitas. Efisiensi, kendali dan kelancaran operasional Organisasi adalah penting.",
                         )
                    ),
                    array(
                        "id" => "ks", 
                        "nama" => "KRITERIA SUKSES", 
                        "pernyataan" => array(
                            "A" => "Organisasi mendefinisikan keberhasilan berdasarkan pengembangan SDM, kerja tim, komitmen pegawai dan kepedulian pada orang.",
                            "B" => "Organisasi mendefinisikan keberhasilan berdasarkan penciptaan produk terbaru dan unik. Hal ini menunjukkan kepemimpinan produk dan inovasi.",
                            "C" => "Organisasi mendefinisikan keberhasilan berdasarkan penguasaan pasar dan unggul dalam persaingan. Kepemimpinan dalam persaingan pasar merupakan kunci.",
                            "D" => "Organisasi mendefinisikan keberhasilan berdasarkan efisiensi. Penyelesaian pekerjaan yang handal, kelancaran penjadwalan dan biaya operasi yang rendah merupakan hal yang kritikal.",
                         )
                    )

                );
            $params_answer = new \stdClass;
            $params_answer->UserId = $user_id;
            $answer = \AppModel\Sipbos::getLastAssessmentByUser($params_answer);

            if($answer->Status){
                $answer = $answer->Data;
                if($answer->OcaiRaw){
                    foreach ($answer->OcaiRaw as $key => $value){
                        $parameters[$key]['answer'] = $value;
                    }
                }                
            }

            $this->view->Parameters = $parameters;
        }

        $this->view->UserId = $user_id;
        $this->view->Apikey = $this->_api_key;        
    }    

    /**
     * @Route("/section/msai")
     * @Login(role = "Participant", redirect_url = "/sipbos", not_allowed_url = "/sipbos")
     * @param Request $request
     */
    public function msaiAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');

        $status_finish = self::checkFinished($user_id);
        if($status_finish) return $this->redirect('/sipbos/thankyou');        

        if ($request->isMethod("POST")) {
            $post = $request->request->all();

            $params = json_decode($post['data']);
            $params->User = $user_id;
            $params->ProjectData = $request->getSession()->get('sipbos_project'. '');
            $result = \AppModel\Sipbos::processMsai($params);

            if($result->Status){            
                return $this->json(["Status" => 1]);
            } else {            
                return $this->json(["Status" => 0]);
            }
        } else {	
            $this->view->Msai = array(
                    array(
                        "id" => "section-1", 
                        "nama" => "Bagian 1", 
                        "type" => "radio", 
                        "pernyataan" => array(
                            ["1", "Saya mendengar, mempedulikan dan memperhatikan dengan serius orang-orang di dalam unit organisasi saya pada saat mereka menceritakan problemnya."],
                            ["2", "Saya mendorong orang-orang di dalam unit organisasi saya untuk menghasilkan ide-ide baru dan metode-metode baru."],
                            ["3", "Saya memotivasi dan memberi semangat orang lain untuk melakukan tugas dengan lebih baik."],
                            ["4", "Saya memantau dengan seksama bagaimana kinerja yang dihasilkan unit organisasi saya"],
                            ["5", "Saya secara teratur membimbing para bawahan untuk memperbaiki kemampuan manajemen mereka agar mereka dapat mencapai kinerja yang lebih tinggi."],
                            ["6", "Saya menuntut kerja keras dan produktivitas yang tinggi dari bawahan saya."],
                            ["7", "Saya menetapkan tujuan/sasaran yang ambisius yang memberikan tantangan kepada bawahan untuk mencapai tingkat kinerja di atas standar."],
                            ["8", "Saya menyediakan, atau membantu orang lain untuk memperoleh, sumber-sumber yang diperlukan mereka dalam mengimplementasikan ide-ide inovatif mereka."],
                            ["9", "Ketika seseorang memunculkan ide-ide baru, saya mensponsori mereka untuk mewujudkannya."],
                            ["10", "Saya memastikan bahwa semua pegawai memahami dengan jelas kebijakan, nilai-nilai dan tujuan Organisasi."],
                            ["11", "Saya memastikan bahwa orang lain memiliki gambaran yang jelas tentang bagaimana pekerjaan mereka sesuai (klop) dengan pekerjaan orang lainnya di dalam Organisasi."],
                            ["12", "Saya membangun tim yang kohesif, terdiri dari orang-orang yang memiliki komitmen."],
                            ["13", "Saya memberikan umpan balik secara berkala kepada bawahan tentang bagaimana mereka melaksanakan pekerjaannya."],
                            ["14", "Saya menyampaikan gambaran yang jelas tentang apa yang dapat dicapai di masa depan."],
                            ["15", "Saya mendorong suasana kompetitif yang dapat membantu unit organisasi saya agar dapat menghasilkan kinerja yang melebihi kinerja unit organisasi lain."],
                            ["16", "Saya memastikan bahwa laporan dan penilaian secara berkala dibuat di unit organisasi saya."],
                            ["17", "Saya memperjelas dan menyederhanakan informasi yang kompleks sehingga dapat dipahami oleh orang lain dan disebarkan ke seluruh Organisasi."],
                            ["18", "Saya memfasilitasi distribusi informasi dan pemecahan masalah secara efektif di unit organisasi saya."],
                            ["19", "Saya mendorong analisa keputusan yang sistematik dan rasional di unit organisasi saya (misalnya secara logis menganalisa bagian-bagian dari permasalahan) untuk mengurangi kompleksitas masalah-masalah penting."],
                            ["20", "Saya memastikan bahwa orang-orang yang berada dalam unit organisasi saya diberikan kesempatan untuk mengembangkan diri."],
                            ["21", "Saya menciptakan suatu lingkungan yang mendorong dan menghargai keterlibatan dan partisipasi dalam pengambilan keputusan."],
                            ["22", "Di dalam unit organisasi yang saya pimpin, saya memastikan bahwa perhatian yang memadai diberikan untuk penyelesaian tugas dan hubungan interpersonal."],
                            ["23", "Ketika memberikan umpan balik negatif, saya mengedepankan perbaikan diri tanpa menimbulkan sikap defensif dan kemarahan pada orang itu."],
                            ["24", "Saya memberi tugas dan tanggung jawab yang memberikan peluang pengembangan diri bagi orang tersebut."],
                            ["25", "Saya secara aktif membantu menyiapkan orang lain untuk dipromosikan (move up) dalam Organisasi."],
                            ["26", "Saya secara konsisten mengemukakan ide-ide baru dan kreatif yang berkaitan dengan proses-proses, produk dan prosedur bagi Organisasi saya."],
                            ["27", "Saya secara konstan menyatakan dan menegaskan kembali visi saya tentang masa depan kepada anggota-anggota unit organisasi saya."],
                            ["28", "Saya membantu orang lain mendeskripsikan suatu pencapaian di masa depan termasuk kemungkinan dan peluang meraihnya."],
                            ["29", "Saya selalu bekerja untuk memperbaiki proses yang digunakan untuk mencapai output yang diinginkan."],
                            ["30", "Saya menuntut unit organisasi saya untuk mencapai kinerja berdaya saing internasional (world-class) dalam produk dan/atau pelayanan/jasa."],
                            ["31", "Dengan memberdayakan orang-orang dalam unit, saya menciptakan iklim yang memotivasi dan menyemangati setiap orang yang terlibat."],
                            ["32", "Saya selalu membina hubungan personal dengan konsumen internal dan eksternal unit organisasi secara konsisten."],
                            ["33", "Saya memastikan agar unit organisasi memiliki ukuran sejauh mana telah memenuhi harapan konsumen."],
                            ["34", "Saya memberikan pengalaman kepada bawahan yang membantu mereka bersosialisasi dan melebur ke dalam budaya Organisasi."],
                            ["35", "Saya meningkatkan persaingan di unit organisasi saya dengan mendorong mereka menyediakan jasa/produk yang dapat memberikan kejutan dan kepuasan pada pelanggan karena melampaui harapan mereka."],
                            ["36", "Saya telah membangun suatu sistem pengawasan yang memastikan konsistensi kualitas, pelayanan, biaya dan produktivitas di unit organisasi saya."],
                            ["37", "Saya berkoordinasi dengan para pimpinan di unit organisasi lainnya dalam Organisasi secara berkala."],
                            ["38", "Untuk memfasilitasi koordinasi, secara rutin saya berbagi informasi lintas fungsi/Organisasi."],
                            ["39", "Saya menggunakan sistem pengukuran yang secara konsisten dapat memonitor baik proses kerja maupun hasil kerja."],
                            ["40", "Saya menjelaskan kepada anggota-anggota di unit organisasi saya tentang apa yang sesungguhnya diharapkan dari mereka."],
                            ["41", "Saya menjamin bahwa segala sesuatu yang dilakukan tertuju pada pelayanan yang lebih baik kepada konsumen."],
                            ["42", "Saya memfasilitasi iklim yang sangat dinamis, penuh antusias dan penuh semangat dalam unit organisasi saya."],
                            ["43", "Saya secara terus menerus memonitor kekuatan dan kelemahan dari pesaing terbesar Organisasi dan menginformasikannya agar unit organisasi saya dapat menanggapinya."],
                            ["44", "Saya memfasilitasi iklim perbaikan secara berkelanjutan (countinuous improvement) dalam unit organisasi saya."],
                            ["45", "Saya telah mengembangkan strategi yang jelas agar unit organisasi saya berhasil mencapai visi masa depan saya."],
                            ["46", "Saya dapat menangkap komitmen dalam nuansa emosi dan imajinasi orang lain ketika saya membicarakan visi masa depan saya."],
                            ["47", "Saya menciptakan suatu lingkungan kerja yang membuat sesama rekan kerja dan bawahan saling belajar dan mengembangkan diri."],
                            ["48", "Saya mendengarkan dengan penuh perhatian dan keterbukaan pada orang yang sedang mengemukakan gagasannya, bahkan ketika saya tidak sependapat dengan gagasan tersebut."],
                            ["49", "Ketika memimpin sebuah tim kerja, saya memastikan berjalannya kerja sama dan penyelesaian konflik-konflik secara positif di antara anggota tim."],
                            ["50", "Saya menumbuhkan kepercayaan dan keterbukaan di unit organisasi saya dengan cara menunjukkan pengertian pada sudut pandang orang yang mengemukakan masalah dan keprihatinannya."],
                            ["51", "Saya menciptakan suatu lingkungan yang mengakui dan menghargai eksperimen dan kreativitas."],
                            ["52", "Saya mendorong setiap orang di unit organisasi saya untuk memperbaiki dan mengembangkan segala sesuatu yang mereka kerjakan secara terus menerus."],
                            ["53", "Saya mendorong seluruh bawahan untuk melakukan perbaikan-perbaikan kecil secara terus menerus pada cara kerja mereka."],
                            ["54", "Saya memastikan bahwa unit organisasi saya mengumpulkan informasi tentang kebutuhan dan keinginan konsumen secara terus menerus."],
                            ["55", "Saya melibatkan konsumen dalam perencanaan dan evaluasi unit organisasi saya."],
                            ["56", "Saya membuat acara khusus dan pemberian penghargaan di unit organisasi saya yang memperkuat nilai-nilai dan budaya Organisasi."],
                            ["57", "Saya memelihara suatu sistem formal untuk mengumpulkan dan menanggapi informasi yang berasal dari luar unit organisasi saya."],
                            ["58", "Saya memprakarsai tim lintas fungsi/Organisasi (gugus tugas) yang memfokuskan pada isu-isu penting Organisasi."],
                            ["59", "Saya membantu bawahan saya yang berusaha memperbaiki semua aspek kehidupan mereka, bukan hanya terbatas pada yang berhubungan dengan pekerjaan saja."],
                            ["60", "Saya menciptakan iklim dimana individu-individu di unit organisasi saya ingin mencapai tingkat kinerja yang lebih tinggi dari kompetitor."]
                        ),
                        "option" => array(
                            ["5", "SS", "Sangat Setuju"],
                            ["4", "S", "Setuju"],
                            ["3", "R", "Rata-rata"],
                            ["2", "TS", "TIdak Setuju"],
                            ["1", "STS", "Sangat Tidak Setuju"]
                        )
                    ),
                    array(
                        "id" => "section-2", 
                        "nama" => "Bagian 2", 
                        "type" => "radio", 
                        "pernyataan" => array(
                            ["61", "Mengelola tim (membangun tim yang efektif, kohesif, berjalan/berfungsi dengan lancar)."],
                            ["62", "Mengelola hubungan interpersonal (mendengarkan dan memberikan umpan balik yang mendukung bagi orang lain)."],
                            ["63", "Mengelola pengembangan orang lain (membantu orang lain memperbaiki kinerja mereka dan memperoleh peluang pengembangan pribadi)."],
                            ["64", "Mendorong inovasi (mendorong orang lain untuk melakukan inovasi & menghasilkan ide-ide baru)."],
                            ["65", "Mengelola pencapaian masa depan (mengkomunikasikan visi masa depan yang jelas dan memfasilitasi upaya pencapaiannya)."],
                            ["66", "Mengelola perbaikan terus menerus/ continuous improvement (mendorong orientasi perbaikan terus menerus di antara para bawahan dalam segala sesuatu yang mereka lakukan)."],
                            ["67", "Mengelola kondisi kerja yang kompetitif (membantu mengembangkan suatu orientasi yang dinamis, antusias dan penuh semangat untuk melampaui kinerja kompetitor."],
                            ["68", "Menyemangati bawahan (memotivasi orang lain untuk memberikan upaya ekstra dan bekerja dinamis, antusias dan penuh semangat)."],
                            ["69", "Mengelola pelayanan konsumen (mendorong fokus pada pelayanan dan membina hubungan dengan konsumen)."],
                            ["70", "Mengelola akulturasi (membantu orang lain untuk mengetahui dengan jelas apa yang diharapkan dari mereka, juga tentang budaya dan standar-standar Organisasi)."],
                            ["71", "Mengelola sistem kontrol (memiliki sistem penilaian dan monitoring untuk menjaga alur proses dan kinerja)."],
                            ["72", "Mengelola koordinasi (berbagi informasi lintas fungsi/Organisasi dan mendorong koordinasi dengan unit-unit di unit organisasi lain)."],
                            ["73", "Kompetensi manajemen secara keseluruhan (kemampuan umum dalam manajerial)"]
                        ),
                        "option" => array(
                            ["5", "SB", "Sangat Baik"],
                            ["4", "B", "Baik"],
                            ["3", "C", "Cukup"],
                            ["2", "K", "Kurang"],
                            ["1", "SK", "Sangat Kurang"]
                        )
                    ),
                    array(
                        "id" => "section-3", 
                        "nama" => "Bagian 3", 
                        "type" => "choice", 
                        "pernyataan" => array(
                            [
                                "74", "Berdasarkan kompetensi manajemen anda, sampai setingkat apa jenjang karir yang anda ingin capai dalam Organisasi?", 
                                array(
                                    ["5", "Posisi jabatan puncak dalam Organisasi (Eselon I/Eselon II/Eselon III/Eselon IV)"],
                                    ["4", "Posisi jabatan mendekati puncak, di bawah Eselon I/Eselon II/Eselon III/Eselon IV"],
                                    ["3", "Posisi jabatan senior, seperti: jabatan fungsional tertinggi."],
                                    ["2", "Posisi satu tingkat di atas posisi jabatan anda sekarang"],
                                    ["1", "Tetap pada posisi jabatan sekarang."]
                                )
                            ],
                            [
                                "75", "Dibandingkan dengan pemimpin-pemimpin lain yang anda kenal dalam Organisasi, menurut anda Bagaimana anda menilai kompetensi anda sendiri sebagai pemimpin diantara pemimpin-pemimpin yang lain?", 
                                array(
                                    ["5", "Sangat Baik (Top 5%)"],
                                    ["4", "Baik (Top 10%)"],
                                    ["3", "Diatas rata-rata (Top 25%)"],
                                    ["2", "Rata-rata (Top 50%)"],
                                    ["1", "Di bawah rata-rata (in the bottom half)"]
                                )
                            ]
                        )
                    ),
                    array(
                        "id" => "section-4", 
                        "nama" => "Bagian 4", 
                        "type" => "radio", 
                        "pernyataan" => array(
                            ["76", "Mengelola tim (membangun tim yang efektif, kohesif, berjalan/berfungsi dengan lancar)."],
                            ["77", "Mengelola hubungan interpersonal (mendengarkan dan memberikan umpan balik yang mendukung bagi orang lain)."],
                            ["78", "Mengelola pengembangan orang lain (membantu orang lain memperbaiki kinerja mereka dan memperoleh peluang pengembangan pribadi)."],
                            ["79", "Mendorong inovasi (mendorong orang lain untuk melakukan inovasi dan menghasilkan ide-ide baru)."],
                            ["80", "Mengelola pencapaian masa depan (mengkomunikasikan visi masa depan yang jelas dan memfasilitasi upaya pencapaiannya)."],
                            ["81", "Mengelola perbaikan terus menerus/ continuous improvement (mendorong orientasi perbaikan terus menerus di antara para bawahan dalam segala sesuatu yang mereka lakukan)."],
                            ["82", "Mengelola kondisi kerja yang kompetitif (membantu mengembangkan suatu orientasi yang sangat dinamis, penuh antusias dan penuh semangat untuk melampaui kinerja kompetitor)."],
                            ["83", "Menyemangati bawahan (memotivasi orang lain untuk memberikan upaya ekstra dan bekerja dinamis, antusias dan penuh semangat)."],
                            ["84", "Mengelola pelayanan konsumen (mendorong fokus pada pelayanan dan membina hubungan dengan konsumen)."],
                            ["85", "Mengelola akulturasi (membantu orang lain untuk mengetahui dengan jelas apa yang diharapkan dari mereka, juga tentang budaya dan standar-standar Organisasi)."],
                            ["86", "Mengelola sistem kontrol (memiliki sistem penilaian dan monitoring untuk menjaga alur proses dan kinerja)."],
                            ["87", "Mengelola koordinasi (berbagi informasi lintas fungsi/Organisasi dan mendorong koordinasi dengan unit-unit di unit organisasi lain)."]
                        ),
                        "option" => array(
                            ["5", "K", "Kritikal (Critically Important)"],
                            ["4", "SP", "Sangat penting (Very Important)"],
                            ["3", "P", "Penting (Moderately Important)"],
                            ["2", "CP", "Cukup penting (of Some Importance)"],
                            ["1", "KP", "Kurang penting (Little Importance)"]
                        )
                    )
                );

            $params_answer = new \stdClass;
            $params_answer->UserId = $user_id;
            $answer = \AppModel\Sipbos::getLastAssessmentByUser($params_answer);

            if($answer->Status){
                $answers = array_fill(0, 87, array_fill(0, 5, ''));
                if($answer->Data->MsaiRaw){                
                    $answers = $answer->Data->MsaiRaw;
                }
            }            

            $this->view->Answers = $answers;
        }

        $this->view->UserId = $user_id;
        $this->view->Apikey = $this->_api_key;
    }    

    /**
     * @Route("/profile")
     * @Login(role = "Participant", redirect_url = "/sipbos", not_allowed_url = "/sipbos")
     * @param Request $request
     */
    public function profileAction(Request $request)
    {
        $provinces = \AppModel\Master::getProvinces();
        $cities = \AppModel\Master::getCities();

        $array_city = [];
        foreach($cities as $city) {
            $province_name = $city->Province->Name;
            $temp['Id'] = $city->o_id;
            $temp['City'] = $city->Name;
            $temp['Province'] = $province_name;
            if($city->Province){
                if(array_key_exists($province_name, $array_city)){
                    array_push($array_city[$province_name], $temp);
                } else {
                    $array_city[$province_name] = [$temp];
                }
            }
        }
        $cities = json_encode($array_city, JSON_PARTIAL_OUTPUT_ON_ERROR);
        $cities = addslashes(preg_replace('/[\t\r\n\v\f]/', '', $cities));
        
        $this->view->Provinces = $provinces;
        $this->view->Cities = $cities;

    }

    /**
     * @Route("/thankyou")
     * @Login(role = "Participant", redirect_url = "/sipbos", not_allowed_url = "/sipbos")
     * @param Request $request
     */
    public function thankyouAction(Request $request)
    {
        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
    }    

    /**
     * @Route("/summary")
     * @Login(role = "Participant", redirect_url = "/sipbos", not_allowed_url = "/sipbos")
     * @param Request $request
     */
    public function summaryAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');

        $params = (object) ["Id" => $user_id];
        $status_complete_profile = \AuthenticationModel\User::checkCompleteProfile($params);
        if(!$status_complete_profile->Status)
            return $this->redirect('/sipbos/thankyou');

        $tipologi = ["Clan", 'Adhocracy', 'Market', 'Hierarchy'];

        $parameters = array();
        $parameters['UserId'] = $user_id;
        $parameters['Role'] = $request->request->get('auth_role');        
        $parameters['Apikey'] = $this->_api_key;

        $params = new \stdClass;
        $params->UserId = $parameters['UserId'];
        $data = \AppModel\Sipbos::getLastAssessmentByUser($params);

        if(!$data->Status) return $this->redirect('/error404');

        $data = $data->Data;

        $rvs = [];
        $rvs['Terminal'] = $data->RvsTerminal;
        $rvs['Instrument'] = $data->RvsInstrument;

        $unit_now = [];
        $unit_want = [];
        $organisasi_now = [];
        $organisasi_want = [];
        foreach ($tipologi as $key => $value) {
            $unit_now[$value] = $data->{"Ocai{$value}NowUnit"};
            $unit_want[$value] = $data->{"Ocai{$value}WantUnit"};
            $organisasi_now[$value] = $data->{"Ocai{$value}NowOrganisasi"};
            $organisasi_want[$value] = $data->{"Ocai{$value}WantOrganisasi"};
        }

        $ocai = [];
        $ocai['UnitKerja'] = [
                'Now' => $unit_now,
                'Want' => $unit_want
            ];
        $ocai['Organisasi'] = [
                'Now' => $organisasi_now,
                'Want' => $organisasi_want
            ];

        $msai = [];
        foreach ($data->MsaiProcess as $key => $value) {
            $temp_tipologi = ucfirst(strtolower($value[0]));
            $msai[$key] = [
                $value[0],
                $value[1] . '(' . $value[2] . ')',
                $value[3],
                $data->{"Msai{$temp_tipologi}"}
            ];
        }

        $summary = array(
                    "Rvs" => $rvs,
                    "Ocai" => $ocai,
                    "Msai" => $msai
                );

        $parameters['Summary'] = $summary; 
        $parameters['Tipologi'] = $tipologi; 

        return $this->render(":Sipbos:summary.html.php", $parameters);        
    }

    // ------------------------------------------------------------------------------------------------------

    public static function checkFinished($user_id = null) {
        if(!$user_id) return 0;

        $params = new \stdClass;
        $params->UserId = $user_id;
        $data = \AppModel\Sipbos::getLastAssessmentByUser($params)->Data;

        return $data->IsFinished;
    }

}
