<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Parser;
use Lcobucci\JWT\ValidationData;
use Pimcore\Log\Simple;
use AuthenticationBundle\Annotation\Login;

/** 
 * @Route("/sipmas") 
 */ 
class SipmasController extends \AppHelper\BaseFrontendController
{

    /**
     * @Route("/")
     * @param Request $request
     */
    public function defaultAction(Request $request)
    {
        // by default unset session project
        $session = $request->getSession()->remove('sipmas_project');

        $code = $request->query->get('c');
        if($code){
            $params = (object) ["Code" => $code];
            $valid_project = \AppModel\SipmasProject::checkValid($params);
            if($valid_project->Status){  
                // set session project
                $session = $request->getSession()->set('sipmas_project', $valid_project->Data->o_id);                
            }
        }

        $role = '';
        $auth_token = $request->getSession()->get('auth_token');
        if($auth_token){
            $role = \AppHelper\Session::getDataFromToken($auth_token, "Role");
        }

        if($role != 'Participant'){
            $params = (object) ["Request" => $request, "Client" => $this->_client, "ApiKey" => $this->_api_key];
            \AppModel\User::createDemoUser($params);
        }

        $this->view->Apikey = $this->_api_key;    	
    }

    /**
     * @Route("/instruction")
     * @Login(role = "Participant", redirect_url = "/sipmas", not_allowed_url = "/sipmas")
     * @param Request $request
     */
    public function instructionAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');
        
        $status_finish = self::checkFinished($user_id);
        if($status_finish) return $this->redirect('/sipmas/thankyou');
    }

    /**
     * @Route("/assessment")
     * @Login(role = "Participant", redirect_url = "/sipmas", not_allowed_url = "/sipmas")
     * @param Request $request
     */
    public function assessmentAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');

        $status_finish = self::checkFinished($user_id);
        if($status_finish) return $this->redirect('/sipmas/thankyou');

        if ($request->isMethod("POST")) {

            $post = $request->request->all();

            $params = json_decode($post['data']);
            $params->User = $user_id;
            $params->ProjectData = $request->getSession()->get('sipmas_project'. '');
            $params->Save = 1;
            $result = \AppModel\Sipmas::calculate($params);

            if($result->Status && $params->IsFinished){ 
                return $this->redirect("/sipmas/thankyou");
            } else if($result->Status){            
                return $this->json(["Status" => 1]);
            } else if(!$result->Status){            
                return $this->json(["Status" => 0]);
            } else {
                return $this->redirect("/sipmas/assessment/error");
            }

        } else {

            $sipmas_question = \AppModel\SipmasQuestion::getAll()->Data;

            $array_count_question = []; $count_pilar = 1; $count_question = 1;
            foreach ($sipmas_question as $key => $value) {

                if($key>0) {
                    if($sipmas_question[$key]->Pillar != $sipmas_question[$key-1]->Pillar) {
                        $count_pilar++;
                        $count_question = 1;
                    }
                }

                $sipmas_question[$key]->CountPillar = $count_pilar;  
                $sipmas_question[$key]->CountQuestion = $count_question++;  

                if($array_count_question[$value->Pillar]){
                    $array_count_question[$value->Pillar]++;
                } else {
                    $array_count_question[$value->Pillar] = 1;
                }
            }

            $this->view->Question = $sipmas_question;
            $this->view->QuestionCount = $array_count_question;

            $params_answer = new \stdClass;
            $params_answer->UserId = $user_id;
            $answer = \AppModel\Sipmas::getLastAssessmentByUser($params_answer);

            if($answer->Status){
                $answer = $answer->Data;

                if($answer->DataRaw){
                    $mapping_answer = array_column($answer->DataRaw, '6');
                    $this->view->Answer = json_encode($mapping_answer); 
                }
            }
        }

        $this->view->UserId = $user_id;
        $this->view->Apikey = $this->_api_key;
    }    

    /**
     * @Route("/thankyou")
     * @Login(role = "Participant", redirect_url = "/sipmas", not_allowed_url = "/sipmas")
     * @param Request $request
     */
    public function thankyouAction(Request $request)
    {
        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
    }    

    /**
     * @Route("/summary")
     * @Login(role = "Participant", redirect_url = "/sipmas")
     * @param Request $request
     */
    public function summaryAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');

        $params = (object) ["Id" => $user_id];
        $status_complete_profile = \AuthenticationModel\User::checkCompleteProfile($params);
        if(!$status_complete_profile->Status)
            return $this->redirect('/sipmas/thankyou');

        $params = new \stdClass;
        $params->UserId = $user_id;
        $data = \AppModel\Sipmas::getLastAssessmentByUser($params)->Data;

        $pillar_color = [
                'rgba(255, 99, 132, 0.5)',
                'rgba(54, 162, 235, 0.5)',
                'rgba(255, 206, 86, 0.5)',
                'rgba(0, 99, 132, 0.5)',
                'rgba(54, 0, 235, 0.5)',
                'rgba(255, 206, 0, 0.5)',
                'rgba(0, 206, 0, 0.5)'
            ];

        $chart_data = [];
        $chart_data['PillarElement'] = [];

        $chart_data['Pillar'] = array("Label" => [], "Value" => [], "Color" => []);
        foreach ($data->PillarResult as $key => $value) {
            array_push($chart_data['Pillar']['Label'], $value[0]);
            array_push($chart_data['Pillar']['Value'], $value[1]);               
            array_push($chart_data['Pillar']['Color'], $pillar_color[$key]);               

            $chart_data['PillarElement'][$value[0]] = array("Label" => [], "Value" => [], "Color" => []);
        }

        $chart_data['Element'] = array("Label" => [], "Value" => [], "Color" => []);
        foreach ($data->ElementResult as $key => $value) {
            $index_color = str_replace('Pilar ', '', explode('.', $value[2])[0]);
            $index_color = intval($index_color) - 1;

            $element[$key][1] = \AppHelper\General::decimalPlaces( $element[$key][1] / count($data) );

            array_push($chart_data['Element']['Label'], $value[0]);
            array_push($chart_data['Element']['Value'], $value[1]);               
            array_push($chart_data['Element']['Color'], $pillar_color[$index_color]);               

            if($value[2]){
                array_push($chart_data['PillarElement'][$value[2]]['Label'], $value[0]);
                array_push($chart_data['PillarElement'][$value[2]]['Value'], $value[1]);                           
                array_push($chart_data['PillarElement'][$value[2]]['Color'], $pillar_color[$index_color]);
            }
        }

        $parameters = array();
        $parameters['Data'] = $data; 
        $parameters['ChartData'] = $chart_data; 

        $parameters['UserId'] = $request->request->get('auth_user_id');
        $parameters['Role'] = $request->request->get('auth_role');        
        $parameters['Apikey'] = $this->_api_key;

        return $this->render(":Sipmas:summary.html.php", $parameters);        
    }

    /**
     * @Route("/assessment/error")
     * @Login(role = "Participant", redirect_url = "/sipmas", not_allowed_url = "/sipmas")
     * @param Request $request
     */
    public function assessmentErrorAction(Request $request)
    {

    }    

    // ------------------------------------------------------------------------------------------------------

    public static function checkFinished($user_id = null) {
        if(!$user_id) return 0;

        $params = new \stdClass;
        $params->UserId = $user_id;
        $data = \AppModel\Sipmas::getLastAssessmentByUser($params)->Data;

        return $data->IsFinished;
    }    

}
