<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Parser;
use Lcobucci\JWT\ValidationData;
use Pimcore\Log\Simple;
use \AppHelper\Manager;
use AuthenticationBundle\Annotation\Login;

/** 
 * @Route("/sa") 
 */ 
class SuperAdminController extends \AppHelper\BaseFrontendController
{

    /**
     * @Route("/dashboard")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function defaultAction(Request $request)
    {
        $user_id = $request->request->get('auth_user_id');

        $params = (object) ['Role' => 'participant'];
        $this->view->StatisticParticipant = \AuthenticationModel\User::getStatistic($params)->Data;

        $statistic_assessment = [];        

        $temp = \AppModel\Sipmas::getStatistic($params)->Data;
        array_push($statistic_assessment, $temp);

        $temp = \AppModel\Sipbos::getStatistic($params)->Data;
        array_push($statistic_assessment, $temp);

        $this->view->StatisticAssessment = $statistic_assessment;   
        $this->view->Sidebar = 1;   
    }

    /**
     * @Route("/sipmas/overview")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipmasOverviewAction(Request $request)
    {
        $this->view->Statistic = \AppModel\Sipmas::getStatistic()->Data;   

        $params = (object)["Periode" => 7];
        $data_periode = \AppModel\Sipmas::getCountDataPeriode($params)->Data;

        $chart_data = [];

        $chart_data['Day'] = array("Label" => [], "Value" => [], "Max" => 0, "Count" => []);
        foreach ($data_periode['d'] as $key => $value) {
            $count = 0;
            $label = [];
            $chart_data['Day']['Value'][$key] = [];
            foreach ($value as $k => $v) {
                array_push($label, $k);
                array_push($chart_data['Day']['Value'][$key], $v);

                if($v > $chart_data['Day']['Max']) { $chart_data['Day']['Max'] = $v; }
                $count += $v;
            }
            $chart_data['Day']['Label'] = $label;
            $chart_data['Day']['Count'][$key] = $count;
        }

        $chart_data['Week'] = array("Label" => [], "Value" => [], "Max" => 0, "Count" => []);
        foreach ($data_periode['w'] as $key => $value) {
            $count = 0;
            $label = [];
            $chart_data['Week']['Value'][$key] = [];
            foreach ($value as $k => $v) {
                array_push($label, $k);
                array_push($chart_data['Week']['Value'][$key], $v);

                if($v > $chart_data['Week']['Max']) { $chart_data['Week']['Max'] = $v; }
                $count += $v;
            }
            $chart_data['Week']['Label'] = $label;
            $chart_data['Week']['Count'][$key] = $count;
        }

        $chart_data['Month'] = array("Label" => [], "Value" => [], "Max" => 0, "Count" => []);
        foreach ($data_periode['m'] as $key => $value) {
            $count = 0;
            $label = [];
            $chart_data['Month']['Value'][$key] = [];
            foreach ($value as $k => $v) {
                array_push($label, $k);
                array_push($chart_data['Month']['Value'][$key], $v);

                if($v > $chart_data['Month']['Max']) { $chart_data['Month']['Max'] = $v; }
                $count += $v;
            }
            $chart_data['Month']['Label'] = $label;
            $chart_data['Month']['Count'][$key] = $count;
        }

        $chart_data['Year'] = array("Label" => [], "Value" => [], "Max" => 0, "Count" => []);
        foreach ($data_periode['y'] as $key => $value) {
            $count = 0;
            $label = [];
            $chart_data['Year']['Value'][$key] = [];
            foreach ($value as $k => $v) {
                array_push($label, $k);
                array_push($chart_data['Year']['Value'][$key], $v);

                if($v > $chart_data['Year']['Max']) { $chart_data['Year']['Max'] = $v; }
                $count += $v;
            }
            $chart_data['Year']['Label'] = $label;
            $chart_data['Year']['Count'][$key] = $count;
        }

        $this->view->ChartData = $chart_data;   

        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }    

    /**
     * @Route("/sipmas")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipmasAction(Request $request)
    {
        $this->view->Provinces = \AppModel\Master::getProvinces()->Data;
        $this->view->Cities = \AppModel\Master::getCities()->Data;

        $this->view->Column = json_encode(\AppModel\Sipmas::getReportColumn()->Data);

        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }    

    /**
     * @Route("/sipmas/resume")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipmasResumeAction(Request $request)
    {
        $parameters = array();
        $parameters['UserId'] = $request->request->get('auth_user_id');
        $parameters['Role'] = $request->request->get('auth_role');        
        $parameters['Apikey'] = $this->_api_key;
        $parameters['Sidebar'] = 1;   

        $id = $request->query->get('q');

        $id = explode(',', $id);
        if(!$id[0])
            return $this->redirect('/error404');

        $where = "a.o_id = " . implode(' OR a.o_id = ', $id);

        $select = "select u.Name, 
            u.Email, 
            u.Phone, 
            a.o_creationDate, 
            a.FinishedDate, 
            a.PillarResult, 
            a.ElementResult, 
            u.Gender, 
            u.Province, 
            u.City, 
            u.Education,
            u.Dob,
            (YEAR(CURDATE()) - year(from_unixtime(u.Dob))) as Age,
            a.IsFinished,
            CONCAT(assets.path, assets.filename) AS ProfilePicture,
            a.o_id";

        if(count($id) == 1) $select .= ",a.DataRaw";

        $id_class = \AppHelper\General::getIdByClassName("Sipmas");        
        $table_sipmas = "object_".$id_class;

        $id_class = \AppHelper\General::getIdByClassName("User");        
        $table_user = "object_".$id_class;

        $query = "                
                {$select} 
                FROM {$table_sipmas} a inner join {$table_user} u on u.o_id = a.user__id left join assets on assets.id = u.ProfilePicture               
                where {$where}
            ";

        $data = \AppHelper\Mysql::makeQuery($query);   

        $users = [];
        $data_raw = [];
        $pillar = [];
        $element = [];
        foreach ($data as $key => $value) {
            
            if($value['DataRaw']){
                $raw = $value['DataRaw'];
                $raw = explode('
', $raw);
                foreach ($raw as $k => $v) {           
                    $temp = explode('|', $v);
                    $data_raw[$k] = $temp;
                }

            }

            $pillar_result = $value['PillarResult'];
            $pillar_result = explode('
', $pillar_result);
            foreach ($pillar_result as $k => $v) {           
                if(!is_array($pillar[$k])) $pillar[$k] = []; 

                $pill = explode('|', $v);

                if(!isset($pillar[$k][0])) $pillar[$k][0] = $pill[0];                
                $pillar[$k][1] += $pill[1];
            }

            $element_result = $value['ElementResult'];
            $element_result = explode('
', $element_result);
            foreach ($element_result as $k => $v) {           
                if(!is_array($element[$k])) $element[$k] = []; 

                $ele = explode('|', $v);

                if(!isset($element[$k][0])) $element[$k][0] = $ele[0];                
                $element[$k][1] += $ele[1];
                if(!isset($element[$k][2])) $element[$k][2] = $ele[2];                                
            }

            $user = $value;

            array_push($users, $user);
        }

        $pillar_color = [
                'rgba(255, 99, 132, 0.5)',
                'rgba(54, 162, 235, 0.5)',
                'rgba(255, 206, 86, 0.5)',
                'rgba(0, 99, 132, 0.5)',
                'rgba(54, 0, 235, 0.5)',
                'rgba(255, 206, 0, 0.5)',
                'rgba(0, 206, 0, 0.5)'
            ];

        $chart_data = [];
        $chart_data['PillarElement'] = [];

        $chart_data['Pillar'] = array("Label" => [], "Value" => [], "Color" => []);
        foreach ($pillar as $key => $value) {
            $pillar[$key][1] = \AppHelper\General::decimalPlaces( $pillar[$key][1] / count($data) );

            array_push($chart_data['Pillar']['Label'], $pillar[$key][0]);
            array_push($chart_data['Pillar']['Value'], $pillar[$key][1]);               
            array_push($chart_data['Pillar']['Color'], $pillar_color[$key]);               

            $chart_data['PillarElement'][$value[0]] = array("Label" => [], "Value" => [], "Color" => []);
        }

        $chart_data['Element'] = array("Label" => [], "Value" => [], "Color" => []);
        foreach ($element as $key => $value) {
            $index_color = str_replace('Pilar ', '', explode('.', $value[2])[0]);
            $index_color = intval($index_color) - 1;

            $element[$key][1] = \AppHelper\General::decimalPlaces( $element[$key][1] / count($data) );

            array_push($chart_data['Element']['Label'], $element[$key][0]);
            array_push($chart_data['Element']['Value'], $element[$key][1]);               
            array_push($chart_data['Element']['Color'], $pillar_color[$index_color]);               

            if($value[2]){
                array_push($chart_data['PillarElement'][$value[2]]['Label'], $element[$key][0]);
                array_push($chart_data['PillarElement'][$value[2]]['Value'], $element[$key][1]);
                array_push($chart_data['PillarElement'][$value[2]]['Color'], $pillar_color[$index_color]);
            }
        }

        $parameters['Data'] = (object) ['DataRaw' => $data_raw, 'ElementResult' => $element, 'PillarResult' => $pillar];
        $parameters['ChartData'] = $chart_data;
        $parameters['Users'] = $users;

        return $this->render(":Sipmas:summary.html.php", $parameters);        
    }    

    /**
     * @Route("/sipmas/import")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipmasImportAction(Request $request)
    {        
        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }        

    /**
     * @Route("/sipmas/project")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipmasProjectAction(Request $request)
    {   
        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }        

    /**
     * @Route("/sipbos/overview")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipbosOverviewAction(Request $request)
    {
        $this->view->Statistic = \AppModel\Sipbos::getStatistic()->Data;   

        $params = (object)["Periode" => 7];
        $data_periode = \AppModel\Sipbos::getCountDataPeriode($params)->Data;

        $chart_data = [];

        $chart_data['Day'] = array("Label" => [], "Value" => [], "Max" => 0, "Count" => []);
        foreach ($data_periode['d'] as $key => $value) {
            $count = 0;
            $label = [];
            $chart_data['Day']['Value'][$key] = [];
            foreach ($value as $k => $v) {
                array_push($label, $k);
                array_push($chart_data['Day']['Value'][$key], $v);

                if($v > $chart_data['Day']['Max']) { $chart_data['Day']['Max'] = $v; }
                $count += $v;
            }
            $chart_data['Day']['Label'] = $label;
            $chart_data['Day']['Count'][$key] = $count;
        }

        $chart_data['Week'] = array("Label" => [], "Value" => [], "Max" => 0, "Count" => []);
        foreach ($data_periode['w'] as $key => $value) {
            $count = 0;
            $label = [];
            $chart_data['Week']['Value'][$key] = [];
            foreach ($value as $k => $v) {
                array_push($label, $k);
                array_push($chart_data['Week']['Value'][$key], $v);

                if($v > $chart_data['Week']['Max']) { $chart_data['Week']['Max'] = $v; }
                $count += $v;
            }
            $chart_data['Week']['Label'] = $label;
            $chart_data['Week']['Count'][$key] = $count;
        }

        $chart_data['Month'] = array("Label" => [], "Value" => [], "Max" => 0, "Count" => []);
        foreach ($data_periode['m'] as $key => $value) {
            $count = 0;
            $label = [];
            $chart_data['Month']['Value'][$key] = [];
            foreach ($value as $k => $v) {
                array_push($label, $k);
                array_push($chart_data['Month']['Value'][$key], $v);

                if($v > $chart_data['Month']['Max']) { $chart_data['Month']['Max'] = $v; }
                $count += $v;
            }
            $chart_data['Month']['Label'] = $label;
            $chart_data['Month']['Count'][$key] = $count;
        }

        $chart_data['Year'] = array("Label" => [], "Value" => [], "Max" => 0, "Count" => []);
        foreach ($data_periode['y'] as $key => $value) {
            $count = 0;
            $label = [];
            $chart_data['Year']['Value'][$key] = [];
            foreach ($value as $k => $v) {
                array_push($label, $k);
                array_push($chart_data['Year']['Value'][$key], $v);

                if($v > $chart_data['Year']['Max']) { $chart_data['Year']['Max'] = $v; }
                $count += $v;
            }
            $chart_data['Year']['Label'] = $label;
            $chart_data['Year']['Count'][$key] = $count;
        }

        $this->view->ChartData = $chart_data;   

        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }    

    /**
     * @Route("/sipbos")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipbosAction(Request $request)
    {
        $this->view->Provinces = \AppModel\Master::getProvinces()->Data;
        $this->view->Cities = \AppModel\Master::getCities()->Data;

        $this->view->Column = json_encode(\AppModel\Sipbos::getReportColumn()->Data);

        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }    

    /**
     * @Route("/sipbos/resume")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipbosResumeAction(Request $request)
    {
        $parameters = array();
        $parameters['UserId'] = $request->request->get('auth_user_id');
        $parameters['Role'] = $request->request->get('auth_role');        
        $parameters['Apikey'] = $this->_api_key;
        $parameters['Sidebar'] = 1;   

        $id = $request->query->get('q');

        $id = explode(',', $id);
        if(!$id[0])
            return $this->redirect('/error404');

        $where = "a.o_id = " . implode(' OR a.o_id = ', $id);

        $select = "select u.Name, 
            u.Email, 
            u.Phone, 
            u.Gender, 
            u.Province, 
            u.City, 
            u.Education,
            u.Dob,
            (YEAR(CURDATE()) - year(from_unixtime(u.Dob))) as Age,
            CONCAT(assets.path, assets.filename) AS ProfilePicture,
            a.o_creationDate, 
            a.FinishedDate, 
            a.RvsTerminal, 
            a.RvsInstrument, 
            a.OcaiClanNowUnit, 
            a.OcaiClanWantUnit, 
            a.OcaiClanNowOrganisasi, 
            a.OcaiClanWantOrganisasi, 
            a.OcaiHierarchyNowUnit, 
            a.OcaiHierarchyWantUnit, 
            a.OcaiHierarchyNowOrganisasi, 
            a.OcaiHierarchyWantOrganisasi, 
            a.OcaiMarketNowUnit, 
            a.OcaiMarketWantUnit, 
            a.OcaiMarketNowOrganisasi, 
            a.OcaiMarketWantOrganisasi, 
            a.OcaiAdhocracyNowUnit, 
            a.OcaiAdhocracyWantUnit, 
            a.OcaiAdhocracyNowOrganisasi, 
            a.OcaiAdhocracyWantOrganisasi, 
            a.MsaiProcess, 
            a.MsaiClan, 
            a.MsaiAdhocracy, 
            a.MsaiMarket, 
            a.MsaiHierarchy, 
            a.TypologyOcaiNowUnit,
            a.TypologyOcaiWantUnit,
            a.TypologyOcaiNowOrganisasi,
            a.TypologyOcaiWantOrganisasi,
            a.TypologyMsai, 
            a.IsFinished,
            a.o_id";

        if(count($id) == 1) $select .= ",a.OcaiRaw, a.MsaiRaw";

        $id_class = \AppHelper\General::getIdByClassName("Sipbos");        
        $table_sipbos = "object_".$id_class;

        $id_class = \AppHelper\General::getIdByClassName("User");        
        $table_user = "object_".$id_class;

        $query = "                
                {$select} 
                FROM {$table_sipbos} a inner join {$table_user} u on u.o_id = a.user__id left join assets on assets.id = u.ProfilePicture               
                where {$where}
            ";

        $query_result = \AppHelper\Mysql::makeQuery($query);  

        $data = new \stdClass;

        $users = [];        
        $data->DataRaw = [];
        $data->MsaiProcess = [[]];

        $TypologyOcaiNowUnit = [];
        $TypologyOcaiNowOrganisasi = [];
        $TypologyOcaiWantUnit = [];
        $TypologyOcaiWantOrganisasi = [];
        $TypologyMsai = [];

        $tipologi = ["Clan", 'Adhocracy', 'Market', 'Hierarchy'];        
        foreach ($tipologi as $key => $value) {
            $TypologyOcaiNowUnit[$value] = 0; 
            $TypologyOcaiNowOrganisasi[$value] = 0;
            $TypologyOcaiWantUnit[$value] = 0;
            $TypologyOcaiWantOrganisasi[$value] = 0;
            $TypologyMsai[$value] = 0;
        }

        foreach ($query_result as $key => $q_result) {

            if($q_result['RvsTerminal']){
                $raw = $q_result['RvsTerminal'];
                $raw = explode('
', $raw);

                foreach ($raw as $k => $v) {           
                    $temp = explode('|', $v);

                    if($key == 0){
                        $data->RvsTerminal[$temp[0]] = $temp;
                    } else {
                        $data->RvsTerminal[$temp[0]][2] += $temp[2];
                    }
                }
            }            

            if($q_result['RvsInstrument']){
                $raw = $q_result['RvsInstrument'];
                $raw = explode('
', $raw);

                foreach ($raw as $k => $v) {           
                    $temp = explode('|', $v);

                    if($key == 0){
                        $data->RvsInstrument[$temp[0]] = $temp;
                    } else {
                        $data->RvsInstrument[$temp[0]][2] += $temp[2];
                    }
                }
            }            

            $data->OcaiClanNowUnit  += $q_result['OcaiClanNowUnit']; 
            $data->OcaiClanWantUnit += $q_result['OcaiClanWantUnit'];
            $data->OcaiClanNowOrganisasi += $q_result['OcaiClanNowOrganisasi'];
            $data->OcaiClanWantOrganisasi += $q_result['OcaiClanWantOrganisasi'];
            $data->OcaiHierarchyNowUnit += $q_result['OcaiHierarchyNowUnit'];
            $data->OcaiHierarchyWantUnit += $q_result['OcaiHierarchyWantUnit'];
            $data->OcaiHierarchyNowOrganisasi += $q_result['OcaiHierarchyNowOrganisasi'];
            $data->OcaiHierarchyWantOrganisasi += $q_result['OcaiHierarchyWantOrganisasi'];
            $data->OcaiMarketNowUnit += $q_result['OcaiMarketNowUnit'];
            $data->OcaiMarketWantUnit += $q_result['OcaiMarketWantUnit'];
            $data->OcaiMarketNowOrganisasi += $q_result['OcaiMarketNowOrganisasi']; 
            $data->OcaiMarketWantOrganisasi += $q_result['OcaiMarketWantOrganisasi'];
            $data->OcaiAdhocracyNowUnit += $q_result['OcaiAdhocracyNowUnit'];
            $data->OcaiAdhocracyWantUnit += $q_result['OcaiAdhocracyWantUnit'];
            $data->OcaiAdhocracyNowOrganisasi += $q_result['OcaiAdhocracyNowOrganisasi'];
            $data->OcaiAdhocracyWantOrganisasi += $q_result['OcaiAdhocracyWantOrganisasi'];

            if($q_result['MsaiProcess']){
                $raw = $q_result['MsaiProcess'];
                $raw = explode('
', $raw);

                foreach ($raw as $k => $v) {           
                    $temp = explode('|', $v);
                    if($key == 0){
                        $data->MsaiProcess[$k] = $temp;
                    } else {
                        $data->MsaiProcess[$k][3] += $temp[3];
                    }
                }
            }

            $data->MsaiClan += $q_result['MsaiClan'];
            $data->MsaiAdhocracy += $q_result['MsaiAdhocracy'];
            $data->MsaiMarket += $q_result['MsaiMarket'];
            $data->MsaiHierarchy += $q_result['MsaiHierarchy'];

            if($q_result['MsaiRaw']){
                $raw = $q_result['MsaiRaw'];
                $raw = explode('
', $raw);
                foreach ($raw as $k => $v) {           
                    $temp = explode('|', $v);
                    if($data->DataRaw['Msai'])
                        array_push($data->DataRaw['Msai'], $temp);
                    else 
                        $data->DataRaw['Msai'] = [$temp];
                }
            }

            if($q_result['OcaiRaw']){
                $raw = $q_result['OcaiRaw'];
                $raw = explode('
', $raw);
                $data->DataRaw['Ocai'] = [];
                foreach ($raw as $k => $v) {           
                    $temp = explode('|', $v);

                    array_push($data->DataRaw['Ocai'],[$k, "Unit Kerja", "Saat Ini", $temp[0], $temp[4], $temp[8], $temp[12]]);
                    array_push($data->DataRaw['Ocai'],[$k, "Unit Kerja", "Diinginkan", $temp[1], $temp[5], $temp[9], $temp[13]]);
                    array_push($data->DataRaw['Ocai'],[$k, "Organisasi", "Saat Ini", $temp[2], $temp[6], $temp[10], $temp[14]]);
                    array_push($data->DataRaw['Ocai'],[$k, "Organisasi", "Diinginkan", $temp[3], $temp[7], $temp[11], $temp[15]]);
                }
            }            

            $TypologyOcaiNowUnit[$q_result['TypologyOcaiNowUnit']]++; 
            $TypologyOcaiNowOrganisasi[$q_result['TypologyOcaiNowOrganisasi']]++;
            $TypologyOcaiWantUnit[$q_result['TypologyOcaiWantUnit']]++;
            $TypologyOcaiWantOrganisasi[$q_result['TypologyOcaiWantOrganisasi']]++;
            $TypologyMsai[$q_result['TypologyMsai']]++;

            $user = $q_result;
            array_push($users, $user);
        }

        $data->RvsTerminal = array_values($data->RvsTerminal);
        usort($data->RvsTerminal, function($a, $b) {
            return $a[2] <=> $b[2];
        });

        $data->RvsInstrument = array_values($data->RvsInstrument);
        usort($data->RvsInstrument, function($a, $b) {
            return $a[2] <=> $b[2];
        });
        
        foreach($data->RvsTerminal as $key => $value){ // calculate average RVS value
            $data->RvsTerminal[$key][2] = \AppHelper\General::decimalPlaces( $data->RvsTerminal[$key][2] / count($query_result) );
            $data->RvsInstrument[$key][2] = \AppHelper\General::decimalPlaces( $data->RvsInstrument[$key][2] / count($query_result) );        
        } // calculate average RVS value

        $data->OcaiClanNowUnit /= count($query_result);
        $data->OcaiClanWantUnit /= count($query_result);
        $data->OcaiClanNowOrganisasi /= count($query_result);
        $data->OcaiClanWantOrganisasi /= count($query_result);
        $data->OcaiHierarchyNowUnit /= count($query_result);
        $data->OcaiHierarchyWantUnit /= count($query_result);
        $data->OcaiHierarchyNowOrganisasi /= count($query_result);
        $data->OcaiHierarchyWantOrganisasi /= count($query_result);
        $data->OcaiMarketNowUnit /= count($query_result);
        $data->OcaiMarketWantUnit /= count($query_result);
        $data->OcaiMarketNowOrganisasi /= count($query_result);
        $data->OcaiMarketWantOrganisasi /= count($query_result);
        $data->OcaiAdhocracyNowUnit /= count($query_result);
        $data->OcaiAdhocracyWantUnit /= count($query_result);
        $data->OcaiAdhocracyNowOrganisasi /= count($query_result);
        $data->OcaiAdhocracyWantOrganisasi /= count($query_result);

        $data->MsaiClan /= count($query_result);
        $data->MsaiAdhocracy /= count($query_result);
        $data->MsaiMarket /= count($query_result);
        $data->MsaiHierarchy /= count($query_result);

        // #######################################################

        $rvs = [];
        $rvs['Terminal'] = $data->RvsTerminal;
        $rvs['Instrument'] = $data->RvsInstrument;

        $unit_now = [];
        $unit_want = [];
        $organisasi_now = [];
        $organisasi_want = [];
        foreach ($tipologi as $key => $value) {
            $unit_now[$value] = \AppHelper\General::decimalPlaces( $data->{"Ocai{$value}NowUnit"} );
            $unit_want[$value] = \AppHelper\General::decimalPlaces( $data->{"Ocai{$value}WantUnit"} );
            $organisasi_now[$value] = \AppHelper\General::decimalPlaces( $data->{"Ocai{$value}NowOrganisasi"} );
            $organisasi_want[$value] = \AppHelper\General::decimalPlaces( $data->{"Ocai{$value}WantOrganisasi"} );
        }

        $ocai = [];
        $ocai['UnitKerja'] = [
                'Now' => $unit_now,
                'Want' => $unit_want
            ];
        $ocai['Organisasi'] = [
                'Now' => $organisasi_now,
                'Want' => $organisasi_want
            ];

        $msai = [];
        foreach ($data->MsaiProcess as $key => $value) {
            $temp_tipologi = ucfirst(strtolower($value[0]));
            $msai[$key] = [
                $temp_tipologi,
                $value[1] . '(' . $value[2] . ')',
                \AppHelper\General::decimalPlaces( $value[3] / count($query_result) ),
                \AppHelper\General::decimalPlaces( $data->{"Msai{$temp_tipologi}"} )
            ];
        }

        $summary = array(
                    "Rvs" => $rvs,
                    "Ocai" => $ocai,
                    "Msai" => $msai
                );

        $parameters = array();
        $parameters['UserId'] = $request->request->get('auth_user_id');
        $parameters['Role'] = $request->request->get('auth_role');        
        $parameters['Apikey'] = $this->_api_key;        
        $parameters['Users'] = $users;
        $parameters['Summary'] = $summary; 
        $parameters['DataRaw'] = $data->DataRaw; 
        $parameters['Tipologi'] = $tipologi; 

        $parameters['TypologyOcaiNowUnit'] = $TypologyOcaiNowUnit;
        $parameters['TypologyOcaiNowOrganisasi'] = $TypologyOcaiNowOrganisasi;
        $parameters['TypologyOcaiWantUnit'] = $TypologyOcaiWantUnit;
        $parameters['TypologyOcaiWantOrganisasi'] = $TypologyOcaiWantOrganisasi;
        $parameters['TypologyMsai'] = $TypologyMsai;

        return $this->render(":Sipbos:summary.html.php", $parameters);        
    }    

    /**
     * @Route("/sipbos/import")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipbosImportAction(Request $request)
    {
        
        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }    

    /**
     * @Route("/sipbos/project")
     * @Login(role = "SuperAdmin")
     * @param Request $request
     */
    public function sipbosProjectAction(Request $request)
    {   
        $this->view->UserId = $request->request->get('auth_user_id');
        $this->view->Apikey = $this->_api_key;
        $this->view->Sidebar = 1;   
    }        

}
