<?php
/*
	This is for PHP function helper
	Initial by Suhar Prasetyo
*/

namespace AppHelper;

use Pimcore\File;

/**
* This is helper for handling Assets
*/
class Asset
{
	
    public static function uploadFileToAsset($params)
    {
        if($params->Type == 'base64'){
            $filename = uniqid().$params->Image['Name'];
            $sourcePath = PIMCORE_SYSTEM_TEMP_DIRECTORY . "/upload-base64" . uniqid() . ".tmp";
            $data = preg_replace("@^data:[^,]+;base64,@", "", $params->Image['Data']);
            File::put($sourcePath, base64_decode($data));
        } else {
            $filename = $params->Image["name"];
            $sourcePath = $params->Image["tmp_name"];
        }

        $parentAsset = \Pimcore\Model\Asset::getByPath($params->Path);

        $filename = File::getValidFilename($filename);
        if (empty($filename)) {
            throw new \Exception("The filename of the asset is empty");
        }

        // cek duplikat file
        $filename = self::getSafeFilename($parentAsset->getFullPath(), $filename);
        
        // print_r(filesize($sourcePath));die();
        if (!is_file($sourcePath) || filesize($sourcePath) < 1) {
            throw new \Exception("Something went wrong, please check upload_max_filesize and post_max_size in your php.ini and write permissions of /website/var/");
        }
        $asset = \Pimcore\Model\Asset::create($parentAsset->getId(), array(
            "filename" => $filename,
            "sourcePath" => $sourcePath
        ));
        @unlink($sourcePath);

        return $asset;
    }

    public static function getSafeFilename($targetPath, $filename)
    {
        $originalFilename = $filename;
        $count = 1;
        if ($targetPath == "/") {
            $targetPath = "";
        }
        while (true) {
            if (\Pimcore\Model\Asset\Service::pathExists($targetPath . "/" . $filename)) {
                $filename = str_replace("." . File::getFileExtension($originalFilename), "_" . $count . "." . File::getFileExtension($originalFilename), $originalFilename);
                $count++;
            } else {
                return $filename;
            }
        }
    }
	
}