<?php
/*
	This is for PHP function helper
	Initial by Suhar Prasetyo
*/

namespace AppHelper;

use Pimcore\Tool\Authentication as PimcoreAuthentication;

/**
* This is helper for handling Authentication pimcore Admin
*/
class Authentication
{
	
	public static function checkPimcoreLogin() 
    {        
        $user = PimcoreAuthentication::authenticateSession();
        return $user;

    }

    public static function checkAuthenticatePimcoreUser($username, $password) 
    {        
        $user = PimcoreAuthentication::authenticatePlaintext($username, $password);
        return $user;
    }

    public static function logoutPimcorePanel($scope) 
    {
        $controller = $scope;

        // clear open edit locks for this session
        \Pimcore\Model\Element\Editlock::clearSession(session_id());

        \Pimcore\Tool\Session::useSession(function ($adminSession) use ($controller) {
            if ($adminSession->user instanceof User) {
                \Pimcore::getEventManager()->trigger("admin.login.logout", $controller, ["user" => $adminSession->user]);
                $adminSession->user = null;
            }

            \Zend_Session::destroy();
        });

        // cleanup pimcore-cookies => 315554400 => strtotime('1980-01-01')
        setcookie("pimcore_opentabs", false, 315554400, "/");        
    }

}