<?php

namespace AppHelper;

use Pimcore\Controller\FrontendController;
use GuzzleHttp\Client;

class BaseFrontendController extends FrontendController
{

    protected $_api_base_uri;
    protected $_api_key;
    protected $_client;

    public function __construct()
    {
        $this->_api_base_uri = \CustomHelper\General::getGlobalVariable('API_BASE_URI');
        $this->_api_key = \CustomHelper\General::getGlobalVariable('API_KEY');
        $this->_client = new Client(['base_uri' => $this->_api_base_uri]);
    }

}
