<?php
/*
    This is for PHP function helper
    Initial by Suhar Prasetyo
*/

namespace AppHelper;

use Pimcore\File;

/**
* This is helper for handling Email
*/
class Email
{
    
    public static function sendEmail($params = null)
    {
        $return = new \stdClass;
        $return->Status = 0;
        $return->Message = '';

        try{
            $mail = new \Pimcore\Mail();
            
            $valid_email = $mail->isValidEmailAddress($params->To);
            if(!$valid_email){
                $return->Message = "Not valid email";
                return $return;
            }

            $mail->addTo($params->To);
            
            if($params->Subject){
                $mail->setSubject($params->Subject);
            }

            if($params->Template){
                $mail->setDocument($params->Template);
                $mail->setParams($params->Params);
            }else {
                $mail->setBodyHtml($params->BodyHtml);
            }

            if($params->From){
                $temp = explode(",", $params->From);
                $from = trim($temp[0]);
                $alias = $temp[1] ? trim($temp[1]) : "";
                
                $mail->setFrom($from, $alias);
            }

            if(json_decode($params->Cc)){
                $mail->addCc(json_decode($params->Cc));
            }

            if($params->Bcc){
                $mail->addBcc($params->Bcc);
            }

            if ($params->Attachment) {
                if (is_array($params->Attachment)) {
                    foreach ($params->Attachment as $key => $att) {
                        $mail->createAttachment($att->getData(), $att->getMimetype(), $att->getFilename());
                    }
                } else {
                    $att = $params->Attachment;
                    $mail->createAttachment($att->getData(), $att->getMimetype(), $att->getFilename());
                }
            }

            $mail->send();
            $return->Status = 1;

        } catch (Exception $ex){
            $return->Message = $ex->getMessage();            
        }
 
        return $return;
    }

}