<?php
/*
	This is for PHP function helper
	Initial by Suhar Prasetyo
*/

namespace AppHelper;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;
/**
* This is helper for handling Excel
*/
class Excel
{
	
	public static function exportToExcel($params = null) 
    {
        /* Example data format
        $params->data = array(
                ['Title A1', 'Title B1', 'Title C1', 'Title D1', 'Title E1'],
                ['Value A2', 'Value B2', 'Value C2', 'Value D2', 'Value E2'],
                ['Value A3', 'Value B3', 'Value C3', 'Value D3', 'Value E3'],
                ['Value A4', 'Value B4', 'Value C4', 'Value D4', 'Value E4'],
                ['Value A5', 'Value B5', 'Value C5', 'Value D5', 'Value E5']
                ....................
                ....................
                ....................
            );
        */

        /** Include PHPExcel */
        include_once("vendor/PHPExcel/PHPExcel.php");

        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator($params->creator)
                                     ->setLastModifiedBy($params->modified)
                                     ->setTitle($params->title)
                                     ->setSubject($params->subject)
                                     ->setDescription($params->description)
                                     ->setKeywords($params->keyword)
                                     ->setCategory($params->category);

        $inc = 1;
        $alphabet = 'A';    
        foreach ($params->data as $row) {
            foreach ($row as $index => $data) {
                $nowAlphabet = chr(ord($alphabet) + $index);
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($nowAlphabet.$inc, $data);
            }

            $inc++;
        }       

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle($params->sheetName);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $params->filename .'.xlsx"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');
        
        exit;
    }  

    public static function readExcelFile($excelFile)
    {
        $spreadsheet = IOFactory::load($excelFile);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        return $sheetData;
    } 

    public static function writeExcelFromTemplate($params = null)
    {
        if(!$params->templatePath){
            // history put here (template not exist)
            die("templatePath is empty");
            return false;
        }

        if (!file_exists($params->templatePath)) {        
            // history put here (template not exist)
            die("templatePath not exist");
            return false;
        }

        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($params->templatePath);

        $worksheet = $spreadsheet->getActiveSheet();

        if($params->Data){        
            foreach ($params->Data as $key => $value) {
                if($value){                
                    $worksheet->getCell($key)->setValue($value);
                }
            }
        }

        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xls');
        $writer->save($params->newFilePath . '.xls');

        return $writer;
    }

}
