<?php

/*
    This is for PHP function helper
    Initial by Suhar Prasetyo
*/

namespace AppHelper;

use \Pimcore\Model\DataObject;


class General {

    public static function CallApi($method, $url, $data = false, $waitRequest = true)
    {
        $curl = curl_init();
    
        switch (strtoupper($method))
        {
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
        
                if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_PUT, 1);
                break;
            default:
                if ($data)
                $url = sprintf("%s?%s", $url, http_build_query($data));
        }
    
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        
        if(!$waitRequest){
            curl_setopt($curl, CURLOPT_TIMEOUT_MS, 250);
        }

        $result = curl_exec($curl);

        if($result === false && $waitRequest){
            $result = 'Curl error: ' . curl_error($curl);
        }   
    
        curl_close($curl);
    
        return $result;
    }   

    public static function getIdByClassName($className)
    {
        try{
            $command = "\$class = new \\Pimcore\\Model\\DataObject\\" . $className . "();";
            eval($command);     

            return $class->o_classId;       
        } catch (Exception $ex){
            return 0;
        }   
    }

    public static function stringCompress($text)
    {   
        return rtrim(strtr(base64_encode(gzdeflate($text, 9)), '+/', '-_'), '=');
    }

    public static function stringDecompress($text)
    {
        return gzinflate(base64_decode(strtr($text, '-_', '+/')));
    }

    public static function getRandomNumber($length)
    {
        $min = pow(10, ($length-1));
        $max = pow(10, $length) - 1;

        return rand($min, $max);
    }

    public static function getRandomClientId()
    {
        $word = $_SERVER['HTTP_USER_AGENT'] . $_SERVER['REMOTE_ADDR'] . microtime() . uniqid();
        return md5($word);
    }

    public static function getRandomPassword($length) 
    {
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        if($specialChar){
            $char .= '!@#$%^&*_';
        }

        $password = substr( str_shuffle( $chars ), 0, $length ); 
        return $password;
    }

    public static function limitString($input, $maxWords, $maxChars = null)
    {
        $words = preg_split('/\s+/', $input);
        $words = array_slice($words, 0, $maxWords);
        $words = array_reverse($words);

        $chars = 0;
        $truncated = array();

        while(count($words) > 0)
        {
            $fragment = trim(array_pop($words));
            $chars += strlen($fragment);

            if($maxChars)
                if($chars > $maxChars) break;

            $truncated[] = $fragment;
        }

        $result = implode($truncated, ' ');

        if ($input == $result)
        {
            return $input;
        }
        else
        {
            return preg_replace('/[^\w]$/', '', $result);
        }
    }

    public static function convertStringToIndonesiaCurrency($string, $decimalPlaces)
    {
        return 'Rp. ' . number_format($string, $decimalPlaces, ',', '.');
    }

    public static function indonesiaDate($timestamp = '', $date_format = 'd M Y', $suffix = '') 
    {
        if (trim ($timestamp) == ''){
                $timestamp = time ();
        }
        elseif (!ctype_digit ($timestamp)){
            $timestamp = strtotime ($timestamp);
        }

        $date_format = preg_replace ("/S/", "", $date_format);
        $pattern = array (
            '/Mon[^day]/','/Tue[^sday]/','/Wed[^nesday]/','/Thu[^rsday]/',
            '/Fri[^day]/','/Sat[^urday]/','/Sun[^day]/','/Monday/','/Tuesday/',
            '/Wednesday/','/Thursday/','/Friday/','/Saturday/','/Sunday/',
            '/Jan[^uary]/','/Feb[^ruary]/','/Mar[^ch]/','/Apr[^il]/','/May/',
            '/Jun[^e]/','/Jul[^y]/','/Aug[^ust]/','/Sep[^tember]/','/Oct[^ober]/',
            '/Nov[^ember]/','/Dec[^ember]/','/January/','/February/','/March/',
            '/April/','/June/','/July/','/August/','/September/','/October/',
            '/November/','/December/',
        );

        $replace = array ( 'Sen','Sel','Rab','Kam','Jum','Sab','Min',
            'Senin','Selasa','Rabu','Kamis','Jumat','Sabtu','Minggu',
            'Jan','Feb','Mar','Apr','Mei','Jun','Jul','Ags','Sep','Okt','Nov','Des',
            'Januari','Februari','Maret','April','Juni','Juli','Agustus','September',
            'Oktober','November','Desember',
        );

        $date = date ($date_format, $timestamp);
        $date = preg_replace ($pattern, $replace, $date);
        $date = "{$date} {$suffix}";

        return $date;
    }

    public static function getSiteUrl($authentication = '') 
    {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";

        $domainName = $_SERVER['HTTP_HOST'].'/';
        
        if ($authentication) {
            $domainName = $authentication ."@". $domainName;
        }

        return $protocol . $domainName;
    }    

    public static function checkOrigin()
    {

        header('Access-Control-Allow-Origin: *');        
        $requester = $_SERVER['HTTP_REFERER'];
        $domain_origin = Custom_Helper::getGlobalVariable('GLOBAL_ALLOW_ORIGIN');
        
        if (!$requester) {
            header('Access-Control-Allow-Origin: *');        
        } else {
            $domain_origin = explode(",", $domain_origin);
            if (in_array($requester, $domain_origin)) {
                header("Access-Control-Allow-Origin: ". rtrim($requester, "/"));        
            }
        }

    }

    public static function daysBetween($date1 = null, $date2 = null) {

        $date1 = new \DateTime($date1);
        $date2 = new \DateTime($date2);

        $diff = $date2->diff($date1)->format("%a");

        return $diff;

    }

    public static function objectToArray($obj)
    {
        if(is_object($obj)) $obj = (array) $obj;
        if(is_array($obj))
        {
            $arr = array();
            foreach($obj as $key => $val) {
                $arr[$key] = self::objectToArray($val);
            }
        }
        else $arr = $obj;

        return $arr;
    }
    
    public static function csv_to_array($filename='', $delimiter=',')
    {
        if(!file_exists($filename) || !is_readable($filename))
            return FALSE;

        $header = NULL;
        $data = array();
        
        if (($handle = fopen($filename, 'r')) !== FALSE)
        {
            while (($row = fgetcsv($handle, 1000, $delimiter)) !== FALSE)
            {
                if(!$header)
                    $header = $row;
                else
                    $data[] = array_combine($header, $row);
            }
            fclose($handle);
        }
        return $data;
    }
    
    public static function get_client_ip() {
        $ipaddress = '';

        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';

        return $ipaddress;
    }   

    public static function checkObjectPath($path, $auto_generate = 0) {
        $check_path = DataObject::getByPath($path);        

        if($check_path){
            return 1;
        } else {
            if($auto_generate){
                return self::generateObjectPath($path);
            } else {            
                return 0;
            }
        }
    }       

    public static function generateObjectPath($path) {
        $keys = explode('/', $path);

        for($i = 2 ; $i <= count($keys) ; $i++){
            $join_path = join("/", array_slice($keys, 0, $i)); 
            $check_path = self::checkObjectPath($join_path);
            
            if(!$check_path){
                $index = $i-1;
                $parent_path = DataObject::getByPath(join("/", array_slice($keys, 0, $index)));
                $folder_key = $keys[$index];

                // create folder $keys[$i - 1]
                $folder = DataObject\Folder::create([
                                                "o_key" => $folder_key,
                                                "o_parentId" => $parent_path ? $parent_path->o_id : 1,
                                                "o_published" => true
                                            ]);							
				$folder->save();
            }
        }

        return 1;
    }    

    public static function decimalPlaces($value, $decimal_places = 2){
        return number_format((float)$value, $decimal_places, '.', '');
    }

    public static function cleanString($value){
        return trim($value);
    }

}
