<?php
/**
 * 
 */

namespace AppHelper\Generator\Lib;


class ApiModel extends \AppHelper\Generator\AbstractModel
{

	protected $bundle = '';
	protected $bundle_name = '';

	public function setBundle($bundle)
	{
		$this->bundle = $bundle;
	}

	public function setBundleName($bundle_name)
	{
		$this->bundle_name = $bundle_name;
	}


	public function start($params = null)
	{

	}

	public function finish($params = null)
	{

	}

	public function body($params = null)
	{
		$body = file_get_contents(PIMCORE_PROJECT_ROOT .'/src/AppBundle/Helper/Generator/Templates/Api.template');
		$body = str_replace('{CLASS_NAME}', $this->_object->getName(), $body);
		$body = str_replace('{CLASS_NAME_ROUTE}', $this->_object->getStripe(), $body);
		$body = str_replace('{BUNDLE_NAME}', $this->bundle_name, $body);

		$data = $this->_object->getData();
		if (count($data)) {
			$params = "";
			$search = "";
			foreach ($data as $key_field => $field) {
				$params .= "{$key_field}, ";
				if ($field->getVisibleSearch()) {
					$search .= ", {$key_field}";
				}
			}
			$params = rtrim($params, ", ");

			$body = str_replace('{PARAMS}', $params, $body);
			$body = str_replace('{getAll_PARAMS}', $search, $body);
		}

		$this->appendScript($body);
	}

	public function generate($params = null)
	{

		$bundle = $this->bundle;
		$path = PIMCORE_PROJECT_ROOT ."/src/".$bundle."/Service/". $this->_object->getName() ."Controller.php";
		if (!file_exists($path) || $this->_overwrite) {
			$file = fopen($path, "w");
			fwrite($file, $this->_script);
			fclose($file);
			return true;
		}
		return false;
		
	}

	public function isProcessData()
	{
		return true;
	}

}