<?php
/**
 * 
 */

namespace AppHelper\Generator\Lib;


class ManagerModel extends \AppHelper\Generator\AbstractModel
{

	protected $bundle = '';
	protected $bundle_name = '';

	public function setBundle($bundle)
	{
		$this->bundle = $bundle;
	}

	public function setBundleName($bundle_name)
	{
		$this->bundle_name = $bundle_name;
	}

	public function start($params = null)
	{

	}

	public function finish($params = null)
	{

	}

	public function body($params = null)
	{
		$body = file_get_contents(PIMCORE_PROJECT_ROOT .'/src/AppBundle/Helper/Generator/Templates/Manager.template');
		$body = str_replace('{CLASS_NAME}', $this->_object->getName(), $body);
		$body = str_replace('{BUNDLE_NAME}', $this->bundle_name, $body);

		$data = $this->_object->getData();
		if (count($data)) {
			$params = "";
			$search = "";
			$mandatory = "";
			$create = "";
			$update = "";
			$get_all_conditional = "";
			foreach ($data as $key_field => $field) {
				$params .= "{$key_field}, ";

				if ($field->getVisibleSearch()) {
					$search .= ", {$key_field}";
					$get_all_conditional .= $this->tab(3) .'if ($params->'. $key_field .') {'. PHP_EOL;
					$get_all_conditional .= $this->tab(4) .'if ($condition) $condition .= " AND ";'. PHP_EOL;
					$get_all_conditional .= $this->tab(4) .'$condition .= "'. $key_field .' = ?";'. PHP_EOL;
					$get_all_conditional .= $this->tab(4) .'array_push($params_condition, $params->'. $key_field .');'. PHP_EOL;
					$get_all_conditional .= $this->tab(3) .'}'. PHP_EOL;
				}

				if ($field->mandatory) {
					$mandatory .= $this->tab(2) .'if (!$params->'. $key_field .') {'. PHP_EOL;
					$mandatory .= $this->tab(3) .'$return->Message = \''. $field->getTitle() .' kosong\';'. PHP_EOL;
					$mandatory .= $this->tab(3) .'return $return;'. PHP_EOL;
					$mandatory .= $this->tab(2) .'}'. PHP_EOL;
				}

				if ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Href) {
					$key_field_u = $this->_object->getUnderscore($key_field);

					$href = $this->tab(3) .'if ($params->'. $key_field .') {'. PHP_EOL;
					$href .= $this->tab(4) .'$'. $key_field_u .' = DataObject\\AbstractObject::getById($params->'. $key_field .');'. PHP_EOL;
					$href .= $this->tab(4) .'if ($'. $key_field_u .') {'. PHP_EOL;
					$href .= $this->tab(5) .'$object->set'. $key_field .'($'. $key_field_u .');'. PHP_EOL;
					$href .= $this->tab(4) .'}'. PHP_EOL . $this->tab(3) .'}'. PHP_EOL;

					$create .= PHP_EOL . $href . PHP_EOL;
					$update .= $href; 
				} elseif ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Multihref) {
					$key_field_u = $this->_object->getUnderscore($key_field) .'_items';

					$multi_href = $this->tab(3) .'$'. $key_field_u .' = [];'. PHP_EOL;
					$multi_href .= $this->tab(3) .'for ($i = 0; $i < count($params->'. $key_field .'); $i++) {'. PHP_EOL;
					$multi_href .= $this->tab(4) .'$item = DataObject\\AbstractObject::getById($params->'. $key_field .'[$i]);'. PHP_EOL;
					$multi_href .= $this->tab(4) .'array_push($'. $key_field_u .', $item);'. PHP_EOL;
					$multi_href .= $this->tab(3) .'}'. PHP_EOL;
					$multi_href .= $this->tab(3) .'$object->set'. $key_field .'($'. $key_field_u .');'. PHP_EOL;

					$create .= PHP_EOL . $multi_href . PHP_EOL;
					$update .= $multi_href;
				} elseif ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Image) {
					$key_field_u = '$'. $this->_object->getUnderscore($key_field) .'_image';
					$key_field_u_params = $key_field_u .'_params';

					$image = $this->tab(3) . 'if ($params->'. $key_field .') {' . PHP_EOL;
					$image .= $this->tab(4) . $key_field_u .';' . PHP_EOL;
					$image .= $this->tab(4) . $key_field_u_params .' = new \stdClass;' . PHP_EOL;
					$image .= $this->tab(4) . 'if (isset($params->'. $key_field .'[\'tmp_name\'])) {' . PHP_EOL;
					$image .= $this->tab(5) . $key_field_u .' = $params->'. $key_field .';' . PHP_EOL;
					$image .= $this->tab(4) . '} else {' . PHP_EOL;
					$image .= $this->tab(5) . $key_field_u .' = [];' . PHP_EOL;
					$image .= $this->tab(5) . $key_field_u .'[\'Data\'] = $params->'. $key_field .';' . PHP_EOL;
					$image .= $this->tab(5) . $key_field_u .'[\'Name\'] = microtime(true) .\'.jpg\';' . PHP_EOL;
					$image .= $this->tab(5) . $key_field_u_params .'->Type = \'base64\';' . PHP_EOL;
					$image .= $this->tab(4) . '}' . PHP_EOL;
					$image .= $this->tab(4) . $key_field_u_params .'->Path = \''. $field->getUploadPath() .'\';' . PHP_EOL;
					$image .= $this->tab(4) . $key_field_u_params .'->Image = '. $key_field_u .';' . PHP_EOL;
					$image .= $this->tab(4) . '$asset = \\AppHelper\\Asset::uploadFileToAsset('. $key_field_u_params .');' . PHP_EOL;
					$image .= $this->tab(4) . 'if ($asset) {' . PHP_EOL;
					
					$update .= PHP_EOL . $image;
					$update .= $this->tab(5) .'if ($object->'. $key_field .') {'. PHP_EOL;
					$update .= $this->tab(6) .'$object->'. $key_field .'->delete();'. PHP_EOL;
					$update .= $this->tab(5) .'}'. PHP_EOL;
					$update .= $this->tab(5) . '$object->set'. $key_field .'($asset);' . PHP_EOL;
					$update .= $this->tab(4) .'}'. PHP_EOL . $this->tab(3) . '}' . PHP_EOL;

					$image .= $this->tab(5) . '$object->set'. $key_field .'($asset);' . PHP_EOL;
					$image .= $this->tab(4) . '}' . PHP_EOL;
					$image .= $this->tab(3) . '}' . PHP_EOL;

					$create .= PHP_EOL . $image . PHP_EOL;

				} elseif ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Video) {
					$key_field_u = '$'. $this->_object->getUnderscore($key_field) .'_data';

					$video = $this->tab(3) . 'if ($params->'. $key_field .') {' . PHP_EOL;
					$video .= $this->tab(4) . $key_field_u .' = new DataObject\\Data\\Video();'. PHP_EOL;
					$video .= $this->tab(4) . $key_field_u .'->setData($params->'. $key_field . ');' . PHP_EOL;
					$video .= $this->tab(4) . $key_field_u .'->setType("youtube");' . PHP_EOL . PHP_EOL;
					$video .= $this->tab(4) . '$object->set'. $key_field .'('.$key_field_u.');' . PHP_EOL;
					$video .= $this->tab(3) . '}' . PHP_EOL;

					$create .= PHP_EOL . $video . PHP_EOL;
					$update .= PHP_EOL . $video . PHP_EOL;

				} elseif ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Geopoint) {
					$key_field_u = $this->_object->getUnderscore($key_field) .'_point';

					$update .= $this->tab(3) .'if ($params->'. $key_field .') {'. PHP_EOL;
					
					$geo_point = '$'. $key_field_u .' = new \\Pimcore\\Model\\DataObject\\Data\\Geopoint($params->'. $key_field .'[\'Longitude\'], $params->'. $key_field .'[\'Latitude\']);';
					$create .= PHP_EOL . $this->tab(3) . $geo_point . PHP_EOL;
					$update .= $this->tab(4) . $geo_point . PHP_EOL;

					$geo_point = '$object->set'. $key_field .'($'. $key_field_u .');';
					$create .= $this->tab(3) . $geo_point . PHP_EOL;
					$update .= $this->tab(4) . $geo_point . PHP_EOL;				

					$update .= $this->tab(3) .'}'. PHP_EOL;
				} elseif ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Link) {
					$key_field_u = $this->_object->getUnderscore($key_field);

					$update .= $this->tab(3) .'if ($params->'. $key_field .') {'. PHP_EOL;

					$link = '$'. $key_field_u .' = new DataObject\\Data\\Link();';
					$create .= PHP_EOL . $this->tab(3) . $link . PHP_EOL;
					$update .= $this->tab(4) . $link . PHP_EOL;

					$link = '$'. $key_field_u .'->setText($params->'. $key_field .'[\'Text\']);';
					$create .= $this->tab(3) . $link . PHP_EOL;
					$update .= $this->tab(4) . $link . PHP_EOL;
					$link = '$'. $key_field_u .'->setPath($params->'. $key_field .'[\'Path\']);';
					$create .= $this->tab(3) . $link . PHP_EOL;
					$update .= $this->tab(4) . $link . PHP_EOL;
					$link = '$'. $key_field_u .'->setTitle($params->'. $key_field .'[\'Title\']);';
					$create .= $this->tab(3) . $link . PHP_EOL;
					$update .= $this->tab(4) . $link . PHP_EOL;

					$link = '$object->set'. $key_field .'($'. $key_field_u .');';
					$create .= $this->tab(3) . $link . PHP_EOL;
					$update .= $this->tab(4) . $link . PHP_EOL;

					$update .= $this->tab(3) .'}'. PHP_EOL;
				} elseif ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Fieldcollections) {
					$key_field_u = $this->_object->getUnderscore($key_field) .'_items';
					$types = $field->getAllowedTypes();
					
					$fc = $this->tab(3) .'if ($params->'. $key_field .') {'. PHP_EOL;
					$fc .= $this->tab(4) .'$'. $key_field_u .' = new DataObject\\Fieldcollection();'. PHP_EOL;
					$fc .= $this->tab(4) .'foreach($params->'. $key_field .' as $key => $value) {'. PHP_EOL;

					if (count($types) > 1) {
						foreach ($types as $type) {
							$object_fc = include(PIMCORE_CLASS_DIRECTORY ."/fieldcollections/{$type}.php");
							$data_fc = $this->processChildData($object_fc->getLayoutDefinitions());

							$fc .= $this->tab(5) .'if ($value->Type == "' . $type .'") {'. PHP_EOL;
							$fc .= $this->tab(6) .'$item = new DataObject\\Fieldcollection\\Data\\'. $type .'();'. PHP_EOL;
								
							foreach ($data_fc as $key_data_fc => $value_data_fc) {
								$array_key = '$value[\''. $value_data_fc->getName() .'\']';
								if ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Href) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$fc .= $this->tab(7) .'if ('. $array_key .') {'. PHP_EOL;
									$fc .= $this->tab(8) . $key_data_fc_u .' = DataObject\\AbstractObject::getById('. $array_key .');'. PHP_EOL;
									$fc .= $this->tab(7) .'if ('. $key_data_fc_u .') {'. PHP_EOL;
									$fc .= $this->tab(8) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u .');'. PHP_EOL;
									$fc .= $this->tab(7) .'}'. PHP_EOL . $this->tab(6) .'}'. PHP_EOL;
								} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Multihref) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$key_data_fc_u_ = $key_data_fc_u .'_multi_href';
									$fc .= $this->tab(6) . $key_data_fc_u_ .' = [];'. PHP_EOL;
									$fc .= $this->tab(6) .'for ($i = 0; $i < count('. $array_key .'); $i++) {'. PHP_EOL;
									$fc .= $this->tab(7) . $key_data_fc_u .' = DataObject\\AbstractObject::getById('. $array_key .'[$i]);'. PHP_EOL;
									$fc .= $this->tab(7) .'if ('. $key_data_fc_u .') {'. PHP_EOL;
									$fc .= $this->tab(8) .'array_push('. $key_data_fc_u_ .', '. $key_data_fc_u .');'. PHP_EOL;
									$fc .= $this->tab(7) .'}'. PHP_EOL . $this->tab(6) .'}'. PHP_EOL;
									$fc .= $this->tab(6) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u_ .');'. PHP_EOL;
								} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Image) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$key_field_u_params = $key_data_fc_u .'_params';

									$fc .= PHP_EOL . $this->tab(6) . '$value->Data[\'' . $value_data_fc->getName() .'\'] = base64_encode(file_get_contents($value->Data[\'' . $value_data_fc->getName() .'\']));' . PHP_EOL; 
									$fc .= $this->tab(6) . 'if ($value->Data[\''. $value_data_fc->getName() .'\']) {'. PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image;' . PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image_params = new \stdClass;' . PHP_EOL . PHP_EOL;
									$fc .= $this->tab(7) . 'if (isset($value->Data[\'' . $value_data_fc->getName() .'\'][\'tmp_name\'])) {'. PHP_EOL;
									$fc .= $this->tab(8) . '$thumbnail_image = $value->Data[\'' . $value_data_fc->getName() .'\'];' . PHP_EOL;
									$fc .= $this->tab(7) . '} else {' . PHP_EOL;
									$fc .= $this->tab(8) . '$thumbnail_image = [];' . PHP_EOL;
									$fc .= $this->tab(8) . '$thumbnail_image[\'Data\'] = ' . '$value->Data[\'' . $value_data_fc->getName() .'\']' . ';' . PHP_EOL;
									$fc .= $this->tab(8) . '$thumbnail_image[\'Name\'] = microtime(true) .\'.jpg\';' . PHP_EOL;
									$fc .= $this->tab(8) . '$thumbnail_image_params->Type = \'base64\';' . PHP_EOL;
									$fc .= $this->tab(7) . '}' . PHP_EOL . PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image_params->Path = \'/' . $value_data_fc->getUploadPath() . '\';' . PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image_params->Image = $thumbnail_image;' . PHP_EOL;
									$fc .= $this->tab(7) . '$asset = \AppHelper\Asset::uploadFileToAsset($thumbnail_image_params);' . PHP_EOL . PHP_EOL;
									$fc .= $this->tab(7) . 'if ($asset) {' . PHP_EOL;
									$fc .= $this->tab(8) . '$item->set' .$value_data_fc->getName(). '($asset);' . PHP_EOL;
									$fc .= $this->tab(7) . '}' . PHP_EOL;
									$fc .= $this->tab(6) . '}' . PHP_EOL;

								} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Video) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$fc .= PHP_EOL. $this->tab(6) . $key_data_fc_u .' = new DataObject\\Data\\Video();'. PHP_EOL;
									$fc .= $this->tab(6) . $key_data_fc_u .'->setData($value->Data[\''. $value_data_fc->getName() . '\']);' . PHP_EOL;
									$fc .= $this->tab(6) . $key_data_fc_u .'->setType("youtube");' . PHP_EOL;
									$fc .= $this->tab(6) . '$item->set'. $value_data_fc->getName() .'('.$key_data_fc_u.');' . PHP_EOL;
								} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Geopoint) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$fc .= $this->tab(6) .'if ('. $array_key .') {'. PHP_EOL;
									$fc .= $this->tab(7) . $key_data_fc_u .' = new \\Pimcore\\Model\\DataObject\\Data\\Geopoint('. $array_key .'[\'Longitude\'], '. $array_key .'[\'Latitude\']);'. PHP_EOL;
									$fc .= $this->tab(7) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u .');'. PHP_EOL;
									$fc .= $this->tab(6) .'}'. PHP_EOL;
								} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Link) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$fc .= $this->tab(6) . $key_data_fc_u . ' = new DataObject\\Data\\Link();'. PHP_EOL;
									$fc .= $this->tab(6) . $key_data_fc_u .'->setText($value->Data[\''. $value_data_fc->getName() .'\'][\'Text\']);';
									$fc .= $this->tab(6) . $key_data_fc_u .'->setPath($value->Data[\''. $value_data_fc->getName() .'\'][\'Path\']);';
									$fc .= $this->tab(6) . $key_data_fc_u .'->setTitle($value->Data[\''. $value_data_fc->getName() .'\'][\'Title\']);';
									$fc .= $this->tab(6) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u .');';
								} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Date || $value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\DateTime) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$fc .= $this->tab(6) . $key_data_fc_u .' = new \DateTime($value->Data[\''. $value_data_fc->getName() .'\']);'. PHP_EOL;  
									$fc .= $this->tab(6) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u .');'. PHP_EOL;
								} else {
									$fc .= $this->tab(6) .'$item->set'. $value_data_fc->getName() .'($value->Data[\''. $value_data_fc->getName() .'\']);'. PHP_EOL;
								}
							}

							$fc .= $this->tab(5) .'}'. PHP_EOL;

						}
					} else {
						$type = $types[0];

						$object_fc = include(PIMCORE_CLASS_DIRECTORY ."/fieldcollections/{$type}.php");
						$data_fc = $this->processChildData($object_fc->getLayoutDefinitions());

						$fc .= $this->tab(5) .'$item = new DataObject\\Fieldcollection\\Data\\'. $type .'();'. PHP_EOL;
							
						foreach ($data_fc as $key_data_fc => $value_data_fc) {
							$array_key = '$value[\''. $value_data_fc->getName() .'\']';
							if ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Href) {
								$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
								$fc .= $this->tab(5) .'if ('. $array_key .') {'. PHP_EOL;
								$fc .= $this->tab(6) . $key_data_fc_u .' = DataObject\\AbstractObject::getById('. $array_key .');'. PHP_EOL;
								$fc .= $this->tab(6) .'if ('. $key_data_fc_u .') {'. PHP_EOL;
								$fc .= $this->tab(7) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u .');'. PHP_EOL;
								$fc .= $this->tab(6) .'}'. PHP_EOL . $this->tab(5) .'}'. PHP_EOL;
							} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Multihref) {
								$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
								$key_data_fc_u_ = $key_data_fc_u .'_multi_href';
								$fc .= $this->tab(5) . $key_data_fc_u_ .' = [];'. PHP_EOL;
								$fc .= $this->tab(5) .'for ($i = 0; $i < count('. $array_key .'); $i++) {'. PHP_EOL;
								$fc .= $this->tab(6) . $key_data_fc_u .' = DataObject\\AbstractObject::getById('. $array_key .'[$i]);'. PHP_EOL;
								$fc .= $this->tab(6) .'if ('. $key_data_fc_u .') {'. PHP_EOL;
								$fc .= $this->tab(7) .'array_push('. $key_data_fc_u_ .', '. $key_data_fc_u .');'. PHP_EOL;
								$fc .= $this->tab(6) .'}'. PHP_EOL . $this->tab(5) .'}'. PHP_EOL;
								$fc .= $this->tab(5) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u_ .');'. PHP_EOL;
							} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Image) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$key_field_u_params = $key_data_fc_u .'_params';

									$fc .= PHP_EOL . $this->tab(5) . '$value[\'' . $value_data_fc->getName() .'\'] = base64_encode(file_get_contents($value[\'' . $value_data_fc->getName() .'\']));' . PHP_EOL; 
									$fc .= $this->tab(5) . 'if ($value[\''. $value_data_fc->getName() .'\']) {'. PHP_EOL;
									$fc .= $this->tab(6) . '$thumbnail_image;' . PHP_EOL;
									$fc .= $this->tab(6) . '$thumbnail_image_params = new \stdClass;' . PHP_EOL . PHP_EOL;
									$fc .= $this->tab(6) . 'if (isset($value[\'' . $value_data_fc->getName() .'\'][\'tmp_name\'])) {'. PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image = $value[\'' . $value_data_fc->getName() .'\'];' . PHP_EOL;
									$fc .= $this->tab(6) . '} else {' . PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image = [];' . PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image[\'Data\'] = ' . '$value[\'' . $value_data_fc->getName() .'\']' . ';' . PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image[\'Name\'] = microtime(true) .\'.jpg\';' . PHP_EOL;
									$fc .= $this->tab(7) . '$thumbnail_image_params->Type = \'base64\';' . PHP_EOL;
									$fc .= $this->tab(6) . '}' . PHP_EOL . PHP_EOL;
									$fc .= $this->tab(6) . '$thumbnail_image_params->Path = \'/' . $value_data_fc->getUploadPath() . '\';' . PHP_EOL;
									$fc .= $this->tab(6) . '$thumbnail_image_params->Image = $thumbnail_image;' . PHP_EOL;
									$fc .= $this->tab(6) . '$asset = \AppHelper\Asset::uploadFileToAsset($thumbnail_image_params);' . PHP_EOL . PHP_EOL;
									$fc .= $this->tab(6) . 'if ($asset) {' . PHP_EOL;
									$fc .= $this->tab(7) . '$item->set' .$value_data_fc->getName(). '($asset);' . PHP_EOL;
									$fc .= $this->tab(6) . '}' . PHP_EOL;
									$fc .= $this->tab(5) . '}' . PHP_EOL;

								} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Video) {
									$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
									$fc .= PHP_EOL. $this->tab(5) . $key_data_fc_u .' = new DataObject\\Data\\Video();'. PHP_EOL;
									$fc .= $this->tab(5) . $key_data_fc_u .'->setData($value[\''. $value_data_fc->getName() . '\']);' . PHP_EOL;
									$fc .= $this->tab(5) . $key_data_fc_u .'->setType("youtube");' . PHP_EOL;
									$fc .= $this->tab(5) . '$item->set'. $value_data_fc->getName() .'('.$key_data_fc_u.');' . PHP_EOL;
								} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Geopoint) {
								$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
								$fc .= $this->tab(5) .'if ('. $array_key .') {'. PHP_EOL;
								$fc .= $this->tab(6) . $key_data_fc_u .' = new \\Pimcore\\Model\\DataObject\\Data\\Geopoint('. $array_key .'[\'Longitude\'], '. $array_key .'[\'Latitude\']);'. PHP_EOL;
								$fc .= $this->tab(6) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u .');'. PHP_EOL;
								$fc .= $this->tab(5) .'}'. PHP_EOL;
							} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Link) {
								$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
								$fc .= $this->tab(5) . $key_data_fc_u . ' = new DataObject\\Data\\Link();'. PHP_EOL;
								$fc .= $this->tab(5) . $key_data_fc_u .'->setText($value[\''. $value_data_fc->getName() .'\'][\'Text\']);';
								$fc .= $this->tab(5) . $key_data_fc_u .'->setPath($value[\''. $value_data_fc->getName() .'\'][\'Path\']);';
								$fc .= $this->tab(5) . $key_data_fc_u .'->setTitle($value[\''. $value_data_fc->getName() .'\'][\'Title\']);';
								$fc .= $this->tab(5) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u .');';
							} elseif ($value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Date || $value_data_fc instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\DateTime) {
								$key_data_fc_u = '$item_'. $this->_object->getUnderscore($value_data_fc->getName());
								$fc .= $this->tab(5) . $key_data_fc_u .' = new \DateTime($value[\''. $value_data_fc->getName() .'\']);'. PHP_EOL;  
								$fc .= $this->tab(5) .'$item->set'. $value_data_fc->getName() .'('. $key_data_fc_u .');'. PHP_EOL;
							} else {
								$fc .= $this->tab(5) .'$item->set'. $value_data_fc->getName() .'($value[\''. $value_data_fc->getName() .'\']);'. PHP_EOL;
							}
						}

					}

					$fc .= $this->tab(5) .'$'. $key_field_u .'->add($item);'. PHP_EOL;
					$fc .= $this->tab(4) .'}'. PHP_EOL;
					$fc .= $this->tab(4) .'$object->set'. $key_field .'($'. $key_field_u .');'. PHP_EOL;
					$fc .= $this->tab(3) .'}'. PHP_EOL;

					$create .= PHP_EOL . $fc . PHP_EOL;
					$update .= $fc;
				} elseif ($field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\Date || $field instanceof \Pimcore\Model\DataObject\ClassDefinition\Data\DateTime) {
					$key_field_u = $this->_object->getUnderscore($key_field);

					$temp_date = $this->tab(3) .'if ($params->'. $key_field .') {'. PHP_EOL;

					$date = '$'. $key_field_u .' = new \DateTime($params->'. $key_field .');';
					$temp_date .= $this->tab(4) . $date . PHP_EOL;

					$date = '$object->set'. $key_field .'($'. $key_field_u .');';
					$temp_date .= $this->tab(4) . $date . PHP_EOL;

					$temp_date .= $this->tab(3) .'}'. PHP_EOL;
					
					$create .= $temp_date;
					$update .= $temp_date;
				} else {
					$create .= $this->tab(3) .'$object->set'. $key_field .'($params->'. $key_field .');'. PHP_EOL;
					
					$update .= $this->tab(3) .'if ($params->'. $key_field .') {'. PHP_EOL;
					$update .= $this->tab(4) .'$object->set'. $key_field .'($params->'. $key_field .');'. PHP_EOL;
					$update .= $this->tab(3) .'}'. PHP_EOL;
				}
			}
			$params = rtrim($params, ", ");
			if ($get_all_conditional) {
				$get_all_conditional = PHP_EOL . $get_all_conditional;
			}
			if ($mandatory) {
				$mandatory = PHP_EOL . $mandatory;
			}
			if ($create) {
				$create = PHP_EOL . $create;
			}
			if ($update) {
				$update = PHP_EOL . $update;
			}

			$body = str_replace('{PARAMS}', $params, $body);
			$body = str_replace('{getAll_PARAMS}', $search, $body);
			$body = str_replace('{getAll_CONDITIONAL}', $get_all_conditional, $body);
			$body = str_replace('{Mandatory}', $mandatory, $body);
			$body = str_replace('{OBJECT_PATH}', '/'. $this->_object->getStripe(), $body);
			$body = str_replace('{create_SET_DATA}', $create, $body);
			$body = str_replace('{update_SET_DATA}', $update, $body);
		}


		$this->appendScript($body);
	}

	public function generate($params = null)
	{
		$bundle = $this->bundle;
		$path = PIMCORE_PROJECT_ROOT ."/src/".$bundle."/Model/". $this->_object->getName() .".php";
		if (!file_exists($path) || $this->_overwrite) {
			$file = fopen($path, "w");
			fwrite($file, $this->_script);
			fclose($file);
			return true;
		}
		return false;

	}

	public function isProcessData()
	{
		return true;
	}

	protected function processChildData($parent, $data = [])
	{

		foreach ($parent->getChilds() as $key => $object) {
			if ($object instanceof \Pimcore\Model\DataObject\ClassDefinition\Layout\Panel) {
				$data = array_merge($this->processChildData($object, $data), $data);
			} elseif ($object instanceof \Pimcore\Model\DataObject\ClassDefinition\Layout\Tabpanel) {
				$data = array_merge($this->processChildData($object, $data), $data);
			} else {
				array_push($data, $object);
			}
		}
		return $data;

	}

}