<?php
/**
 * Library for generating Pimcore object class
 * Store detail of object pimcore and data field
 *
 * @author Suhar Prasetyo suhar.tyo@gmail.com
 * @copyright 2017 Dreamcube Id
 * @version 1.0 In development, very unstable
 * @package Website
 * @subpackage Website\Generator
 * @category Library For pimcore and use standard coding by Backend team in Dreamcube Id 
 */

namespace AppHelper\Generator;


class ObjectData
{
	
	/**
	 * ID from database
	 * @var int
	 */
	private $_id;

	/**
	 * Name from database
	 * @var String
	 */
	private $_name;

	/**
	 * Description from database
	 * @var String
	 */
	private $_description;

	/**
	 * Contains child classes of \Pimcore\Model\DataObject\ClassDefinition\Data
	 * @var Hash[Name:\Pimcore\Model\DataObject\ClassDefinition\Data]
	 */
	protected $_data = [];


	function __construct($id, $name, $description)
	{
		$this->_id = $id;
		$this->_name = $name;
		$this->_description = $description;
	}

	/**
	 * Setter ID
	 * 
	 * @param int $id
	 * @return void       
	 */
	public function setId($id)
	{
		$this->_id = $id;
	}

	/**
	 * Setter name
	 * 
	 * @param String $name
	 * @return void       
	 */
	public function setName($name)
	{
		$this->_name = $name;
	}

	/**
	 * Setter description
	 * 
	 * @param String $description
	 * @return void       
	 */
	public function setDescription($description)
	{
		$this->_description = $description;
	}

	/**
	 * Setter data
	 * 
	 * @param Hash[Name:\Pimcore\Model\DataObject\ClassDefinition\Data] $data
	 * @return void       
	 */
	public function setData(array $data)
	{
		$this->_data = $data;
	}

	/**
	 * Getter ID
	 * 
	 * @return int
	 */
	public function getId()
	{
		return $this->_id;
	}

	/**
	 * Getter name
	 * 
	 * @return String
	 */
	public function getName()
	{
		return $this->_name;
	}

	/**
	 * Getter description
	 * 
	 * @return String
	 */
	public function getDescription()
	{
		return $this->_description;
	}

	/**
	 * Getter data
	 * 
	 * @return Hash[Name:\Pimcore\Model\DataObject\ClassDefinition\Data]
	 */
	public function getData()
	{
		return $this->_data;
	}

	/**
	 * Convert name to stripe
	 * 
	 * @return String
	 */
	public function getStripe($string = null)
	{
		if (!$string) $string = $this->_name;
		return strtolower(preg_replace(["/([A-Z]+)/", "/_([A-Z]+)([A-Z][a-z])/"], ["-$1", "-$1-$2"], lcfirst($string)));
	}

	/**
	 * Convert name to stripe
	 * 
	 * @return String
	 */
	public function getUnderscore($string = null)
	{
		if (!$string) $string = $this->_name;
		return strtolower(preg_replace(["/([A-Z]+)/", "/_([A-Z]+)([A-Z][a-z])/"], ["_$1", "_$1_$2"], lcfirst($string)));
	}

	/**
	 * Add data to model
	 * 
	 * @param \Model\DataObject\ClassDefinition\Data $data  
	 * @return void
	 */
	public function addData(\Pimcore\Model\DataObject\ClassDefinition\Data $data)
	{
		$this->_data[$data->getName()] = $data;
	}

	/**
	 * Remove data from model by data name
	 * 
	 * @param  String $name 
	 * @return void       
	 */
	public function removeData(String $name)
	{
		if (isset($this->_data[$name])) unset($this->_data[$name]);
	}

}