<?php
/**
* Manager
* For Accessing Data
* @author Suhar Prasetyo suhar.tyo@gmail.com
*/

namespace AppHelper;

class Manager implements \Iterator
{
	
	public static $DisallowParameter = ['Limit', 'Offset', 'SortBy', 'SortType'];
	public $Data = null;
	public $Message = '';
	public $Status = 0;

	protected $_additional_property = [];
	protected $_pimcore_attibutes = [
		'o_classId',
		'o_className',
		'lazyLoadedFields',
		'o_class',
		'o_versions',
		'o___loadedLazyFields',
		'scheduledTasks',
		'o_type',
		'o_userOwner',
		'o_userModification',
		'o_properties',
		'o_hasChilds',
		'o_siblings',
		'o_hasSiblings',
		'o_dependencies',
		'o_childs',
		'o_locked',
		'o_index',
		'o_published',
		'o_parentId',
		'o_parent',
		'o_key',
		'o_path',
		'o_index',
		'o_creationDate',
		'o_modificationDate',
		'o_elementAdminStyle',
		'____pimcore_cache_item__',
	];


	public function ToJson()
	{
		return json_encode($this->Load(), JSON_PARTIAL_OUTPUT_ON_ERROR);
	}

	public function CleanPimcoreAttributes(&$data, $curr_depth, $depth)
	{

		$pimcore_attibutes = $this->_pimcore_attibutes;

		if (is_array($data)) {			
			foreach ($pimcore_attibutes as $pimcore_attibute) {
                unset($data[$attribute]);
                foreach($data as &$value) {
                    if(is_array($value)) {
                        if($curr_depth != $depth) {
                            $this->cleanPimcoreAttributes($value, $curr_depth + 1, $depth);
                        } else {
                            unset($value[$attribute]);
                        }
                    }
                }
            }			
		} elseif (is_object($data)) {
			foreach ($pimcore_attibutes as $pimcore_attibute) {
				unset($data->{$pimcore_attibute});
			}
			foreach ($data as $key => $value) {
				if (is_object($value) || is_array($value)) {
					if ($curr_depth != $depth) {
						$this->CleanPimcoreAttributes($value, $curr_depth + 1, $depth);
					} else {
						unset($data->{$key});
					}
				}
			}
		}

	}

	public function Load($remove_pimcore_attribute = false, $depth = -1)
	{

		$data = $this->Data;

		if ($remove_pimcore_attribute === true) {
			$data = json_encode($data, JSON_PARTIAL_OUTPUT_ON_ERROR);
			$data = json_decode($data);
			$this->CleanPimcoreAttributes($data, 0, $depth);
		}

		$return = new \stdClass;
		$return->Message = $this->Message;
		$return->Status = $this->Status;
		if (count($this->_additional_property)) {
			foreach ($this->_additional_property as $key => $value) {
				$return->$key = $value;
			}
		}
		$return->Data = \AppHelper\General::objectToArray($data);

		return (array) $return;
	}

	public function Get($index = 0)
	{
		return $this->Data[$index];
	}

	public function AddPimcoreAttribute($attribute)
	{
		array_push($this->_pimcore_attibutes, $attribute);
	}

	public function RemovePimcoreAttribute($attribute)
	{
		$this->_pimcore_attibutes = array_diff($this->_pimcore_attibutes, [$attribute]);
	}

	// Using magic method to set get additional property
	
	public function __set($key, $value)
	{
		$this->_additional_property[$key] = $value;
	}

	public function __get($key)
	{
		return $this->_additional_property[$key];
	}

	// Implements all interface from Iterator

	public function __construct($data = [])
    {
        if (is_array($data)) {
            $this->Data = $data;
        } else {
        	$this->Data = [];
        }
    }

    public function rewind()
    {
        reset($this->Data);
    }
  
    public function current()
    {
        $data = current($this->Data);
        return $data;
    }
  
    public function key() 
    {
        $data = key($this->Data);
        return $data;
    }
  
    public function next() 
    {
        $data = next($this->Data);
        return $data;
    }
  
    public function valid()
    {
        $key = key($this->Data);
        $data = ($key !== NULL && $key !== FALSE);
        return $data;
    }

}