<?php
/*
	This is for PHP function helper
	Initial by Suhar Prasetyo
*/

namespace AppHelper;

use Lcobucci\JWT\Parser;

/**
* This is helper for handling Session
*/
class Session
{
	
	public static function setSession($key, $value)
    {
        if (session_status() === \PHP_SESSION_NONE) {
            session_start();
        }
        $_SESSION[$key] = $value;       
    }

    public static function getSession($key)
    {
        if (session_status() === \PHP_SESSION_NONE) {
            session_start();
        }
        return $_SESSION[$key];
    }

    public static function removeSession($key)
    {
        if (session_status() === \PHP_SESSION_NONE) {
            session_start();
        }
        unset($_SESSION[$key]);     
    }

    public static function getDataFromToken($auth_token, $key = null)
    {
        $data = null;

        if($auth_token){            
           $data = (new Parser())->parse((string) $auth_token);
           if($key){               
               $data = $data->getClaim($key);
           }
        }

       return $data;
    } 

}