<?php

namespace AppModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;

class EmailBucket {

	public static function get($params = null)
	{

		$return = new Manager();

		$objects = new DataObject\EmailBucket\Listing();

		if ($params->SortBy)
			$objects ->setOrderKey($params->SortBy);
		if ($params->Order)
			$objects ->setOrder($params->Order);		
		if ($params->Limit)
			$objects ->setLimit($params->Limit);		
		if ($params->Condition)		
			$objects ->setCondition($params->Condition);
		$objects = $objects->load();

		if ($objects) {
			$return->Status = 1;
			$return->Data = $objects;
		} else {
			$return->Message = 'Data email tidak ada';
		}

		return $return;

	}

	public static function add($params = null) 
	{

    	$return = new Manager();
		
		$entries = new DataObject\EmailBucket();
		$entries->setActivity($params->Activity);
		$entries->setTo($params->To);
		$entries->setFrom($params->From);
		$entries->setCc($params->Cc);		
		$entries->setBcc($params->Bcc);
		$entries->setTemplate($params->Template);
		$entries->setParams(json_encode($params->Params));
		$entries->setBodyText($params->BodyText ? $params->BodyText : "");
		$entries->setMessage($params->Message);
		$entries->setSubject($params->Subject);
		
		if($params->Delay){
			$entries->setStatus("Pending");
			$entries->setDelay($params->Delay);
		}else {
			$entries->setStatus("Success");
			$entries->setDelay(0);
		}

		if ($params->Attachment) {
			$attachments = [];
			if (is_array($params->Attachment)){
				foreach ($params->Attachment as $key => $att) {
					array_push($attachments, $att);
				}
			} else {
				array_push($attachments, $params->Attachment);
			}

			$entries->setAttachment($attachments);
		}
		
		$namekey = str_replace(' ', '-', $params->Activity).'_'.microtime(true);
		$entries->setKey(\Pimcore\File::getValidFilename($namekey));
		
		$getPath = DataObject\AbstractObject::getByPath('/email-bucket');
		$entries->setParentId ($getPath->o_id);

		$entries->setIndex (0);
		$entries->setPublished (1);

		if($entries->save()) {
			$return->Status = 1;
			$return->Data = $entries;

			if(!$entries->Delay){

				// send email using api
	            $method = "POST";
	            $url = \AppHelper\General::getSiteUrl() . "/api/email-bucket/send-email-by-id";

	            $data = array("id" => $entries->o_id);
            	$sendEmail = \AppHelper\General::CallApi($method, $url, $data, false);
			
			}			
		}
			
		return $return;
		
    }

}