<?php
/**
 * 
 */

namespace AppModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class Sipbos
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object Sipbos
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\Sipbos\Listing();
			
			if ($params->Condition) {
				$objects->setCondition($params->Condition, $params->ConditionArray);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}
	
	/**
	 * Fungsi untuk mengambil Sipbos tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\Sipbos::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk membuat Sipbos baru
	 * 
	 * @param  stdClass $params User, Order, IsFinished, FinishedDate, RvsTerminal, RvsInstrument, OcaiRaw, OcaiClanNowUnit, OcaiClanWantUnit, OcaiClanNowOrganisasi, OcaiClanWantOrganisasi, OcaiHierarchyNowUnit, OcaiHierarchyWantUnit, OcaiHierarchyNowOrganisasi, OcaiHierarchyWantOrganisasi, OcaiMarketNowUnit, OcaiMarketWantUnit, OcaiMarketNowOrganisasi, OcaiMarketWantOrganisasi, OcaiAdhocracyNowUnit, OcaiAdhocracyWantUnit, OcaiAdhocracyNowOrganisasi, OcaiAdhocracyWantOrganisasi, MsaiRaw, MsaiProcess, MsaiClan, MsaiAdhocracy, MsaiMarket, MsaiHierarchy, TypologyOcai, TypologyMsai
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();
				
		
		try {

			// check path of object
			$path = $params->Path ? $params->Path : '/sipbos';
			$exist_path  = \AppHelper\General::checkObjectPath($path, 1);
			if(!$exist_path){
				$return->Message = 'Path object not exist';
				return $return;
			}				
			$object_path = DataObject\AbstractObject::getByPath($path);
			
			// check key name of object 
			$object_key = $params->Key ? $params->Key : microtime(true) .'_'. rand();
		
			// Inisialisasi object
			$object = DataObject\Sipbos::create();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($object_key));
			$object->setParentId($object_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished($params->Published ? $params->Published : 1);

	        // Set data

			if ($params->User) {
				$user = DataObject\AbstractObject::getById($params->User);
				if ($user) {
					$object->setUser($user);
				}
			}

			if ($params->ImportData) {
				$import_data = DataObject\AbstractObject::getById($params->ImportData);
				if ($import_data) {
					$object->setImportData($import_data);
				}
			}

			if ($params->ProjectData) {
				$project_data = DataObject\AbstractObject::getById($params->ProjectData);
				if ($project_data) {
					$object->setProjectData($project_data);
				}
			}

			$object->setOrder($params->Order);
			$object->setRvsFinished($params->IsFinished);
			$object->setOcaiFinished($params->IsFinished);
			$object->setMsaiFinished($params->IsFinished);
			$object->setIsFinished($params->IsFinished);
			if ($params->FinishedDate) {
				$finished_date = new \DateTime($params->FinishedDate);
				$object->setFinishedDate($finished_date);
			}

			$object->setCorrupt($params->Corrupt);
			$object->setNote($params->Note);

			$object->setRvsTerminal($params->RvsTerminal);
			$object->setRvsInstrument($params->RvsInstrument);

			$object->setOcaiRaw($params->OcaiRaw);
			$object->setOcaiClanNowUnit($params->OcaiClanNowUnit);
			$object->setOcaiClanWantUnit($params->OcaiClanWantUnit);
			$object->setOcaiClanNowOrganisasi($params->OcaiClanNowOrganisasi);
			$object->setOcaiClanWantOrganisasi($params->OcaiClanWantOrganisasi);
			$object->setOcaiHierarchyNowUnit($params->OcaiHierarchyNowUnit);
			$object->setOcaiHierarchyWantUnit($params->OcaiHierarchyWantUnit);
			$object->setOcaiHierarchyNowOrganisasi($params->OcaiHierarchyNowOrganisasi);
			$object->setOcaiHierarchyWantOrganisasi($params->OcaiHierarchyWantOrganisasi);
			$object->setOcaiMarketNowUnit($params->OcaiMarketNowUnit);
			$object->setOcaiMarketWantUnit($params->OcaiMarketWantUnit);
			$object->setOcaiMarketNowOrganisasi($params->OcaiMarketNowOrganisasi);
			$object->setOcaiMarketWantOrganisasi($params->OcaiMarketWantOrganisasi);
			$object->setOcaiAdhocracyNowUnit($params->OcaiAdhocracyNowUnit);
			$object->setOcaiAdhocracyWantUnit($params->OcaiAdhocracyWantUnit);
			$object->setOcaiAdhocracyNowOrganisasi($params->OcaiAdhocracyNowOrganisasi);
			$object->setOcaiAdhocracyWantOrganisasi($params->OcaiAdhocracyWantOrganisasi);

			$object->setMsaiRaw($params->MsaiRaw);
			$object->setMsaiProcess($params->MsaiProcess);
			$object->setMsaiClan($params->MsaiClan);
			$object->setMsaiAdhocracy($params->MsaiAdhocracy);
			$object->setMsaiMarket($params->MsaiMarket);
			$object->setMsaiHierarchy($params->MsaiHierarchy);
			$object->setMsaiMte($params->MsaiMte);
			$object->setMsaiMir($params->MsaiMir);
			$object->setMsaiMdo($params->MsaiMdo);
			$object->setMsaiMin($params->MsaiMin);
			$object->setMsaiMfu($params->MsaiMfu);
			$object->setMsaiMci($params->MsaiMci);
			$object->setMsaiMco($params->MsaiMco);
			$object->setMsaiEem($params->MsaiEem);
			$object->setMsaiMcs($params->MsaiMcs);
			$object->setMsaiMac($params->MsaiMac);
			$object->setMsaiMcy($params->MsaiMcy);
			$object->setMsaiMcr($params->MsaiMcr);

			$object->setTypologyOcaiNowUnit($params->setTypologyOcaiNowUnit);
			$object->setTypologyOcaiWantUnit($params->setTypologyOcaiWantUnit);
			$object->setTypologyOcaiNowOrganisasi($params->setTypologyOcaiNowOrganisasi);
			$object->setTypologyOcaiWantOrganisasi($params->setTypologyOcaiWantOrganisasi);
			$object->setTypologyMsai($params->TypologyMsai);

	        if ($object->save()) {
	        	if($params->CreationDate){ 
	        		$date = new \DateTime($params->CreationDate);       		
		        	$object->o_creationDate = $date->getTimestamp();
					$object->save();
	        	}

	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk mengubah data dari Sipbos yang sudah ada
	 * 
	 * @param  stdClass $params Id, User, Order, IsFinished, FinishedDate, RvsTerminal, RvsInstrument, OcaiRaw, OcaiClanNowUnit, OcaiClanWantUnit, OcaiClanNowOrganisasi, OcaiClanWantOrganisasi, OcaiHierarchyNowUnit, OcaiHierarchyWantUnit, OcaiHierarchyNowOrganisasi, OcaiHierarchyWantOrganisasi, OcaiMarketNowUnit, OcaiMarketWantUnit, OcaiMarketNowOrganisasi, OcaiMarketWantOrganisasi, OcaiAdhocracyNowUnit, OcaiAdhocracyWantUnit, OcaiAdhocracyNowOrganisasi, OcaiAdhocracyWantOrganisasi, MsaiRaw, MsaiProcess, MsaiClan, MsaiAdhocracy, MsaiMarket, MsaiHierarchy, TypologyOcai, TypologyMsai
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}
		
		try {

			$object = DataObject\Sipbos::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->User) {
				$user = DataObject\AbstractObject::getById($params->User);
				if ($user) {
					$object->setUser($user);
				}
			}
			if ($params->ImportData) {
				$import_data = DataObject\AbstractObject::getById($params->ImportData);
				if ($import_data) {
					$object->setImportData($import_data);
				}
			}
			if ($params->ProjectData) {
				$project_data = DataObject\AbstractObject::getById($params->ProjectData);
				if ($project_data) {
					$object->setProjectData($project_data);
				}
			}
			if ($params->Order) {
				$object->setOrder($params->Order);
			}
			if ($params->RvsFinished) {
				$object->setRvsFinished($params->RvsFinished);
			}
			if ($params->OcaiFinished) {
				$object->setOcaiFinished($params->OcaiFinished);
			}
			if ($params->MsaiFinished) {
				$object->setMsaiFinished($params->MsaiFinished);
			}
			if ($params->IsFinished) {
				$object->setIsFinished($params->IsFinished);
			}
			if ($params->FinishedDate) {
				$finished_date = new \DateTime($params->FinishedDate);
				$object->setFinishedDate($finished_date);
			}

			if ($params->Corrupt) {
				$object->setCorrupt($params->Corrupt);
			}
			if ($params->Note) {
				$object->setNote($params->Note);
			}

			if ($params->RvsTerminal) {
				$object->setRvsTerminal($params->RvsTerminal);
			}
			if ($params->RvsInstrument) {
				$object->setRvsInstrument($params->RvsInstrument);
			}

			if ($params->OcaiRaw) {
				$object->setOcaiRaw($params->OcaiRaw);
			}
			if ($params->OcaiClanNowUnit) {
				$object->setOcaiClanNowUnit($params->OcaiClanNowUnit);
			}
			if ($params->OcaiClanWantUnit) {
				$object->setOcaiClanWantUnit($params->OcaiClanWantUnit);
			}
			if ($params->OcaiClanNowOrganisasi) {
				$object->setOcaiClanNowOrganisasi($params->OcaiClanNowOrganisasi);
			}
			if ($params->OcaiClanWantOrganisasi) {
				$object->setOcaiClanWantOrganisasi($params->OcaiClanWantOrganisasi);
			}
			if ($params->OcaiHierarchyNowUnit) {
				$object->setOcaiHierarchyNowUnit($params->OcaiHierarchyNowUnit);
			}
			if ($params->OcaiHierarchyWantUnit) {
				$object->setOcaiHierarchyWantUnit($params->OcaiHierarchyWantUnit);
			}
			if ($params->OcaiHierarchyNowOrganisasi) {
				$object->setOcaiHierarchyNowOrganisasi($params->OcaiHierarchyNowOrganisasi);
			}
			if ($params->OcaiHierarchyWantOrganisasi) {
				$object->setOcaiHierarchyWantOrganisasi($params->OcaiHierarchyWantOrganisasi);
			}
			if ($params->OcaiMarketNowUnit) {
				$object->setOcaiMarketNowUnit($params->OcaiMarketNowUnit);
			}
			if ($params->OcaiMarketWantUnit) {
				$object->setOcaiMarketWantUnit($params->OcaiMarketWantUnit);
			}
			if ($params->OcaiMarketNowOrganisasi) {
				$object->setOcaiMarketNowOrganisasi($params->OcaiMarketNowOrganisasi);
			}
			if ($params->OcaiMarketWantOrganisasi) {
				$object->setOcaiMarketWantOrganisasi($params->OcaiMarketWantOrganisasi);
			}
			if ($params->OcaiAdhocracyNowUnit) {
				$object->setOcaiAdhocracyNowUnit($params->OcaiAdhocracyNowUnit);
			}
			if ($params->OcaiAdhocracyWantUnit) {
				$object->setOcaiAdhocracyWantUnit($params->OcaiAdhocracyWantUnit);
			}
			if ($params->OcaiAdhocracyNowOrganisasi) {
				$object->setOcaiAdhocracyNowOrganisasi($params->OcaiAdhocracyNowOrganisasi);
			}
			if ($params->OcaiAdhocracyWantOrganisasi) {
				$object->setOcaiAdhocracyWantOrganisasi($params->OcaiAdhocracyWantOrganisasi);
			}

			if ($params->MsaiRaw) {
				$object->setMsaiRaw($params->MsaiRaw);
			}
			if ($params->MsaiProcess) {
				$object->setMsaiProcess($params->MsaiProcess);
			}
			if ($params->MsaiMte) {
				$object->setMsaiMte($params->MsaiMte);
			}
			if ($params->MsaiMir) {
				$object->setMsaiMir($params->MsaiMir);
			}
			if ($params->MsaiMdo) {
				$object->setMsaiMdo($params->MsaiMdo);
			}
			if ($params->MsaiMin) {
				$object->setMsaiMin($params->MsaiMin);
			}
			if ($params->MsaiMfu) {
				$object->setMsaiMfu($params->MsaiMfu);
			}
			if ($params->MsaiMci) {
				$object->setMsaiMci($params->MsaiMci);
			}
			if ($params->MsaiMco) {
				$object->setMsaiMco($params->MsaiMco);
			}
			if ($params->MsaiEem) {
				$object->setMsaiEem($params->MsaiEem);
			}
			if ($params->MsaiMcs) {
				$object->setMsaiMcs($params->MsaiMcs);
			}
			if ($params->MsaiMac) {
				$object->setMsaiMac($params->MsaiMac);
			}
			if ($params->MsaiMcy) {
				$object->setMsaiMcy($params->MsaiMcy);
			}
			if ($params->MsaiMcr) {
				$object->setMsaiMcr($params->MsaiMcr);
			}
			if ($params->MsaiClan) {
				$object->setMsaiClan($params->MsaiClan);
			}
			if ($params->MsaiAdhocracy) {
				$object->setMsaiAdhocracy($params->MsaiAdhocracy);
			}
			if ($params->MsaiMarket) {
				$object->setMsaiMarket($params->MsaiMarket);
			}
			if ($params->MsaiHierarchy) {
				$object->setMsaiHierarchy($params->MsaiHierarchy);
			}

			if ($params->TypologyOcaiWantUnit) {
				$object->setTypologyOcaiWantUnit($params->TypologyOcaiWantUnit);
			}
			if ($params->TypologyOcaiNowUnit) {
				$object->setTypologyOcaiNowUnit($params->TypologyOcaiNowUnit);
			}
			if ($params->TypologyOcaiWantOrganisasi) {
				$object->setTypologyOcaiWantOrganisasi($params->TypologyOcaiWantOrganisasi);
			}
			if ($params->TypologyOcaiNowOrganisasi) {
				$object->setTypologyOcaiNowOrganisasi($params->TypologyOcaiNowOrganisasi);
			}			
			if ($params->TypologyMsai) {
				$object->setTypologyMsai($params->TypologyMsai);
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}
	
	/**
	 * Fungsi untuk menghapus Sipbos
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}

		try {

			$object = DataObject\Sipbos::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$object->delete();
				$return->Status = 1;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}

	/**
	 * Fungsi untuk menghapus bulk import data 
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function deleteByImportData($params = null) {
		
		$return = new Manager();

		if (!$params->ImportData) {
			$return->Message = 'ID import data kosong';
		}

		try {
			$params->Condition = "ImportData__id = ?";
			$params->ConditionArray = [$params->ImportData];
			$objects = self::getAll($params);

			if($objects->Status){
				foreach ($objects->Data as $key => $obj) {
					if($obj->getUser()){
						$obj->getUser()->delete();	
					}
					$obj->delete();
				}
			} 
			
			$return->Status = 1;
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;
	}

	/**
	 * Fungsi untuk menghapus bulk project data 
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function deleteByProjectData($params = null) {
		
		$return = new Manager();

		if (!$params->ProjectData) {
			$return->Message = 'ID project data kosong';
		}

		try {
			$params->Condition = "ProjectData__id = ?";
			$params->ConditionArray = [$params->ProjectData];
			$objects = self::getAll($params);

			if($objects->Status){
				foreach ($objects->Data as $key => $obj) {
					if($obj->getUser()){
						$obj->getUser()->delete();	
					}
					$obj->delete();
				}
			} 
			
			$return->Status = 1;
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;
	}

	/**
	 * Fungsi untuk prosesing data RVS 
	 * 
	 * @return stdClass	Status, Message, Data
	 */
	public static function processRvs($params = null) {

		$return = new Manager();

    	$user = \AuthenticationModel\User::getById((object)["Id" => $params->User])->Data;

        $params->Order = 1;
        $params->RvsFinished = $params->RvsFinished ? 1 : 0;
        $params->RvsTerminal = $params->Terminal;
        $params->RvsInstrument = $params->Instrument;
        
        $params_exsist = new \stdClass;
        $params_exsist->UserId = $params->User;
        $exist = self::getLastAssessmentByUser($params_exsist);

        if($exist->Status){
        	$params->Id = $exist->Data->o_id;
            $result = self::update($params);
        } else {
	        if(!$params->Path){
		        $now = new \DateTime();	
		        $y = $now->format('Y');
		        $m = $now->format('F');
		        $d = $now->format('d');     
		        $params->Path = '/sipbos/data-assessment/' . $y . '/' . $m . '/' . $d;
	        	
		        $h = $now->format('H');
		        $i = $now->format('i');     
		        $params->Key = $h . '_' . $i . '_' . $user->Email;
	        }        
            $result = self::create($params);
        }

        $return->Status = 1;
        $return->Data = $result->Data;

        return $return;
    }

	/**
	 * Fungsi untuk prosesing data OCAI 
	 * 
	 * @return stdClass	Status, Message, Data
	 */
	public static function processOcai($params = null) {

		$return = new Manager();

    	$user = \AuthenticationModel\User::getById((object)["Id" => $params->User])->Data;

        $params->Order = 1;

        $params->OcaiClanNowUnit = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][0] + $params->OcaiRaw[1][0] + $params->OcaiRaw[2][0] + $params->OcaiRaw[3][0] + $params->OcaiRaw[4][0] + $params->OcaiRaw[5][0]) / 6 );
        $params->OcaiClanWantUnit = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][1] + $params->OcaiRaw[1][1] + $params->OcaiRaw[2][1] + $params->OcaiRaw[3][1] + $params->OcaiRaw[4][1] + $params->OcaiRaw[5][1]) / 6 );
        $params->OcaiClanNowOrganisasi = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][2] + $params->OcaiRaw[1][2] + $params->OcaiRaw[2][2] + $params->OcaiRaw[3][2] + $params->OcaiRaw[4][2] + $params->OcaiRaw[5][2]) / 6 );
        $params->OcaiClanWantOrganisasi = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][3] + $params->OcaiRaw[1][3] + $params->OcaiRaw[2][3] + $params->OcaiRaw[3][3] + $params->OcaiRaw[4][3] + $params->OcaiRaw[5][3]) / 6 );

        $params->OcaiAdhocracyNowUnit = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][4] + $params->OcaiRaw[1][4] + $params->OcaiRaw[2][4] + $params->OcaiRaw[3][4] + $params->OcaiRaw[4][4] + $params->OcaiRaw[5][4]) / 6 );
        $params->OcaiAdhocracyWantUnit = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][5] + $params->OcaiRaw[1][5] + $params->OcaiRaw[2][5] + $params->OcaiRaw[3][5] + $params->OcaiRaw[4][5] + $params->OcaiRaw[5][5]) / 6 );
        $params->OcaiAdhocracyNowOrganisasi = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][6] + $params->OcaiRaw[1][6] + $params->OcaiRaw[2][6] + $params->OcaiRaw[3][6] + $params->OcaiRaw[4][6] + $params->OcaiRaw[5][6]) / 6 );
        $params->OcaiAdhocracyWantOrganisasi = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][7] + $params->OcaiRaw[1][7] + $params->OcaiRaw[2][7] + $params->OcaiRaw[3][7] + $params->OcaiRaw[4][7] + $params->OcaiRaw[5][7]) / 6 );

       	$params->OcaiMarketNowUnit = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][8] + $params->OcaiRaw[1][8] + $params->OcaiRaw[2][8] + $params->OcaiRaw[3][8] + $params->OcaiRaw[4][8] + $params->OcaiRaw[5][8]) / 6 );
       	$params->OcaiMarketWantUnit = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][9] + $params->OcaiRaw[1][9] + $params->OcaiRaw[2][9] + $params->OcaiRaw[3][9] + $params->OcaiRaw[4][9] + $params->OcaiRaw[5][9]) / 6 );
       	$params->OcaiMarketNowOrganisasi = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][10] + $params->OcaiRaw[1][10] + $params->OcaiRaw[2][10] + $params->OcaiRaw[3][10] + $params->OcaiRaw[4][10] + $params->OcaiRaw[5][10]) / 6 );
       	$params->OcaiMarketWantOrganisasi = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][11] + $params->OcaiRaw[1][11] + $params->OcaiRaw[2][11] + $params->OcaiRaw[3][11] + $params->OcaiRaw[4][11] + $params->OcaiRaw[5][11]) / 6 );

       	$params->OcaiHierarchyNowUnit = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][12] + $params->OcaiRaw[1][12] + $params->OcaiRaw[2][12] + $params->OcaiRaw[3][12] + $params->OcaiRaw[4][12] + $params->OcaiRaw[5][12]) / 6 );
       	$params->OcaiHierarchyWantUnit = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][13] + $params->OcaiRaw[1][13] + $params->OcaiRaw[2][13] + $params->OcaiRaw[3][13] + $params->OcaiRaw[4][13] + $params->OcaiRaw[5][13]) / 6 );
       	$params->OcaiHierarchyNowOrganisasi = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][14] + $params->OcaiRaw[1][14] + $params->OcaiRaw[2][14] + $params->OcaiRaw[3][14] + $params->OcaiRaw[4][14] + $params->OcaiRaw[5][14]) / 6 );
       	$params->OcaiHierarchyWantOrganisasi = \AppHelper\General::decimalPlaces( ($params->OcaiRaw[0][15] + $params->OcaiRaw[1][15] + $params->OcaiRaw[2][15] + $params->OcaiRaw[3][15] + $params->OcaiRaw[4][15] + $params->OcaiRaw[5][15]) / 6 );

       	$unit_now = [
				"Clan" => $params->OcaiClanNowUnit,
				"Adhocracy" => $params->OcaiAdhocracyNowUnit,
				"Market" => $params->OcaiMarketNowUnit,
				"Hierarchy" => $params->OcaiHierarchyNowUnit
			];
		arsort($unit_now);
		$params->TypologyOcaiNowUnit = array_keys($unit_now)[0];

       	$unit_want = [
				"Clan" => $params->OcaiClanWantUnit,
				"Adhocracy" => $params->OcaiAdhocracyWantUnit,
				"Market" => $params->OcaiMarketWantUnit,
				"Hierarchy" => $params->OcaiHierarchyWantUnit
			];
		arsort($unit_want);
		$params->TypologyOcaiWantUnit = array_keys($unit_want)[0];

       	$organisasi_now = [
				"Clan" => $params->OcaiClanNowOrganisasi,
				"Adhocracy" => $params->OcaiAdhocracyNowOrganisasi,
				"Market" => $params->OcaiMarketNowOrganisasi,
				"Hierarchy" => $params->OcaiHierarchyNowOrganisasi
			];
		arsort($organisasi_now);
		$params->TypologyOcaiNowOrganisasi = array_keys($organisasi_now)[0];

       	$organisasi_want = [
				"Clan" => $params->OcaiClanWantOrganisasi,
				"Adhocracy" => $params->OcaiAdhocracyWantOrganisasi,
				"Market" => $params->OcaiMarketWantOrganisasi,
				"Hierarchy" => $params->OcaiHierarchyWantOrganisasi
			];
		arsort($organisasi_want);
		$params->TypologyOcaiWantOrganisasi = array_keys($organisasi_want)[0];

        $params_exsist = new \stdClass;
        $params_exsist->UserId = $params->User;
        $exist = self::getLastAssessmentByUser($params_exsist);

        if($exist->Status){
        	$params->Id = $exist->Data->o_id;
            $result = self::update($params);
        } else {
	        if(!$params->Path){
		        $now = new \DateTime();	
		        $y = $now->format('Y');
		        $m = $now->format('F');
		        $d = $now->format('d');     
		        $params->Path = '/sipbos/data-assessment/' . $y . '/' . $m . '/' . $d;
	        	
		        $h = $now->format('H');
		        $i = $now->format('i');     
		        $params->Key = $h . '_' . $i . '_' . $user->Email;
	        }        
            $result = self::create($params);
        }

        $return->Status = 1;
        $return->Data = $result->Data;

        return $return;
    }    

	/**
	 * Fungsi untuk prosesing data OCAI 
	 * 
	 * @return stdClass	Status, Message, Data
	 */
	public static function processMsai($params = null) {

		$return = new Manager();

    	$user = \AuthenticationModel\User::getById((object)["Id" => $params->User])->Data;

        $params->Order = 1;

        if($params->MsaiFinished){
        	$params->IsFinished = 1;
        	if(!$params->FinishedDate) $params->FinishedDate = 'now';
        }

        // ENHANCE CALCULATE MSAI (ADD 10 Question) ================================================================
    	$mte = self::geometricMean([$params->MsaiRaw[17][4], $params->MsaiRaw[11][4], $params->MsaiRaw[20][4], $params->MsaiRaw[21][4], $params->MsaiRaw[48][4], $params->MsaiRaw[60][4], $params->MsaiRaw[75][4]]);
    	$mir = self::geometricMean([$params->MsaiRaw[0][4], $params->MsaiRaw[12][4], $params->MsaiRaw[22][4], $params->MsaiRaw[47][4], $params->MsaiRaw[61][4], $params->MsaiRaw[76][4], $params->MsaiRaw[49][4]]);
    	$mdo = self::geometricMean([$params->MsaiRaw[4][4], $params->MsaiRaw[19][4], $params->MsaiRaw[23][4], $params->MsaiRaw[24][4], $params->MsaiRaw[46][4], $params->MsaiRaw[62][4], $params->MsaiRaw[77][4], $params->MsaiRaw[2][4], $params->MsaiRaw[72][4]]);
    	$min = self::geometricMean([$params->MsaiRaw[7][4], $params->MsaiRaw[8][4], $params->MsaiRaw[25][4], $params->MsaiRaw[50][4], $params->MsaiRaw[63][4], $params->MsaiRaw[1][4], $params->MsaiRaw[78][4]]);
    	$mfu = self::geometricMean([$params->MsaiRaw[13][4], $params->MsaiRaw[26][4], $params->MsaiRaw[27][4], $params->MsaiRaw[44][4], $params->MsaiRaw[45][4], $params->MsaiRaw[64][4], $params->MsaiRaw[74][4], $params->MsaiRaw[79][4]]);
    	$mci = self::geometricMean([$params->MsaiRaw[28][4], $params->MsaiRaw[43][4], $params->MsaiRaw[51][4], $params->MsaiRaw[52][4], $params->MsaiRaw[58][4], $params->MsaiRaw[65][4], $params->MsaiRaw[80][4], $params->MsaiRaw[72][4]]);
    	$mco = self::geometricMean([$params->MsaiRaw[14][4], $params->MsaiRaw[29][4], $params->MsaiRaw[34][4], $params->MsaiRaw[42][4], $params->MsaiRaw[59][4], $params->MsaiRaw[66][4], $params->MsaiRaw[81][4], $params->MsaiRaw[6][4], $params->MsaiRaw[73][4]]);
    	$eem = self::geometricMean([$params->MsaiRaw[5][4], $params->MsaiRaw[30][4], $params->MsaiRaw[41][4], $params->MsaiRaw[67][4], $params->MsaiRaw[82][4], $params->MsaiRaw[74][4]]);
    	$mcs = self::geometricMean([$params->MsaiRaw[31][4], $params->MsaiRaw[32][4], $params->MsaiRaw[40][4], $params->MsaiRaw[53][4], $params->MsaiRaw[54][4], $params->MsaiRaw[68][4], $params->MsaiRaw[83][4]]);
    	$mac = self::geometricMean([$params->MsaiRaw[9][4], $params->MsaiRaw[10][4], $params->MsaiRaw[33][4], $params->MsaiRaw[39][4], $params->MsaiRaw[55][4], $params->MsaiRaw[69][4], $params->MsaiRaw[84][4]]);
    	$mcy = self::geometricMean([$params->MsaiRaw[3][4], $params->MsaiRaw[15][4], $params->MsaiRaw[18][4], $params->MsaiRaw[35][4], $params->MsaiRaw[38][4], $params->MsaiRaw[70][4], $params->MsaiRaw[85][4]]);
    	$mcr = self::geometricMean([$params->MsaiRaw[16][4], $params->MsaiRaw[36][4], $params->MsaiRaw[37][4], $params->MsaiRaw[56][4], $params->MsaiRaw[57][4], $params->MsaiRaw[71][4], $params->MsaiRaw[86][4], $params->MsaiRaw[73][4]]);
        // ENHANCE CALCULATE MSAI (ADD 10 Question) ================================================================

        // ORIGINAL CALCULATE MSAI ================================================================    	
    	// $mte = self::geometricMean([$params->MsaiRaw[17][4], $params->MsaiRaw[11][4], $params->MsaiRaw[20][4], $params->MsaiRaw[21][4], $params->MsaiRaw[48][4], $params->MsaiRaw[60][4], $params->MsaiRaw[75][4]]);
    	// $mir = self::geometricMean([$params->MsaiRaw[0][4], $params->MsaiRaw[12][4], $params->MsaiRaw[22][4], $params->MsaiRaw[47][4], $params->MsaiRaw[61][4], $params->MsaiRaw[76][4]]);
    	// $mdo = self::geometricMean([$params->MsaiRaw[4][4], $params->MsaiRaw[19][4], $params->MsaiRaw[23][4], $params->MsaiRaw[24][4], $params->MsaiRaw[46][4], $params->MsaiRaw[62][4], $params->MsaiRaw[77][4]]);
    	// $min = self::geometricMean([$params->MsaiRaw[7][4], $params->MsaiRaw[8][4], $params->MsaiRaw[25][4], $params->MsaiRaw[50][4], $params->MsaiRaw[63][4]]);
    	// $mfu = self::geometricMean([$params->MsaiRaw[13][4], $params->MsaiRaw[26][4], $params->MsaiRaw[27][4], $params->MsaiRaw[44][4], $params->MsaiRaw[45][4], $params->MsaiRaw[64][4]]);
    	// $mci = self::geometricMean([$params->MsaiRaw[28][4], $params->MsaiRaw[43][4], $params->MsaiRaw[51][4], $params->MsaiRaw[52][4], $params->MsaiRaw[58][4], $params->MsaiRaw[65][4], $params->MsaiRaw[80][4]]);
    	// $mco = self::geometricMean([$params->MsaiRaw[14][4], $params->MsaiRaw[29][4], $params->MsaiRaw[34][4], $params->MsaiRaw[42][4], $params->MsaiRaw[59][4], $params->MsaiRaw[66][4], $params->MsaiRaw[81][4]]);
    	// $eem = self::geometricMean([$params->MsaiRaw[5][4], $params->MsaiRaw[30][4], $params->MsaiRaw[41][4], $params->MsaiRaw[67][4], $params->MsaiRaw[82][4]]);
    	// $mcs = self::geometricMean([$params->MsaiRaw[31][4], $params->MsaiRaw[32][4], $params->MsaiRaw[40][4], $params->MsaiRaw[53][4], $params->MsaiRaw[54][4], $params->MsaiRaw[68][4], $params->MsaiRaw[83][4]]);
    	// $mac = self::geometricMean([$params->MsaiRaw[9][4], $params->MsaiRaw[10][4], $params->MsaiRaw[33][4], $params->MsaiRaw[39][4], $params->MsaiRaw[55][4], $params->MsaiRaw[69][4]]);
    	// $mcy = self::geometricMean([$params->MsaiRaw[3][4], $params->MsaiRaw[15][4], $params->MsaiRaw[18][4], $params->MsaiRaw[35][4], $params->MsaiRaw[38][4], $params->MsaiRaw[70][4], $params->MsaiRaw[85][4]]);
    	// $mcr = self::geometricMean([$params->MsaiRaw[16][4], $params->MsaiRaw[36][4], $params->MsaiRaw[37][4], $params->MsaiRaw[56][4], $params->MsaiRaw[57][4], $params->MsaiRaw[71][4], $params->MsaiRaw[86][4]]);
        // ORIGINAL CALCULATE MSAI ================================================================    	

		$params->MsaiProcess = [
				["CLAN", "Managing Team", "MTE", $mte],
				["CLAN", "Managing Interpersonal Relationship", "MIR", $mir],
				["CLAN", "Managing the Development of the Other", "MDO", $mdo],
				["ADHOCRACY", "Managing Innovation", "MIN", $min],
				["ADHOCRACY", "Managing the Future", "MFU",  $mfu],
				["ADHOCRACY", "Managing Continuous Improvement", "MCI", $mci],
				["MARKET", "Managing Competitiveness", "MCO", $mco],
				["MARKET", "Energizing Employee", "EEM", $eem],
				["MARKET", "Managing Customer Service", "MCS", $mcs],
				["HIERARCHY", "Managing Acculturation", "MAC", $mac],
				["HIERARCHY", "Managing the Control System", "MCY", $mcy],
				["HIERARCHY", "Managing Coordination", "MCR", $mcr]
			];        

		$params->MsaiMte = $mte;
		$params->MsaiMir = $mir;
		$params->MsaiMdo = $mdo;
		$params->MsaiMin = $min;
		$params->MsaiMfu = $mfu;
		$params->MsaiMci = $mci;
		$params->MsaiMco = $mco;
		$params->MsaiEem = $eem;
		$params->MsaiMcs = $mcs;
		$params->MsaiMac = $mac;
		$params->MsaiMcy = $mcy;
		$params->MsaiMcr = $mcr;

		$params->MsaiClan = self::geometricMean([$mte, $mir, $mdo]);
		$params->MsaiAdhocracy = self::geometricMean([$min, $mfu, $mci]);
		$params->MsaiMarket = self::geometricMean([$mco, $eem, $mcs]);
		$params->MsaiHierarchy = self::geometricMean([$mac, $mcy, $mcr]);

		$typologys = [
				"Clan" => $params->MsaiClan,
				"Adhocracy" => $params->MsaiAdhocracy,
				"Market" => $params->MsaiMarket,
				"Hierarchy" => $params->MsaiHierarchy
			];
		arsort($typologys);

		$params->TypologyMsai = array_keys($typologys)[0];

        $params_exsist = new \stdClass;
        $params_exsist->UserId = $params->User;
        $exist = self::getLastAssessmentByUser($params_exsist);

        if($exist->Status){
        	$params->Id = $exist->Data->o_id;
            $result = self::update($params);
        } else {
	        if(!$params->Path){
		        $now = new \DateTime();	
		        $y = $now->format('Y');
		        $m = $now->format('F');
		        $d = $now->format('d');     
		        $params->Path = '/sipbos/data-assessment/' . $y . '/' . $m . '/' . $d;
	        	
		        $h = $now->format('H');
		        $i = $now->format('i');     
		        $params->Key = $h . '_' . $i . '_' . $user->Email;
	        }                	
            $result = self::create($params);
        }

        $return->Status = 1;
        $return->Data = $result->Data;

        return $return;
    }    

	/**
	 * Fungsi untuk mengambil last assessment Sipbos by user 
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getLastAssessmentByUser($params = null) {
		
		$return = new Manager();

		if (!$params->UserId) {
			$return->Message = 'ID user kosong';
			return $return;
		}

		try {

	        $params->Condition = "User__id = ?";
	        $params->ConditionArray = [$params->UserId];
	        $params->Limit = 1;
	        $params->SortBy = "o_id";
	        $params->SortType = "Desc";
	        $object = self::getAll($params);			

			if (!$object->Status) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object->Data[0];
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}    


	/**
	 * Fungsi untuk mendapatkan statistik asesmen Sipbos
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getStatistic($params = null) {
		$return = new Manager();

        $params = new \stdClass;
        $params->Condition = "(User__id IS NOT NULL AND User__id <> '')";
        $all = \AppModel\Sipbos::getAll($params);
        $all = $all->Status ? count($all->Data) : 0;

        $params->Condition .= " AND IsFinished = 1";
        $finished = \AppModel\Sipbos::getAll($params);
        $finished = $finished->Status ? count($finished->Data) : 0;

        $ratio = ($all > 0) ? ($finished / $all) * 100 : 0;
        if(is_float($ratio)) $ratio = number_format((float)$ratio, 1, '.', '');

        $return->Status = 1;
        $return->Data = (object) [
        		"Name" => "SIPBOS",
                "All" => $all,
                "Finished" => $finished,
                "Ratio" => $ratio
            ];
		
		return $return;            
	}

	/**
	 * Fungsi untuk mendapatkan statistik asesmen Sipbos
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getCountDataPeriode($params = null) {
		$return = new Manager();

        $day_condition = ""; $week_condition = ""; $month_condition = ""; $year_condition = "";

		$periode = ($params->Periode ? $params->Periode : 4) - 1;
        for($i = $periode ; $i >= 0 ; $i--){
            $date = strtotime('- ' . ($i) . ' day');
            $day_condition .= "sum(day(from_unixtime(o_creationDate)) = " . (date("d", $date))  . " AND month(from_unixtime(o_creationDate)) = " . date("n", $date) . " AND year(from_unixtime(o_creationDate)) = " . date("Y", $date) . ") as '". date("d/m/Y", $date) . "',";

            $date = strtotime('- ' . ($i+1) . ' week') + 86400; // 86400 = 1day
            $date1 = strtotime('- ' . ($i) . ' week');
            $week_condition .= "sum(week(from_unixtime(o_creationDate)) = " . date("W", $date) . " AND year(from_unixtime(o_creationDate)) = " . date("Y", $date) . ") as '". (date("d/m/y", $date) . ' s/d ' . date("d/m/y", $date1)) . "',";

            $date = strtotime('- ' . $i . ' months');
            $month_condition .= "sum(month(from_unixtime(o_creationDate)) = " . date("n", $date) . " AND year(from_unixtime(o_creationDate)) = " . date("Y", $date) . ") as '". date("M/Y", $date) . "',";

            $date = strtotime('- ' . $i . ' year');
            $year_condition .= "sum(year(from_unixtime(o_creationDate)) = " . date("Y", $date) . ") as '". date("Y", $date) . "',";
        }

        $day_condition = substr($day_condition, 0, -1);
        $week_condition = substr($week_condition, 0, -1);
        $month_condition = substr($month_condition, 0, -1);
        $year_condition = substr($year_condition, 0, -1);

        $id_class = \AppHelper\General::getIdByClassName("Sipbos");        
        $table_id = "object_".$id_class;

        $query_d = "                
                select {$day_condition} FROM {$table_id}                
                UNION ALL 
                select {$day_condition} FROM {$table_id} WHERE IsFinished = 1           
            ";

        $query_w = "
                select {$week_condition} FROM {$table_id}
                UNION ALL                
                select {$week_condition} FROM {$table_id} WHERE IsFinished = 1                
            ";


        $query_m = "
                select {$month_condition} FROM {$table_id}
                UNION ALL                
                select {$month_condition} FROM {$table_id} WHERE IsFinished = 1
            ";


        $query_y = "
                select {$year_condition} FROM {$table_id}
                UNION ALL                
                select {$year_condition} FROM {$table_id} WHERE IsFinished = 1
            ";

        $return->Status = 1;
        $return->Data = [
		        'd' => \AppHelper\Mysql::makeQuery($query_d),
		        'w' => \AppHelper\Mysql::makeQuery($query_w),
		        'm' => \AppHelper\Mysql::makeQuery($query_m),
		        'y' => \AppHelper\Mysql::makeQuery($query_y)
        	];

        return $return;
	}

	/**
	 * Fungsi untuk mengambil data object Sipbos untuk kebutuhan server side reporting
	 * 
	 * @return stdClass	Status, Message, Data
	 */
	public static function getReportData($params = null) {
		
		$return = new Manager();

		$age_string = "(YEAR(CURDATE()) - year(from_unixtime(u.Dob)))";
		
		try {

	        $params->Filter = json_decode($params->params_filter);

			if($params->Filter->Name){
				$filter_name = "u.Name like '%{$params->Filter->Name}%'";
			}

			if($params->Filter->Email){
				$filter_email = "u.Email like '%{$params->Filter->Email}%'";
			}

			if($params->Filter->Gender){
				$filter_gender = "";
				foreach ($params->Filter->Gender as $key => $value) {
					$prefix = $filter_gender ? " OR " : "";
					$filter_gender .= $prefix . "u.Gender = '{$value}'";
				}
			}

			if($params->Filter->AgeFrom){
				$filter_age_from .= "{$age_string} >= {$params->Filter->AgeFrom}";
			}

			if($params->Filter->AgeTo){
				$filter_age_to .= "{$age_string} <= {$params->Filter->AgeTo}";
			}

			if($params->Filter->Province){
				$filter_province = "";
				foreach ($params->Filter->Province as $key => $value) {
					$prefix = $filter_province ? " OR " : "";
					$filter_province .= $prefix . "u.Province = '{$value}'";
				}
			}			

			if($params->Filter->City){
				$filter_city = "";
				foreach ($params->Filter->City as $key => $value) {
					$prefix = $filter_city ? " OR " : "";
					$filter_city .= $prefix . "u.City = '{$value}'";
				}
			}

			if($params->Filter->Education){
				$filter_education = "";
				foreach ($params->Filter->Education as $key => $value) {
					$prefix = $filter_education ? " OR " : "";
					$filter_education .= $prefix . "u.Education like '%{$value}%'";
				}
			}

			if($params->Filter->Departement){
				$filter_departement = "u.Departement like '%{$params->Filter->Departement}%'";
			}			

			if($params->Filter->Institute){
				$filter_institute = "u.Institute like '%{$params->Filter->Institute}%'";
			}			

			if($params->Filter->InstituteSection){
				$filter_institute_section = "u.InstituteSection like '%{$params->Filter->InstituteSection}%'";
			}			

			if($params->Filter->Note){
				$filter_note = "a.Note like '%{$params->Filter->Note}%'";
			}			

			if($params->Filter->StartDate){
				$filter_start_date .= "a.o_creationDate >= {$params->Filter->StartDate}";
			}

			if($params->Filter->EndDate){
				$filter_end_date .= "a.o_creationDate <= {$params->Filter->EndDate}";
			}

			if($params->Filter->IsFinished){
				$filter_is_finished = "";
				foreach ($params->Filter->IsFinished as $key => $value) {
					$prefix = $filter_is_finished ? " OR " : "";
					$filter_is_finished .= $prefix . "a.IsFinished = '{$value}'";
				}
			}

			if($params->Filter->Corrupt){
				$filter_corrupt = "";
				foreach ($params->Filter->Corrupt as $key => $value) {
					$prefix = $filter_corrupt ? " OR " : "";
					$filter_corrupt .= $prefix . "a.Corrupt = '{$value}'";
				}
			}

			$where = "where 1";
			$where .= $filter_name ? ($where ? " AND " : "") . "({$filter_name})" : "";  
			$where .= $filter_email ? ($where ? " AND " : "") . "({$filter_email})" : "";  
			$where .= $filter_gender ? ($where ? " AND " : "") . "({$filter_gender})" : "";  
			$where .= $filter_education ? ($where ? " AND " : "") . "({$filter_education})" : "";  
			$where .= $filter_institute ? ($where ? " AND " : "") . "({$filter_institute})" : "";  
			$where .= $filter_institute_section ? ($where ? " AND " : "") . "({$filter_institute_section})" : "";  
			$where .= $filter_departement ? ($where ? " AND " : "") . "({$filter_departement})" : "";  
			$where .= $filter_nip ? ($where ? " AND " : "") . "({$filter_nip})" : "";  
			$where .= $filter_note ? ($where ? " AND " : "") . "({$filter_note})" : "";  
			$where .= $filter_start_date ? ($where ? " AND " : "") . "({$filter_start_date})" : "";  
			$where .= $filter_end_date ? ($where ? " AND " : "") . "({$filter_end_date})" : "";  
			$where .= $filter_is_finished ? ($where ? " AND " : "") . "({$filter_is_finished})" : "";  
			$where .= $filter_corrupt ? ($where ? " AND " : "") . "({$filter_corrupt})" : "";  
			$where .= $filter_age_from ? ($where ? " AND " : "") . "({$filter_age_from})" : "";  
			$where .= $filter_age_to ? ($where ? " AND " : "") . "({$filter_age_to})" : "";  

			$province .= $filter_province ? "({$filter_province})" : "";
			$city .= $filter_city ? ($filter_province ? " OR " : "") . "({$filter_city})" : "";  
			$where .= ($filter_province || $filter_city) ? ($where ? " AND " : "") . "(" . $province . $city . ")" : "";

			$select = "select u.Name, 
				u.Email, 
				a.o_creationDate,
				a.TypologyOcaiNowUnit,
				a.TypologyOcaiWantUnit,
				a.TypologyOcaiNowOrganisasi,
				a.TypologyOcaiWantOrganisasi,
				a.TypologyMsai,				 
				a.FinishedDate, 
				{$age_string} AS Age , 
				u.Gender, 
				u.Province, 
				u.City, 
				u.Education,
				u.Institute,
				u.InstituteSection,
				u.Departement,
				a.Note,
				a.IsFinished,
				a.Corrupt,
				a.o_id";			

	        $id_class = \AppHelper\General::getIdByClassName("Sipbos");        
	        $table_sipbos = "object_".$id_class;

	        $id_class = \AppHelper\General::getIdByClassName("User");        
	        $table_user = "object_".$id_class;

            $intLimit = 10;
            $intOffset = 0;
			$intLimit = $params->length ? $params->length : $intLimit;
			$intOffset = $params->start ? $params->start : $intOffset;

			$limit = $intLimit > 0 ? "Limit {$intLimit}" : "";
			$offset = ($intOffset >= 0 && $limit) ? "Offset {$intOffset}" : "";
			$order = "Order By a.o_modificationDate DESC";

	        $query_filtered = "                
	                {$select} 
	                FROM {$table_sipbos} a inner join {$table_user} u on u.o_id = a.user__id               
	                {$where} {$order}
	            ";	        	       	
	       	
	    	$result_filtered = \AppHelper\Mysql::makeQuery("{$query_filtered} {$limit} {$offset}");
			$data = self::getFormatReport((object) ["Object" => $result_filtered]);
			$columns = self::getReportColumn();

            $count['Filtered'] = count(\AppHelper\Mysql::makeQuery("{$query_filtered}"));

            $count['All'] = \AppHelper\Mysql::makeQuery(
            		"select count(a.o_id) AS Total 
            		FROM {$table_sipbos} a inner join {$table_user} u on u.o_id = a.user__id "
            	)[0]['Total'];
							                                    
            $all_id = \AppHelper\Mysql::makeQuery(
            		"select a.o_id 
            		FROM {$table_sipbos} a inner join {$table_user} u on u.o_id = a.user__id
            		{$where}"
            	);            

			$return->Status = 1;
			$return->Data = [
					'data' => $data->Status ? $data->Data : [],
					'recordsTotal' => $count['All'],
					'recordsFiltered' => $count['Filtered'],
					'allId' => implode(',', array_map('current', $all_id))
				];
			
		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}	

	/**
	 * Fungsi untuk mendapatkan kolom untuk report
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getReportColumn($params = null) {
		$return = new Manager();

		try {
			$i = 0;
			$columns = [];
						
			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => '<div class=\"pl-4 \"><input class=\"form-check-input my-0 checkbox_all_data\" type=\"checkbox\" onclick=\"checkboxAllData(this)\" style=\"top:70%\"></div>' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => '' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Name' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Email' ]);
					
			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Mulai Pengisian' ]);
						
			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Selesai Pengisian' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'OCAI UK Saat Ini' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'OCAI UK Diinginkan' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'OCAI Organisasi Saat Ini' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'OCAI Organisasi Diinginkan' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Tipologi MSAI' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Instansi' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Divisi Instansi' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Jabatan' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Usia' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Jenis Kelamin' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Provinsi' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Kota' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pendidikan' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Kualitas Pengisian' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Keterangan' ]);


			$return->Status = 1;
			$return->Data = $columns;			
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;		
	}	

	/**
	 * Fungsi untuk memformat object Sipbos ke format report
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getFormatReport($params = null) {
		$return = new Manager();

		if (!$params->Object) {
			$return->Message = 'Object kosong';
		}

		try {
			$data = [];
			$all_id = [];
		
			foreach($params->Object as $key => $val){
				$temp_data = [];				
				$i = 0;
				
				$temp_data['data' . $i++] = "<div class='pl-4'><input class='form-check-input checkbox_data' type='checkbox' value='{$val['o_id']}' onclick='checkboxDataCallback(this)'></div>";
				$temp_data['data' . $i++] = "<a href='/sa/sipbos/resume?q={$val['o_id']}' target='_blank' title='View Detail'><button class='btn btn-info text-light'><i class='fas fa-search'></i></button></a>";
				$temp_data['data' . $i++] = $val['Name'];
				$temp_data['data' . $i++] = $val['Email'];
				$temp_data['data' . $i++] = \AppHelper\General::indonesiaDate($val['o_creationDate'], 'd F Y H:i');
				$temp_data['data' . $i++] = $val['FinishedDate'] ? \AppHelper\General::indonesiaDate($val['FinishedDate'], 'd F Y H:i') : '---';
				$temp_data['data' . $i++] = $val['TypologyOcaiNowUnit'] ? $val['TypologyOcaiNowUnit'] : '---';
				$temp_data['data' . $i++] = $val['TypologyOcaiWantUnit'] ? $val['TypologyOcaiWantUnit'] : '---';
				$temp_data['data' . $i++] = $val['TypologyOcaiNowOrganisasi'] ? $val['TypologyOcaiNowOrganisasi'] : '---';
				$temp_data['data' . $i++] = $val['TypologyOcaiWantOrganisasi'] ? $val['TypologyOcaiWantOrganisasi'] : '---';
				$temp_data['data' . $i++] = $val['TypologyMsai'] ? $val['TypologyMsai'] : '---';
				$temp_data['data' . $i++] = $val['Institute'] ? $val['Institute'] : '---';
				$temp_data['data' . $i++] = $val['InstituteSection'] ? $val['InstituteSection'] : '---';
				$temp_data['data' . $i++] = $val['Departement'] ? $val['Departement'] : '---';
				$temp_data['data' . $i++] = $val['Age'] ? $val['Age'] : '---';
				$temp_data['data' . $i++] = $val['Gender'] ? $val['Gender'] : '---';
				$temp_data['data' . $i++] = $val['Province'] ? $val['Province'] : '---';
				$temp_data['data' . $i++] = $val['City'] ? $val['City'] : '---';
				$temp_data['data' . $i++] = $val['Education'] ? $val['Education'] : '---';
				$temp_data['data' . $i++] = $val['IsFinished'] ? ($val['Corrupt'] ? 'Kurang Baik' : 'Baik')  : '---';
				$temp_data['data' . $i++] = $val['Note'] ? $val['Note'] : '---';
								
				array_push($data, $temp_data);
				array_push($all_id, $val['o_id']);
			}	

			$return->Status = 1;
			$return->Data = $data;			
			$return->AllId = $all_id;			
		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		return $return;
	}	

	public static function geometricMean($a) {
        foreach($a as $i=>$n){
            if($n > 0){
                $mul = $i == 0 ? $n : $mul*$n;              
            }
        } 
        return \AppHelper\General::decimalPlaces(pow($mul,1/count($a)));	
    }

}
