<?php
/**
 * 
 */

namespace AppModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class Sipmas
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object Sipmas
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\Sipmas\Listing();
			
			if ($params->Condition) {
				$objects->setCondition($params->Condition, $params->ConditionArray);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}
	
	/**
	 * Fungsi untuk mengambil Sipmas tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\Sipmas::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk membuat Sipmas baru
	 * 
	 * @param  stdClass $params User, Order, IsFinished, DataRaw, ElementResult, PillarResult, OrganizationDevelopment, PersonnelAdministration, Recruitment, WorkManagement, CompetencyManagement, HrDevelopment, Payroll
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();
		
		if (!$params->Order) {
			$return->Message = 'Order kosong';
			return $return;
		}
		
		
		try {

			// check path of object
			$path = $params->Path ? $params->Path : '/sipmas';
			$exist_path  = \AppHelper\General::checkObjectPath($path, 1);
			if(!$exist_path){
				$return->Message = 'Path object not exist';
				return $return;
			}				
			$object_path = DataObject\AbstractObject::getByPath($path);
			
			// check key name of object 
			$object_key = $params->Key ? $params->Key : microtime(true) .'_'. rand();
		
			// Inisialisasi object
			$object = DataObject\Sipmas::create();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($object_key));
			$object->setParentId($object_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished($params->Published ? $params->Published : 1);

	        // Set data

			if ($params->User) {
				$user = DataObject\AbstractObject::getById($params->User);
				if ($user) {
					$object->setUser($user);
				}
			}

			if ($params->ImportData) {
				$import_data = DataObject\AbstractObject::getById($params->ImportData);
				if ($import_data) {
					$object->setImportData($import_data);
				}
			}

			if ($params->ProjectData) {
				$project_data = DataObject\AbstractObject::getById($params->ProjectData);
				if ($project_data) {
					$object->setProjectData($project_data);
				}
			}

			$object->setOrder($params->Order);
			$object->setIsFinished($params->IsFinished);
			$object->setDataRaw($params->DataRaw);
			$object->setElementResult($params->ElementResult);
			$object->setPillarResult($params->PillarResult);
			$object->setPillar1($params->Pillar1);
			$object->setPillar2($params->Pillar2);
			$object->setPillar3($params->Pillar3);
			$object->setPillar4($params->Pillar4);
			$object->setPillar5($params->Pillar5);
			$object->setPillar6($params->Pillar6);
			$object->setPillar7($params->Pillar7);

			if ($params->FinishedDate) {
				$finished_date = new \DateTime($params->FinishedDate);
				$object->setFinishedDate($finished_date);
			}

			$object->setCorrupt($params->Corrupt);
			$object->setNote($params->Note);

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk mengubah data dari Sipmas yang sudah ada
	 * 
	 * @param  stdClass $params Id, User, Order, IsFinished, DataRaw, ElementResult, PillarResult, OrganizationDevelopment, PersonnelAdministration, Recruitment, WorkManagement, CompetencyManagement, HrDevelopment, Payroll
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}
		
		try {

			$object = DataObject\Sipmas::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->User) {
				$user = DataObject\AbstractObject::getById($params->User);
				if ($user) {
					$object->setUser($user);
				}
			}
			if ($params->ImportData) {
				$import_data = DataObject\AbstractObject::getById($params->ImportData);
				if ($import_data) {
					$object->setImportData($import_data);
				}
			}
			if ($params->ProjectData) {
				$project_data = DataObject\AbstractObject::getById($params->ProjectData);
				if ($project_data) {
					$object->setProjectData($project_data);
				}
			}
			if ($params->Order) {
				$object->setOrder($params->Order);
			}
			if ($params->IsFinished) {
				$object->setIsFinished($params->IsFinished);
			}
			if ($params->DataRaw) {
				$object->setDataRaw($params->DataRaw);
			}
			if ($params->ElementResult) {
				$object->setElementResult($params->ElementResult);
			}
			if ($params->PillarResult) {
				$object->setPillarResult($params->PillarResult);
			}
			if ($params->Pillar1) {
				$object->setPillar1($params->Pillar1);
			}
			if ($params->Pillar2) {
				$object->setPillar2($params->Pillar2);
			}
			if ($params->Pillar3) {
				$object->setPillar3($params->Pillar3);
			}
			if ($params->Pillar4) {
				$object->setPillar4($params->Pillar4);
			}
			if ($params->Pillar5) {
				$object->setPillar5($params->Pillar5);
			}
			if ($params->Pillar6) {
				$object->setPillar6($params->Pillar6);
			}
			if ($params->Pillar7) {
				$object->setPillar7($params->Pillar7);
			}

			if ($params->FinishedDate) {
				$finished_date = new \DateTime($params->FinishedDate);
				$object->setFinishedDate($finished_date);
			}

			if ($params->Corrupt) {
				$object->setCorrupt($params->Corrupt);
			}
			if ($params->Note) {
				$object->setNote($params->Note);
			}						

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}
	
	/**
	 * Fungsi untuk menghapus Sipmas
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}

		try {

			$object = DataObject\Sipmas::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$object->delete();
				$return->Status = 1;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}

	/**
	 * Fungsi untuk menghapus bulk project data
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function deleteByImportData($params = null) {
		
		$return = new Manager();

		if (!$params->ImportData) {
			$return->Message = 'ID import data kosong';
		}

		try {
			$params->Condition = "ImportData__id = ?";
			$params->ConditionArray = [$params->ImportData];
			$objects = self::getAll($params);

			if($objects->Status){
				foreach ($objects->Data as $key => $obj) {
					if($obj->getUser()){
						$obj->getUser()->delete();	
					}
					$obj->delete();
				}
			} 
			
			$return->Status = 1;
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;
	}

	/**
	 * Fungsi untuk menghapus bulk project data 
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function deleteByProjectData($params = null) {
		
		$return = new Manager();

		if (!$params->ProjectData) {
			$return->Message = 'ID project data kosong';
		}

		try {
			$params->Condition = "ProjectData__id = ?";
			$params->ConditionArray = [$params->ProjectData];
			$objects = self::getAll($params);

			if($objects->Status){
				foreach ($objects->Data as $key => $obj) {
					if($obj->getUser()){
						$obj->getUser()->delete();	
					}
					$obj->delete();
				}
			} 
			
			$return->Status = 1;
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;
	}

	/**
	 * Fungsi untuk menghapus Sipmas
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function calculate($params = null) {

		$return = new Manager();

		if(!isset($params->ElementData)){
			$return->Message = 'Element data empty';
			return $return;
		}

		if(!isset($params->PillarData)){
			$return->Message = 'Pillar data empty';
			return $return;
		}

        $element_data = [];
        foreach ($params->ElementData as $key => $element) {
            $total_score = 0;
            $total_data = count($element);
            foreach ($element as $key_sub => $sub_element) {
                $total_score += $sub_element->Value;
            }

            $score = $total_data > 0 ? ($total_score / $total_data) : 0;
            $temp = [
                $key,
                number_format((float)$score, 2, '.', ''),
                $element[0]->Pillar                    
            ];

            array_push($element_data, $temp);
        }

        $pillar_data = [];
        foreach ($params->PillarData as $key => $pillar) {
            $total_score = 0;
            $total_data = count($pillar);
            foreach ($pillar as $key_sub => $sub_pillar) {
                $total_score += $sub_pillar->Value;
            }

            $score = $total_data > 0 ? ($total_score / $total_data) : 0;
            $temp = [
                $key,
                number_format((float)$score, 2, '.', '')                    
            ];

            array_push($pillar_data, $temp);
        }

        $data = [
            'ElementResult' => $element_data,
            'PillarResult' => $pillar_data
        ];

        if($params->Save){
        	$user = \AuthenticationModel\User::getById((object)["Id" => $params->User])->Data;

            $now = new \DateTime();

            $y = $now->format('Y');
            $m = $now->format('F');
            $d = $now->format('d');     
            $params->Path = '/sipmas/data-assessment/' . $y . '/' . $m . '/' . $d;
            
            $h = $now->format('H');
            $i = $now->format('i');     
            $params->Key = $h . '_' . $i . '_' . $user->Email;

            $params->ElementResult = $data['ElementResult'];
            $params->PillarResult = $data['PillarResult'];

            $params->Order = 1;
            $params->IsFinished = $params->IsFinished ? 1 : 0;
            
            if($params->IsFinished)
            	$params->FinishedDate = 'now';

            // simpan per pilar
            foreach ($data['PillarResult'] as $key => $value) {
            	$key = "Pillar".($key+1); 
            	$params->$key = $value[1];
            }

            $params_exsist = new \stdClass;
            $params_exsist->UserId = $params->User;
            $exist = self::getLastAssessmentByUser($params_exsist);

            if($exist->Status){
            	$params->Id = $exist->Data->o_id;
	            $result = self::update($params);
            } else {
	            $result = self::create($params);
            }

            $data = $result->Data;
        }

        $return->Status = 1;
        $return->Data = $data;

        return $return;
    }

	/**
	 * Fungsi untuk mengambil last assessment Sipmas by user 
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getLastAssessmentByUser($params = null) {
		
		$return = new Manager();

		if (!$params->UserId) {
			$return->Message = 'ID user kosong';
			return $return;
		}

		try {

	        $params->Condition = "User__id = ?";
	        $params->ConditionArray = [$params->UserId];
	        $params->Limit = 1;
	        $params->SortBy = "o_id";
	        $params->SortType = "Desc";
	        $object = self::getAll($params);			

			if (!$object->Status) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object->Data[0];
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}    


	/**
	 * Fungsi untuk mendapatkan statistik asesmen Sipmas
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getStatistic($params = null) {
		$return = new Manager();

        $params = new \stdClass;
        $params->Condition = "(User__id IS NOT NULL AND User__id <> '')";
        $all = \AppModel\Sipmas::getAll($params);
        $all = $all->Status ? count($all->Data) : 1;

        $params->Condition .= " AND IsFinished = 1";
        $finished = \AppModel\Sipmas::getAll($params);
        $finished = $finished->Status ? count($finished->Data) : 1;

        $ratio = ($finished / $all) * 100;
        if(is_float($ratio)) $ratio = number_format((float)$ratio, 1, '.', '');

        $return->Status = 1;
        $return->Data = (object) [
        		"Name" => "SIPMAS",
                "All" => $all,
                "Finished" => $finished,
                "Ratio" => $ratio
            ];
		
		return $return;            
	}

	/**
	 * Fungsi untuk mendapatkan statistik asesmen Sipmas
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getCountDataPeriode($params = null) {
		$return = new Manager();

        $day_condition = ""; $week_condition = ""; $month_condition = ""; $year_condition = "";

		$periode = ($params->Periode ? $params->Periode : 4) - 1;
        for($i = $periode ; $i >= 0 ; $i--){
            $date = strtotime('- ' . $i . ' day');
            $day_condition .= "sum(day(from_unixtime(o_creationDate)) = " . date("d", $date)  . " AND month(from_unixtime(o_creationDate)) = " . date("n", $date) . " AND year(from_unixtime(o_creationDate)) = " . date("Y", $date) . ") as '". date("d/m/Y", $date) . "',";

            $date = strtotime('- ' . ($i+1) . ' week') + 86400; // 86400 = 1day
            $date1 = strtotime('- ' . ($i) . ' week');
            $week_condition .= "sum(week(from_unixtime(o_creationDate)) = " . date("W", $date) . " AND year(from_unixtime(o_creationDate)) = " . date("Y", $date) . ") as '". (date("d/m/y", $date) . ' s/d ' . date("d/m/y", $date1)) . "',";

            $date = strtotime('- ' . $i . ' months');
            $month_condition .= "sum(month(from_unixtime(o_creationDate)) = " . date("n", $date) . " AND year(from_unixtime(o_creationDate)) = " . date("Y", $date) . ") as '". date("M/Y", $date) . "',";

            $date = strtotime('- ' . $i . ' year');
            $year_condition .= "sum(year(from_unixtime(o_creationDate)) = " . date("Y", $date) . ") as '". date("Y", $date) . "',";
        }

        $day_condition = substr($day_condition, 0, -1);
        $week_condition = substr($week_condition, 0, -1);
        $month_condition = substr($month_condition, 0, -1);
        $year_condition = substr($year_condition, 0, -1);

        $id_class = \AppHelper\General::getIdByClassName("Sipmas");        
        $table_id = "object_".$id_class;

        $query_d = "                
                select {$day_condition} FROM {$table_id}                
                UNION ALL 
                select {$day_condition} FROM {$table_id} WHERE IsFinished = 1           
            ";

        $query_w = "
                select {$week_condition} FROM {$table_id}
                UNION ALL                
                select {$week_condition} FROM {$table_id} WHERE IsFinished = 1                
            ";


        $query_m = "
                select {$month_condition} FROM {$table_id}
                UNION ALL                
                select {$month_condition} FROM {$table_id} WHERE IsFinished = 1
            ";


        $query_y = "
                select {$year_condition} FROM {$table_id}
                UNION ALL                
                select {$year_condition} FROM {$table_id} WHERE IsFinished = 1
            ";

        $return->Status = 1;
        $return->Data = [
		        'd' => \AppHelper\Mysql::makeQuery($query_d),
		        'w' => \AppHelper\Mysql::makeQuery($query_w),
		        'm' => \AppHelper\Mysql::makeQuery($query_m),
		        'y' => \AppHelper\Mysql::makeQuery($query_y)
        	];

        return $return;
	}

	/**
	 * Fungsi untuk mengambil data object Sipmas untuk kebutuhan server side reporting
	 * 
	 * @return stdClass	Status, Message, Data
	 */
	public static function getReportData($params = null) {
		
		$return = new Manager();

		$age_string = "(YEAR(CURDATE()) - year(from_unixtime(u.Dob)))";
		
		try {

	        $params->Filter = json_decode($params->params_filter);

			if($params->Filter->Name){
				$filter_name = "u.Name like '%{$params->Filter->Name}%'";
			}

			if($params->Filter->Email){
				$filter_email = "u.Email like '%{$params->Filter->Email}%'";
			}

			if($params->Filter->Gender){
				$filter_gender = "";
				foreach ($params->Filter->Gender as $key => $value) {
					$prefix = $filter_gender ? " OR " : "";
					$filter_gender .= $prefix . "u.Gender = '{$value}'";
				}
			}

			if($params->Filter->AgeFrom){
				$filter_age_from .= "{$age_string} >= {$params->Filter->AgeFrom}";
			}

			if($params->Filter->AgeTo){
				$filter_age_to .= "{$age_string} <= {$params->Filter->AgeTo}";
			}

			if($params->Filter->Province){
				$filter_province = "";
				foreach ($params->Filter->Province as $key => $value) {
					$prefix = $filter_province ? " OR " : "";
					$filter_province .= $prefix . "u.Province = '{$value}'";
				}
			}			

			if($params->Filter->City){
				$filter_city = "";
				foreach ($params->Filter->City as $key => $value) {
					$prefix = $filter_city ? " OR " : "";
					$filter_city .= $prefix . "u.City = '{$value}'";
				}
			}

			if($params->Filter->Education){
				$filter_education = "";
				foreach ($params->Filter->Education as $key => $value) {
					$prefix = $filter_education ? " OR " : "";
					$filter_education .= $prefix . "u.Education like '%{$value}%'";
				}
			}

			if($params->Filter->Departement){
				$filter_departement = "u.Departement like '%{$params->Filter->Departement}%'";
			}			

			if($params->Filter->Institute){
				$filter_institute = "u.Institute like '%{$params->Filter->Institute}%'";
			}			

			if($params->Filter->InstituteSection){
				$filter_institute_section = "u.InstituteSection like '%{$params->Filter->InstituteSection}%'";
			}			

			if($params->Filter->Note){
				$filter_note = "a.Note like '%{$params->Filter->Note}%'";
			}			

			if($params->Filter->StartDate){
				$filter_start_date .= "a.o_creationDate >= {$params->Filter->StartDate}";
			}

			if($params->Filter->EndDate){
				$filter_end_date .= "a.o_creationDate <= {$params->Filter->EndDate}";
			}

			if($params->Filter->IsFinished){
				$filter_is_finished = "";
				foreach ($params->Filter->IsFinished as $key => $value) {
					$prefix = $filter_is_finished ? " OR " : "";
					$filter_is_finished .= $prefix . "a.IsFinished = '{$value}'";
				}
			}

			if($params->Filter->Corrupt){
				$filter_corrupt = "";
				foreach ($params->Filter->Corrupt as $key => $value) {
					$prefix = $filter_corrupt ? " OR " : "";
					$filter_corrupt .= $prefix . "a.Corrupt = '{$value}'";
				}
			}

			$where = "where 1";
			$where .= $filter_name ? ($where ? " AND " : "") . "({$filter_name})" : "";  
			$where .= $filter_email ? ($where ? " AND " : "") . "({$filter_email})" : "";  
			$where .= $filter_gender ? ($where ? " AND " : "") . "({$filter_gender})" : "";  
			$where .= $filter_education ? ($where ? " AND " : "") . "({$filter_education})" : "";  
			$where .= $filter_institute ? ($where ? " AND " : "") . "({$filter_institute})" : "";  
			$where .= $filter_institute_section ? ($where ? " AND " : "") . "({$filter_institute_section})" : "";  
			$where .= $filter_departement ? ($where ? " AND " : "") . "({$filter_departement})" : "";  
			$where .= $filter_note ? ($where ? " AND " : "") . "({$filter_note})" : "";  
			$where .= $filter_corrupt ? ($where ? " AND " : "") . "({$filter_corrupt})" : "";  
			$where .= $filter_nip ? ($where ? " AND " : "") . "({$filter_nip})" : "";  
			$where .= $filter_start_date ? ($where ? " AND " : "") . "({$filter_start_date})" : "";  
			$where .= $filter_end_date ? ($where ? " AND " : "") . "({$filter_end_date})" : "";  
			$where .= $filter_is_finished ? ($where ? " AND " : "") . "({$filter_is_finished})" : "";  
			$where .= $filter_age_from ? ($where ? " AND " : "") . "({$filter_age_from})" : "";  
			$where .= $filter_age_to ? ($where ? " AND " : "") . "({$filter_age_to})" : "";  

			$province .= $filter_province ? "({$filter_province})" : "";
			$city .= $filter_city ? ($filter_province ? " OR " : "") . "({$filter_city})" : "";  
			$where .= ($filter_province || $filter_city) ? ($where ? " AND " : "") . "(" . $province . $city . ")" : "";

			$select = "select u.Name, 
				u.Email, 
				a.o_creationDate, 
				a.FinishedDate, 
				a.Pillar1, 
				a.Pillar2, 
				a.Pillar3, 
				a.Pillar4, 
				a.Pillar5, 
				a.Pillar6, 
				a.Pillar7, 
				{$age_string} AS Age , 
				u.Gender, 
				u.Province, 
				u.City, 
				u.Education,
				u.Institute,
				u.InstituteSection,
				u.Departement,
				a.Note,
				a.IsFinished,
				a.Corrupt,
				a.o_id";			

	        $id_class = \AppHelper\General::getIdByClassName("Sipmas");        
	        $table_sipmas = "object_".$id_class;

	        $id_class = \AppHelper\General::getIdByClassName("User");        
	        $table_user = "object_".$id_class;

            $intLimit = 10;
            $intOffset = 0;
			$intLimit = $params->length ? $params->length : $intLimit;
			$intOffset = $params->start ? $params->start : $intOffset;

			$limit = $intLimit > 0 ? "Limit {$intLimit}" : "";
			$offset = ($intOffset >= 0 && $limit) ? "Offset {$intOffset}" : "";
			$order = "Order By a.o_modificationDate DESC";

	        $query_filtered = "                
	                {$select} 
	                FROM {$table_sipmas} a inner join {$table_user} u on u.o_id = a.user__id               
	                {$where} {$order}
	                {$limit} {$offset}
	            ";

	        $result_filtered = \AppHelper\Mysql::makeQuery($query_filtered);
            $count['Filtered'] = count($result_filtered);

            $count['All'] = \AppHelper\Mysql::makeQuery("select count(*) AS Total FROM {$table_sipmas} a inner join {$table_user} u on u.o_id = a.user__id")[0]['Total'];
							                                    
			$data = self::getFormatReport((object) ["Object" => $result_filtered]);
			$columns = self::getReportColumn();

			$return->Status = 1;
			$return->Data = [
					'data' => $data->Status ? $data->Data : [],
					'recordsTotal' => $count['All'],
					'recordsFiltered' => $count['Filtered'],
					'columns' =>  $columns,
					'allId' => implode(",", $data->AllId)
				];
			
		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}	

	/**
	 * Fungsi untuk mendapatkan kolom untuk report
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getReportColumn($params = null) {
		$return = new Manager();

		try {
			$i = 0;
			$columns = [];
						
			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => '<div class=\"pl-4 \"><input class=\"form-check-input my-0 checkbox_all_data\" type=\"checkbox\" onclick=\"checkboxAllData(this)\" style=\"top:70%\"></div>' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => '' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Name' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Email' ]);
					
			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Mulai Pengisian' ]);
						
			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Selesai Pengisian' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pillar1' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pillar2' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pillar3' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pillar4' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pillar5' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pillar6' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pillar7' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Instansi' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Divisi Instansi' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Jabatan' ]);


			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Usia' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Jenis Kelamin' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Provinsi' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Kota' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Pendidikan' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Kualitas Pengisian' ]);

			array_push($columns, [
					'id' => $i,
					'data' => 'data' . $i++,
					'title' => 'Keterangan' ]);			

			$return->Status = 1;
			$return->Data = $columns;			
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;		
	}	

	/**
	 * Fungsi untuk memformat object Sipmas ke format report
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getFormatReport($params = null) {
		$return = new Manager();

		if (!$params->Object) {
			$return->Message = 'Object kosong';
		}

		try {
			$data = [];
			$all_id = [];
		
			foreach($params->Object as $key => $val){
				$temp_data = [];				
				$i = 0;
				
				$temp_data['data' . $i++] = "<div class='pl-4'><input class='form-check-input checkbox_data' type='checkbox' value='{$val['o_id']}' onclick='checkboxDataCallback(this)'></div>";
				$temp_data['data' . $i++] = "<a href='/sa/sipmas/resume?q={$val['o_id']}' target='_blank' title='View Detail'><button class='btn btn-info text-light'><i class='fas fa-search'></i></button></a>";
				$temp_data['data' . $i++] = $val['Name'];
				$temp_data['data' . $i++] = $val['Email'];
				$temp_data['data' . $i++] = \AppHelper\General::indonesiaDate($val['o_creationDate'], 'd F Y H:i');
				$temp_data['data' . $i++] = $val['FinishedDate'] ? \AppHelper\General::indonesiaDate($val['FinishedDate'], 'd F Y H:i') : '---';
				$temp_data['data' . $i++] = $val['Pillar1'] ? $val['Pillar1'] : '---';
				$temp_data['data' . $i++] = $val['Pillar2'] ? $val['Pillar2'] : '---';
				$temp_data['data' . $i++] = $val['Pillar3'] ? $val['Pillar3'] : '---';
				$temp_data['data' . $i++] = $val['Pillar4'] ? $val['Pillar4'] : '---';
				$temp_data['data' . $i++] = $val['Pillar5'] ? $val['Pillar5'] : '---';
				$temp_data['data' . $i++] = $val['Pillar6'] ? $val['Pillar6'] : '---';
				$temp_data['data' . $i++] = $val['Pillar7'] ? $val['Pillar7'] : '---';
				$temp_data['data' . $i++] = $val['Institute'] ? $val['Institute'] : '---';
				$temp_data['data' . $i++] = $val['InstituteSection'] ? $val['InstituteSection'] : '---';
				$temp_data['data' . $i++] = $val['Departement'] ? $val['Departement'] : '---';
				$temp_data['data' . $i++] = $val['Age'] ? $val['Age'] : '---';
				$temp_data['data' . $i++] = $val['Gender'] ? $val['Gender'] : '---';
				$temp_data['data' . $i++] = $val['Province'] ? $val['Province'] : '---';
				$temp_data['data' . $i++] = $val['City'] ? $val['City'] : '---';
				$temp_data['data' . $i++] = $val['Education'] ? $val['Education'] : '---';
				$temp_data['data' . $i++] = $val['IsFinished'] ? ($val['Corrupt'] ? 'Kurang Baik' : 'Baik')  : '---';
				$temp_data['data' . $i++] = $val['Note'] ? $val['Note'] : '---';				
								
				array_push($data, $temp_data);
				array_push($all_id, $val['o_id']);
			}	

			$return->Status = 1;
			$return->Data = $data;			
			$return->AllId = $all_id;			
		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		return $return;
	}
		
}
