<?php
/**
 * 
 */

namespace AppModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class SipmasImport
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object SipmasImport
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\SipmasImport\Listing();
			
			if ($params->Condition) {
				$objects->setCondition($params->Condition, $params->ConditionArray);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}
	
	/**
	 * Fungsi untuk mengambil SipmasImport tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\SipmasImport::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk membuat SipmasImport baru
	 * 
	 * @param  stdClass $params Name, Note, DateInput
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();
		
		if (!$params->Name) {
			$return->Message = 'Name kosong';
			return $return;
		}
		
		
		try {

			// check path of object
			$path = $params->Path ? $params->Path : '/sipmas-import';
			$exist_path  = \AppHelper\General::checkObjectPath($path, 1);
			if(!$exist_path){
				$return->Message = 'Path object not exist';
				return $return;
			}				
			$object_path = DataObject\AbstractObject::getByPath($path);
			
			// check key name of object 
			$object_key = $params->Key ? $params->Key : microtime(true) .'_'. rand();
		
			// Inisialisasi object
			$object = DataObject\SipmasImport::create();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($object_key));
			$object->setParentId($object_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished($params->Published ? $params->Published : 1);

	        // Set data
			$object->setName($params->Name);
			$object->setNote($params->Note);
			if ($params->DateInput) {
				$date_input = new \DateTime($params->DateInput);
				$object->setDateInput($date_input);
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk mengubah data dari SipmasImport yang sudah ada
	 * 
	 * @param  stdClass $params Id, Name, Note, DateInput
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}
		
		try {

			$object = DataObject\SipmasImport::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->Name) {
				$object->setName($params->Name);
			}
			if ($params->Note) {
				$object->setNote($params->Note);
			}
			if ($params->DateInput) {
				$date_input = new \DateTime($params->DateInput);
				$object->setDateInput($date_input);
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}
	
	/**
	 * Fungsi untuk menghapus SipmasImport
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\SipmasImport::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$object->delete();
				$return->Status = 1;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}

	/**
	 * Fungsi untuk mengambil data by server side
	 * 
	 * @return stdClass	Status, Message, Data
	 */
	public static function getServerSide($params = null) {
		
		$return = new Manager();
		
		try {
			$where = "where 1";
	        $keyword = $params->search['value'];
			if($keyword){
				$filter_name = "si.Name like '%{$keyword}%'";
				$filter_note = "si.Note like '%{$keyword}%'";
	
				$where .= " AND {$filter_name} OR {$filter_note}";  
			}

			$select = "select 
				si.o_creationDate,
				si.o_id, 
				si.Name, 
				si.Note,
				si.DateInput,
				GROUP_CONCAT(s.o_id SEPARATOR ',') as Ids,
				count(s.ImportData__id) as Total
			";			

	        $id_class = \AppHelper\General::getIdByClassName("Sipmas");        
	        $table_1 = "object_".$id_class;

	        $id_class = \AppHelper\General::getIdByClassName("SipmasImport");        
	        $table_2 = "object_".$id_class;

            $intLimit = 10;
            $intOffset = 0;
			$intLimit = $params->length ? $params->length : $intLimit;
			$intOffset = $params->start ? $params->start : $intOffset;

			$limit = $intLimit > 0 ? "Limit {$intLimit}" : "";
			$offset = ($intOffset >= 0 && $limit) ? "Offset {$intOffset}" : "";
			$order = "Order By si.o_modificationDate DESC";

	        $query_filtered = "                
	                {$select} 
	                FROM {$table_1} s right join {$table_2} si on si.o_id = s.ImportData__id               
	                {$where}
	                Group By s.ImportData__id
	                {$order}
	            ";	        	       	
	       	
	    	$result_filtered = \AppHelper\Mysql::makeQuery("{$query_filtered} {$limit} {$offset}");
			$data = self::getFormatServerSide((object) ["Object" => $result_filtered]);

            $count['Filtered'] = count(\AppHelper\Mysql::makeQuery("{$query_filtered}"));

            $count['All'] = count(\AppHelper\Mysql::makeQuery("{$query_filtered}"));
							                                    
			$return->Status = 1;
			$return->Data = [
					'data' => $data->Status ? $data->Data : [],
					'recordsTotal' => $count['All'],
					'recordsFiltered' => $count['Filtered']
				];
			
		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}		

	public static function getFormatServerSide($params = null) {
		$return = new Manager();

		if (!$params->Object) {
			$return->Message = 'Object kosong';
		}

		try {
			$data = [];
			$all_id = [];
		
			foreach($params->Object as $key => $val){
				$temp_data = [];				
				$i = 0;
				
				$temp_data['data' . $i++] = "
						<a href='/sa/sipmas/resume?q={$val['Ids']}' target='_blank' title='Lihat Resume'><button class='btn btn-info text-light'><i class='fas fa-search'></i></button></a>
						<a href='javascript:void(0);' title='Hapus Semua Data' onclick='deleteData(\"{$val['o_id']}\", \"{$val['Name']}\")'><button class='btn btn-danger text-light'><i class='fas fa-trash'></i></button></a>
					";
				$temp_data['data' . $i++] = $val['Name'];
				$temp_data['data' . $i++] = $val['Note'] ? $val['Note'] : '---';
				$temp_data['data' . $i++] = $val['Total'] ? $val['Total'] : '0';
				$temp_data['data' . $i++] = $val['DateInput'] ? \AppHelper\General::indonesiaDate($val['DateInput'], 'd F Y') : '---';
				$temp_data['data' . $i++] = \AppHelper\General::indonesiaDate($val['o_creationDate'], 'd F Y H:i');
								
				array_push($data, $temp_data);
			}	

			$return->Status = 1;
			$return->Data = $data;			
		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		return $return;
	}	

}
