<?php
/**
 * 
 */

namespace AppModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class SipmasProject
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object SipmasProject
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\SipmasProject\Listing();
			
			if ($params->Condition) {
				$objects->setCondition($params->Condition, $params->ConditionArray);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}
	
	/**
	 * Fungsi untuk mengambil SipmasProject tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\SipmasProject::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk membuat SipmasProject baru
	 * 
	 * @param  stdClass $params Name, Code, Note, DateStart, DateEnd
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();
		
		if (!$params->Name) {
			$return->Message = 'Name kosong';
			return $return;
		}		

		// fgenerate unique code		
		$unique_code = self::generateUniqueCode();			
			
		try {
			// check path of object
			$path = $params->Path ? $params->Path : '/sipmas/project';
			$exist_path  = \AppHelper\General::checkObjectPath($path, 1);
			if(!$exist_path){
				$return->Message = 'Path object not exist';
				return $return;
			}				
			$object_path = DataObject\AbstractObject::getByPath($path);

			// check key name of object 
			$object_key = $params->Key ? $params->Key : $unique_code;
		
			// Inisialisasi object
			$object = DataObject\SipmasProject::create();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($object_key));
			$object->setParentId($object_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished($params->Published ? $params->Published : 1);

	        // Set data
			$object->setName($params->Name);
			$object->setNote($params->Note);
			if ($params->DateStart) {
				$date_start = new \DateTime($params->DateStart);
				$object->setDateStart($date_start);
			}
			if ($params->DateEnd) {
				$date_end = new \DateTime($params->DateEnd);
				$object->setDateEnd($date_end);
			}

			// === custom generate unique code
			$object->setCode($unique_code);			

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk mengubah data dari SipmasProject yang sudah ada
	 * 
	 * @param  stdClass $params Id, Name, Code, Note, DateStart, DateEnd
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}
		
		try {

			$object = DataObject\SipmasProject::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->Name) {
				$object->setName($params->Name);
			}
			if ($params->Code) {
				$object->setCode($params->Code);
			}
			if ($params->Note) {
				$object->setNote($params->Note);
			}
			if ($params->DateStart) {
				$date_start = new \DateTime($params->DateStart);
				$object->setDateStart($date_start);
			}
			if ($params->DateEnd) {
				$date_end = new \DateTime($params->DateEnd);
				$object->setDateEnd($date_end);
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}
	
	/**
	 * Fungsi untuk menghapus SipmasProject
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {
			$object = DataObject\SipmasProject::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {				
				try{  // remove sipmas assessment object
					$params_sipmas = (object)[];
					$params_sipmas->Condition = "ProjectData__id = ?";
					$params_sipmas->ConditionArray = [$params->Id];
					$sipmas = \AppModel\Sipmas::getAll($params_sipmas);
					foreach ($sipmas as $s) {
						$s->delete();
					}				
				} catch (Exception $e) {}
	
				$object->delete();
				$return->Status = 1;
			}
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;
	}

	/**
	 * Fungsi untuk mengambil data by server side
	 * 
	 * @return stdClass	Status, Message, Data
	 */
	public static function getServerSide($params = null) {
		
		$return = new Manager();
		
		try {
			$where = "where 1";
	        $keyword = $params->search['value'];
			if($keyword){
				$filter_code = "sp.Code like '%{$keyword}%'";
				$filter_name = "sp.Name like '%{$keyword}%'";
				$filter_note = "sp.Note like '%{$keyword}%'";
	
				$where .= " AND {$filter_code} OR {$filter_name} OR {$filter_note}";  
			}

			$select = "select 
				sp.o_creationDate,
				sp.o_id, 
				sp.Code, 
				sp.Name, 
				sp.Note,
				sp.DateStart,
				sp.DateEnd,
		        count_table.Ids,
			    ifnull(count_table.Total, 0) as Total
			";			

	        $id_class = \AppHelper\General::getIdByClassName("Sipmas");        
	        $table_1 = "object_".$id_class;

	        $id_class = \AppHelper\General::getIdByClassName("SipmasProject");        
	        $table_2 = "object_".$id_class;

            $intLimit = 10;
            $intOffset = 0;
			$intLimit = $params->length ? $params->length : $intLimit;
			$intOffset = $params->start ? $params->start : $intOffset;

			$limit = $intLimit > 0 ? "Limit {$intLimit}" : "";
			$offset = ($intOffset >= 0 && $limit) ? "Offset {$intOffset}" : "";
			$order = "Order By sp.o_modificationDate DESC";

	        $query_filtered = "                
	                {$select} 
	                FROM {$table_2} sp
	                left join ( 
	                	SELECT 
	                		sp.o_id,
	        				GROUP_CONCAT(s.o_id SEPARATOR ',') as Ids,
							count(s.ProjectData__id) as Total
						FROM {$table_1} s right join {$table_2} sp on sp.o_id = s.ProjectData__id               
	                	Group By s.ProjectData__id
	                ) count_table on count_table.o_id = sp.o_id
	                {$where} {$order}
	            ";	        	       	

	    	$result_filtered = \AppHelper\Mysql::makeQuery("{$query_filtered} {$limit} {$offset}");
			$data = self::getFormatServerSide((object) ["Object" => $result_filtered]);

            $count['Filtered'] = count(\AppHelper\Mysql::makeQuery("{$query_filtered}"));

            $count['All'] = count(\AppHelper\Mysql::makeQuery("{$query_filtered}"));
							                                    
			$return->Status = 1;
			$return->Data = [
					'data' => $data->Status ? $data->Data : [],
					'recordsTotal' => $count['All'],
					'recordsFiltered' => $count['Filtered']
				];
			
		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}		

	public static function getFormatServerSide($params = null) {
		$return = new Manager();

		if (!$params->Object) {
			$return->Message = 'Object kosong';
		}

		try {
			$data = [];
			$all_id = [];
		
			foreach($params->Object as $key => $val){
				$temp_data = [];				
				$i = 0;
				
				$temp_data['data' . $i++] = "
						<a href='/sa/sipmas/resume?q={$val['Ids']}' target='_blank' title='Lihat Resume'><button class='btn btn-info text-light'><i class='fas fa-search'></i></button></a>
						<a href='javascript:void(0);' title='Hapus Semua Data' onclick='deleteData(\"{$val['o_id']}\", \"{$val['Name']}\")'><button class='btn btn-danger text-light'><i class='fas fa-trash'></i></button></a>
						<a href='javascript:void(0);' title='Link assessment' onclick='getLinkAssessment(\"{$val['Code']}\")'><button class='btn btn-warning text-light'><i class='fas fa-link'></i></button></a>	
					";
				$temp_data['data' . $i++] = $val['Code'];
				$temp_data['data' . $i++] = $val['Name'];
				$temp_data['data' . $i++] = $val['Total'] ? $val['Total'] : '0';
				$temp_data['data' . $i++] = $val['DateStart'] ? \AppHelper\General::indonesiaDate($val['DateStart'], 'd F Y') : '---';
				$temp_data['data' . $i++] = $val['DateEnd'] ? \AppHelper\General::indonesiaDate($val['DateEnd'], 'd F Y') : '---';
				$temp_data['data' . $i++] = $val['Note'] ? $val['Note'] : '---';
				$temp_data['data' . $i++] = \AppHelper\General::indonesiaDate($val['o_creationDate'], 'd F Y H:i');
								
				array_push($data, $temp_data);
			}	

			$return->Status = 1;
			$return->Data = $data;			
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}
		return $return;
	}	

	/**
	 * Fungsi untuk check valid
	 * 
	 * @param  stdClass $params Code
	 * @return stdClass	Status, Message, Data
	 */
	public static function checkValid($params = null) {
		
		$return = new Manager();

		if (!$params->Code) {
			$return->Message = 'Code kosong';
			return $return;
		}

		try {
			$object = DataObject\SipmasProject::getByCode($params->Code, 1);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$now = new \Carbon\Carbon();
				$start_status = $object->DateStart->lessThanOrEqualTo($now);
				$end_status = $object->DateEnd->greaterThanOrEqualTo($now);

				if($start_status && $end_status){
					$return->Status = 1;
					$return->Data = $object;					
				} else {
					$return->Message = 'Project sudah tidak berlaku';
				}
			}
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;	
	}   

	public static function generateUniqueCode() {
		$loop = 1;
		while($loop){
			$code = \AppHelper\General::getRandomPassword(10);
			$exist = DataObject\SipmasProject::getByCode($code, 1);
			if(!$exist){
				$loop = 0;
			}
		}

        return $code;
    }	 

}
