<?php
/**
 * 
 */

namespace AppModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class SipmasQuestion
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object SipmasQuestion
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\SipmasQuestion\Listing();
			
			if ($params->Condition) {
				$objects->setCondition($params->Condition, $params->ConditionArray);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}
	
	/**
	 * Fungsi untuk mengambil SipmasQuestion tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\SipmasQuestion::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk membuat SipmasQuestion baru
	 * 
	 * @param  stdClass $params Order, Pillar, Element, KeyActivity, Output, Indicator, Options
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();
		
		if (!$params->Order) {
			$return->Message = 'Order kosong';
			return $return;
		}
		
		
		try {

			// check path of object
			$path = $params->Path ? $params->Path : '/sipmas-question';
			$exist_path  = \AppHelper\General::checkObjectPath($path, 1);
			if(!$exist_path){
				$return->Message = 'Path object not exist';
				return $return;
			}				
			$object_path = DataObject\AbstractObject::getByPath($path);
			
			// check key name of object 
			$object_key = $params->Key ? $params->Key : microtime(true) .'_'. rand();
		
			// Inisialisasi object
			$object = DataObject\SipmasQuestion::create();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($object_key));
			$object->setParentId($object_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished($params->Published ? $params->Published : 1);

	        // Set data
			$object->setOrder($params->Order);
			$object->setPillar($params->Pillar);
			$object->setElement($params->Element);
			$object->setKeyActivity($params->KeyActivity);
			$object->setOutput($params->Output);
			$object->setIndicator($params->Indicator);
			$object->setOptions($params->Options);

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk mengubah data dari SipmasQuestion yang sudah ada
	 * 
	 * @param  stdClass $params Id, Order, Pillar, Element, KeyActivity, Output, Indicator, Options
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}
		
		try {

			$object = DataObject\SipmasQuestion::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->Order) {
				$object->setOrder($params->Order);
			}
			if ($params->Pillar) {
				$object->setPillar($params->Pillar);
			}
			if ($params->Element) {
				$object->setElement($params->Element);
			}
			if ($params->KeyActivity) {
				$object->setKeyActivity($params->KeyActivity);
			}
			if ($params->Output) {
				$object->setOutput($params->Output);
			}
			if ($params->Indicator) {
				$object->setIndicator($params->Indicator);
			}
			if ($params->Options) {
				$object->setOptions($params->Options);
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}
	
	/**
	 * Fungsi untuk menghapus SipmasQuestion
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}

		try {

			$object = DataObject\SipmasQuestion::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$object->delete();
				$return->Status = 1;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}

}
