<?php
/**
 * 
 */

namespace AppModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class User
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object User
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\User\Listing();
			
			if ($params->Condition) {
				$objects->setCondition($params->Condition, $params->ConditionArray);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}
	
	/**
	 * Fungsi untuk mengambil User tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\User::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk membuat User baru
	 * 
	 * @param  stdClass $params Email, Password, Role, LoginAttempts, PasswordLastModified, LastPasswordUsed, TempCode, StatusAccount, Organization, OrganizationUnit, Name, Dob, Gender, Phone, Province, City, Education, Departement, Nip, ProfilePicture
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();
		
		if (!$params->Email) {
			$return->Message = 'Email kosong';
			return $return;
		}
		
		
		try {

			// check path of object
			$path = $params->Path ? $params->Path : '/user';
			$exist_path  = \AppHelper\General::checkObjectPath($path, 1);
			if(!$exist_path){
				$return->Message = 'Path object not exist';
				return $return;
			}				
			$object_path = DataObject\AbstractObject::getByPath($path);
			
			// check key name of object 
			$object_key = $params->Key ? $params->Key : microtime(true) .'_'. rand();
		
			// Inisialisasi object
			$object = DataObject\User::create();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($object_key));
			$object->setParentId($object_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished($params->Published ? $params->Published : 1);

	        // Set data
			$object->setEmail($params->Email);
			$object->setPassword($params->Password);

			if ($params->Role) {
				$role = DataObject\AbstractObject::getById($params->Role);
				if ($role) {
					$object->setRole($role);
				}
			}

			$object->setLoginAttempts($params->LoginAttempts);
			if ($params->PasswordLastModified) {
				$password_last_modified = new \DateTime($params->PasswordLastModified);
				$object->setPasswordLastModified($password_last_modified);
			}
			$object->setLastPasswordUsed($params->LastPasswordUsed);
			$object->setTempCode($params->TempCode);
			$object->setStatusAccount($params->StatusAccount);

			if ($params->Organization) {
				$organization = DataObject\AbstractObject::getById($params->Organization);
				if ($organization) {
					$object->setOrganization($organization);
				}
			}


			if ($params->OrganizationUnit) {
				$organization_unit = DataObject\AbstractObject::getById($params->OrganizationUnit);
				if ($organization_unit) {
					$object->setOrganizationUnit($organization_unit);
				}
			}

			$object->setName($params->Name);
			if ($params->Dob) {
				$dob = new \DateTime($params->Dob);
				$object->setDob($dob);
			}
			$object->setGender($params->Gender);
			$object->setPhone($params->Phone);
			$object->setProvince($params->Province);
			$object->setCity($params->City);
			$object->setEducation($params->Education);
			$object->setDepartement($params->Departement);
			$object->setNip($params->Nip);

			if ($params->ProfilePicture) {
				$profile_picture_image;
				$profile_picture_image_params = new stdClass;
				if (isset($params->ProfilePicture['tmp_name'])) {
					$profile_picture_image = $params->ProfilePicture;
				} else {
					$profile_picture_image = [];
					$profile_picture_image['Data'] = $params->ProfilePicture;
					$profile_picture_image['Name'] = microtime(true) .'.jpg';
					$profile_picture_image_params->Type = 'base64';
				}
				$profile_picture_image_params->Path = '/user';
				$profile_picture_image_params->Image = $profile_picture_image;
				$asset = \AppHelper\Asset::uploadFileToAsset($profile_picture_image_params);
				if ($asset) {
					$object->setProfilePicture($asset);
				}
			}


	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk mengubah data dari User yang sudah ada
	 * 
	 * @param  stdClass $params Id, Email, Password, Role, LoginAttempts, PasswordLastModified, LastPasswordUsed, TempCode, StatusAccount, Organization, OrganizationUnit, Name, Dob, Gender, Phone, Province, City, Education, Departement, Nip, ProfilePicture
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}
		
		try {

			$object = DataObject\User::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->Email) {
				$object->setEmail($params->Email);
			}
			if ($params->Password) {
				$object->setPassword($params->Password);
			}
			if ($params->Role) {
				$role = DataObject\AbstractObject::getById($params->Role);
				if ($role) {
					$object->setRole($role);
				}
			}
			if ($params->LoginAttempts) {
				$object->setLoginAttempts($params->LoginAttempts);
			}
			if ($params->PasswordLastModified) {
				$password_last_modified = new \DateTime($params->PasswordLastModified);
				$object->setPasswordLastModified($password_last_modified);
			}
			if ($params->LastPasswordUsed) {
				$object->setLastPasswordUsed($params->LastPasswordUsed);
			}
			if ($params->TempCode) {
				$object->setTempCode($params->TempCode);
			}
			if ($params->StatusAccount) {
				$object->setStatusAccount($params->StatusAccount);
			}
			if ($params->Organization) {
				$organization = DataObject\AbstractObject::getById($params->Organization);
				if ($organization) {
					$object->setOrganization($organization);
				}
			}
			if ($params->OrganizationUnit) {
				$organization_unit = DataObject\AbstractObject::getById($params->OrganizationUnit);
				if ($organization_unit) {
					$object->setOrganizationUnit($organization_unit);
				}
			}
			if ($params->Name) {
				$object->setName($params->Name);
			}
			if ($params->Dob) {
				$dob = new \DateTime($params->Dob);
				$object->setDob($dob);
			}
			if ($params->Gender) {
				$object->setGender($params->Gender);
			}
			if ($params->Phone) {
				$object->setPhone($params->Phone);
			}
			if ($params->Province) {
				$object->setProvince($params->Province);
			}
			if ($params->City) {
				$object->setCity($params->City);
			}
			if ($params->Education) {
				$object->setEducation($params->Education);
			}
			if ($params->Departement) {
				$object->setDepartement($params->Departement);
			}
			if ($params->Nip) {
				$object->setNip($params->Nip);
			}

			if ($params->ProfilePicture) {
				$profile_picture_image;
				$profile_picture_image_params = new stdClass;
				if (isset($params->ProfilePicture['tmp_name'])) {
					$profile_picture_image = $params->ProfilePicture;
				} else {
					$profile_picture_image = [];
					$profile_picture_image['Data'] = $params->ProfilePicture;
					$profile_picture_image['Name'] = microtime(true) .'.jpg';
					$profile_picture_image_params->Type = 'base64';
				}
				$profile_picture_image_params->Path = '/user';
				$profile_picture_image_params->Image = $profile_picture_image;
				$asset = \AppHelper\Asset::uploadFileToAsset($profile_picture_image_params);
				if ($asset) {
					if ($object->ProfilePicture) {
						$object->ProfilePicture->delete();
					}
					$object->setProfilePicture($asset);
				}
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}
	
	/**
	 * Fungsi untuk menghapus User
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}

		try {

			$object = DataObject\User::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$object->delete();
				$return->Status = 1;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}

	/**
	 * Fungsi untuk create demo user
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function createDemoUser($params = null) {
		
		$return = new Manager();

		if (!$params->Client) {
			$return->Message = 'Client not defined';
		}

		if (!$params->ApiKey) {
			$return->Message = 'ApiKey not defined';
		}

		if (!$params->Request) {
			$return->Message = 'ApiKey not defined';
		}

		try {
            $params_user = new \stdClass;

            $microtime = microtime(True) * 10000;
            $params_user->Email = "demo_" . $microtime . "@pakarya.com" ;                
            $params_user->Password = $params_user->Email;                
            $params_user->StatusAccount = 1;

            $now = new \DateTime();
            $y = $now->format('Y');
            $m = $now->format('F');
            $d = $now->format('d');     
            
            $h = $now->format('H');
            $i = $now->format('i');     
            $params_user->Key = $h . '_' . $i . '_' . $params_user->Email;            
            $params_user->Path = '/user/data/participant/' . $y . '/' . $m . '/' . $d;

            $role = \AuthenticationModel\UserRole::getByPath((object) ["Key" => 'participant']);
            $params_user->Role = $role->Data->o_id;
            
            $check_existing = \AuthenticationModel\User::getByEmail($params_user);
            if($check_existing->Status) {                
                $params_user->Email = $microtime . $params_user->Email ;
            }

            $user = \AuthenticationModel\User::create($params_user)->Data;

            $headers = [
                'apikey' => $params->ApiKey
            ];
            $response = $params->Client->request('POST', 'authentication/user', [
                'headers' => $headers,
                'form_params' => [
                    'Email' => $params_user->Email,
                    'Password' => $params_user->Password,
                    'Role' => null,
                    'Type' => 'global'
                ]
            ]);
            
            $contents = $response->getBody()->getContents();
            $contents = json_decode($contents);

            if($contents->Status == 1) {
                $session = $params->Request->getSession();
                $session->set('auth_token', $contents->Token);

				$return->Status = 1;                
            }
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;
	}

}
