<?php

namespace AppBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use \Pimcore\Model\DataObject;


/**
 * @Route("/email-bucket")
 */
class EmailBucketController extends FOSRestController {

    /**
     * @Route("/send-email")
     */
    public function sendEmailAction()
    {
        $return = new \stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = null;

        $params = new \stdClass;
        $params->SortBy = "o_creationDate";
        $params->Order = "desc";

        // initial condition for get valid data
        $condition1 = "((Status <> 'Success' OR (IFNULL(Counter, 0) < 1)))"; // if Status != Success OR (Counter < 1 OR Counter = NULL)        
        $condition2 = "(IFNULL(Counter, 0) < 100)"; // if Counter < 100)
        $params->Condition = "o_published = 1 AND " . $condition1 . " AND " . $condition2;

        $params->Limit = 10;
        $emails = \AppModel\EmailBucket::get($params);
        
        if($emails->Status){            
            foreach ($emails->Data as $email) {
                $params = new \stdClass;  
                $params->From = $email->From;      
                $params->To = $email->To;
                $params->Subject = $email->Subject;
                $params->Cc = $email->CC;
                $params->Bcc = $email->BCC;
                $params->Template = $email->Template;
                $params->Params = (array)json_decode($email->Params);
                $params->BodyHtml = $email->BodyText;
                $params->Attachment = $email->Attachment;

                $return = \AppHelper\Email::sendEmail($params); 
                
                if($return->Status){
                    $email->Status = "Success";
                }else{
                    $email->Message = $return->Message;
                    $email->Status = "Failed";
                }
                $email->Counter = $email->Counter ? $email->Counter+1 : 1;
                if($email->save()) {
                    $return->Status = 1;
                } 

            }              
        }

        return $this->json(["Status" => 1]);        
    }

    /**
     * @Route("/send-email-by-id")
     */
    public function sendEmailByIdAction()
    {

        $email = DataObject\EmailBucket::getById($_POST['id']);      
        if($email){
            $params = new \stdClass;  
            $params->From = $email->From;      
            $params->To = $email->To;
            $params->Subject = $email->Subject;
            $params->Cc = $email->CC;
            $params->Bcc = $email->BCC;
            $params->Template= $email->Template;
            $params->Params = (array) json_decode($email->Params);
            $params->BodyHtml = $email->BodyText;
            $params->Attachment = $email->Attachment;

            $return = \AppHelper\Email::sendEmail($params); 
            if($return->Status){
                $email->Status = "Success";
            }else{
                $email->Message = $return->Message;
                $email->Status = "Failed";
            }
            $email->Counter = $email->Counter ? ($email->Counter+1) : 1;
            $email->save(); 
        }

        return $this->json(1);
    }    

    /**
     * @Route("/delete-email")
     */
    public function deleteEmailAction()
    {

        $time = $_GET["t"];

        if(!$time) { return $this->json(0); }

        $params = new \stdClass;
        $params->SortBy = "o_modificationDate";
        $params->Order = "desc";
        $limitTime = strtotime('-'.$time.' minutes', time());
        $params->Condition = "o_published = 1 AND Status = 'Success' AND o_modificationDate < ".$limitTime;

        $emails = \AppModel\EmailBucket::get($params);
        
        if($emails->Status){            
            foreach ($emails->Data as $email) {
                $object = DataObject\EmailBucket::getById($email->o_id);
                $object->delete();
            
            }              
        }

        return $this->json(1);
    }

    /**
     * @Route("/add-email")
     */
    public function addEmailAction() 
    {

        $params = new \stdClass;
        $params->Delay = $_POST['Delay'];
        $params->Activity = $_POST['Activity'];
        $params->To = $_POST['To'];
        $params->From = $_POST['From'];
        $params->Subject = $_POST['Subject'];
        $params->Cc = $_POST['Cc'];
        $params->Bcc = $_POST['Bcc'];
        $params->Template = (array) json_decode($_POST['Template']);
        $params->Params = $_POST['Params'];
        $params->Message = $_POST['Message'];
        $params->BodyText = $_POST['BodyText'];

        $object = \AppModel\EmailBucket::add($params);

        return $this->json(1);
    }

}
