<?php

namespace AppBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @Route("/generator")
 */
class GeneratorController extends FOSRestController
{

    /**
     * @Route("/test")
     */
    public function testAction(Request $request)
    {
        $user = \AppHelper\Authentication::checkPimcoreLogin();
        if (!$user) {
            return new Response('You must login pimcore Admin first', Response::HTTP_BAD_REQUEST);
        }

        var_dump(['asdasd']);die();
    }

    /**
     * @Route("/generate/model")
     */
    public function modelAction(Request $request)
    {

        $user = \AppHelper\Authentication::checkPimcoreLogin();
        if (!$user) {
            return new Response('You must login pimcore Admin first', Response::HTTP_BAD_REQUEST);
        }

        $id = $request->get('id');
        $bundle = $request->get('bundle');
        $bundle_name = substr($bundle, 0, -6);

        $model = new \AppHelper\Generator\Lib\ManagerModel();
        $model->setBundle($bundle);
        $model->setBundleName($bundle_name);

        $manager = new \AppHelper\Generator\Adapter($model);
        $manager->generate($id);
        
        return $this->json(['status' => true, 'message' => 'Generate model success']);
    }

    /**
     * @Route("/generate/api")
     */
    public function apiAction(Request $request)
    {
        $user = \AppHelper\Authentication::checkPimcoreLogin();
        if (!$user) {
            return new Response('You must login pimcore Admin first', Response::HTTP_BAD_REQUEST);
        }

        $id = $request->get('id');
        $bundle = $request->get('bundle');
        $bundle_name = substr($bundle, 0, -6);

        $model = new \AppHelper\Generator\Lib\ApiModel();
        $model->setBundle($bundle);
        $model->setBundleName($bundle_name);

        $api = new \AppHelper\Generator\Adapter($model);
        $api->generate($id);


        return $this->json(['status' => true, 'message' => 'Generate API success']);
    }

    private function checkLogin()
    {
        $user = \AppHelper\Authentication::checkPimcoreLogin();
        if (!$user) {
            return new Response('You must login pimcore Admin first', Response::HTTP_BAD_REQUEST);
        }
        return null;
    }

}
