<?php
/**
 * 
 */

namespace AppBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @Route("/sipbos")
 */
class SipbosController extends FOSRestController
{

    /**
     * Fungsi untuk mengambil seluruh data dari object Sipbos
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-all")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getAllAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipbos::getAll($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil Sipbos tertentu berdasarkan Id
     *
     * Id
     * 
     * @Route("/get-by-id")
     * @Method("POST")
     *
     * @param Id
     * @return JSON Status, Message, Data
     */
    public function getByIdAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipbos::getById($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk membuat Sipbos baru
     *
     * User, Order, IsFinished, FinishedDate, RvsTerminal, RvsInstrument, OcaiRaw, OcaiClanNowUnit, OcaiClanWantUnit, OcaiClanNowOrganisasi, OcaiClanWantOrganisasi, OcaiHierarchyNowUnit, OcaiHierarchyWantUnit, OcaiHierarchyNowOrganisasi, OcaiHierarchyWantOrganisasi, OcaiMarketNowUnit, OcaiMarketWantUnit, OcaiMarketNowOrganisasi, OcaiMarketWantOrganisasi, OcaiAdhocracyNowUnit, OcaiAdhocracyWantUnit, OcaiAdhocracyNowOrganisasi, OcaiAdhocracyWantOrganisasi, MsaiRaw, MsaiProcess, MsaiClan, MsaiAdhocracy, MsaiMarket, MsaiHierarchy, TypologyOcai, TypologyMsai
     * 
     * @Route("/create")
     * @Method("POST")
     *
     * @param User, Order, IsFinished, FinishedDate, RvsTerminal, RvsInstrument, OcaiRaw, OcaiClanNowUnit, OcaiClanWantUnit, OcaiClanNowOrganisasi, OcaiClanWantOrganisasi, OcaiHierarchyNowUnit, OcaiHierarchyWantUnit, OcaiHierarchyNowOrganisasi, OcaiHierarchyWantOrganisasi, OcaiMarketNowUnit, OcaiMarketWantUnit, OcaiMarketNowOrganisasi, OcaiMarketWantOrganisasi, OcaiAdhocracyNowUnit, OcaiAdhocracyWantUnit, OcaiAdhocracyNowOrganisasi, OcaiAdhocracyWantOrganisasi, MsaiRaw, MsaiProcess, MsaiClan, MsaiAdhocracy, MsaiMarket, MsaiHierarchy, TypologyOcai, TypologyMsai
     * @return JSON Status, Message, Data
     */
    public function createAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipbos::create($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengubah data dari Sipbos yang sudah ada
     *
     * Id, User, Order, IsFinished, FinishedDate, RvsTerminal, RvsInstrument, OcaiRaw, OcaiClanNowUnit, OcaiClanWantUnit, OcaiClanNowOrganisasi, OcaiClanWantOrganisasi, OcaiHierarchyNowUnit, OcaiHierarchyWantUnit, OcaiHierarchyNowOrganisasi, OcaiHierarchyWantOrganisasi, OcaiMarketNowUnit, OcaiMarketWantUnit, OcaiMarketNowOrganisasi, OcaiMarketWantOrganisasi, OcaiAdhocracyNowUnit, OcaiAdhocracyWantUnit, OcaiAdhocracyNowOrganisasi, OcaiAdhocracyWantOrganisasi, MsaiRaw, MsaiProcess, MsaiClan, MsaiAdhocracy, MsaiMarket, MsaiHierarchy, TypologyOcai, TypologyMsai
     * 
     * @Route("/update")
     * @Method("POST")
     *
     * @param Id, User, Order, IsFinished, FinishedDate, RvsTerminal, RvsInstrument, OcaiRaw, OcaiClanNowUnit, OcaiClanWantUnit, OcaiClanNowOrganisasi, OcaiClanWantOrganisasi, OcaiHierarchyNowUnit, OcaiHierarchyWantUnit, OcaiHierarchyNowOrganisasi, OcaiHierarchyWantOrganisasi, OcaiMarketNowUnit, OcaiMarketWantUnit, OcaiMarketNowOrganisasi, OcaiMarketWantOrganisasi, OcaiAdhocracyNowUnit, OcaiAdhocracyWantUnit, OcaiAdhocracyNowOrganisasi, OcaiAdhocracyWantOrganisasi, MsaiRaw, MsaiProcess, MsaiClan, MsaiAdhocracy, MsaiMarket, MsaiHierarchy, TypologyOcai, TypologyMsai
     * @return JSON Status, Message, Data
     */
    public function updateAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipbos::update($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk menghapus Sipbos
     *
     * Id
     * 
     * @Route("/delete")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function deleteAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipbos::delete($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk ambil data report
     *
     * @Route("/get-report-data")
     * @Method("POST")
     *
     * @return JSON Status, Message, Data
     */
    public function getReportDataAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipbos::getReportData($params);
        
        return $this->json($result->Data);
    }

}
