<?php
/**
 * 
 */

namespace AppBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @Route("/sipbos-import")
 */
class SipbosImportController extends FOSRestController
{

    /**
     * Fungsi untuk mengambil seluruh data dari object SipbosImport
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-all")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getAllAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipbosImport::getAll($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil SipbosImport tertentu berdasarkan Id
     *
     * Id
     * 
     * @Route("/get-by-id")
     * @Method("POST")
     *
     * @param Id
     * @return JSON Status, Message, Data
     */
    public function getByIdAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipbosImport::getById($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk membuat SipbosImport baru
     *
     * Name, Note
     * 
     * @Route("/create")
     * @Method("POST")
     *
     * @param Name, Note
     * @return JSON Status, Message, Data
     */
    public function createAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipbosImport::create($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengubah data dari SipbosImport yang sudah ada
     *
     * Id, Name, Note
     * 
     * @Route("/update")
     * @Method("POST")
     *
     * @param Id, Name, Note
     * @return JSON Status, Message, Data
     */
    public function updateAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipbosImport::update($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk menghapus SipbosImport
     *
     * Id
     * 
     * @Route("/delete")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function deleteAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();

        $delete_bulk = \AppModel\Sipbos::deleteByImportData((object) ["ImportData" => $params->Id]);
        if($delete_bulk->Status){
            $result = \AppModel\SipbosImport::delete($params);
        }

        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil data by server side 
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-server-side")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getServerSideAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipbosImport::getServerSide($params);
        
        return $this->json($result->Data);
    }    

    /**
     * Fungsi untuk mengimport Raw Data Sipbos from excel template
     *
     * Path, Key 
     * 
     * @Route("/import-data")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function importAction(Request $request = null, Response $response = null)
    {
        $params_post = (object) $request->request->all();

        $file_path = $_FILES['FilePath'];
        if(!$file_path){
            return $this->json(["Status" => 0, "Message" => "Path file empty"]);
        }

        $data = \AppHelper\Excel::readExcelFile($file_path['tmp_name']);

        // import excel into asset pimcore
        $path_import = '/import/sipbos';
        $exist_path  = \AppHelper\General::checkObjectPath($path_import, 1);
        if($exist_path){
            $params_asset = new \stdClass;
            if (isset($file_path['tmp_name'])) {
                $params_asset->Image = $file_path;
                $params_asset->Image["name"] = $params_post->Name."_".microtime(true).".xlsx";
            }
            $params_asset->Path = $path_import;
            $asset = \AppHelper\Asset::uploadFileToAsset($params_asset);
        }
        // import excel into asset pimcore
    
        $params_exist = new \stdClass;
        $params_exist->Condition = "Name = ?";
        $params_exist->ConditionArray = [$params_post->Name];
        $obj_exist = \AppModel\SipbosImport::getAll($params_exist);
        if($obj_exist->Status){
            return $this->json(["Status" => 0, "Message" => "Nama import harus unik, saat ini import data dengan nama {$params_post->Name} sudah ada di sistem"]);            
        }

        $params_post->Path = "/sipbos/import";
        $params_post->Key = $params_post->Name;        
        $obj_import = \AppModel\SipbosImport::create($params_post);
        if(!$obj_import->Status){
            return $this->json(["Status" => 0, "Message" => "Gagal membuat import file"]);            
        }

        $help = 3;
        foreach ($data as $key => $value) {
            if($key < $help) continue;  
            if(!$value['B']) continue;

            $inc_alpha = 'C';

            $params = new \stdClass;
            $params->Name = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Dob = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Gender = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Education = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Departement = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Institute = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->InstituteSection = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Email = \AppHelper\General::cleanString($value[$inc_alpha++]);

            $microtime = microtime(True) * 10000;

            if(!$params->Email){ // check email empty, add timestamp email if empty
                $params->Email = $microtime . "@pakarya.com" ;                
            }

            if($params->Gender){ // check gender
                if(strtolower($params->Gender[0]) == 'l'){ 
                    $params->Gender = "Laki-laki";
                } else {
                    $params->Gender = "Perempuan";                    
                }
            }

            $params->Path = $obj_import->Data->o_path . $obj_import->Data->o_key;
            $params->Key = $params->Email;

            $role = \AuthenticationModel\UserRole::getByPath((object) ["Key" => 'participant']);
            $params->Role = $role->Data->o_id;
            
            $check_existing = \AuthenticationModel\User::getByEmail($params);
            if($check_existing->Status) {                
                $params->Email = $microtime . $params->Email ;
            }

            $params->StatusAccount = 1;

            $user = \AuthenticationModel\User::create($params)->Data;

            if(!$user) continue;

            // ----------------------------------------------------------------------------------------------------------

            $inc_alpha = 'K';

            $params = (object) array(                    
                "Terminal" => array(
                        ["TMV-1", "Hidup nyaman (hidup makmur)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-2", "Hidup yang aktif dan dinamis", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-3", "Rasa berprestasi dan berkontribusi", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-4", "Hidup damai bebas dari konflik", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-5", "Menikmati keindahan alam dan kesenian", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-6", "Kesamaan dan persaudaraan antar sesama manusia/pekerja", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-7", "Keamanan keluarga", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-8", "Kemerdekaan dan kebebasan memilih", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-9", "Kebahagiaan (kepuasan)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-10", "Ketentraman batin (bebas dari konflik batin)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-11", "Cinta yang tulus", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-12", "Hidup santai dan bersenang-senang", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-13", "Keselamatan", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-14", "Menghormati/menghargai diri sendiri", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-15", "Pengakuan sosial/mendapat respek dari orang lain", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-16", "Persahabatan sejati (memperoleh kawan karib)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-17", "Menjadi bijaksana (memahami kehidupan secara matang)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["TMV-18", "Keamanan nasional", \AppHelper\General::cleanString($value[$inc_alpha++])]                    
                    ),                    
                "Instrument" => array(
                        ["ITV-1", "Kerja keras, bercita-cita tinggi", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-2", "Berpikiran luas dan terbuka", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-3", "Kapabel (mampu, efektif)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-4", "Riang (senang, gembira)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-5", "Bersih (rapi, teratur)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-6", "Berani (teguh mempertahankan keyakinan)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-7", "Memaafkan (memaafkan orang lain)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-8", "Membantu orang lain", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-9", "Jujur, tidak bohong", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-10", "Imaginatif, kreatif", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-11", "Berdikari, mencukupi diri", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-12", "Intelektual (cerdas, reflektif/penuh renungan)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-13", "Logis dan rasional", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-14", "Mencintai (penuh kasih sayang, lembut)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-15", "Patuh (menurut, penuh hormat)", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-16", "Sopan santun dan berbudi bahasa", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-17", "Bertanggung jawab dan dapat diandalkan", \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["ITV-18", "Kendali diri (disiplin diri, tenang)", \AppHelper\General::cleanString($value[$inc_alpha++])]
                    ),               
                "RvsFinished" => 1, 
                "User" => $user->o_id
            );
            $params->CreationDate = $params_post->DateInput;
            $params->Path = $user->o_path . $user->o_key;
            $params->Key = "result_{$user->o_key}";
            $result = \AppModel\Sipbos::processRvs($params);

            // ----------------------------------------------------------------------------------------------------------

            $inc_alpha = 'AU';
            $ocai_raw = [[]];
            for($i=0 ; $i<6 ; $i++){
                for($j=0; $j<16; $j++){
                    $ocai_raw[$i][$j] = $value[$inc_alpha++];
                }
            }
            $params = (object) array(                    
                "OcaiRaw" => $ocai_raw,
                "OcaiFinished" => 1, 
                "User" => $user->o_id                                                    
            );
            $result = \AppModel\Sipbos::processOcai($params);

            // ----------------------------------------------------------------------------------------------------------

            $inc_alpha = 'EM';
            $counter_pernyataan_msai = 1;

            $option_msai_1 = ["", "STS", "TS", "R", "S", "SS"];
            $option_msai_2 = ["", "SK", "K", "C", "B", "SB"];
            $option_msai_3 = [
                    "", 
                    "Tetap pada posisi jabatan sekarang.", 
                    "Posisi satu tingkat di atas posisi jabatan anda sekarang", 
                    "Posisi jabatan senior, seperti: jabatan fungsional tertinggi.", 
                    "Posisi jabatan mendekati puncak, di bawah Eselon I/Eselon II/Eselon III/Eselon IV",
                    "Posisi jabatan puncak dalam Organisasi (Eselon I/Eselon II/Eselon III/Eselon IV)"
                ];
            $option_msai_4 = [
                    "", 
                    "Di bawah rata-rata (in the bottom half)", 
                    "Rata-rata (Top 50%)", 
                    "Diatas rata-rata (Top 25%)", 
                    "Baik (Top 10%)", 
                    "Sangat Baik (Top 5%)"
                ];
            $option_msai_5 = ["", "KP", "CP", "P", "SP", "K"];

            $params = (object) array(
                "MsaiRaw" => array(
                        ["1", "Saya mendengar, mempedulikan dan memperhatikan dengan serius orang-orang di dalam unit organisasi saya pada saat mereka menceritakan problemnya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["2", "Saya mendorong orang-orang di dalam unit organisasi saya untuk menghasilkan ide-ide baru dan metode-metode baru.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["3", "Saya memotivasi dan memberi semangat orang lain untuk melakukan tugas dengan lebih baik.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["4", "Saya memantau dengan seksama bagaimana kinerja yang dihasilkan unit organisasi saya", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["5", "Saya secara teratur membimbing para bawahan untuk memperbaiki kemampuan manajemen mereka agar mereka dapat mencapai kinerja yang lebih tinggi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["6", "Saya menuntut kerja keras dan produktivitas yang tinggi dari bawahan saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["7", "Saya menetapkan tujuan/sasaran yang ambisius yang memberikan tantangan kepada bawahan untuk mencapai tingkat kinerja di atas standar.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["8", "Saya menyediakan, atau membantu orang lain untuk memperoleh, sumber-sumber yang diperlukan mereka dalam mengimplementasikan ide-ide inovatif mereka.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["9", "Ketika seseorang memunculkan ide-ide baru, saya mensponsori mereka untuk mewujudkannya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["10", "Saya memastikan bahwa semua pegawai memahami dengan jelas kebijakan, nilai-nilai dan tujuan Organisasi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["11", "Saya memastikan bahwa orang lain memiliki gambaran yang jelas tentang bagaimana pekerjaan mereka sesuai (klop) dengan pekerjaan orang lainnya di dalam Organisasi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["12", "Saya membangun tim yang kohesif, terdiri dari orang-orang yang memiliki komitmen.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["13", "Saya memberikan umpan balik secara berkala kepada bawahan tentang bagaimana mereka melaksanakan pekerjaannya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["14", "Saya menyampaikan gambaran yang jelas tentang apa yang dapat dicapai di masa depan.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["15", "Saya mendorong suasana kompetitif yang dapat membantu unit organisasi saya agar dapat menghasilkan kinerja yang melebihi kinerja unit organisasi lain.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["16", "Saya memastikan bahwa laporan dan penilaian secara berkala dibuat di unit organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["17", "Saya memperjelas dan menyederhanakan informasi yang kompleks sehingga dapat dipahami oleh orang lain dan disebarkan ke seluruh Organisasi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["18", "Saya memfasilitasi distribusi informasi dan pemecahan masalah secara efektif di unit organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["19", "Saya mendorong analisa keputusan yang sistematik dan rasional di unit organisasi saya (misalnya secara logis menganalisa bagian-bagian dari permasalahan) untuk mengurangi kompleksitas masalah-masalah penting.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["20", "Saya memastikan bahwa orang-orang yang berada dalam unit organisasi saya diberikan kesempatan untuk mengembangkan diri.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["21", "Saya menciptakan suatu lingkungan yang mendorong dan menghargai keterlibatan dan partisipasi dalam pengambilan keputusan.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["22", "Di dalam unit organisasi yang saya pimpin, saya memastikan bahwa perhatian yang memadai diberikan untuk penyelesaian tugas dan hubungan interpersonal.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["23", "Ketika memberikan umpan balik negatif, saya mengedepankan perbaikan diri tanpa menimbulkan sikap defensif dan kemarahan pada orang itu.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["24", "Saya memberi tugas dan tanggung jawab yang memberikan peluang pengembangan diri bagi orang tersebut.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["25", "Saya secara aktif membantu menyiapkan orang lain untuk dipromosikan (move up) dalam Organisasi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["26", "Saya secara konsisten mengemukakan ide-ide baru dan kreatif yang berkaitan dengan proses-proses, produk dan prosedur bagi Organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["27", "Saya secara konstan menyatakan dan menegaskan kembali visi saya tentang masa depan kepada anggota-anggota unit organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["28", "Saya membantu orang lain mendeskripsikan suatu pencapaian di masa depan termasuk kemungkinan dan peluang meraihnya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["29", "Saya selalu bekerja untuk memperbaiki proses yang digunakan untuk mencapai output yang diinginkan.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["30", "Saya menuntut unit organisasi saya untuk mencapai kinerja berdaya saing internasional (world-class) dalam produk dan/atau pelayanan/jasa.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["31", "Dengan memberdayakan orang-orang dalam unit, saya menciptakan iklim yang memotivasi dan menyemangati setiap orang yang terlibat.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["32", "Saya selalu membina hubungan personal dengan konsumen internal dan eksternal unit organisasi secara konsisten.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["33", "Saya memastikan agar unit organisasi memiliki ukuran sejauh mana telah memenuhi harapan konsumen.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["34", "Saya memberikan pengalaman kepada bawahan yang membantu mereka bersosialisasi dan melebur ke dalam budaya Organisasi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["35", "Saya meningkatkan persaingan di unit organisasi saya dengan mendorong mereka menyediakan jasa/produk yang dapat memberikan kejutan dan kepuasan pada pelanggan karena melampaui harapan mereka.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["36", "Saya telah membangun suatu sistem pengawasan yang memastikan konsistensi kualitas, pelayanan, biaya dan produktivitas di unit organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["37", "Saya berkoordinasi dengan para pimpinan di unit organisasi lainnya dalam Organisasi secara berkala.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["38", "Untuk memfasilitasi koordinasi, secara rutin saya berbagi informasi lintas fungsi/Organisasi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["39", "Saya menggunakan sistem pengukuran yang secara konsisten dapat memonitor baik proses kerja maupun hasil kerja.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["40", "Saya menjelaskan kepada anggota-anggota di unit organisasi saya tentang apa yang sesungguhnya diharapkan dari mereka.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["41", "Saya menjamin bahwa segala sesuatu yang dilakukan tertuju pada pelayanan yang lebih baik kepada konsumen.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["42", "Saya memfasilitasi iklim yang sangat dinamis, penuh antusias dan penuh semangat dalam unit organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["43", "Saya secara terus menerus memonitor kekuatan dan kelemahan dari pesaing terbesar Organisasi dan menginformasikannya agar unit organisasi saya dapat menanggapinya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["44", "Saya memfasilitasi iklim perbaikan secara berkelanjutan (countinuous improvement) dalam unit organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["45", "Saya telah mengembangkan strategi yang jelas agar unit organisasi saya berhasil mencapai visi masa depan saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["46", "Saya dapat menangkap komitmen dalam nuansa emosi dan imajinasi orang lain ketika saya membicarakan visi masa depan saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["47", "Saya menciptakan suatu lingkungan kerja yang membuat sesama rekan kerja dan bawahan saling belajar dan mengembangkan diri.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["48", "Saya mendengarkan dengan penuh perhatian dan keterbukaan pada orang yang sedang mengemukakan gagasannya, bahkan ketika saya tidak sependapat dengan gagasan tersebut.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["49", "Ketika memimpin sebuah tim kerja, saya memastikan berjalannya kerja sama dan penyelesaian konflik-konflik secara positif di antara anggota tim.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["50", "Saya menumbuhkan kepercayaan dan keterbukaan di unit organisasi saya dengan cara menunjukkan pengertian pada sudut pandang orang yang mengemukakan masalah dan keprihatinannya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["51", "Saya menciptakan suatu lingkungan yang mengakui dan menghargai eksperimen dan kreativitas.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["52", "Saya mendorong setiap orang di unit organisasi saya untuk memperbaiki dan mengembangkan segala sesuatu yang mereka kerjakan secara terus menerus.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["53", "Saya mendorong seluruh bawahan untuk melakukan perbaikan-perbaikan kecil secara terus menerus pada cara kerja mereka.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["54", "Saya memastikan bahwa unit organisasi saya mengumpulkan informasi tentang kebutuhan dan keinginan konsumen secara terus menerus.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["55", "Saya melibatkan konsumen dalam perencanaan dan evaluasi unit organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["56", "Saya membuat acara khusus dan pemberian penghargaan di unit organisasi saya yang memperkuat nilai-nilai dan budaya Organisasi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["57", "Saya memelihara suatu sistem formal untuk mengumpulkan dan menanggapi informasi yang berasal dari luar unit organisasi saya.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["58", "Saya memprakarsai tim lintas fungsi/Organisasi (gugus tugas) yang memfokuskan pada isu-isu penting Organisasi.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["59", "Saya membantu bawahan saya yang berusaha memperbaiki semua aspek kehidupan mereka, bukan hanya terbatas pada yang berhubungan dengan pekerjaan saja.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["60", "Saya menciptakan iklim dimana individu-individu di unit organisasi saya ingin mencapai tingkat kinerja yang lebih tinggi dari kompetitor.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_1[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["61", "Mengelola tim (membangun tim yang efektif, kohesif, berjalan/berfungsi dengan lancar).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["62", "Mengelola hubungan interpersonal (mendengarkan dan memberikan umpan balik yang mendukung bagi orang lain).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["63", "Mengelola pengembangan orang lain (membantu orang lain memperbaiki kinerja mereka dan memperoleh peluang pengembangan pribadi).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["64", "Mendorong inovasi (mendorong orang lain untuk melakukan inovasi & menghasilkan ide-ide baru).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["65", "Mengelola pencapaian masa depan (mengkomunikasikan visi masa depan yang jelas dan memfasilitasi upaya pencapaiannya).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["66", "Mengelola perbaikan terus menerus/ continuous improvement (mendorong orientasi perbaikan terus menerus di antara para bawahan dalam segala sesuatu yang mereka lakukan).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["67", "Mengelola kondisi kerja yang kompetitif (membantu mengembangkan suatu orientasi yang dinamis, antusias dan penuh semangat untuk melampaui kinerja kompetitor.", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["68", "Menyemangati bawahan (memotivasi orang lain untuk memberikan upaya ekstra dan bekerja dinamis, antusias dan penuh semangat).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["69", "Mengelola pelayanan konsumen (mendorong fokus pada pelayanan dan membina hubungan dengan konsumen).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["70", "Mengelola akulturasi (membantu orang lain untuk mengetahui dengan jelas apa yang diharapkan dari mereka, juga tentang budaya dan standar-standar Organisasi).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["71", "Mengelola sistem kontrol (memiliki sistem penilaian dan monitoring untuk menjaga alur proses dan kinerja).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["72", "Mengelola koordinasi (berbagi informasi lintas fungsi/Organisasi dan mendorong koordinasi dengan unit-unit di unit organisasi lain).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["73", "Kompetensi manajemen secara keseluruhan (kemampuan umum dalam manajerial)", "pernyataan-".$counter_pernyataan_msai++, $option_msai_2[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["74", "Berdasarkan kompetensi manajemen anda, sampai setingkat apa jenjang karir yang anda ingin capai dalam Organisasi?", "pernyataan-".$counter_pernyataan_msai++, $option_msai_3[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["75", "Dibandingkan dengan pemimpin-pemimpin lain yang anda kenal dalam Organisasi, menurut anda Bagaimana anda menilai kompetensi anda sendiri sebagai pemimpin diantara pemimpin-pemimpin yang lain?", "pernyataan-".$counter_pernyataan_msai++, $option_msai_4[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["76", "Mengelola tim (membangun tim yang efektif, kohesif, berjalan/berfungsi dengan lancar).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["77", "Mengelola hubungan interpersonal (mendengarkan dan memberikan umpan balik yang mendukung bagi orang lain).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["78", "Mengelola pengembangan orang lain (membantu orang lain memperbaiki kinerja mereka dan memperoleh peluang pengembangan pribadi).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["79", "Mendorong inovasi (mendorong orang lain untuk melakukan inovasi dan menghasilkan ide-ide baru).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["80", "Mengelola pencapaian masa depan (mengkomunikasikan visi masa depan yang jelas dan memfasilitasi upaya pencapaiannya).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["81", "Mengelola perbaikan terus menerus/ continuous improvement (mendorong orientasi perbaikan terus menerus di antara para bawahan dalam segala sesuatu yang mereka lakukan).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["82", "Mengelola kondisi kerja yang kompetitif (membantu mengembangkan suatu orientasi yang sangat dinamis, penuh antusias dan penuh semangat untuk melampaui kinerja kompetitor).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["83", "Menyemangati bawahan (memotivasi orang lain untuk memberikan upaya ekstra dan bekerja dinamis, antusias dan penuh semangat).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["84", "Mengelola pelayanan konsumen (mendorong fokus pada pelayanan dan membina hubungan dengan konsumen).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["85", "Mengelola akulturasi (membantu orang lain untuk mengetahui dengan jelas apa yang diharapkan dari mereka, juga tentang budaya dan standar-standar Organisasi).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["86", "Mengelola sistem kontrol (memiliki sistem penilaian dan monitoring untuk menjaga alur proses dan kinerja).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])],
                        ["87", "Mengelola koordinasi (berbagi informasi lintas fungsi/Organisasi dan mendorong koordinasi dengan unit-unit di unit organisasi lain).", "pernyataan-".$counter_pernyataan_msai++, $option_msai_5[\AppHelper\General::cleanString($value[$inc_alpha])], \AppHelper\General::cleanString($value[$inc_alpha++])]
                    ),               
                "MsaiFinished" => 1, 
                "FinishedDate" => $params_post->DateInput,
                "User" => $user->o_id            
            );

            $result = \AppModel\Sipbos::processMsai($params);

            // ----------------------------------------------------------------------------------------------------------

            $object = $result->Data;
            $object->IsFinished = 1;
            $object->Note = $params_post->Note;
            $object->ImportData = $obj_import->Data;
            $object->save();
        }

        return $this->json(["Status" => 1]);
    }   

}
