<?php
/**
 * 
 */

namespace AppBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @Route("/sipmas")
 */
class SipmasController extends FOSRestController
{

    /**
     * Fungsi untuk mengambil seluruh data dari object Sipmas
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-all")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getAllAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipmas::getAll($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil Sipmas tertentu berdasarkan Id
     *
     * Id
     * 
     * @Route("/get-by-id")
     * @Method("POST")
     *
     * @param Id
     * @return JSON Status, Message, Data
     */
    public function getByIdAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipmas::getById($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk membuat Sipmas baru
     *
     * User, Order, IsFinished, DataRaw, ElementResult, PillarResult, OrganizationDevelopment, PersonnelAdministration, Recruitment, WorkManagement, CompetencyManagement, HrDevelopment, Payroll
     * 
     * @Route("/create")
     * @Method("POST")
     *
     * @param User, Order, IsFinished, DataRaw, ElementResult, PillarResult, OrganizationDevelopment, PersonnelAdministration, Recruitment, WorkManagement, CompetencyManagement, HrDevelopment, Payroll
     * @return JSON Status, Message, Data
     */
    public function createAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipmas::create($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengubah data dari Sipmas yang sudah ada
     *
     * Id, User, Order, IsFinished, DataRaw, ElementResult, PillarResult, OrganizationDevelopment, PersonnelAdministration, Recruitment, WorkManagement, CompetencyManagement, HrDevelopment, Payroll
     * 
     * @Route("/update")
     * @Method("POST")
     *
     * @param Id, User, Order, IsFinished, DataRaw, ElementResult, PillarResult, OrganizationDevelopment, PersonnelAdministration, Recruitment, WorkManagement, CompetencyManagement, HrDevelopment, Payroll
     * @return JSON Status, Message, Data
     */
    public function updateAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipmas::update($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk menghapus Sipmas
     *
     * Id
     * 
     * @Route("/delete")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function deleteAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipmas::delete($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk ambil data report
     *
     * @Route("/get-report-data")
     * @Method("POST")
     *
     * @return JSON Status, Message, Data
     */
    public function getReportDataAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\Sipmas::getReportData($params);
        
        return $this->json($result->Data);
    }

}
