<?php
/**
 * 
 */

namespace AppBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @Route("/sipmas-import")
 */
class SipmasImportController extends FOSRestController
{

    /**
     * Fungsi untuk mengambil seluruh data dari object SipmasImport
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-all")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getAllAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasImport::getAll($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil SipmasImport tertentu berdasarkan Id
     *
     * Id
     * 
     * @Route("/get-by-id")
     * @Method("POST")
     *
     * @param Id
     * @return JSON Status, Message, Data
     */
    public function getByIdAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasImport::getById($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk membuat SipmasImport baru
     *
     * Name, Note, DateInput
     * 
     * @Route("/create")
     * @Method("POST")
     *
     * @param Name, Note, DateInput
     * @return JSON Status, Message, Data
     */
    public function createAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasImport::create($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengubah data dari SipmasImport yang sudah ada
     *
     * Id, Name, Note, DateInput
     * 
     * @Route("/update")
     * @Method("POST")
     *
     * @param Id, Name, Note, DateInput
     * @return JSON Status, Message, Data
     */
    public function updateAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasImport::update($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk menghapus SipmasImport
     *
     * Id
     * 
     * @Route("/delete")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function deleteAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $delete_bulk = \AppModel\Sipmas::deleteByImportData((object) ["ImportData" => $params->Id]);
        if($delete_bulk->Status){
            $result = \AppModel\SipmasImport::delete($params);
        }
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil data by server side 
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-server-side")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getServerSideAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasImport::getServerSide($params);
        
        return $this->json($result->Data);
    }    

    /**
     * Fungsi untuk mengimport Raw Data Sipmas from excel template
     *
     * Path, Key 
     * 
     * @Route("/import-data")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function importAction(Request $request = null, Response $response = null)
    {
        $params_post = (object) $request->request->all();

        $file_path = $_FILES['FilePath'];
        if(!$file_path){
            return $this->json(["Status" => 0, "Message" => "Path file empty"]);
        }

        $data = \AppHelper\Excel::readExcelFile($file_path['tmp_name']);

        // import excel into asset pimcore
        $path_import = '/import/sipmas';
        $exist_path  = \AppHelper\General::checkObjectPath($path_import, 1);
        if($exist_path){
            $params_asset = new \stdClass;
            if (isset($file_path['tmp_name'])) {
                $params_asset->Image = $file_path;
                $params_asset->Image["name"] = $params_post->Name."_".microtime(true).".xlsx";
            }
            $params_asset->Path = $path_import;
            $asset = \AppHelper\Asset::uploadFileToAsset($params_asset);
        }
        // import excel into asset pimcore
    
        $params_exist = new \stdClass;
        $params_exist->Condition = "Name = ?";
        $params_exist->ConditionArray = [$params_post->Name];
        $obj_exist = \AppModel\SipmasImport::getAll($params_exist);
        if($obj_exist->Status){
            return $this->json(["Status" => 0, "Message" => "Nama import harus unik, saat ini import data dengan nama {$params_post->Name} sudah ada di sistem"]);            
        }

        $params_post->Path = "/sipmas/import";
        $params_post->Key = $params_post->Name;        
        $obj_import = \AppModel\SipmasImport::create($params_post);
        if(!$obj_import->Status){
            return $this->json(["Status" => 0, "Message" => "Gagal membuat import file"]);            
        }

        $help = 3;
        foreach ($data as $key => $value) {
            if($key < $help) continue;  
            if(!$value['B']) continue;

            $inc_alpha = 'C';

            $params = new \stdClass;
            $params->Name = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Dob = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Gender = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Education = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Departement = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Institute = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->InstituteSection = \AppHelper\General::cleanString($value[$inc_alpha++]);
            $params->Email = \AppHelper\General::cleanString($value[$inc_alpha++]);

            $microtime = microtime(True) * 10000;

            if(!$params->Email){ // check email empty, add timestamp email if empty
                $params->Email = $microtime . "@pakarya.com" ;                
            }

            if($params->Gender){ // check gender
                if(strtolower($params->Gender[0]) == 'l'){ 
                    $params->Gender = "Laki-laki";
                } else {
                    $params->Gender = "Perempuan";                    
                }
            }

            $params->Path = $obj_import->Data->o_path . $obj_import->Data->o_key;
            $params->Key = $params->Email;

            $role = \AuthenticationModel\UserRole::getByPath((object) ["Key" => 'participant']);
            $params->Role = $role->Data->o_id;
            
            $check_existing = \AuthenticationModel\User::getByEmail($params);
            if($check_existing->Status) {                
                $params->Email = $microtime . $params->Email ;
            }

            $params->StatusAccount = 1;

            $user = \AuthenticationModel\User::create($params)->Data;

            if(!$user) continue;

            // ----------------------------------------------------------------------------------------------------------

            $inc_alpha = 'K';

            $params = (object)[
                'DataRaw' => Array(),
                'AssosiativeData' => Array(),
                'ElementData' => (object)[],
                'PillarData' => (object)[]
            ];

            $count_pilar = 1;
            $sipmas_question = \AppModel\SipmasQuestion::getAll()->Data;
            foreach ($sipmas_question as $key_q => $value_q) {
                $answer_question = \AppHelper\General::cleanString($value[$inc_alpha++]);

                if($key_q>0) {
                    if($sipmas_question[$key_q]->Pillar != $sipmas_question[$key_q-1]->Pillar) {
                        $count_pilar++;
                    }
                }

                $data_raw = [
                    "Pilar " . $count_pilar . ". " . $value_q->Pillar,
                    $value_q->Element,
                    $value_q->KeyActivity,
                    $value_q->Output,
                    $value_q->Indicator,
                    $value_q->Options[5-$answer_question][1],
                    $value_q->Options[5-$answer_question][0]                                      
                ];
                array_push($params->DataRaw, $data_raw);

                $data_raw_assosiative = (object)[
                    "Pillar" => $data_raw[0],
                    "Element" => $data_raw[1],
                    "KeyActivity" => $data_raw[2],
                    "Output" => $data_raw[3],
                    "Indicator" => $data_raw[4],
                    "Name" => $data_raw[5],
                    "Value" => $data_raw[6]
                ];
                array_push($params->AssosiativeData, $data_raw_assosiative);

                if($params->ElementData->{$data_raw_assosiative->Element}){
                    array_push($params->ElementData->{$data_raw_assosiative->Element}, $data_raw_assosiative);
                } else {
                    $params->ElementData->{$data_raw_assosiative->Element} = [$data_raw_assosiative];
                }

                if($params->PillarData->{$data_raw_assosiative->Pillar}){
                    array_push($params->PillarData->{$data_raw_assosiative->Pillar}, $data_raw_assosiative);
                } else {
                    $params->PillarData->{$data_raw_assosiative->Pillar} = [$data_raw_assosiative];
                }
            }            

            $params->User = $user->o_id;
            $params->Save = 1;
            $result = \AppModel\Sipmas::calculate($params);

            $object = $result->Data;
            $object->IsFinished = 1;
            $object->Note = $params_post->Note;
            $object->ImportData = $obj_import->Data;
            $object->save();
        }

        return $this->json(["Status" => 1]);
    }   

}
