<?php
/**
 * 
 */

namespace AppBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @Route("/sipmas-project")
 */
class SipmasProjectController extends FOSRestController
{

    /**
     * Fungsi untuk mengambil seluruh data dari object SipmasProject
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-all")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getAllAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasProject::getAll($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil SipmasProject tertentu berdasarkan Id
     *
     * Id
     * 
     * @Route("/get-by-id")
     * @Method("POST")
     *
     * @param Id
     * @return JSON Status, Message, Data
     */
    public function getByIdAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasProject::getById($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk membuat SipmasProject baru
     *
     * Name, Code, Note, DateStart, DateEnd
     * 
     * @Route("/create")
     * @Method("POST")
     *
     * @param Name, Code, Note, DateStart, DateEnd
     * @return JSON Status, Message, Data
     */
    public function createAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasProject::create($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengubah data dari SipmasProject yang sudah ada
     *
     * Id, Name, Code, Note, DateStart, DateEnd
     * 
     * @Route("/update")
     * @Method("POST")
     *
     * @param Id, Name, Code, Note, DateStart, DateEnd
     * @return JSON Status, Message, Data
     */
    public function updateAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasProject::update($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk menghapus SipmasProject
     *
     * Id
     * 
     * @Route("/delete")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function deleteAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();

        $delete_bulk = \AppModel\Sipmas::deleteByProjectData((object) ["ProjectData" => $params->Id]);
        if($delete_bulk->Status){
            $result = \AppModel\SipmasProject::delete($params);
        }

        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil data by server side 
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-server-side")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getServerSideAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasProject::getServerSide($params);
        
        return $this->json($result->Data);
    }    

}
